/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgfast.revise.handler;

import com.google.common.collect.Sets;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.haos.business.domain.repository.adorg.AdOrgSortCodeRepository;
import kd.hr.haos.business.domain.repository.adorg.AdminOrgStructRepository;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.haos.business.util.LocalDateRangeUtils;
import kd.hr.haos.business.util.cascade.MultiVersionCascadeHelper;
import kd.hr.haos.common.constants.masterdata.AdminOrgConstants;
import kd.hr.haos.common.model.cascade.CascadeBo;
import kd.hr.haos.common.model.cascade.CascadeResult;
import kd.hr.haos.common.model.cascade.PartBo;
import kd.hr.haos.common.util.LocalDateRange;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.homs.business.service.batcheffect.QueryHelper;
import kd.hr.homs.business.service.batcheffect.constant.EffectBillConstant;
import kd.hr.homs.business.service.orgfast.revise.handler.IOrgReviseHandler;
import kd.hr.homs.business.service.orgfast.revise.model.OrgCascadeBo;
import kd.hr.homs.business.service.orgfast.revise.model.OrgPartBo;
import kd.hr.homs.business.service.orgfast.revise.model.OrgReviseModel;
import kd.hr.homs.business.service.orgfast.revise.model.OrgSortCodePartBo;
import kd.hr.homs.business.service.orgfast.revise.model.OrgStructPartBo;

public class OrgSubReviseHandler
implements IOrgReviseHandler {
    @Override
    public boolean isChanged(OrgReviseModel model) {
        return model.isOrgTypeStdChanged() || model.isParentChanged();
    }

    @Override
    public void execute(OrgReviseModel model) {
        Map<Class, List<PartBo>> map = this.calculate(model).getBoVsPartCascadeBo().values().stream().flatMap(Collection::stream).collect(Collectors.groupingBy(Object::getClass));
        this.setResult(map.get(OrgPartBo.class), model);
        this.setResult(map.get(OrgStructPartBo.class), model);
        this.setResult(map.get(OrgSortCodePartBo.class), model);
    }

    private void setResult(List<PartBo> list, OrgReviseModel model) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        if (list.get(0) instanceof OrgPartBo && list.size() > 1) {
            list.sort(Comparator.comparing(o -> o.getEffectRange().getStart()));
        }
        Set<Long> idSet = list.stream().map(PartBo::getVid).collect(Collectors.toSet());
        DynamicObject[] dyArray = this.getDyArray(idSet, list.get(0));
        Map<Long, DynamicObject> idMap = Arrays.stream(dyArray).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        DynamicObjectType dyType = dyArray[0].getDynamicObjectType();
        for (PartBo partBo : list) {
            DynamicObject hisDy = model.getResultDy(dyType.getName(), partBo.getVid());
            if (hisDy == null) {
                hisDy = idMap.get(partBo.getVid());
            }
            this.buildNewDy(hisDy, partBo, model);
            DynamicObject newDy = new DynamicObject(dyType);
            HRDynamicObjectUtils.copy((DynamicObject)hisDy, (DynamicObject)newDy);
            newDy.set("id", (Object)partBo.getVid());
            LocalDateRangeUtils.setEffectRange((DynamicObject)newDy, (LocalDateRange)partBo.getEffectRange());
            this.setValue(newDy, partBo, model.getDy());
            model.setSubResultDy(newDy);
        }
    }

    private void buildNewDy(DynamicObject hisDy, PartBo bo, OrgReviseModel model) {
        if (bo instanceof OrgPartBo) {
            DynamicObject dy = model.getDy();
            if (dy.getLong("boid") == hisDy.getLong("boid")) {
                return;
            }
            List<DynamicObject> list = model.getSubResultMap().get(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey());
            if (!CollectionUtils.isEmpty(list) && list.stream().anyMatch(resultDy -> resultDy.getLong("id") == hisDy.getLong("id"))) {
                return;
            }
            if (hisDy.getDate("bsed").compareTo(dy.getDate("bsed")) < 0 && hisDy.getDate("bsled").compareTo(dy.getDate("bsled")) > 0) {
                DynamicObject newDy = new DynamicObject(hisDy.getDynamicObjectType());
                HRDynamicObjectUtils.copy((DynamicObject)hisDy, (DynamicObject)newDy);
                newDy.set("id", (Object)bo.getVid());
                newDy.set("bsled", (Object)LocalDateRangeUtils.getDate((LocalDate)bo.getEffectRange().getStart().minusDays(1L)));
                model.setSubResultDy(newDy);
            }
        }
    }

    private void setParentValue(DynamicObject newDy, Long boId) {
        DynamicObject parentAdminOrg = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey()));
        parentAdminOrg.set("id", (Object)boId);
        parentAdminOrg.set("boid", (Object)boId);
        newDy.set("parentorg", (Object)parentAdminOrg);
    }

    private void setValue(DynamicObject newDy, PartBo bo, DynamicObject dy) {
        if (bo instanceof OrgPartBo) {
            OrgPartBo orgPartBo = (OrgPartBo)bo;
            newDy.set("belongcompany", (Object)QueryHelper.generateEmptySubEntityMasterDy(orgPartBo.getBelongCompany()));
            newDy.set("companychangetype", (Object)AdminOrgConstants.CompanyChangeType.FOLLOW_CHANGE.code());
            newDy.set("sourcevid", (Object)orgPartBo.getVid());
            if (dy.getLong("boid") == newDy.getLong("boid")) {
                this.setParentValue(newDy, dy.getLong("parentorg.boid"));
                newDy.set("companychangetype", (Object)AdminOrgConstants.CompanyChangeType.SELF_CHANGE.code());
            }
        } else if (bo instanceof OrgStructPartBo) {
            OrgStructPartBo orgStructPartBo = (OrgStructPartBo)bo;
            String structLongNumber = orgStructPartBo.getStructLongNumber();
            newDy.set("structlongnumber", (Object)structLongNumber);
            newDy.set("level", (Object)structLongNumber.split("!").length);
            if (dy.getLong("boid") == newDy.getLong("adminorg.id")) {
                this.setParentValue(newDy, dy.getLong("parentorg.boid"));
            }
        } else {
            OrgSortCodePartBo orgSortCodePartBo = (OrgSortCodePartBo)bo;
            String sortCode = orgSortCodePartBo.getSortCode();
            newDy.set("sortcode", (Object)sortCode);
            newDy.set("index", (Object)Integer.valueOf(sortCode.substring(sortCode.lastIndexOf("!") + 1)));
        }
    }

    private DynamicObject[] getDyArray(Set<Long> idSet, PartBo bo) {
        DynamicObject[] dyArray = bo instanceof OrgPartBo ? AdOrgRepository.getInstance().loadByIds(idSet) : (bo instanceof OrgStructPartBo ? AdminOrgStructRepository.getInstance().loadByIds(idSet) : AdOrgSortCodeRepository.getInstance().loadByIds(idSet));
        return dyArray;
    }

    private CascadeResult calculate(OrgReviseModel model) {
        return MultiVersionCascadeHelper.getCascadeResult(this.buildCascadeBo(model));
    }

    private List<CascadeBo> buildCascadeBo(OrgReviseModel model) {
        DynamicObject dy = model.getDy();
        Date startDate = model.isEstablishmentDateChanged() ? dy.getDate("establishmentdate") : dy.getDate("bsed");
        Date endDate = dy.getDate("bsled");
        DynamicObjectCollection structLongNumberCol = AdminOrgStructRepository.getInstance().queryHisColByBoDate((Set)Sets.newHashSet((Object[])new Long[]{dy.getLong("boid"), dy.getLong("parentorg.boid")}), startDate, endDate);
        Map booleanMap = structLongNumberCol.stream().collect(Collectors.groupingBy(struct -> dy.getLong("boid") == struct.getLong("adminorg.id"), Collectors.mapping(struct -> struct.getString("structlongnumber"), Collectors.toSet())));
        DynamicObjectCollection structCol = AdminOrgStructRepository.getInstance().queryHisColBySLN(booleanMap.get(Boolean.TRUE), booleanMap.get(Boolean.FALSE), startDate, endDate);
        Set boIdSet = structCol.stream().map(structDy -> structDy.getLong("adminorg.id")).collect(Collectors.toSet());
        DynamicObjectCollection orgCol = AdOrgRepository.getInstance().queryOrgColByBoDate(boIdSet, startDate, endDate);
        Map<Long, List<DynamicObject>> orgMap = orgCol.stream().collect(Collectors.groupingBy(orgDy -> orgDy.getLong("boid")));
        List<DynamicObject> orgDyList = orgMap.get(dy.getLong("boid"));
        if (!CollectionUtils.isEmpty(orgDyList)) {
            orgDyList.removeIf(orgDy -> orgDy.getLong("id") != dy.getLong("id"));
            DynamicObject orgDy2 = orgDyList.get(0);
            orgDy2.set("parentorg.id", (Object)dy.getLong("parentorg.boid"));
            orgDy2.set("adminorgtype.adminorgtypestd.id", (Object)dy.getLong("adminorgtype.adminorgtypestd.id"));
            if (EffectBillConstant.BELONG_COMPANY_SELF_TYPE.contains(dy.getLong("adminorgtype.adminorgtypestd.id"))) {
                orgDy2.set("belongcompany.id", (Object)dy.getLong("boid"));
            }
            if (model.isEstablishmentDateChanged()) {
                orgDy2.set("bsed", (Object)dy.getDate("establishmentdate"));
            }
        }
        DynamicObjectCollection sortCodCol = AdOrgSortCodeRepository.getInstance().querySortCodeColByBoDate(boIdSet, startDate, endDate);
        Map<Long, List<DynamicObject>> structMap = structCol.stream().collect(Collectors.groupingBy(structDy -> structDy.getLong("adminorg.id")));
        Map<Long, List<DynamicObject>> sortCodeMap = sortCodCol.stream().collect(Collectors.groupingBy(sortCodeDy -> sortCodeDy.getLong("adminorg.id")));
        if (model.isEstablishmentDateChanged()) {
            this.setEffStartDate(structMap, dy);
            this.setEffStartDate(sortCodeMap, dy);
        }
        return orgMap.entrySet().stream().map(entry -> this.createCascadeBo((List)entry.getValue(), structMap.getOrDefault(entry.getKey(), Collections.emptyList()), sortCodeMap.getOrDefault(entry.getKey(), Collections.emptyList()))).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private void setEffStartDate(Map<Long, List<DynamicObject>> map, DynamicObject dy) {
        List<DynamicObject> list = map.get(dy.getLong("boid"));
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.sort(Comparator.comparing(o -> o.getDate("bsed")));
        list.get(0).set("bsed", (Object)dy.getDate("establishmentdate"));
    }

    private List<CascadeBo> createCascadeBo(List<DynamicObject> orgDyList, List<DynamicObject> structDyList, List<DynamicObject> sortCodeDyList) {
        return orgDyList.stream().map(orgDy -> {
            OrgCascadeBo orgCascadeBo = new OrgCascadeBo();
            orgCascadeBo.setBo(orgDy.getLong("boid"));
            LocalDateRange effectRange = LocalDateRangeUtils.getEffectRange((DynamicObject)orgDy);
            orgCascadeBo.setEffectRange(effectRange);
            orgCascadeBo.setParentBo(orgDy.getLong("parentorg.id"));
            orgCascadeBo.setParam("structnumber", orgDy.getString("structnumber"));
            orgCascadeBo.setParam("index", orgDy.getInt("index"));
            OrgPartBo orgPartBo = new OrgPartBo();
            this.setValue(orgPartBo, (DynamicObject)orgDy);
            orgPartBo.setBelongCompany(orgDy.getLong("belongcompany.id"));
            orgPartBo.setFollowCompany(EffectBillConstant.BELONG_COMPANY_FOLLOW_TYPE.contains(orgDy.getLong("adminorgtype.adminorgtypestd.id")));
            orgCascadeBo.setOrgList(Collections.singletonList(orgPartBo));
            orgCascadeBo.setStructList(this.buildStructList(orgCascadeBo, structDyList));
            orgCascadeBo.setSortCodeList(this.buildSortCodeList(orgCascadeBo, sortCodeDyList));
            return orgCascadeBo;
        }).collect(Collectors.toList());
    }

    private List<OrgStructPartBo> buildStructList(OrgCascadeBo orgCascadeBo, List<DynamicObject> structDyList) {
        LocalDateRange effectRange = orgCascadeBo.getEffectRange();
        return structDyList.stream().filter(dy -> LocalDateRangeUtils.getEffectRange((DynamicObject)dy).overlaps(effectRange)).map(structDy -> {
            OrgStructPartBo orgStructPartBo = new OrgStructPartBo();
            this.setValue(orgStructPartBo, (DynamicObject)structDy);
            orgStructPartBo.setStructLongNumber(structDy.getString("structlongnumber"));
            return orgStructPartBo;
        }).collect(Collectors.toList());
    }

    private List<OrgSortCodePartBo> buildSortCodeList(OrgCascadeBo orgCascadeBo, List<DynamicObject> sortCodeDyList) {
        LocalDateRange effectRange = orgCascadeBo.getEffectRange();
        return sortCodeDyList.stream().filter(dy -> LocalDateRangeUtils.getEffectRange((DynamicObject)dy).overlaps(effectRange)).map(sortCodeDy -> {
            OrgSortCodePartBo orgSortCodePartBo = new OrgSortCodePartBo();
            this.setValue(orgSortCodePartBo, (DynamicObject)sortCodeDy);
            orgSortCodePartBo.setSortCode(sortCodeDy.getString("sortcode"));
            return orgSortCodePartBo;
        }).collect(Collectors.toList());
    }

    private void setValue(PartBo partBo, DynamicObject dy) {
        partBo.setVid(dy.getLong("id"));
        partBo.setEffectRange(LocalDateRangeUtils.getEffectRange((DynamicObject)dy));
    }
}

