/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgfast.revise.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.haos.business.domain.repository.adorg.AdminOrgStructRepository;
import kd.hr.haos.business.domain.repository.adorg.OtherRepository;
import kd.hr.haos.business.domain.repository.teamcoop.TeamCoopRelRepository;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.homs.business.service.orgfast.revise.AdminOrgReviseCompareService;

public class OrgReviseModel {
    private final DynamicObject dy;
    private final boolean isEstablishmentDateChanged;
    private final boolean isParentChanged;
    private final boolean isNameChanged;
    private boolean isOrgTypeStdChanged;
    private final Map<String, DynamicObject> dyHisMap = new HashMap<String, DynamicObject>(8);
    private final Map<String, List<DynamicObject>> subResultMap = new HashMap<String, List<DynamicObject>>(8);
    private final Map<String, List<DynamicObject>> resultMap = new HashMap<String, List<DynamicObject>>(8);
    private final Map<String, List<DynamicObject>> resultFirstMap = new HashMap<String, List<DynamicObject>>(8);

    public OrgReviseModel(DynamicObject dy) {
        if ("1".equals(dy.getString("isfirstversionnoparent"))) {
            dy.set("parentorg", null);
        }
        this.dy = dy;
        DynamicObject hisOrgDy = this.getHisDy(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey());
        Date hisEsDate = HRDateTimeUtils.truncateDate((Date)hisOrgDy.getDate("establishmentdate"));
        Date currentEsDate = HRDateTimeUtils.truncateDate((Date)dy.getDate("establishmentdate"));
        this.isEstablishmentDateChanged = currentEsDate.compareTo(hisEsDate) != 0;
        this.isParentChanged = dy.getLong("parentorg.boid") != hisOrgDy.getLong("parentorg.boid");
        List<String> name = AdminOrgReviseCompareService.compare(dy, hisOrgDy, Collections.singletonList("name"));
        this.isNameChanged = name.size() != 0;
    }

    public boolean isNameChanged() {
        return this.isNameChanged;
    }

    public boolean isOrgTypeStdChanged() {
        return this.isOrgTypeStdChanged;
    }

    public void setOrgTypeStdChanged(boolean orgTypeStdChanged) {
        this.isOrgTypeStdChanged = orgTypeStdChanged;
    }

    public boolean isEstablishmentDateChanged() {
        return this.isEstablishmentDateChanged;
    }

    public boolean isParentChanged() {
        return this.isParentChanged;
    }

    public DynamicObject getDy() {
        return this.dy;
    }

    public final DynamicObject getHisDy(String entityName) {
        if (this.dyHisMap.containsKey(entityName)) {
            return this.dyHisMap.get(entityName);
        }
        Long boId = this.dy.getLong("boid");
        Date date = this.dy.getDate("bsed");
        DynamicObject hisDy = AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey().equals(entityName) ? AdOrgRepository.getInstance().loadByBoIdAndDate(boId, date) : ("haos_orgteamcooprel".equals(entityName) ? TeamCoopRelRepository.getInstance().getAffiliationCoopRelBySourceOrg(boId, HRDateTimeUtils.truncateDate((Date)new Date())) : (AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey().equals(entityName) ? AdminOrgStructRepository.getInstance().loadByAdminOrgAndDate(boId, date) : OtherRepository.getInstance().loadByAdminOrgAndDate(entityName, boId, date)));
        this.dyHisMap.put(entityName, hisDy);
        return hisDy;
    }

    public void setFirstResultDy(DynamicObject dy) {
        this.addDy(this.resultFirstMap, dy);
    }

    public void setResultDy(DynamicObject dy) {
        this.addDy(this.resultMap, dy);
    }

    public void setSubResultDy(DynamicObject dy) {
        this.addDy(this.subResultMap, dy);
    }

    public Map<String, List<DynamicObject>> getResultMap() {
        return this.resultMap;
    }

    public Map<String, List<DynamicObject>> getSubResultMap() {
        return this.subResultMap;
    }

    public DynamicObject getResultDy(String entityName, Long id) {
        List<DynamicObject> list = this.resultMap.get(entityName);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.stream().filter(resultDy -> resultDy.getLong("id") == id.longValue()).findFirst().orElse(null);
    }

    public DynamicObject getNewDy(String entityName, Long id) {
        DynamicObject newDy = this.getResultDy(entityName, id);
        if (newDy == null) {
            DynamicObject hisOrgDy = this.getHisDy(entityName);
            newDy = new DynamicObject(hisOrgDy.getDynamicObjectType());
            HRDynamicObjectUtils.copy((DynamicObject)hisOrgDy, (DynamicObject)newDy);
            if (AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey().equals(entityName)) {
                newDy.set("sourcevid", (Object)hisOrgDy.getLong("id"));
            }
            newDy.set("id", (Object)hisOrgDy.getLong("id"));
            this.setResultDy(newDy);
        }
        return newDy;
    }

    private void addDy(Map<String, List<DynamicObject>> map, DynamicObject dy) {
        List list = map.computeIfAbsent(dy.getDynamicObjectType().getName(), v -> new ArrayList(16));
        list.add(dy);
    }

    public Map<String, List<DynamicObject>> getResultFirstMap() {
        return this.resultFirstMap;
    }

    public Map<String, DynamicObject> getDyHisMap() {
        return this.dyHisMap;
    }
}

