/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.position;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.DateTimeField;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbpm.business.domain.repository.position.PositionQueryRepository;
import kd.hrmp.hbpm.business.domain.repository.position.ReviseFieldConfigRepository;
import org.apache.curator.shaded.com.google.common.collect.Maps;

public class PositionReviseService {
    private Map<String, EntityItem> fieldKeyNameMap;
    private String selectFields;

    public PositionReviseService(boolean initFieldData) {
        if (initFieldData) {
            this.initFieldData();
        }
    }

    public DynamicObject[] getHisVersions(Long positionBoId) {
        return PositionQueryRepository.getInstance().queryPositionEnableEffectVersionByBoId(positionBoId.longValue(), this.selectFields);
    }

    public DynamicObject getHisVersionById(String id) {
        return PositionQueryRepository.getInstance().queryPositionVersionById(Long.parseLong(id), this.selectFields);
    }

    private List<String> getMustField() {
        ArrayList<String> fieldList = new ArrayList<String>();
        fieldList.add("id");
        fieldList.add("bsed");
        fieldList.add("bsled");
        fieldList.add("datastatus");
        return fieldList;
    }

    private List<String> getSettingField() {
        DynamicObject[] fieldSet = ReviseFieldConfigRepository.getInstance().queryAllField();
        return Arrays.stream(fieldSet).map(o -> o.getString("number")).collect(Collectors.toList());
    }

    public void openDetailRevise(String id, IFormView view) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.setFormId("homs_positiondetailrevise");
        showParameter.setCustomParam("position", (Object)id);
        showParameter.setCustomParam("hasPositionBill", (Object)"false");
        showParameter.setCustomParam("fromRevise", (Object)"true");
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.getOpenStyle().setTargetKey("revise_info");
        view.showForm((FormShowParameter)showParameter);
    }

    private List<Map<String, Object>> getFieldShowList(DynamicObject his) {
        ArrayList fieldKeyValueList = Lists.newArrayListWithExpectedSize((int)8);
        for (Map.Entry<String, EntityItem> entry : this.fieldKeyNameMap.entrySet()) {
            HashMap<String, Object> fieldMap = new HashMap<String, Object>();
            String fieldKey = entry.getKey();
            EntityItem item = entry.getValue();
            fieldMap.put("fieldkey", item.getName().getLocaleValue());
            fieldMap.put("fieldvalue", this.getFieldValue(his, fieldKey, this.fieldKeyNameMap));
            fieldKeyValueList.add(fieldMap);
        }
        return fieldKeyValueList;
    }

    private Object getFieldValue(DynamicObject his, String fieldKey, Map<String, EntityItem> fieldKeyNameMap) {
        EntityItem field = fieldKeyNameMap.get(fieldKey);
        if (field instanceof MulBasedataField) {
            DynamicObjectCollection mulBasedata = his.getDynamicObjectCollection(field.getKey());
            ArrayList<String> values = new ArrayList<String>();
            for (DynamicObject data : mulBasedata) {
                values.add(data.getDynamicObject("fbasedataid").getString(((MulBasedataField)field).getDisplayProp()));
            }
            return String.join((CharSequence)"\uff1b", values);
        }
        if (field instanceof DateTimeField) {
            return HRInteDateTimeUtil.formatDate((String)his.getDataEntityType().getName(), (String)field.getKey(), (Date)his.getDate(field.getKey()));
        }
        if (field instanceof BasedataField) {
            return his.getString(field.getKey() + "." + ((BasedataField)field).getDisplayProp());
        }
        if (field instanceof ComboField) {
            String hisValue = his.getString(field.getKey());
            Map<String, String> valueToDisplayValueMap = ((ComboField)field).getItems().stream().collect(Collectors.toMap(ComboItem::getValue, o -> o.getCaption().getLocaleValue()));
            return valueToDisplayValueMap.get(hisValue);
        }
        return his.getString(field.getKey());
    }

    public void customControlInitData(DynamicObject[] hisVersions, String selectId, IFormView view) {
        ArrayList<Map<String, Object>> initData = new ArrayList<Map<String, Object>>(hisVersions.length);
        for (DynamicObject his : hisVersions) {
            Map<String, Object> dataMap = this.assembleCustomControData(his, selectId);
            initData.add(dataMap);
        }
        this.setDataToCustomControl(initData, "init", "init", view);
    }

    public void customControlChangeSelect(String selectId, IFormView view) {
        HashMap selectDataMap = Maps.newHashMapWithExpectedSize((int)8);
        if (HRStringUtils.isEmpty((String)selectId)) {
            selectDataMap.put("canselect", Boolean.FALSE);
        } else {
            selectDataMap.put("canselect", Boolean.TRUE);
        }
        this.setDataToCustomControl(selectDataMap, "update", "changeselect", view);
    }

    public void customControlUpdateVersion(DynamicObject his, boolean isAdd, IFormView view) {
        Map<String, Object> updateMap = this.assembleCustomControData(his, his.getString("id"));
        if (isAdd) {
            updateMap.put("versiontype", "add");
        } else {
            updateMap.put("versiontype", "update");
        }
        this.setDataToCustomControl(updateMap, "update", "updateversioninfo", view);
    }

    private void setDataToCustomControl(Object data, String eventStatus, String eventName, IFormView view) {
        Map<String, Object> controlData = this.buildCustomControlData(data, eventStatus, eventName);
        CustomControl customcontrol = (CustomControl)view.getControl("customcontrolap");
        customcontrol.setData(controlData);
    }

    private Map<String, Object> assembleCustomControData(DynamicObject his, String selectId) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("id", his.getString("id"));
        dataMap.put("bsed", HRInteDateTimeUtil.formatDate((String)his.getDataEntityType().getName(), (String)"bsed", (Date)his.getDate("bsed")));
        if (HRStringUtils.equals((String)his.getString("datastatus"), (String)"1")) {
            dataMap.put("bsled", ResManager.loadKDString((String)"\u81f3\u4eca", (String)"PositionReviseService_0", (String)"odc-homs-business", (Object[])new Object[0]));
        } else {
            dataMap.put("bsled", HRInteDateTimeUtil.formatDate((String)his.getDataEntityType().getName(), (String)"bsled", (Date)his.getDate("bsled")));
        }
        dataMap.put("isselect", HRStringUtils.equals((String)his.getString("id"), (String)selectId) ? 1 : 0);
        dataMap.put("filedData", this.getFieldShowList(his));
        return dataMap;
    }

    private void initFieldData() {
        this.fieldKeyNameMap = new LinkedHashMap<String, EntityItem>();
        List<String> settingFieldList = this.getSettingField();
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)"hbpm_positionhr", (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Entity);
        for (String settingField : settingFieldList) {
            for (EntityItem item : entityMetadata.getItems()) {
                if (!HRStringUtils.equals((String)settingField, (String)item.getKey())) continue;
                this.fieldKeyNameMap.put(item.getKey(), item);
            }
        }
        HashSet<String> selectFieldSet = new HashSet<String>();
        selectFieldSet.addAll(this.fieldKeyNameMap.keySet());
        selectFieldSet.addAll(this.getMustField());
        this.selectFields = String.join((CharSequence)",", selectFieldSet);
    }

    private Map<String, Object> buildCustomControlData(Object data, String eventStatus, String eventName) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("data", data);
        dataMap.put("code", "200");
        dataMap.put("errorMessage", "");
        dataMap.put("eventStatus", eventStatus);
        dataMap.put("eventName", eventName);
        dataMap.put("time", System.currentTimeMillis());
        return dataMap;
    }

    public Set<String> getChangeType(DynamicObject dyn) {
        HashSet<String> changeType = new HashSet<String>();
        for (IDataEntityProperty property : dyn.getDataEntityState().getBizChangedProperties()) {
            String propName = property.getName();
            if (HRStringUtils.equals((String)propName, (String)"changedesc") || HRStringUtils.equals((String)propName, (String)"changeexplain") || HRStringUtils.equals((String)propName, (String)"billno")) continue;
            if (HRStringUtils.equals((String)propName, (String)"establishmentdate")) {
                changeType.add("1");
                continue;
            }
            if (HRStringUtils.equals((String)propName, (String)"bsed") || HRStringUtils.equals((String)propName, (String)"firstbsed")) {
                changeType.add("2");
                continue;
            }
            changeType.add("3");
        }
        return changeType;
    }
}

