/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.position;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.homs.business.service.position.IPositionValidateService;
import kd.hrmp.hbpm.business.domain.repository.position.MserviceQueryRepository;
import kd.hrmp.hbpm.business.utils.SystemParamHelper;

public class PositionValidateServiceImpl
implements IPositionValidateService {
    private static final Log LOGGER = LogFactory.getLog(PositionValidateServiceImpl.class);

    @Override
    public Predicate<Map<String, Object>> openDialogOrPositionBill(Long adminorgId) {
        return parametercache -> {
            boolean openDialogOrBillPage = false;
            Map result = (Map)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSBatchAdminOrgInfoQueryService", (String)"adminOrgInfoQuery", (Object[])new Object[]{Collections.singletonList(adminorgId), new Date()});
            if (result == null || result.size() == 0) {
                LOGGER.info("openDialogOrPositionBill invoke adminOrgInfoQuery error result is null orgId:{}", (Object)adminorgId);
                return false;
            }
            Map adminorgInfo = (Map)result.get(String.valueOf(adminorgId));
            Long orgId = adminorgInfo.getOrDefault("org", 0L);
            Map batchParameter = SystemParamHelper.getBatchParameter(Collections.singletonList(orgId));
            Map parameter = batchParameter.getOrDefault(String.valueOf(orgId), Maps.newHashMap());
            parametercache.putAll(parameter);
            boolean openpositiontpl = parameter.getOrDefault("openpositiontpl", false);
            if (openpositiontpl) {
                String radiogroupfield = (String)parameter.get("radiogroupfield");
                if ("1".equals(radiogroupfield)) {
                    openDialogOrBillPage = true;
                } else if ("2".equals(radiogroupfield)) {
                    String orgrange = parameter.getOrDefault("orgrange", "");
                    List fieldRangeDataList = (List)JSONObject.parseObject((String)orgrange, List.class);
                    List<Long> orgSubId = this.getOrgSubId(fieldRangeDataList, "adminorg.id", "containssubordinate");
                    String exceptionrange = parameter.getOrDefault("exceptionrange", "");
                    List exceptionrangeDataList = (List)JSONObject.parseObject((String)exceptionrange, List.class);
                    if (!CollectionUtils.isEmpty((Collection)exceptionrangeDataList)) {
                        List<Long> exceptionOrgIds = this.getOrgSubId(exceptionrangeDataList, "exceptionadminorg.id", "exceptionsubordinate");
                        orgSubId.removeAll(exceptionOrgIds);
                    }
                    if (orgSubId.contains(adminorgId)) {
                        openDialogOrBillPage = true;
                    }
                }
            }
            return openDialogOrBillPage;
        };
    }

    private List<Long> getOrgSubId(List<JSONObject> fieldRangeDataList, String orgFieldKey, String containssubordinateField) {
        Map<String, ArrayList> containssubordinate = fieldRangeDataList.stream().collect(Collectors.toMap(temp -> temp.getBoolean(containssubordinateField) != false ? "1" : "0", temp -> Lists.newArrayList((Object[])new Long[]{temp.getLong(orgFieldKey)}), (v1, v2) -> {
            v1.addAll(v2);
            return v1;
        }));
        ArrayList<Long> result = new ArrayList<Long>(16);
        ArrayList containssubordinateIdList = containssubordinate.getOrDefault("1", Lists.newArrayList());
        List maps = MserviceQueryRepository.getInstance().queryAllSubOrg((List)containssubordinateIdList, new Date());
        List contailsOrg = maps.stream().map(temp -> temp.getOrDefault("orgId", 0L)).collect(Collectors.toList());
        result.addAll(contailsOrg);
        result.addAll(containssubordinate.getOrDefault("0", Lists.newArrayList()));
        result.addAll(containssubordinateIdList);
        return result;
    }
}

