/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.proxy.test;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.filter.FilterScheme;
import kd.bos.entity.tree.TreeNode;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.list.ITreeListView;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.list.query.SchemeQuery;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.dao.IHRBaseDao;
import kd.hr.hbp.business.dao.factory.HRBaseDaoFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.orgchart.OrgChartServiceHelper;
import kd.hr.homs.common.constants.orgchart.OrgChartConstants;
import kd.hr.homs.common.enums.OrgChartOperateTypes;
import kd.hr.homs.common.model.ChartOrgInfo;
import kd.hr.homs.common.model.ChartStyle;
import kd.hr.homs.common.model.OrgChartTreeNode;
import kd.hr.homs.common.model.SearchChartData;
import kd.sdk.odc.homs.service.IOrgChartCustomEventService;

public class OrgChartCustomEventServiceImplTest
implements IOrgChartCustomEventService {
    private static final Log LOGGER = LogFactory.getLog(OrgChartCustomEventServiceImplTest.class);

    public void nodeUpHoleQuery(AbstractTreeListPlugin plugin, String eventArgs) {
        LOGGER.info("OrgChartCustomEventServiceImplTest eventArgs:{}", (Object)eventArgs);
        try {
            JSONObject jsonObject = (JSONObject)JSONObject.parseObject((String)eventArgs, JSONObject.class);
            String parentNodeId = jsonObject.getString("parentNodeId");
            IFormView formView = plugin.getView();
            ITreeListView treeListView = plugin.getTreeListView();
            TreeView treeView = treeListView.getTreeView();
            ITreeModel treeModel = treeListView.getTreeModel();
            String currentNodeId = treeListView.getTreeModel().getCurrentNodeId().toString();
            IHRBaseDao structInstance = HRBaseDaoFactory.getInstance((String)"haos_adminorgstructure");
            QFilter structProjectFilter = new QFilter("structproject", "=", (Object)Long.parseLong(this.getStructProjectId(formView)));
            QFilter filter = new QFilter("iscurrentversion", "=", (Object)"1");
            filter.and(structProjectFilter);
            String selectProperties = "orgteam.id,orgteam.boid,orgteam.org,structlongnumber,orgteam.name name,orgteam.number number,parentorgteam,isleaf,enable,orgteam.otclassify,level";
            DynamicObject currentOrgStruct = structInstance.queryOriginalOne(selectProperties, new QFilter[]{filter, new QFilter("orgteam.boid", "=", (Object)Long.parseLong(currentNodeId))});
            String structLongNumber = currentOrgStruct.getString("structlongnumber");
            String[] structNumbers = structLongNumber.split(String.valueOf('!'));
            QFilter[] leftTreeNodeFilters = new QFilter[]{filter, new QFilter("parentorgteam.id", "=", (Object)Long.parseLong(currentNodeId)).or(new QFilter("orgteam.structnumber", "in", Arrays.asList(structNumbers)))};
            String rootNodeId = treeModel.getRoot().getId();
            Map<String, OrgChartTreeNode> leftTreeNodeMap = this.getTreeNodeMap(leftTreeNodeFilters, selectProperties, rootNodeId);
            OrgChartTreeNode leftTreeRootNode = leftTreeNodeMap.get(rootNodeId);
            treeModel.setRoot((TreeNode)leftTreeRootNode);
            treeModel.setCurrentNodeId((Object)parentNodeId);
            IPageCache pageCache = plugin.getPageCache();
            pageCache.put("CURRENT_NODE_ID", parentNodeId);
            OrgChartTreeNode parentNode = leftTreeNodeMap.get(parentNodeId);
            this.expandParents(treeView, (TreeNode)leftTreeRootNode, (TreeNode)parentNode);
            treeView.showNode(parentNodeId);
            treeView.focusNode((TreeNode)parentNode);
            String searchChartDataStr = formView.getPageCache().get("CURRENT_SEARCH_CHART_ID");
            QFilter[] rightTreeNodeFilters = new QFilter[]{filter, new QFilter("parentorgteam.id", "=", (Object)Long.parseLong(currentNodeId)).or(new QFilter("orgteam.id", "in", (Object)Lists.newArrayList((Object[])new Long[]{Long.parseLong(parentNodeId), Long.parseLong(currentNodeId)})))};
            Map<String, OrgChartTreeNode> rightTreeNodeMap = this.getTreeNodeMap(rightTreeNodeFilters, selectProperties, parentNodeId);
            OrgChartTreeNode rightTreeRootNode = rightTreeNodeMap.get(parentNodeId);
            SearchChartData searchChartData = (SearchChartData)JSONObject.parseObject((String)searchChartDataStr, SearchChartData.class);
            Map<String, Object> queryShowParams = this.getCurrentQueryShowParams(formView, searchChartData);
            HashMap<String, Object> resultMap = new HashMap<String, Object>(queryShowParams);
            resultMap.put("data", rightTreeRootNode);
            resultMap.put("operateType", OrgChartOperateTypes.NODE_CLICK.getValue());
            resultMap.put("hasOrgPerm", "1");
            resultMap.put("showErrorInfo", null);
            this.setSimpleDataForCustomControl(formView, resultMap);
        }
        catch (Exception e) {
            LOGGER.error("OrgChartCustomEventServiceImplTest error", (Throwable)e);
        }
        LOGGER.info("OrgChartCustomEventServiceImplTest end");
    }

    private Map<String, OrgChartTreeNode> getTreeNodeMap(QFilter[] filters, String selectProperties, String rootNodeId) {
        IHRBaseDao structInstance = HRBaseDaoFactory.getInstance((String)"haos_adminorgstructure");
        DynamicObjectCollection treeViewCollection = structInstance.queryColl(selectProperties, filters, "index asc,orgteam.number asc");
        Map<Long, ChartOrgInfo> orgTeamIdOrgTypeMap = OrgChartServiceHelper.getOrgTeamOrgType(treeViewCollection, new Date());
        HashMap<String, OrgChartTreeNode> treeNodeMap = new HashMap<String, OrgChartTreeNode>(treeViewCollection.size());
        List treeNodes = treeViewCollection.stream().map(dy -> {
            OrgChartTreeNode orgChartTreeNode = OrgChartServiceHelper.wrapTreeNode(dy, orgTeamIdOrgTypeMap);
            treeNodeMap.put(dy.getString("orgteam.id"), orgChartTreeNode);
            return orgChartTreeNode;
        }).collect(Collectors.toList());
        OrgChartTreeNode rootNode = (OrgChartTreeNode)treeNodeMap.get(rootNodeId);
        OrgChartServiceHelper.addChildNodes((TreeNode)rootNode, treeNodes);
        return treeNodeMap;
    }

    private String getStructProjectId(IFormView formView) {
        String structProjectId = formView.getPageCache().get("STRUCT_PROJECT_KEY");
        if (HRStringUtils.isNotEmpty((String)structProjectId)) {
            return structProjectId;
        }
        return "1010";
    }

    private void expandParents(TreeView treeView, TreeNode rootNode, TreeNode node) {
        String parentId = node.getParentid();
        if (StringUtils.isNotBlank((CharSequence)parentId)) {
            TreeNode p = rootNode.getTreeNode(parentId);
            if (p != null) {
                this.expandParents(treeView, rootNode, p);
                treeView.expand(parentId);
                if (p == rootNode) {
                    treeView.updateNode(node);
                }
            } else {
                treeView.updateNode(node);
            }
        } else {
            treeView.updateNode(node);
        }
    }

    private void setSimpleDataForCustomControl(IFormView formView, Map<String, Object> data) {
        CustomControl customcontrol = (CustomControl)formView.getControl("customcontrolap");
        OrgChartServiceHelper.setSimpleDataForCustomControl("queryTreeNodeData", data, customcontrol);
    }

    private Map<String, Object> getCurrentQueryShowParams(IFormView formView, SearchChartData searchChartData) {
        ChartStyle chartStyle;
        IPageCache pageCache = formView.getPageCache();
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("queryDate", searchChartData.getDateField());
        if (!StringUtils.isEmpty((CharSequence)searchChartData.getChartStyleId())) {
            Map<String, ChartStyle> styleMap = OrgChartServiceHelper.getChartStyleByIds(searchChartData.getChartStyleId());
            chartStyle = styleMap.get(searchChartData.getChartStyleId());
        } else {
            String chartStyleStr = pageCache.get("MATCH_CHART_STYLE_KEY");
            if (StringUtils.isEmpty((CharSequence)chartStyleStr)) {
                Map<String, ChartStyle> styleMap = OrgChartServiceHelper.getChartStyleByIds("1001");
                chartStyle = styleMap.get(searchChartData.getChartStyleId());
            } else {
                chartStyle = (ChartStyle)JSONObject.parseObject((String)chartStyleStr, ChartStyle.class);
            }
        }
        result.put("MATCH_CHART_STYLE_KEY", chartStyle);
        result.put("isShowEye", OrgChartServiceHelper.getIsShowEye(chartStyle, OrgChartServiceHelper.getDesensitizeFields(OrgChartConstants.ORG_CARDDISSION)));
        result.put("personalStyle", null);
        result.put("hasPersonalStyle", 0);
        if (searchChartData.isOpenPersonalStyle() != null) {
            result.put("isOpenPersonalStyle", searchChartData.isOpenPersonalStyle() != false ? 1 : 0);
        } else {
            String isOpenPersonalStyle = pageCache.get("0");
            result.put("isOpenPersonalStyle", "1".equals(isOpenPersonalStyle) ? 1 : 0);
        }
        result.put("showLevel", searchChartData.getShowLevel());
        if (!CollectionUtils.isEmpty((Collection)searchChartData.getTeamOtClassify())) {
            List<Long> otClassifyIds = searchChartData.getTeamOtClassify().stream().map(Long::parseLong).collect(Collectors.toList());
            result.put("showOtclassifys", OrgChartServiceHelper.getOtClassifys(otClassifyIds));
        } else {
            result.put("showOtclassifys", new ArrayList());
        }
        if (!CollectionUtils.isEmpty((Collection)searchChartData.getAdminOrgTypes())) {
            List<Long> adminOrgTypeIds = searchChartData.getAdminOrgTypes().stream().map(Long::parseLong).collect(Collectors.toList());
            result.put("showAdminOrgTypes", OrgChartServiceHelper.getAdminOrgTypes(adminOrgTypeIds));
        } else {
            result.put("showAdminOrgTypes", new ArrayList());
        }
        if (!CollectionUtils.isEmpty((Collection)searchChartData.getCoopRelTypes())) {
            List<Long> coopRelTypeIds = searchChartData.getCoopRelTypes().stream().map(Long::parseLong).collect(Collectors.toList());
            result.put("showCooprelTypes", OrgChartServiceHelper.getCoopRelTypes(coopRelTypeIds));
        } else {
            result.put("showCooprelTypes", new ArrayList());
        }
        result.put("orgchartdirection", searchChartData.getOrgChartDirection());
        if (!StringUtils.isEmpty((CharSequence)searchChartData.getSchemeId())) {
            result.put("showScheme", new SchemeQuery().getScheme(searchChartData.getSchemeId()));
        } else {
            result.put("showScheme", null);
        }
        result.put("orgs", OrgChartServiceHelper.getOrgInfo(searchChartData.getOrgs()));
        List<FilterScheme> schemes = OrgChartServiceHelper.getSchemeWithFilter("homs_adminorgchart", RequestContext.get().getUserId(), false, this.getStructProjectId(formView));
        result.put("schemes", schemes);
        return result;
    }
}

