/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.repository;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.repository.HOMSBaseRepository;

public class HOMSAdminOrgRepository
extends HOMSBaseRepository {
    public HOMSAdminOrgRepository() {
        super("haos_adminorgdetail");
    }

    public static HOMSAdminOrgRepository getInstance() {
        return AdminOrgReviseInstance.INSTANCE;
    }

    public DynamicObject getOrgDyByBoId(Long orgBoId) {
        QFilter boidQf = new QFilter("boid", "=", (Object)orgBoId);
        QFilter iscurrentversionQf = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1'));
        DynamicObject orgDy = this.serviceHelper.queryOne("id,enable,sourcevid", new QFilter[]{boidQf, iscurrentversionQf});
        return orgDy;
    }

    public DynamicObject getOrgDyById(Long orgId) {
        QFilter boidQf = new QFilter("id", "=", (Object)orgId);
        DynamicObject orgDy = this.serviceHelper.queryOne("id,enable,datastatus,name", new QFilter[]{boidQf});
        return orgDy;
    }

    public DynamicObject[] getDynamicObjectArrOrderDesc(Long orgBoId, String extParamsStr) {
        QFilter idFilter = new QFilter("boid", "=", (Object)orgBoId);
        QFilter statusFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter initFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Arrays.asList("1", "2"));
        String baseInfoStr = "id,boid,name,bsed,bsled,iscurrentversion,modifier,parentorg,adminorglayer,creator,adminorgtype";
        if (HRStringUtils.isNotEmpty((String)extParamsStr)) {
            baseInfoStr = baseInfoStr + "," + extParamsStr;
        }
        DynamicObject[] orgInfoDys = this.serviceHelper.query(baseInfoStr, new QFilter[]{idFilter, statusFilter, initFilter, dataStatusFilter}, "bsed desc");
        return orgInfoDys;
    }

    public DynamicObject[] getDynamicObjectArrByBoIds(List<Long> orgBoIds) {
        QFilter idFilter = new QFilter("boid", "in", orgBoIds);
        QFilter statusFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter initFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Arrays.asList("1", "2"));
        String baseInfoStr = "id,boid,name,bsed,bsled,iscurrentversion";
        DynamicObject[] orgInfoDys = this.serviceHelper.query(baseInfoStr, new QFilter[]{idFilter, statusFilter, initFilter, dataStatusFilter});
        return orgInfoDys;
    }

    public Map<String, String> queryBillByOrgBoId(Long orgBoId) {
        List billIdList;
        HashMap billMap = Maps.newHashMap();
        HRBaseServiceHelper entryHelper = new HRBaseServiceHelper("homs_batchorgentity");
        DynamicObject[] entryDyArr = entryHelper.query("id,billid,changetype,adminorg", new QFilter[]{new QFilter("adminorg.boid", "=", (Object)orgBoId)});
        if (entryDyArr.length > 0 && !CollectionUtils.isEmpty(billIdList = Arrays.asList(entryDyArr).stream().map(entryDy -> entryDy.getLong("billid")).collect(Collectors.toList()))) {
            HRBaseServiceHelper billHelper = new HRBaseServiceHelper("homs_orgbatchchgbill");
            QFilter qFilter = new QFilter("id", "in", billIdList);
            qFilter.and(new QFilter("billstatus", "in", (Object)new String[]{"B", "D"}));
            DynamicObject[] billDyArr = billHelper.query("id,billno", new QFilter[]{qFilter});
            if (billDyArr.length > 0) {
                DynamicObject billDy = billDyArr[0];
                Long billId = billDy.getLong("id");
                String billNo = billDy.getString("billno");
                billMap.put("billno", billNo);
                for (DynamicObject entryDy2 : entryDyArr) {
                    if (!billId.equals(entryDy2.getLong("billid"))) continue;
                    String changeType = entryDy2.getDynamicObject("changetype").getString("name");
                    billMap.put("changetype", changeType);
                    billMap.put("adminorg", entryDy2.getDynamicObject("adminorg").getString("name"));
                }
            }
        }
        return billMap;
    }

    public DynamicObject getDynamicObjecByBoIdAndBsed(Long orgBoId, Date bsed, Date bsled) {
        QFilter idFilter = new QFilter("boid", "=", (Object)orgBoId);
        QFilter statusFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter initFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Arrays.asList("1", "2"));
        QFilter besdFilter = new QFilter("bsed", "<=", (Object)bsed);
        QFilter bsledFilter = new QFilter("bsled", ">=", (Object)bsled);
        String baseInfoStr = "id,boid,name,bsed,bsled,iscurrentversion";
        DynamicObject orgInfoDy = this.serviceHelper.queryOne(baseInfoStr, new QFilter[]{idFilter, statusFilter, initFilter, dataStatusFilter, besdFilter, bsledFilter});
        return orgInfoDy;
    }

    private static class AdminOrgReviseInstance {
        private static final HOMSAdminOrgRepository INSTANCE = new HOMSAdminOrgRepository();

        private AdminOrgReviseInstance() {
        }
    }
}

