/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.task;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.id.ID;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.homs.common.constants.fastchg.OrgFastChgBillConstants;

public class AdminOrgDetailPermUpdateTask
extends AbstractTask
implements OrgFastChgBillConstants {
    private static final String SELECT_PERM_SQL = "SELECT FID, FENTRYID, FSEQ, FCONTROLMODE, FPERMITEMID, FINHERITMODE, FENTITYTYPEID, FBIZAPPID, FROLEID FROM T_PERM_ROLEPERMDETIAL WHERE FENTITYTYPEID = ? AND FPERMITEMID = ?";
    private static final String NEW_ORG_PERM_ITEM_ID = "35V/N+G1/TIS";
    private static final String ROLE = "froleid";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        DynamicObjectCollection orgFastChgRoles = this.queryRoleByEntityAndPermItem("homs_orgfastchgadd", "47156aff000000ac");
        DynamicObjectCollection orgDetailRoles = this.queryRoleByEntityAndPermItem("homs_adminorgdetail", NEW_ORG_PERM_ITEM_ID);
        Map<String, DynamicObject> orgDetailNewRoleMap = orgDetailRoles.stream().collect(Collectors.toMap(orgDetailRole -> orgDetailRole.getString(ROLE), orgDetailRole -> orgDetailRole));
        ArrayList sqlList = Lists.newArrayListWithExpectedSize((int)orgFastChgRoles.size());
        String sqlInsert = "INSERT INTO T_PERM_ROLEPERMDETIAL(FID, FENTRYID, FPERMITEMID, FENTITYTYPEID, FBIZAPPID, FROLEID) VALUES";
        for (DynamicObject orgFastChgRole : orgFastChgRoles) {
            String roleId = orgFastChgRole.getString(ROLE);
            DynamicObject orgDetailNewRole = orgDetailNewRoleMap.get(roleId);
            if (orgDetailNewRole != null) continue;
            String sqlCopy = sqlInsert + "('" + orgFastChgRole.getString("fid") + "','" + ID.genStringId() + "','" + NEW_ORG_PERM_ITEM_ID + "','" + "homs_adminorgdetail" + "','" + orgFastChgRole.getString("fbizappid") + "','" + orgFastChgRole.getString(ROLE) + "')";
            sqlList.add(sqlCopy);
        }
        if (!CollectionUtils.isEmpty((Collection)sqlList)) {
            sqlList.forEach(sql -> HRDBUtil.execute((DBRoute)new DBRoute("sys"), (String)sql, (Object[])new Object[0]));
        }
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        scheduleManager.disableJob("3J3BP23AW03X");
        scheduleManager.disableSchedule("3J3C2ZEHR/DY");
    }

    private DynamicObjectCollection queryRoleByEntityAndPermItem(String entityTypeId, String permItemId) {
        ORM orm = ORM.create();
        Object[] param = new Object[]{entityTypeId, permItemId};
        try (DataSet dataSet = HRDBUtil.queryDataSet((String)"homs_perm_update", (DBRoute)new DBRoute("sys"), (String)SELECT_PERM_SQL, (Object[])param);){
            DynamicObjectCollection dynamicObjectCollection = orm.toPlainDynamicObjectCollection(dataSet);
            return dynamicObjectCollection;
        }
    }
}

