/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.task;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.homs.business.service.helper.AdminOrgBatchChgHelper;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;

public class DeleteOrgBatchEntityTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(DeleteOrgBatchEntityTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOG.info("DeleteOrgBatchEntityTask start:");
        try (TXHandle required = TX.required();){
            try {
                this.handleData();
            }
            catch (Exception ex) {
                required.markRollback();
                LOG.error((Throwable)ex);
                throw ex;
            }
        }
        LOG.info("DeleteOrgBatchEntityTask end:");
    }

    private void handleData() {
        Date date = Date.from(LocalDate.now().minusDays(1L).atStartOfDay(ZoneId.systemDefault()).toInstant());
        HRBaseServiceHelper entityHelp = new HRBaseServiceHelper("homs_batchorgentity");
        QFilter qFilter = new QFilter("modifytime", "<=", (Object)date);
        qFilter.and(new QFilter("mergesplitstatus", "in", Arrays.asList("0", "1")));
        DynamicObjectCollection entityCol = entityHelp.queryOriginalCollection("id,changetype,adminorg,mergesplitstatus,billid", qFilter.toArray());
        HashSet<Long> idSet = new HashSet<Long>(entityCol.size());
        HashSet<Long> orgIdSet = new HashSet<Long>(entityCol.size());
        HashSet<Long> billId = new HashSet<Long>(entityCol.size());
        for (DynamicObject entityDy : entityCol) {
            idSet.add(entityDy.getLong("id"));
            if (!"0".equals(entityDy.getString("mergesplitstatus")) || entityDy.getLong("changetype") != OrgBatchChgBillConstants.CHANGE_TYPE_ADD.longValue()) continue;
            orgIdSet.add(entityDy.getLong("adminorg"));
            billId.add(entityDy.getLong("billid"));
        }
        if (!CollectionUtils.isEmpty(idSet)) {
            entityHelp.delete((Object[])idSet.toArray(new Long[0]));
        }
        if (!CollectionUtils.isEmpty(orgIdSet)) {
            qFilter = new QFilter("billid", "in", billId);
            qFilter.and("mergesplitstatus", "=", (Object)"2");
            qFilter.and("adminorg", "in", orgIdSet);
            DynamicObjectCollection col = entityHelp.queryOriginalCollection("adminorg", qFilter.toArray());
            col.forEach(entity -> orgIdSet.remove(entity.getLong("adminorg")));
            if (CollectionUtils.isEmpty(orgIdSet)) {
                return;
            }
            AdminOrgBatchChgHelper.delAddMaster(new ArrayList<Long>(orgIdSet));
        }
    }
}

