/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.task;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.haos.common.constants.structproject.StructProjectConstants;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.homs.business.service.task.OrgchgbillentryDto;

public class DeleteRedundanceTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(DeleteRedundanceTask.class);
    private static final String ID = "id";
    private static final String ADMINORG = "adminorg";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        List<OrgchgbillentryDto> orgchgbillentryDtoList = this.queryFidAndAdminOrgId();
        HRBaseServiceHelper homsOrgBatchChgBillEntry = new HRBaseServiceHelper("homs_batchorgentity");
        HRBaseServiceHelper homsAdminOrgDetail = new HRBaseServiceHelper("haos_adminorgdetail");
        HRBaseServiceHelper homsAdminOrgCompany = new HRBaseServiceHelper("haos_adminorgcompany");
        HRBaseServiceHelper homsOrgSortCode = new HRBaseServiceHelper("haos_orgsortcode");
        HRBaseServiceHelper homsAdminOrgDepartment = new HRBaseServiceHelper("haos_adminorgdepartment");
        HRBaseServiceHelper homsAdminOrgGroup = new HRBaseServiceHelper("haos_adminorggroup");
        HRBaseServiceHelper homsAdminOrgStruct = new HRBaseServiceHelper("haos_adminorgstruct");
        Object[] fentryidArray = new Long[orgchgbillentryDtoList.size()];
        Object[] fadminOrgArray = new Long[orgchgbillentryDtoList.size()];
        for (int i = 0; i < orgchgbillentryDtoList.size(); ++i) {
            fentryidArray[i] = orgchgbillentryDtoList.get(i).getEntryId();
            fadminOrgArray[i] = orgchgbillentryDtoList.get(i).getAdminorgId();
        }
        DynamicObject[] homsAdminOrgDynamicObject = homsAdminOrgCompany.query(ID, new QFilter[]{new QFilter(ADMINORG, "in", (Object)fadminOrgArray)});
        DynamicObject[] homsOrgDepartmentDynamicObject = homsAdminOrgDepartment.query(ID, new QFilter[]{new QFilter(ADMINORG, "in", (Object)fadminOrgArray)});
        DynamicObject[] homsOrgGroupDynamicObject = homsAdminOrgGroup.query(ID, new QFilter[]{new QFilter(ADMINORG, "in", (Object)fadminOrgArray)});
        DynamicObject[] homsOrgSortDynamicObject = homsOrgSortCode.query(ID, new QFilter[]{new QFilter(ADMINORG, "in", (Object)fadminOrgArray)});
        DynamicObject[] homsAdminOrgStructDynamicObject = homsAdminOrgStruct.query(ID, new QFilter[]{new QFilter(ADMINORG, "in", (Object)fadminOrgArray), (QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get()});
        try (TXHandle txHandle = TX.required();){
            try {
                homsOrgBatchChgBillEntry.delete(fentryidArray);
                homsAdminOrgDetail.delete(fadminOrgArray);
                homsAdminOrgCompany.delete((Object[])this.getIdList(homsAdminOrgDynamicObject));
                homsOrgSortCode.delete((Object[])this.getIdList(homsOrgSortDynamicObject));
                homsAdminOrgDepartment.delete((Object[])this.getIdList(homsOrgDepartmentDynamicObject));
                homsAdminOrgGroup.delete((Object[])this.getIdList(homsOrgGroupDynamicObject));
                homsAdminOrgStruct.delete((Object[])this.getIdList(homsAdminOrgStructDynamicObject));
            }
            catch (Exception e1) {
                logger.error("\u6e05\u7406\u5355\u636e\u7c7b\u578b\u4e3a2\u4e14\u6ca1\u6709\u5355\u636e\u7f16\u53f7\u7684\u5355\u636e\u53ca\u5176\u5206\u5f55\u4efb\u52a1\u5931\u8d25");
                logger.error(e1.toString());
                txHandle.markRollback();
            }
        }
    }

    private List<OrgchgbillentryDto> queryFidAndAdminOrgId() {
        Timestamp currentTime = new Timestamp(HRDateTimeUtils.addHour((Date)new Date(), (long)-24L).getTime());
        ArrayList<OrgchgbillentryDto> result = new ArrayList<OrgchgbillentryDto>(10);
        StringBuilder sb = new StringBuilder();
        sb.append("select e.fadminorgid,e.fentryid from t_homs_orgchgbillentry e\nleft join t_homs_orgchgbill b on e.fid = b.fid\nwhere b.fid is null\nand e.fchangetypeid = 1010\nand e.fcreatetime <= ?");
        try (DataSet ds = HRDBUtil.queryDataSet((String)"queryFidAndAdminOrgId", (DBRoute)new DBRoute("haos"), (String)sb.toString(), (Object[])new Object[]{currentTime});){
            for (Row data : ds) {
                OrgchgbillentryDto orgchgbillentryDto = new OrgchgbillentryDto();
                orgchgbillentryDto.setEntryId(data.getLong("fentryid"));
                orgchgbillentryDto.setAdminorgId(data.getLong("fadminorgid"));
                result.add(orgchgbillentryDto);
            }
        }
        return result;
    }

    private Long[] getIdList(DynamicObject[] dynamicObjects) {
        Long[] idArray = new Long[dynamicObjects.length];
        for (int i = 0; i < dynamicObjects.length; ++i) {
            idArray[i] = dynamicObjects[i].getLong(ID);
        }
        return idArray;
    }
}

