/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.task;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.haos.common.constants.changetransaction.ChangeTransactionConstants;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.helper.OrgBatchValidateHelper;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;
import kd.hr.homs.common.model.ChangeDetailVO;

public class InitOrgChgRecordTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(InitOrgChgRecordTask.class);
    private final List<String> baseInfoSet = Arrays.asList("number", "name", "simplename", "adminorgtype", "parentorg", "belongcompany", "corporateorg", "adminorglayer", "adminorgfunction", "tobedisableflag", "tobedisabledate", "enable", "companyarea", "city", "workplace", "detailaddress", "description", "index", "positioning", "mainduty", "safelevel", "safetype", "safedescription");
    private final List<String> groupInfo = Arrays.asList("groupvision", "groupmission");
    private final List<String> companyInfo = Arrays.asList("companytype", "industrytype");
    private final List<String> deptInfo = Collections.singletonList("departmenttype");
    private static final String AFTER_BASE_INFO_ID = "afterbaseinfoid";
    private static final String BEFORE_GROUP_ID = "beforegroupid";
    private static final String AFTER_GROUP_ID = "aftergroupid";
    private static final String BEFORE_COMPANY_ID = "beforecompanyid";
    private static final String AFTER_COMPANY_ID = "aftercompanyid";
    private static final String BEFORE_DEPT_ID = "beforedepartmentid";
    private static final String AFTER_DEPT_ID = "afterdepartmentid";
    private int seq;
    private final Map<String, Map<Long, DynamicObject>> otherInfoMap = new HashMap<String, Map<Long, DynamicObject>>(3);
    private final HRBaseServiceHelper recordHelper = new HRBaseServiceHelper("homs_orgchgrecord");
    private final HRBaseServiceHelper orgHelper = new HRBaseServiceHelper("haos_adminorgdetail");

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        long startTime = System.currentTimeMillis();
        LOG.info("InitOrgChgRecordTask start:");
        try (TXHandle required = TX.required();){
            try {
                if ("1".equals(String.valueOf(map.get("type")))) {
                    this.initOtherScene(false);
                } else {
                    this.initData();
                }
            }
            catch (Exception ex) {
                required.markRollback();
                LOG.error((Throwable)ex);
                throw ex;
            }
        }
        LOG.info("InitOrgChgRecordTask end, cost time {} ms", (Object)(System.currentTimeMillis() - startTime));
    }

    private DynamicObjectCollection getInitHrData() {
        HRBaseServiceHelper hrHelper = new HRBaseServiceHelper("homs_orgdifftemp");
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        qFilter.and("status", "=", (Object)"C");
        qFilter.and("ischange", "=", (Object)"1");
        DynamicObjectCollection hrOrgCol = hrHelper.queryOriginalCollection("id", new QFilter[]{qFilter});
        Set hrOrgIdSet = hrOrgCol.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        qFilter = this.commonQFilter().and("boid", "in", hrOrgIdSet);
        return this.orgHelper.queryOriginalCollection("id,bsed,boid,initdatasource,creator,createtime,enable", new QFilter[]{qFilter});
    }

    private QFilter commonQFilter() {
        QFilter qFilter = new QFilter("establishmentdate", "=", (Object)"bsed", true);
        qFilter.and("iscurrentversion", "=", (Object)"0");
        qFilter.and("initstatus", "=", (Object)"2");
        qFilter.and("datastatus", "in", Arrays.asList("1", "2"));
        return qFilter;
    }

    private void initOtherScene(boolean initHRFlag) {
        DynamicObjectCollection hrCol;
        QFilter qFilter = this.commonQFilter().and("initdatasource", "=", (Object)"1");
        DynamicObjectCollection newCol = this.orgHelper.queryOriginalCollection("id,bsed,boid,initdatasource,creator,createtime,enable", new QFilter[]{qFilter});
        if (initHRFlag && !CollectionUtils.isEmpty((Collection)(hrCol = this.getInitHrData()))) {
            newCol.addAll((Collection)hrCol);
        }
        Set boIdSet = newCol.stream().map(dy -> dy.getLong("boid")).collect(Collectors.toSet());
        DynamicObject[] recordArray = this.recordHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("adminorg.boid", "in", boIdSet)});
        Map<Long, DynamicObject> recordMap = Arrays.stream(recordArray).collect(Collectors.toMap(dy -> dy.getLong("adminorg.boid"), dy -> dy));
        for (DynamicObject newDy : newCol) {
            DynamicObject recordDy = this.getRecordDy(recordMap, newDy.getLong("boid"));
            this.buildOtherSceneEntryDy(recordDy, newDy);
        }
        this.recordHelper.save(recordMap.values().toArray(new DynamicObject[0]));
    }

    private void buildOtherSceneEntryDy(DynamicObject recordDy, DynamicObject newDy) {
        DynamicObjectCollection entryCol = recordDy.getDynamicObjectCollection("orgchgentry");
        for (DynamicObject dbDy : entryCol) {
            if (dbDy.getLong("afterchgorg") != newDy.getLong("id")) continue;
            return;
        }
        DynamicObject entryDy = new DynamicObject(entryCol.getDynamicObjectType());
        entryDy.set("chgeffecttime", newDy.get("bsed"));
        entryDy.set("changetype", (Object)1060L);
        if ("1".equals(newDy.getString("enable"))) {
            entryDy.set("changescene", (Object)ChangeTransactionConstants.CHANGE_SCENE_NEW);
        } else {
            entryDy.set("changescene", (Object)ChangeTransactionConstants.CHANGE_SCENE_DISABLE);
        }
        if (!"1".equals(newDy.getString("initdatasource"))) {
            entryDy.set("changescene", (Object)OrgBatchChgBillConstants.CHANGE_SCENE_ADD);
            entryDy.set("changetype", (Object)OrgBatchChgBillConstants.CHANGE_TYPE_ADD);
        }
        entryDy.set("operator", newDy.get("creator"));
        entryDy.set("operationtime", newDy.get("createtime"));
        entryDy.set("afterchgorg", newDy.get("id"));
        entryCol.add((Object)entryDy);
    }

    private Map<Long, DynamicObject> getDyMapById(String selectProperties, String entityName, Set<Long> set) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityName);
        set.remove(0L);
        QFilter qFilter = new QFilter("id", "in", set);
        DynamicObject[] dyArray = helper.query(selectProperties, new QFilter[]{qFilter});
        return Arrays.stream(dyArray).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
    }

    private void initOtherInfoMap(Set<Long> groupSet, Set<Long> companySet, Set<Long> deptSet) {
        this.otherInfoMap.put("haos_adminorggroup", this.getDyMapById(String.join((CharSequence)",", this.groupInfo), "haos_adminorggroup", groupSet));
        this.otherInfoMap.put("haos_adminorgcompany", this.getDyMapById(String.join((CharSequence)",", this.companyInfo), "haos_adminorgcompany", companySet));
        this.otherInfoMap.put("haos_adminorgdepartment", this.getDyMapById(String.join((CharSequence)",", this.deptInfo), "haos_adminorgdepartment", deptSet));
    }

    private void initData(Map<Long, DynamicObject> billMap) {
        QFilter filter = new QFilter("billid", "in", billMap.keySet()).and("adminorg.boid", "!=", (Object)0L);
        String selectProperties = "establishmentdate,adminorg,changescene,changetype,changereason,afterbaseinfoid,beforedepartmentid,afterdepartmentid,beforecompanyid,aftercompanyid,beforegroupid,aftergroupid,billid,changedescription,cooprelentryentity,cooprelentryentity.coopreltyp,cooprelentryentity.cooporgteam";
        DynamicObject[] dyArray = OrgBatchValidateHelper.BATCHORGENTITY_HELPER.query(selectProperties, new QFilter[]{filter}, "adminorg.boid asc,modifytime asc");
        HashSet<Long> boIdSet = new HashSet<Long>(dyArray.length);
        HashSet<Long> orgIdSet = new HashSet<Long>(dyArray.length);
        HashSet<Long> groupSet = new HashSet<Long>(dyArray.length);
        HashSet<Long> companySet = new HashSet<Long>(dyArray.length);
        HashSet<Long> deptSet = new HashSet<Long>(dyArray.length);
        for (DynamicObject orgEntityDy : dyArray) {
            long changeTypeId = orgEntityDy.getLong("changetype.id");
            boIdSet.add(orgEntityDy.getLong("adminorg.boid"));
            if (changeTypeId == OrgBatchChgBillConstants.CHANGE_TYPE_ADD) continue;
            orgIdSet.add(orgEntityDy.getLong("adminorg.id"));
            orgIdSet.add(orgEntityDy.getLong(AFTER_BASE_INFO_ID));
            if (changeTypeId != OrgBatchChgBillConstants.CHANGE_TYPE_PARENT && changeTypeId != OrgBatchChgBillConstants.CHANGE_TYPE_INFO) continue;
            groupSet.add(orgEntityDy.getLong(BEFORE_GROUP_ID));
            groupSet.add(orgEntityDy.getLong(AFTER_GROUP_ID));
            companySet.add(orgEntityDy.getLong(BEFORE_COMPANY_ID));
            companySet.add(orgEntityDy.getLong(AFTER_COMPANY_ID));
            deptSet.add(orgEntityDy.getLong(BEFORE_DEPT_ID));
            deptSet.add(orgEntityDy.getLong(AFTER_DEPT_ID));
        }
        this.initOtherScene(true);
        this.initOtherInfoMap(groupSet, companySet, deptSet);
        DynamicObject[] orgArray = this.orgHelper.query(String.join((CharSequence)",", this.baseInfoSet) + ",bsed", new QFilter[]{new QFilter("id", "in", orgIdSet)});
        Map<Long, DynamicObject> orgBaseMap = Arrays.stream(orgArray).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        DynamicObject[] recordArray = this.recordHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("adminorg.boid", "in", boIdSet)});
        Map<Long, DynamicObject> recordMap = Arrays.stream(recordArray).collect(Collectors.toMap(dy -> dy.getLong("adminorg.boid"), dy -> dy));
        for (int index = 0; index < dyArray.length; ++index) {
            DynamicObject dy2 = dyArray[index];
            DynamicObject record = this.getRecordDy(recordMap, dy2.getLong("adminorg.boid"));
            if (index == 0 || dy2.getLong("adminorg.boid") != dyArray[index - 1].getLong("adminorg.boid")) {
                this.buildEntryDy(record, dy2, null, orgBaseMap, billMap);
                continue;
            }
            this.buildEntryDy(record, dy2, dyArray[index - 1], orgBaseMap, billMap);
        }
        this.recordHelper.save(recordMap.values().toArray(new DynamicObject[0]));
    }

    private void buildEntryDy(DynamicObject record, DynamicObject dy, DynamicObject oldDy, Map<Long, DynamicObject> orgBaseMap, Map<Long, DynamicObject> billMap) {
        DynamicObject entryDy = this.buildEntryDy(record, dy, billMap);
        if (entryDy == null) {
            return;
        }
        DynamicObjectCollection subCol = entryDy.getDynamicObjectCollection("subentryentity");
        DynamicObject afterOrg = orgBaseMap.get(dy.getLong(AFTER_BASE_INFO_ID));
        DynamicObject beforeOrg = orgBaseMap.get(dy.getLong("adminorg.id"));
        if (afterOrg == null || beforeOrg == null) {
            LOG.error("----afterbaseinfoid---" + dy.getLong(AFTER_BASE_INFO_ID));
            LOG.error("----adminorg---" + dy.getLong("adminorg.id"));
            return;
        }
        if (dy.getLong("changetype.id") == OrgBatchChgBillConstants.CHANGE_TYPE_ADD.longValue()) {
            return;
        }
        this.seq = 1;
        List<String> changeProperties = this.getChangeProperties(afterOrg, beforeOrg, this.baseInfoSet);
        this.fillEntryDetail(subCol, changeProperties, "haos_adminorgdetail", beforeOrg.getLong("id"), afterOrg.getLong("id"));
        this.buildOrgOtherChangeDetail(dy, oldDy, subCol);
    }

    private void initData() {
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        filter.and("billtype", "in", Arrays.asList("1", "2"));
        DynamicObjectCollection billCol = OrgBatchValidateHelper.ORGBATCHCHGBILL_HELPER.queryOriginalCollection("id,effdt,createtime,creator", new QFilter[]{filter});
        Map<Long, DynamicObject> billMap = billCol.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        this.initData(billMap);
    }

    private DynamicObject buildEntryDy(DynamicObject recordDy, DynamicObject newDy, Map<Long, DynamicObject> billMap) {
        DynamicObjectCollection entryCol = recordDy.getDynamicObjectCollection("orgchgentry");
        for (DynamicObject dbDy : entryCol) {
            if (dbDy.getLong("orgentry") != newDy.getLong("id")) continue;
            return null;
        }
        DynamicObject billDy = billMap.get(newDy.getLong("billid"));
        Object effectTime = newDy.getLong("changetype.id") == OrgBatchChgBillConstants.CHANGE_TYPE_ADD.longValue() ? newDy.get("establishmentdate") : billDy.get("effdt");
        DynamicObject entryDy = new DynamicObject(entryCol.getDynamicObjectType());
        entryDy.set("chgeffecttime", effectTime);
        entryDy.set("changescene", newDy.get("changescene"));
        entryDy.set("changetype", newDy.get("changetype"));
        entryDy.set("changereason", newDy.get("changereason"));
        entryDy.set("changedescription", newDy.get("changedescription"));
        entryDy.set("operator", billDy.get("creator"));
        entryDy.set("operationtime", billDy.get("createtime"));
        entryDy.set("chgbill", (Object)billDy.getLong("id"));
        entryDy.set("orgentry", (Object)newDy.getLong("id"));
        entryDy.set("afterchgorg", (Object)newDy.getLong(AFTER_BASE_INFO_ID));
        entryCol.add((Object)entryDy);
        return entryDy;
    }

    private DynamicObject getRecordDy(Map<Long, DynamicObject> recordMap, Long orgId) {
        DynamicObject newDy = recordMap.get(orgId);
        if (newDy == null) {
            newDy = this.recordHelper.generateEmptyDynamicObject();
            newDy.set("id", (Object)ORM.create().genLongId("homs_orgchgrecord"));
            newDy.set("adminorg", (Object)orgId);
            newDy.set("initdatasource", (Object)"0");
            newDy.set("initstatus", (Object)"2");
            newDy.set("creator", (Object)1);
            recordMap.put(orgId, newDy);
        }
        return newDy;
    }

    private void fillEntryDetail(DynamicObjectCollection subDyCol, List<String> properties, String entityNumber, Long beforeKey, Long afterKey) {
        for (String property : properties) {
            DynamicObject detailDy = new DynamicObject(subDyCol.getDynamicObjectType());
            detailDy.set("chgpageelement", (Object)property);
            detailDy.set("chgentitynumber", (Object)entityNumber);
            detailDy.set("beforechgentity", (Object)beforeKey);
            detailDy.set("afterchgentity", (Object)afterKey);
            detailDy.set("seq", (Object)this.seq++);
            subDyCol.add((Object)detailDy);
        }
    }

    private void buildOrgOtherChangeDetail(DynamicObject newDy, DynamicObject oldDy, DynamicObjectCollection subDyCol) {
        long changeType = newDy.getLong("changetype.id");
        if (changeType != OrgBatchChgBillConstants.CHANGE_TYPE_PARENT && changeType != OrgBatchChgBillConstants.CHANGE_TYPE_INFO) {
            return;
        }
        if (newDy.getLong("changescene.id") == OrgBatchChgBillConstants.CHANGE_SCENE_ENABLE.longValue()) {
            return;
        }
        DynamicObject beforeOtherDy = this.otherInfoMap.get("haos_adminorggroup").get(newDy.getLong(BEFORE_GROUP_ID));
        DynamicObject afterOtherDy = this.otherInfoMap.get("haos_adminorggroup").get(newDy.getLong(AFTER_GROUP_ID));
        List<String> changeProperties = this.getChangeProperties(afterOtherDy, beforeOtherDy, this.groupInfo);
        this.fillEntryDetail(subDyCol, changeProperties, "haos_adminorggroup", newDy.getLong(BEFORE_GROUP_ID), newDy.getLong(AFTER_GROUP_ID));
        beforeOtherDy = this.otherInfoMap.get("haos_adminorgcompany").get(newDy.getLong(BEFORE_COMPANY_ID));
        afterOtherDy = this.otherInfoMap.get("haos_adminorgcompany").get(newDy.getLong(AFTER_COMPANY_ID));
        changeProperties = this.getChangeProperties(afterOtherDy, beforeOtherDy, this.companyInfo);
        this.fillEntryDetail(subDyCol, changeProperties, "haos_adminorgcompany", newDy.getLong(BEFORE_COMPANY_ID), newDy.getLong(AFTER_COMPANY_ID));
        beforeOtherDy = this.otherInfoMap.get("haos_adminorgdepartment").get(newDy.getLong(BEFORE_DEPT_ID));
        afterOtherDy = this.otherInfoMap.get("haos_adminorgdepartment").get(newDy.getLong(AFTER_DEPT_ID));
        changeProperties = this.getChangeProperties(afterOtherDy, beforeOtherDy, this.deptInfo);
        this.fillEntryDetail(subDyCol, changeProperties, "haos_adminorgdepartment", newDy.getLong(BEFORE_DEPT_ID), newDy.getLong(AFTER_DEPT_ID));
        this.buildRelDetail(newDy, oldDy, subDyCol);
    }

    private void buildRelDetail(DynamicObject newDy, DynamicObject oldDy, DynamicObjectCollection subDyCol) {
        ChangeDetailVO changeDetailVO;
        long coopRelTypeId;
        DynamicObjectCollection dyCol = newDy.getDynamicObjectCollection("cooprelentryentity");
        HashMap<Long, ChangeDetailVO> map = new HashMap<Long, ChangeDetailVO>(8);
        if (dyCol != null) {
            for (DynamicObject dy : dyCol) {
                coopRelTypeId = dy.getLong("coopreltyp.id");
                changeDetailVO = map.computeIfAbsent(coopRelTypeId, k -> new ChangeDetailVO());
                changeDetailVO.setAfterValue((Object)dy.getLong("cooporgteam.boid"));
            }
        }
        DynamicObjectCollection dynamicObjectCollection = dyCol = oldDy != null ? oldDy.getDynamicObjectCollection("cooprelentryentity") : null;
        if (dyCol != null) {
            for (DynamicObject dy : dyCol) {
                coopRelTypeId = dy.getLong("coopreltyp.id");
                changeDetailVO = map.computeIfAbsent(coopRelTypeId, k -> new ChangeDetailVO());
                changeDetailVO.setBeforeValue((Object)dy.getLong("cooporgteam.boid"));
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            Object beforeValue = ((ChangeDetailVO)entry.getValue()).getBeforeValue();
            Object afterValue = ((ChangeDetailVO)entry.getValue()).getAfterValue();
            if (beforeValue != null && beforeValue.equals(afterValue)) continue;
            DynamicObject detailDy = new DynamicObject(subDyCol.getDynamicObjectType());
            detailDy.set("chgpageelement", null);
            detailDy.set("chgentitynumber", (Object)"haos_orgteamcooprel");
            detailDy.set("beforechgentity", beforeValue);
            detailDy.set("afterchgentity", afterValue);
            detailDy.set("coopreltype", entry.getKey());
            detailDy.set("seq", (Object)this.seq++);
            subDyCol.add((Object)detailDy);
        }
    }

    private List<String> getChangeProperties(DynamicObject newDy, DynamicObject oldDy, List<String> list) {
        ArrayList changeList = Lists.newArrayListWithExpectedSize((int)list.size());
        if (newDy == null && oldDy == null) {
            return changeList;
        }
        for (String property : list) {
            Object oldVal;
            Object newVal = newDy != null ? this.formatObj(newDy.get(property)) : null;
            Object object = oldVal = oldDy != null ? this.formatObj(oldDy.get(property)) : null;
            if (Objects.isNull(newVal) && Objects.isNull(oldVal)) continue;
            if (Objects.isNull(newVal) || Objects.isNull(oldVal)) {
                changeList.add(property);
                continue;
            }
            if (HistoryEntityUtils.compareValues((Object)newVal, (Object)oldVal)) continue;
            changeList.add(property);
        }
        return changeList;
    }

    private Object formatObj(Object obj) {
        if (obj instanceof ILocaleString) {
            ILocaleString localeString = (ILocaleString)obj;
            for (String value : localeString.values()) {
                if (HRStringUtils.isEmpty((String)value)) continue;
                return obj;
            }
            return null;
        }
        return obj;
    }
}

