/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.task;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.homs.business.service.batcheffect.OrgRootChangeController;

public class OrgRootChangeTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(OrgRootChangeTask.class);
    private static final String NEW_ROOT_ID = "newRootId";
    private static final String OLD_ROOT_ID = "oldRootId";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("OrgRootChangeTask start: {}", (Object)((Object)((Object)this)).getClass().getName());
        Long newRootId = Long.valueOf(map.get(NEW_ROOT_ID).toString());
        Long oldRootId = Long.valueOf(map.get(OLD_ROOT_ID).toString());
        LOGGER.info("OrgRootChangeTask oldRootId:" + oldRootId + "-------newRootId:" + newRootId);
        if (this.checkOrgId(oldRootId, newRootId)) {
            return;
        }
        OrgRootChangeController controller = new OrgRootChangeController();
        controller.asy(oldRootId, newRootId);
        LOGGER.info("OrgRootChangeTask end: {}", (Object)((Object)((Object)this)).getClass().getName());
    }

    private boolean checkOrgId(Long oldRootId, Long newRootId) {
        Map<Long, DynamicObject> map = AdOrgRepository.getInstance().queryOriginalColByPks("id,parentorg,iscurrentversion", Arrays.asList(newRootId, oldRootId)).stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        if (map.containsKey(newRootId)) {
            LOGGER.error("homs newRootId exists,newRootId={}", (Object)newRootId);
            return true;
        }
        DynamicObject dy2 = map.get(oldRootId);
        if (dy2 == null) {
            LOGGER.error("homs oldRootId not exists,oldRootId={}", (Object)oldRootId);
            return true;
        }
        long parentId = dy2.getLong("parentorg");
        if (parentId != 0L || !dy2.getBoolean("iscurrentversion")) {
            LOGGER.error("homs oldRootId parentId={}", (Object)parentId);
            return true;
        }
        return false;
    }
}

