/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.utils;

import com.google.common.collect.Lists;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class OrgChgUtil {
    public static final ThreadLocal<DateFormat> THREAD_LOCAL = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd"));

    public static Date getDefaultBsled() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return sdf.parse("2999-12-31");
        }
        catch (ParseException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static void deleteOrgAndRelateInfo(List<Long> orgIds) {
        for (AdminOrgHisDynKey orgHisDynKey : AdminOrgHisDynKey.getOrgHisDynKeyList()) {
            String filterField = HRStringUtils.equals((String)"haos_adminorgdetail", (String)orgHisDynKey.getDynKey()) ? "id" : "adminorg";
            OrgChgUtil.deleteEntityDataFromDB(orgHisDynKey.getDynKey(), filterField, orgIds);
        }
    }

    public static void deleteEntityDataFromDB(String entityNumber, String filterField, List<Long> filterFieldValues) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        QFilter qFilter = new QFilter(filterField, "in", filterFieldValues);
        serviceHelper.deleteByFilter(new QFilter[]{qFilter});
    }

    public static synchronized void setValue(IDataModel model, DynamicObject source, String prefix, String key) {
        Class propertyType = model.getProperty(prefix + key).getPropertyType();
        if (propertyType.equals(String.class)) {
            model.setValue(prefix + key, (Object)source.getString(key));
        } else if (propertyType.equals(ILocaleString.class)) {
            model.setValue(prefix + key, (Object)source.getLocaleString(key));
        } else if (propertyType.equals(Date.class)) {
            model.setValue(prefix + key, (Object)source.getDate(key));
        } else if (propertyType.equals(DynamicObject.class)) {
            model.setValue(prefix + key, (Object)source.getDynamicObject(key));
        }
    }

    public static synchronized IFormView getView(IFormView view) {
        return OrgChgUtil.getView(view, "homs_orgbatchchgbill");
    }

    public static synchronized IFormView getView(IFormView view, String name) {
        String msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u9700\u8981\u4ece %s \u9875\u9762\u8fdb\u5165", (String)"BaseDataContainer_10", (String)"odc-homs-business", (Object[])new Object[0]), name);
        if (view == null) {
            throw new KDBizException(msg);
        }
        String pageName = view.getModel().getDataEntityType().getName();
        Stream<String> pause = Stream.of(name, "bos_list");
        if (pause.anyMatch(s -> s.equals(pageName))) {
            return view;
        }
        return OrgChgUtil.getView(view.getParentView(), name);
    }

    public static synchronized Object getValue(IDataModel model, String key) {
        Class propertyType = model.getProperty(key).getPropertyType();
        DynamicObject data = model.getDataEntity();
        if (propertyType.equals(String.class)) {
            return data.getString(key);
        }
        if (propertyType.equals(ILocaleString.class)) {
            return data.getLocaleString(key);
        }
        if (propertyType.equals(Date.class)) {
            return data.getDate(key);
        }
        if (propertyType.equals(DynamicObject.class)) {
            return data.getDynamicObject(key);
        }
        if (propertyType.equals(Boolean.TYPE)) {
            return data.getBoolean(key);
        }
        return null;
    }

    public static Date parseDate(String dateStr) throws ParseException {
        TimeZone timeZone = KDDateUtils.getSysTimeZone();
        DateFormat dateFormat = THREAD_LOCAL.get();
        dateFormat.setTimeZone(timeZone);
        return dateFormat.parse(dateStr);
    }

    public static boolean checkRootInit(IFormView iFormView) {
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        HRBaseServiceHelper rootHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter qFilter = new QFilter("boid", "=", (Object)rootOrgId);
        qFilter.and("iscurrentversion", "=", (Object)Character.valueOf('1'));
        qFilter.and("initstatus", "=", (Object)"2");
        boolean exists = rootHelper.isExists(qFilter);
        if (!exists) {
            iFormView.showErrorNotification(ResManager.loadKDString((String)"\u65e0\u6839\u7ec4\u7ec7\uff0c\u8bf7\u5148\u5b8c\u6210\u6839\u7ec4\u7ec7\u521d\u59cb\u5316\u3002\u521d\u59cb\u5316\u6839\u7ec4\u7ec7\u7684\u8def\u5f84\u4e3a\u201cHR\u57fa\u7840\u670d\u52a1\u4e91>\u521d\u59cb\u5316\u4e2d\u5fc3>\u521d\u59cb\u5316\u4efb\u52a1\u201d\u3002", (String)"FastChgAdminOrgRootInit_1", (String)"odc-homs-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private static Object formatObj(Object val) {
        if (val instanceof ILocaleString) {
            ILocaleString localeString = (ILocaleString)val;
            for (String value : localeString.values()) {
                if (HRStringUtils.isEmpty((String)value)) continue;
                return val;
            }
            return null;
        }
        return val;
    }

    public static List<String> getChangeProperties(DynamicObject beforeDy, DynamicObject afterDy, List<String> propertiesList) {
        if (afterDy == null && beforeDy == null) {
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        ArrayList changedList = Lists.newArrayListWithExpectedSize((int)propertiesList.size());
        for (String property : propertiesList) {
            Object beforeVal;
            Object afterVal = afterDy != null ? OrgChgUtil.formatObj(afterDy.get(property)) : null;
            Object object = beforeVal = beforeDy != null ? OrgChgUtil.formatObj(beforeDy.get(property)) : null;
            if (Objects.isNull(afterVal) && Objects.isNull(beforeVal)) continue;
            if (Objects.isNull(afterVal) || Objects.isNull(beforeVal)) {
                changedList.add(property);
                continue;
            }
            if (HistoryEntityUtils.compareValues((Object)afterVal, (Object)beforeVal)) continue;
            changedList.add(property);
        }
        return changedList;
    }
}

