/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.entity.ISVInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.ISVServiceHelper;

public class PatternUtil {
    private static final Log logger = LogFactory.getLog(PatternUtil.class);
    private static final char[] SPECIAL_SEPARATORS = new char[]{'!', '_', '\\'};
    private static final Pattern SPECIAL_SEPARATORS_REGEX;
    public static final String ISV_ID;
    public static final String ISV_NAME;

    public static boolean valideName(String orgName) {
        Matcher matcher = SPECIAL_SEPARATORS_REGEX.matcher(orgName);
        return matcher.find();
    }

    public static boolean isExProperty(String property) {
        if (property == null) {
            return false;
        }
        return property.endsWith("_ext") || property.contains(ISV_ID + "_") || property.contains(ISV_NAME + "_");
    }

    static {
        StringBuilder stringBuffer = new StringBuilder();
        for (int i = 0; i < SPECIAL_SEPARATORS.length; ++i) {
            stringBuffer.append("\\").append(SPECIAL_SEPARATORS[i]).append("+");
            if (i >= SPECIAL_SEPARATORS.length - 1) continue;
            stringBuffer.append("|");
        }
        SPECIAL_SEPARATORS_REGEX = Pattern.compile(stringBuffer.toString());
        ISVInfo isvInfo = ISVServiceHelper.getISVInfo();
        ISV_ID = isvInfo.getId();
        ISV_NAME = isvInfo.getName();
        logger.info("do isExProperty,the isv is {} {}", (Object)ISV_ID, (Object)ISV_NAME);
    }
}

