/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.hr.ruleengine.enums.RuleOperatorEnum;
import kd.bos.ext.hr.ruleengine.infos.ConditionExpressInfo;
import kd.bos.ext.hr.ruleengine.infos.ConditionInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleResultInfo;
import kd.bos.ext.hr.ruleengine.utils.RuleUtil;
import kd.bos.lang.Lang;
import kd.hr.hbp.common.util.HRStringUtils;

public class RulePreviewUtil {
    static List<String> replaceOptList = new ArrayList<String>(10);

    public static String getConditionPreviewStr(String conditions) {
        if (StringUtils.isEmpty((CharSequence)conditions)) {
            return "";
        }
        if (StringUtils.isEmpty((CharSequence)(conditions = RuleUtil.getNewestConditionValue((String)conditions)))) {
            return "";
        }
        RuleConditionInfo conditionInfo = (RuleConditionInfo)SerializationUtils.fromJsonString((String)conditions, RuleConditionInfo.class);
        List conditionList = conditionInfo.getConditionList();
        List conditionExpressList = conditionInfo.getConditionExpressList();
        StringBuilder previewSb = new StringBuilder();
        Map<String, ConditionInfo> conditionInfoMap = conditionList.stream().collect(Collectors.toMap(ConditionInfo::getName, condition -> condition));
        if (!conditionExpressList.isEmpty()) {
            ConditionExpressInfo lastInfo = (ConditionExpressInfo)conditionExpressList.get(conditionExpressList.size() - 1);
            lastInfo.setLogical("");
        }
        conditionExpressList.forEach(conditionExpressInfo -> {
            String logical;
            String rightBracket;
            String leftBracket = conditionExpressInfo.getLeftBracket();
            if (HRStringUtils.isNotEmpty((String)leftBracket)) {
                previewSb.append(leftBracket).append(' ');
            }
            ConditionInfo info = (ConditionInfo)conditionInfoMap.get(conditionExpressInfo.getName());
            previewSb.append(info.getDisplayParam()).append(' ');
            if (RulePreviewUtil.isReplaceOpt(info.getOperators())) {
                rightBracket = RuleOperatorEnum.getEnum((String)info.getOperators()).getName().replace("/", ResManager.loadKDString((String)"\u6216\u8005\u662f", (String)"RulePreviewUtil_3", (String)"hrmp-brm-business", (Object[])new Object[0])).replace("...", info.getDisplayValue());
                previewSb.append(rightBracket).append(' ');
            } else {
                previewSb.append(RuleOperatorEnum.getEnum((String)info.getOperators()).getName()).append(' ');
                rightBracket = info.getDisplayValue();
                if (HRStringUtils.isNotEmpty((String)rightBracket)) {
                    previewSb.append(rightBracket).append(' ');
                }
            }
            rightBracket = conditionExpressInfo.getRightBracket();
            if (HRStringUtils.isNotEmpty((String)rightBracket)) {
                previewSb.append(rightBracket).append(' ');
            }
            if (HRStringUtils.isNotEmpty((String)(logical = conditionExpressInfo.getLogical()))) {
                previewSb.append(RulePreviewUtil.getLogicLocaleStr(logical)).append(' ');
            }
        });
        return previewSb.toString();
    }

    private static boolean isReplaceOpt(String opt) {
        return (Lang.zh_CN.equals((Object)Lang.get()) || Lang.zh_TW.equals((Object)Lang.get())) && replaceOptList.contains(opt);
    }

    public static String getResultPreviewStr(String results) {
        if (HRStringUtils.isEmpty((String)results)) {
            return "";
        }
        results = RuleUtil.getNewestResultValue((String)results);
        RuleResultInfo resultInfo = (RuleResultInfo)SerializationUtils.fromJsonString((String)results, RuleResultInfo.class);
        List resultInfoList = resultInfo.getResultList();
        StringBuilder previewSb = new StringBuilder();
        resultInfoList.forEach(info -> {
            previewSb.append(info.getDisplayParam()).append(' ');
            previewSb.append(RuleOperatorEnum.getEnum((String)info.getOperators()).getName()).append(' ');
            previewSb.append(info.getDisplayValue()).append(' ');
            previewSb.append(";").append(' ');
        });
        return previewSb.toString();
    }

    private static String getLogicLocaleStr(String logic) {
        return HRStringUtils.equals((String)logic.trim(), (String)"and") ? ResManager.loadKDString((String)"\u5e76\u4e14", (String)"RulePreviewUtil_1", (String)"hrmp-brm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6216\u8005", (String)"RulePreviewUtil_2", (String)"hrmp-brm-business", (Object[])new Object[0]);
    }

    static {
        replaceOptList.add(RuleOperatorEnum.IN.getValue());
        replaceOptList.add(RuleOperatorEnum.NOT_IN.getValue());
        replaceOptList.add(RuleOperatorEnum.IS_OR_IS_SUB.getValue());
        replaceOptList.add(RuleOperatorEnum.STARTS_WITH.getValue());
        replaceOptList.add(RuleOperatorEnum.ENDS_WITH.getValue());
    }
}

