/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.validcommon;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.hr.homs.business.service.helper.OrgBatchValidateHelper;
import kd.hr.homs.common.model.CalibratorBean;

public class BaseDataWithBusinessUnitCheck {
    private static Log logger = LogFactory.getLog(BaseDataWithBusinessUnitCheck.class);
    private long orgId;
    private String orgName;
    private String systemType;
    private String entryEntityName;
    private CoopRelEntry coopRelEntry;
    public Map<String, String> metaPropToEntityType;
    private Collection<DynamicObject> checkDynamicObject;
    private Map<String, String> metaPropToResourceId;
    private Map<String, String> metaPropToDescription;
    private List<CalibratorBean> result = new ArrayList<CalibratorBean>();

    public BaseDataWithBusinessUnitCheck() {
    }

    public BaseDataWithBusinessUnitCheck(BaseDataWithBusinessUnitCheckBuilder builder) {
        this.orgId = builder.orgId;
        this.orgName = builder.orgName;
        this.systemType = builder.systemType;
        this.metaPropToEntityType = builder.metaPropToEntityType;
        this.checkDynamicObject = builder.checkDynamicObject;
        this.metaPropToResourceId = builder.metaPropToResourceId;
        this.metaPropToDescription = builder.metaPropToDescription;
        this.entryEntityName = builder.entryEntityName;
        this.coopRelEntry = this.buildCoopRelEntry(builder.entryOrg);
    }

    private CoopRelEntry buildCoopRelEntry(DynamicObject[] entryOrg) {
        if (entryOrg == null) {
            return null;
        }
        Map<Long, DynamicObjectCollection> collect = Arrays.stream(entryOrg).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getDynamicObjectCollection("cooprelentryentity")));
        return new CoopRelEntry(collect);
    }

    public List<CalibratorBean> getResult() {
        return this.result;
    }

    public BaseDataWithBusinessUnitCheck setOrgId(long orgId) {
        this.orgId = orgId;
        return this;
    }

    public BaseDataWithBusinessUnitCheck setOrgName(String orgName) {
        this.orgName = orgName;
        return this;
    }

    public BaseDataWithBusinessUnitCheck setSystemType(String systemType) {
        this.systemType = systemType;
        return this;
    }

    public BaseDataWithBusinessUnitCheck setMetaPropToEntityType(Map<String, String> metaPropToEntityType) {
        this.metaPropToEntityType = metaPropToEntityType;
        return this;
    }

    public BaseDataWithBusinessUnitCheck setCheckDynamicObject(Collection<DynamicObject> checkDynamicObject) {
        this.checkDynamicObject = checkDynamicObject;
        return this;
    }

    public BaseDataWithBusinessUnitCheck setCheckDynamicObjectCollection(Collection<DynamicObjectCollection> checkDynamicObject) {
        this.checkDynamicObject = new ArrayList<DynamicObject>();
        checkDynamicObject.forEach(dy -> this.checkDynamicObject.addAll((Collection<DynamicObject>)dy));
        return this;
    }

    public BaseDataWithBusinessUnitCheck setMetaPropToResourceId(Map<String, String> metaPropToResourceId) {
        this.metaPropToResourceId = metaPropToResourceId;
        return this;
    }

    public BaseDataWithBusinessUnitCheck setMetaPropToDescription(Map<String, String> metaPropToDescription) {
        this.metaPropToDescription = metaPropToDescription;
        return this;
    }

    public BaseDataWithBusinessUnitCheck check() {
        Map<String, Set<Long>> baseDataIdsByHrOrgBuID = OrgBatchValidateHelper.getBaseDataIdsByHrOrgBuID(this.metaPropToEntityType.values(), this.orgId);
        if (baseDataIdsByHrOrgBuID == null) {
            logger.error("method OrgBatchValidateHelper.getBaseDataIdsByHrOrgBuID fetch data failed");
            return this;
        }
        if (Objects.isNull(this.checkDynamicObject) || Objects.isNull(this.metaPropToEntityType) || Objects.isNull(this.metaPropToDescription) || Objects.isNull(this.metaPropToResourceId) || Objects.isNull(this.systemType)) {
            logger.info("some param must not be null , checkDynamicObject: [{}], metaPropToEntityType: [{}], metaPropToDescription:[{}], metaPropToResourceId:[{}],systemType:[{}]", new Object[]{this.checkDynamicObject, this.metaPropToEntityType, this.metaPropToDescription, this.metaPropToResourceId, this.systemType});
            return this;
        }
        this.checkDynamicObject.forEach(dy -> {
            ArrayList errorList = Lists.newArrayListWithCapacity((int)1);
            this.metaPropToEntityType.forEach((key, value) -> {
                if (!key.contains(".")) {
                    try {
                        dy.get(key);
                    }
                    catch (Exception ex) {
                        logger.error("could not find this element in this dynamicObject", (Throwable)ex);
                        return;
                    }
                    long id = dy.getLong(key + ".id");
                    if (id != 0L && !((Set)baseDataIdsByHrOrgBuID.get(value)).contains(id)) {
                        String type = ResManager.loadKDString((String)this.metaPropToDescription.get(key), (String)this.metaPropToResourceId.get(key), (String)this.systemType, (Object[])new Object[0]);
                        errorList.add(new CalibratorBean("BaseDataWithBusinessUnitCheck_1", ResManager.loadKDString((String)"\u201c%1$s\u201d\u201c%2$s\u201d\u4e0d\u5728\u201c%3$s\u201d\u4f7f\u7528\u8303\u56f4\u5185\u3002", (String)"BaseDataWithBusinessUnitCheck_1", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{type, dy.getString(key + ".name"), this.orgName}));
                    }
                } else {
                    DynamicObjectCollection dynamicObjectCollection = null;
                    if (this.coopRelEntry != null) {
                        dynamicObjectCollection = this.coopRelEntry.getCoopRelEntryByAdOrg(dy.getLong("id"));
                    }
                    if (!StringUtils.isEmpty((String)this.entryEntityName)) {
                        if (dynamicObjectCollection == null) {
                            dynamicObjectCollection = dy.getDynamicObjectCollection(this.entryEntityName);
                        }
                        dynamicObjectCollection.forEach(dyc -> {
                            String newKey = key.substring(key.indexOf(".") + 1);
                            long entryId = dyc.getLong(newKey + ".id");
                            if (entryId != 0L && !((Set)baseDataIdsByHrOrgBuID.get(value)).contains(entryId)) {
                                String type = ResManager.loadKDString((String)this.metaPropToDescription.get(key), (String)this.metaPropToResourceId.get(key), (String)this.systemType, (Object[])new Object[0]);
                                errorList.add(new CalibratorBean("BaseDataWithBusinessUnitCheck_1", ResManager.loadKDString((String)"\u201c%1$s\u201d\u201c%2$s\u201d\u4e0d\u5728\u201c%3$s\u201d\u4f7f\u7528\u8303\u56f4\u5185\u3002", (String)"BaseDataWithBusinessUnitCheck_1", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{type, dyc.getString(newKey + ".name"), this.orgName}));
                            }
                        });
                    }
                }
            });
            this.result.addAll(errorList);
        });
        return this;
    }

    static class CoopRelEntry {
        Map<Long, DynamicObjectCollection> adOrgVsCoopRelList;

        DynamicObjectCollection getCoopRelEntryByAdOrg(long bo) {
            return this.adOrgVsCoopRelList.getOrDefault(bo, new DynamicObjectCollection());
        }

        public CoopRelEntry(Map<Long, DynamicObjectCollection> adOrgVsCoopRelList) {
            this.adOrgVsCoopRelList = adOrgVsCoopRelList;
        }
    }

    public static class BaseDataWithBusinessUnitCheckBuilder {
        private long orgId;
        private String orgName;
        private String systemType;
        private String entryEntityName;
        public Map<String, String> metaPropToEntityType;
        private Collection<DynamicObject> checkDynamicObject;
        private Map<String, String> metaPropToResourceId;
        private Map<String, String> metaPropToDescription;
        private DynamicObject[] entryOrg;

        public BaseDataWithBusinessUnitCheckBuilder orgId(long orgId) {
            this.orgId = orgId;
            return this;
        }

        public BaseDataWithBusinessUnitCheckBuilder orgName(String orgName) {
            this.orgName = orgName;
            return this;
        }

        public BaseDataWithBusinessUnitCheckBuilder systemType(String systemType) {
            this.systemType = systemType;
            return this;
        }

        public BaseDataWithBusinessUnitCheckBuilder entryEntityName(String entryEntityName) {
            this.entryEntityName = entryEntityName;
            return this;
        }

        public BaseDataWithBusinessUnitCheckBuilder metaPropToEntityType(Map<String, String> metaPropToEntityType) {
            this.metaPropToEntityType = metaPropToEntityType;
            return this;
        }

        public BaseDataWithBusinessUnitCheckBuilder addCheckDynamicObject(DynamicObject checkDynamicObject) {
            if (this.checkDynamicObject == null) {
                this.checkDynamicObject = new ArrayList<DynamicObject>();
            }
            this.checkDynamicObject.add(checkDynamicObject);
            return this;
        }

        public BaseDataWithBusinessUnitCheckBuilder addAllCheckDynamicObject(Collection<DynamicObject> checkDynamicObjects) {
            if (this.checkDynamicObject == null) {
                this.checkDynamicObject = new ArrayList<DynamicObject>();
            }
            this.checkDynamicObject.addAll(checkDynamicObjects);
            return this;
        }

        public BaseDataWithBusinessUnitCheckBuilder addAllCheckDynamicCollectionObject(Collection<DynamicObjectCollection> checkDynamicObjects) {
            if (this.checkDynamicObject == null) {
                this.checkDynamicObject = new ArrayList<DynamicObject>();
            }
            checkDynamicObjects.forEach(dy -> this.checkDynamicObject.addAll((Collection<DynamicObject>)dy));
            return this;
        }

        public BaseDataWithBusinessUnitCheckBuilder metaPropToResourceId(Map<String, String> metaPropToResourceId) {
            this.metaPropToResourceId = metaPropToResourceId;
            return this;
        }

        public BaseDataWithBusinessUnitCheckBuilder metaPropToDescription(Map<String, String> metaPropToDescription) {
            this.metaPropToDescription = metaPropToDescription;
            return this;
        }

        public BaseDataWithBusinessUnitCheckBuilder coopRelEntry(DynamicObject[] entryOrg) {
            this.entryOrg = entryOrg;
            return this;
        }

        public BaseDataWithBusinessUnitCheck build() {
            return new BaseDataWithBusinessUnitCheck(this);
        }
    }
}

