/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.validcommon;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.extplugin.PluginProxy;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.ext.function.DefaultOrgBatchBillServiceExtend;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;
import kd.sdk.odc.homs.service.IOrgBatchBillServiceExtend;

public enum BillEntryHelperEnum {
    addEntry(OrgBatchChgBillConstants.CHANGE_TYPE_ADD, "add", "entryentity_add", BillEntryHelperEnum::getOrgAddLocaleName),
    parentEntry(OrgBatchChgBillConstants.CHANGE_TYPE_PARENT, "parent", "entryentity_parent", BillEntryHelperEnum::getParentChangeLocaleName),
    infoEntry(OrgBatchChgBillConstants.CHANGE_TYPE_INFO, "info", "entryentity_info", BillEntryHelperEnum::getInfoChangeLocaleName),
    disableEntry(OrgBatchChgBillConstants.CHANGE_TYPE_DISABLE, "disable", "entryentity_disable", BillEntryHelperEnum::getOrgDisableLocaleName),
    mergeEntry(OrgBatchChgBillConstants.CHANGE_TYPE_MERGE, "merge", "entryentity_merge", BillEntryHelperEnum::getOrgMergeLocaleName),
    splitEntry(OrgBatchChgBillConstants.CHANGE_TYPE_SPLIT, "split", "entryentity_split", BillEntryHelperEnum::getOrgSplitLocaleName);

    private static List<String> addEntryFields;
    private static List<String> parentEntryFields;
    private static List<String> infoEntryFields;
    private static List<String> disableEntryFields;
    private final Supplier<String> localeNameSupplier;
    private Long changeTypeId;
    private String operateKey;
    private String entryName;
    private static Map<String, LocaleString> tableNameMap;
    private static Set<String> tabPageApSet;

    private BillEntryHelperEnum(Long changeTypeId, String operateKey, String entryName, Supplier<String> localeNameSupplier) {
        this.changeTypeId = changeTypeId;
        this.operateKey = operateKey;
        this.entryName = entryName;
        this.localeNameSupplier = localeNameSupplier;
    }

    private static Map<String, LocaleString> getTableNameMap() {
        FormMetadata entityMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)"homs_orgbatchchgbill", (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        tableNameMap = Maps.newHashMap();
        for (ControlAp item : entityMetadata.getItems()) {
            if (!tabPageApSet.contains(item.getKey())) continue;
            tableNameMap.put(item.getKey(), item.getName());
        }
        return tableNameMap;
    }

    private static String getOrgAddLocaleName() {
        return BillEntryHelperEnum.getTabPageApName("tabpageap_add") + "(%s)";
    }

    private static String getParentChangeLocaleName() {
        return BillEntryHelperEnum.getTabPageApName("tabpageap_parent") + "(%s)";
    }

    private static String getInfoChangeLocaleName() {
        return BillEntryHelperEnum.getTabPageApName("tabpageap_info") + "(%s)";
    }

    private static String getOrgDisableLocaleName() {
        return BillEntryHelperEnum.getTabPageApName("tabpageap_disable") + "(%s)";
    }

    private static String getOrgMergeLocaleName() {
        return BillEntryHelperEnum.getTabPageApName("tabpageap_merge") + "(%s)";
    }

    private static String getOrgSplitLocaleName() {
        return BillEntryHelperEnum.getTabPageApName("tabpageap_split") + "(%s)";
    }

    private static String getTabPageApName(String tabPageAp) {
        BillEntryHelperEnum.getTableNameMap();
        return tableNameMap.get(tabPageAp).getLocaleValue();
    }

    public static List<String> getEntryListByChangeType(Long changeTypeId) {
        if (changeTypeId.equals(OrgBatchChgBillConstants.CHANGE_TYPE_ADD)) {
            return addEntryFields;
        }
        if (changeTypeId.equals(OrgBatchChgBillConstants.CHANGE_TYPE_PARENT)) {
            return parentEntryFields;
        }
        if (changeTypeId.equals(OrgBatchChgBillConstants.CHANGE_TYPE_INFO)) {
            return infoEntryFields;
        }
        if (changeTypeId.equals(OrgBatchChgBillConstants.CHANGE_TYPE_DISABLE)) {
            return disableEntryFields;
        }
        return new ArrayList<String>();
    }

    public static List<String> getEntryListByChangeTypeWithExt(Long changeTypeId) {
        List<String> entryFields = BillEntryHelperEnum.getEntryListByChangeType(changeTypeId);
        if (!CollectionUtils.isEmpty(entryFields)) {
            return entryFields;
        }
        PluginProxy extendPluginProxy = PluginProxy.create((Object)new DefaultOrgBatchBillServiceExtend(), IOrgBatchBillServiceExtend.class, (String)"kd.hr.homs.business.service.ext.function.DefaultOrgBatchBillServiceExtend");
        AtomicReference entryField = new AtomicReference(new ArrayList());
        extendPluginProxy.callReplace(plugin -> {
            Map entityParamMap = plugin.getBatchBillExtendParam();
            if (!CollectionUtils.isEmpty((Map)entityParamMap)) {
                for (Map.Entry entry : entityParamMap.entrySet()) {
                    Long changeTypeIdExt;
                    Map param = (Map)entry.getValue();
                    if (CollectionUtils.isEmpty((Map)param) || !changeTypeId.equals(changeTypeIdExt = (Long)param.get("changetype"))) continue;
                    entryField.set((List)param.get("entryField"));
                }
            }
            return null;
        });
        return entryField.get();
    }

    public static String getEntryDescriptionByChangeType(Long changeTypeId) {
        if (changeTypeId.equals(OrgBatchChgBillConstants.CHANGE_TYPE_ADD)) {
            return ResManager.loadKDString((String)"\u65b0\u589e\u7ec4\u7ec7", (String)"BillEntryHelperEnum_4", (String)"odc-homs-business", (Object[])new Object[0]);
        }
        if (changeTypeId.equals(OrgBatchChgBillConstants.CHANGE_TYPE_PARENT)) {
            return ResManager.loadKDString((String)"\u8c03\u6574\u4e0a\u7ea7", (String)"BillEntryHelperEnum_5", (String)"odc-homs-business", (Object[])new Object[0]);
        }
        if (changeTypeId.equals(OrgBatchChgBillConstants.CHANGE_TYPE_INFO)) {
            return ResManager.loadKDString((String)"\u53d8\u66f4\u4fe1\u606f", (String)"BillEntryHelperEnum_6", (String)"odc-homs-business", (Object[])new Object[0]);
        }
        if (changeTypeId.equals(OrgBatchChgBillConstants.CHANGE_TYPE_DISABLE)) {
            return ResManager.loadKDString((String)"\u505c\u7528\u7ec4\u7ec7", (String)"BillEntryHelperEnum_7", (String)"odc-homs-business", (Object[])new Object[0]);
        }
        if (changeTypeId.equals(OrgBatchChgBillConstants.CHANGE_TYPE_MERGE)) {
            return ResManager.loadKDString((String)"\u5408\u5e76\u7ec4\u7ec7", (String)"BillEntryHelperEnum_10", (String)"odc-homs-business", (Object[])new Object[0]);
        }
        if (changeTypeId.equals(OrgBatchChgBillConstants.CHANGE_TYPE_SPLIT)) {
            return ResManager.loadKDString((String)"\u62c6\u5206\u7ec4\u7ec7", (String)"BillEntryHelperEnum_11", (String)"odc-homs-business", (Object[])new Object[0]);
        }
        return "";
    }

    public static String getEntryDescriptionByChangeName(String changeTypeName) {
        switch (changeTypeName) {
            case "add": {
                return ResManager.loadKDString((String)"\u65b0\u589e\u7ec4\u7ec7", (String)"BillEntryHelperEnum_4", (String)"odc-homs-business", (Object[])new Object[0]);
            }
            case "parent": {
                return ResManager.loadKDString((String)"\u8c03\u6574\u4e0a\u7ea7", (String)"BillEntryHelperEnum_5", (String)"odc-homs-business", (Object[])new Object[0]);
            }
            case "info": {
                return ResManager.loadKDString((String)"\u53d8\u66f4\u4fe1\u606f", (String)"BillEntryHelperEnum_6", (String)"odc-homs-business", (Object[])new Object[0]);
            }
            case "disable": {
                return ResManager.loadKDString((String)"\u518d\u6b21\u505c\u7528", (String)"BillEntryHelperEnum_8", (String)"odc-homs-business", (Object[])new Object[0]);
            }
        }
        return "";
    }

    public static List<String> getEntryListByPrefix(String prefix) {
        switch (prefix) {
            case "add": {
                return addEntryFields;
            }
            case "parent": {
                return parentEntryFields;
            }
            case "info": {
                return infoEntryFields;
            }
            case "disable": {
                return disableEntryFields;
            }
        }
        return new ArrayList<String>();
    }

    public static String getPrefixByChangeTypeId(Long changeTypeId) {
        BillEntryHelperEnum[] entryEnums;
        for (BillEntryHelperEnum entryEnum : entryEnums = BillEntryHelperEnum.values()) {
            if (!entryEnum.getChangeTypeId().equals(changeTypeId)) continue;
            return entryEnum.getOperateKey();
        }
        return "";
    }

    public static String getPrefixByChangeTypeIdWithExt(Long changeTypeId) {
        String prefix = BillEntryHelperEnum.getPrefixByChangeTypeId(changeTypeId);
        if (!HRStringUtils.isEmpty((String)prefix)) {
            return prefix;
        }
        PluginProxy extendPluginProxy = PluginProxy.create((Object)new DefaultOrgBatchBillServiceExtend(), IOrgBatchBillServiceExtend.class, (String)"kd.hr.homs.business.service.ext.function.DefaultOrgBatchBillServiceExtend");
        AtomicReference<String> entryField = new AtomicReference<String>("");
        extendPluginProxy.callReplace(plugin -> {
            Map entityParamMap = plugin.getBatchBillExtendParam();
            if (!CollectionUtils.isEmpty((Map)entityParamMap)) {
                for (Map.Entry entry : entityParamMap.entrySet()) {
                    Long changeTypeIdExt;
                    Map param = (Map)entry.getValue();
                    if (CollectionUtils.isEmpty((Map)param) || !changeTypeId.equals(changeTypeIdExt = (Long)param.get("changetype"))) continue;
                    entryField.set((String)param.get("prefix"));
                }
            }
            return null;
        });
        return entryField.get();
    }

    public static String getEntryNameByChangeTypeId(long changeTypeId) {
        BillEntryHelperEnum[] entryEnums;
        for (BillEntryHelperEnum entryEnum : entryEnums = BillEntryHelperEnum.values()) {
            if (!entryEnum.getChangeTypeId().equals(changeTypeId)) continue;
            return entryEnum.getEntryName();
        }
        return "";
    }

    public static List<String> getAllEntryName() {
        BillEntryHelperEnum[] entryEnums = BillEntryHelperEnum.values();
        return Arrays.stream(entryEnums).map(BillEntryHelperEnum::getEntryName).collect(Collectors.toList());
    }

    public static List<String> getEntryNameExcludeAdd() {
        BillEntryHelperEnum[] entryEnums = BillEntryHelperEnum.values();
        return Arrays.stream(entryEnums).filter(entryEnum -> !"entryentity_add".equals(entryEnum.getEntryName())).filter(entryEnum -> !"entryentity_merge".equals(entryEnum.getEntryName())).filter(entryEnum -> !"entryentity_split".equals(entryEnum.getEntryName())).map(BillEntryHelperEnum::getEntryName).collect(Collectors.toList());
    }

    public static String getEntryNameByPrefix(String prefix) {
        BillEntryHelperEnum[] entryEnums;
        for (BillEntryHelperEnum entryEnum : entryEnums = BillEntryHelperEnum.values()) {
            if (!HRStringUtils.equals((String)entryEnum.getOperateKey(), (String)prefix)) continue;
            return entryEnum.getEntryName();
        }
        return "";
    }

    public static String getOperateLocaleNameByPrefix(String prefix) {
        BillEntryHelperEnum[] entryEnums;
        for (BillEntryHelperEnum entryEnum : entryEnums = BillEntryHelperEnum.values()) {
            if (!HRStringUtils.equals((String)entryEnum.getOperateKey(), (String)prefix)) continue;
            return entryEnum.getLocaleName();
        }
        return "";
    }

    public static Long getChangeTypeIdByPrefix(String prefix) {
        BillEntryHelperEnum[] entryEnums;
        for (BillEntryHelperEnum entryEnum : entryEnums = BillEntryHelperEnum.values()) {
            if (!entryEnum.getOperateKey().equals(prefix)) continue;
            return entryEnum.getChangeTypeId();
        }
        return 0L;
    }

    public String getLocaleName() {
        return this.localeNameSupplier.get();
    }

    public Long getChangeTypeId() {
        return this.changeTypeId;
    }

    public void setChangeTypeId(Long changeTypeId) {
        this.changeTypeId = changeTypeId;
    }

    public String getOperateKey() {
        return this.operateKey;
    }

    public void setOperateKey(String operateKey) {
        this.operateKey = operateKey;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public void setEntryName(String entryName) {
        this.entryName = entryName;
    }

    static {
        addEntryFields = Arrays.asList("id", "number", "name", "simplename", "adminorgtype", "parentorg", "parentorg_name", "establishmentdate", "corporateorg", "changescene", "changereason", "changedescription", "adminorglayer", "adminorgfunction", "companyarea", "city", "workplace", "org", "safelevel", "safetype");
        parentEntryFields = Arrays.asList("id", "adminorg", "number", "name", "oriparentorg", "oriparentorg_name", "parentorg", "parentorg_name", "simplename", "adminorgtype", "establishmentdate", "corporateorg", "tobedisableflag", "changescene", "changereason", "changedescription", "adminorglayer", "adminorgfunction", "companyarea", "city", "workplace", "org", "safelevel", "safetype");
        infoEntryFields = Arrays.asList("id", "adminorg", "number", "name", "parentorg", "oriparentorg_name", "simplename", "adminorgtype", "establishmentdate", "corporateorg", "tobedisableflag", "changescene", "changereason", "changedescription", "adminorglayer", "adminorgfunction", "companyarea", "city", "workplace", "org", "safelevel", "safetype");
        disableEntryFields = Arrays.asList("id", "adminorg", "parentorg", "oriparentorg_name", "adminorgtype", "tobedisableflag", "changescene", "changereason", "changedescription", "org");
        tabPageApSet = Sets.newHashSet((Object[])new String[]{"tabpageap_add", "tabpageap_parent", "tabpageap_info", "tabpageap_disable", "tabpageap_merge", "tabpageap_split"});
    }
}

