/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.validcommon;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.domain.repository.OrgOperateTaskRepository;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.validcommon.IOrgBatchBillCheckService;
import kd.hr.homs.business.service.validcommon.OrgBatchBillCheckFactory;
import kd.hr.homs.business.service.validcommon.OrgBatchBillConverter;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckCacheModel;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckDto;
import kd.hr.homs.common.model.CalibratorBean;

public class OrgBatchBillCheckContext {
    private static final Log LOGGER = LogFactory.getLog(OrgBatchBillCheckContext.class);
    private DynamicObject targetObject;
    private OrgBatchCheckCacheModel cacheModel;
    private List<IOrgBatchBillCheckService> serviceList;

    public OrgBatchBillCheckContext(DynamicObject targetObject, OrgBatchCheckCacheModel cacheModel) {
        this.cacheModel = cacheModel;
        String checkType = cacheModel.getCheckType();
        this.serviceList = OrgBatchBillCheckFactory.getServiceList(checkType);
        if (HRStringUtils.equals((String)"billBatch", (String)checkType)) {
            this.targetObject = OrgBatchBillConverter.processDynamicObject(targetObject, cacheModel);
            cacheModel.setOriginalDynamicObject(targetObject);
        } else if (HRStringUtils.equals((String)"billChartParent", (String)checkType)) {
            OrgBatchBillConverter.loadOwnOrgCacheForChart(targetObject, cacheModel);
            this.targetObject = targetObject;
        } else {
            this.targetObject = targetObject;
        }
        this.loadParamCache(checkType, HRDyObjectPropUtil.getIdLongObject((DynamicObject)targetObject.getDynamicObject("org")));
    }

    public List<CalibratorBean> handle() {
        ArrayList<CalibratorBean> result = new ArrayList<CalibratorBean>(16);
        for (IOrgBatchBillCheckService service : this.serviceList) {
            long startTime = System.currentTimeMillis();
            List<CalibratorBean> beans = service.check(this.targetObject, this.cacheModel);
            long costTime = System.currentTimeMillis() - startTime;
            LOGGER.info(service.getClass().getName() + "\tOrgBatchBillCheckContext each check service cost :" + costTime);
            if (CollectionUtils.isEmpty(beans)) continue;
            result.addAll(beans);
        }
        return result;
    }

    private void loadParamCache(String checkType, Long orgid) {
        List<OrgBatchCheckDto> checkDtoList = OrgBatchBillCheckHelper.queryBillOrgList();
        this.cacheModel.setBillOrgList(checkDtoList);
        DynamicObject[] operateTaskIngArr = OrgOperateTaskRepository.getInstance().getAllOrgTaskByIng();
        this.cacheModel.setOperateTaskArr(operateTaskIngArr);
        DynamicObjectCollection currentOrgColl = OrgBatchBillCheckHelper.queryCurrentOrgCollectionByBillId(this.cacheModel.getCurrentBillId());
        this.cacheModel.setCurrentOrgColl(currentOrgColl);
        if (orgid == null) {
            return;
        }
    }
}

