/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.validcommon;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.homs.business.service.validcommon.IOrgBatchBillCheckService;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckConstants;

public class OrgBatchBillCheckFactory {
    private static Log logger = LogFactory.getLog(OrgBatchBillCheckFactory.class);
    private static final Map<String, List<String>> CHECK_MAPPING = Maps.newHashMapWithExpectedSize((int)8);

    public static List<IOrgBatchBillCheckService> getServiceList(String checkType) {
        ArrayList serviceList = Lists.newArrayListWithCapacity((int)8);
        List<String> serviceNameList = CHECK_MAPPING.get(checkType);
        if (CollectionUtils.isEmpty(serviceNameList)) {
            logger.warn("\u83b7\u53d6\u6821\u9a8c\u670d\u52a1\u5217\u8868\u4e3a\u7a7a\uff0c\u6821\u9a8c\u7c7b\u578b\u4e3a\uff1a{}", (Object)checkType);
            return serviceList;
        }
        for (String serviceName : serviceNameList) {
            try {
                IOrgBatchBillCheckService checkService = (IOrgBatchBillCheckService)Class.forName(serviceName).newInstance();
                serviceList.add(checkService);
            }
            catch (Exception e) {
                logger.error("\u751f\u6210\u6821\u9a8c\u670d\u52a1\u5f02\u5e38\uff0c\u5168\u7c7b\u540d\uff1a{}\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)serviceName, (Object)e);
            }
        }
        return serviceList;
    }

    static {
        CHECK_MAPPING.put("billSingle", OrgBatchCheckConstants.SINGLE_SERVICE_NAME_LIST);
        CHECK_MAPPING.put("billBatch", OrgBatchCheckConstants.BATCH_SERVICE_NAME_LIST);
        CHECK_MAPPING.put("billChartParent", OrgBatchCheckConstants.PARENT_BATCH_SERVICE_NAME_LIST);
        CHECK_MAPPING.put("billChartDisable", OrgBatchCheckConstants.CHART_DISABLE_SERVICE_NAME_LIST);
        CHECK_MAPPING.put("orgFastChg", OrgBatchCheckConstants.FAST_CHG_SERVICE_NAME_LIST);
        CHECK_MAPPING.put("orgAddDisabled", OrgBatchCheckConstants.MSERVICE_SAVE_SERVICE_NAME_LIST);
        CHECK_MAPPING.put("orgChangeDisabled", OrgBatchCheckConstants.MSERVICE_CHANGE_DISABLED_SERVICE_NAME_LIST);
        CHECK_MAPPING.put("orgChangeEnabled", OrgBatchCheckConstants.MSERVICE_CHANGE_ENABLED_SERVICE_NAME_LIST);
    }
}

