/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.validcommon;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.enums.EntryEntityEnum;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckCacheModel;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckDto;

public class OrgBatchBillConverter {
    public static DynamicObject processDynamicObject(DynamicObject targetObject, OrgBatchCheckCacheModel cacheModel) {
        HRBaseServiceHelper baseHelper = new HRBaseServiceHelper("homs_batchorgentity");
        HashMap ownDisableOrgIMap = Maps.newHashMapWithExpectedSize((int)10);
        HashMap ownTobeDisableOrgIMap = Maps.newHashMapWithExpectedSize((int)10);
        ArrayList ownEnableOrgList = Lists.newArrayListWithExpectedSize((int)10);
        List<String> entryKeys = EntryEntityEnum.getEntryKeys();
        HRBaseServiceHelper billHelper = new HRBaseServiceHelper("homs_orgbatchchgbill");
        DynamicObject newCheckObj = billHelper.generateEmptyDynamicObject();
        newCheckObj.set("org", (Object)targetObject.getDynamicObject("org"));
        QFilter billIdFilter = new QFilter("billid", "=", (Object)targetObject.getLong("id"));
        QFilter filter = billIdFilter.and(new QFilter("mergesplitstatus", "in", Arrays.asList("0", "1")));
        DynamicObject[] objects = baseHelper.loadDynamicObjectArray(filter.toArray());
        Map<Long, DynamicObject> unSafeAndDeleteDataMap = Arrays.stream(objects).collect(Collectors.toMap(entry -> entry.getLong("adminorg.id"), entry -> entry));
        for (String entryKey : entryKeys) {
            if (HRStringUtils.equals((String)EntryEntityEnum.splitEntry.getEntryKey(), (String)entryKey) || HRStringUtils.equals((String)EntryEntityEnum.mergeEntry.getEntryKey(), (String)entryKey)) continue;
            DynamicObjectCollection newColl = new DynamicObjectCollection();
            DynamicObjectCollection oriEntryColl = targetObject.getDynamicObjectCollection(entryKey);
            String prefix = EntryEntityEnum.getPrefixByEntryKey(entryKey);
            oriEntryColl.forEach(oriEntry -> {
                long entryOrgId;
                long l = entryOrgId = HRStringUtils.equals((String)EntryEntityEnum.addEntry.getEntryKey(), (String)entryKey) ? oriEntry.getLong(prefix + "adminorg") : oriEntry.getLong(prefix + "adminorg.id");
                if (unSafeAndDeleteDataMap.containsKey(entryOrgId)) {
                    DynamicObject data = (DynamicObject)unSafeAndDeleteDataMap.get(entryOrgId);
                    String status = data.getString("mergesplitstatus");
                    if (HRStringUtils.equals((String)"0", (String)status)) {
                        if (HRStringUtils.equals((String)EntryEntityEnum.addEntry.getEntryKey(), (String)entryKey)) {
                            data.set("adminorg", (Object)entryOrgId);
                        }
                        newColl.add((Object)data);
                    }
                } else {
                    newColl.add((Object)OrgBatchBillConverter.converterEntityField(baseHelper, entryKey, oriEntry));
                }
            });
            newCheckObj.set(entryKey, (Object)newColl);
            OrgBatchBillConverter.loadOwnOrgCache(entryKey, newColl, ownDisableOrgIMap, ownTobeDisableOrgIMap, ownEnableOrgList, cacheModel);
        }
        OrgBatchBillConverter.copyTargetObjectToCheckObject(targetObject, newCheckObj);
        newCheckObj.set("entryentity_merge", targetObject.get("entryentity_merge"));
        newCheckObj.set("entryentity_split", targetObject.get("entryentity_split"));
        return newCheckObj;
    }

    public static void loadOwnOrgCache(String entryKey, DynamicObjectCollection entryColl, Map<Long, String> ownDisableOrgIMap, Map<Long, String> ownTobeDisableOrgIMap, List<OrgBatchCheckDto> ownEnableOrgList, OrgBatchCheckCacheModel cacheModel) {
        if (HRStringUtils.equals((String)EntryEntityEnum.disableEntry.getEntryKey(), (String)entryKey)) {
            entryColl.forEach(oriEntry -> ownDisableOrgIMap.put(oriEntry.getLong("adminorg.id"), oriEntry.getString("adminorg.name")));
            cacheModel.setOwnDisableOrgIdSet(ownDisableOrgIMap);
        } else {
            entryColl.forEach(entry -> ownEnableOrgList.add(OrgBatchBillConverter.putOwnEnableFieldMap(entry, cacheModel.getOperateType(), cacheModel.getEffectDate())));
            cacheModel.setOwnEnableOrgList(ownEnableOrgList);
            if (HRStringUtils.equals((String)EntryEntityEnum.parentEntry.getEntryKey(), (String)entryKey) || HRStringUtils.equals((String)EntryEntityEnum.infoEntry.getEntryKey(), (String)entryKey)) {
                for (DynamicObject dy : entryColl) {
                    if (!dy.getBoolean("tobedisableflag")) continue;
                    ownTobeDisableOrgIMap.put(dy.getLong("adminorg.id"), dy.getString("adminorg.name"));
                }
                cacheModel.setOwnTobeDisableOrgIMap(ownTobeDisableOrgIMap);
            }
        }
        if (HRStringUtils.equals((String)EntryEntityEnum.parentEntry.getEntryKey(), (String)entryKey)) {
            HashSet set = Sets.newHashSetWithExpectedSize((int)entryColl.size());
            entryColl.forEach(entry -> set.add(entry.getLong("adminorg.boid")));
            cacheModel.setParentEntryIds(set);
        }
    }

    public static void loadOwnOrgCacheForChart(DynamicObject targetObject, OrgBatchCheckCacheModel cacheModel) {
        ArrayList ownEnableOrgList = cacheModel.getOwnEnableOrgList();
        if (CollectionUtils.isEmpty(ownEnableOrgList)) {
            ownEnableOrgList = Lists.newArrayListWithExpectedSize((int)10);
        }
        List<String> entryKeys = EntryEntityEnum.getEntryKeys();
        for (String entryKey : entryKeys) {
            DynamicObjectCollection orgColl = targetObject.getDynamicObjectCollection(entryKey);
            OrgBatchBillConverter.loadOwnEnableOrgCache(orgColl, ownEnableOrgList, cacheModel);
        }
    }

    public static void loadOwnEnableOrgCache(DynamicObjectCollection entryColl, List<OrgBatchCheckDto> ownEnableOrgList, OrgBatchCheckCacheModel cacheModel) {
        Set entryIdSet = ownEnableOrgList.stream().map(OrgBatchCheckDto::getEntryId).collect(Collectors.toSet());
        entryColl.forEach(entry -> {
            if (!entryIdSet.contains(entry.getLong("id"))) {
                ownEnableOrgList.add(OrgBatchBillConverter.putOwnEnableFieldMap(entry, cacheModel.getOperateType(), cacheModel.getEffectDate()));
            }
        });
        cacheModel.setOwnEnableOrgList(ownEnableOrgList);
    }

    public static void copyTargetObjectToCheckObject(DynamicObject targetObject, DynamicObject newCheckObj) {
        newCheckObj.set("id", targetObject.get("id"));
        newCheckObj.set("billno", targetObject.get("billno"));
        newCheckObj.set("effdt", targetObject.get("effdt"));
    }

    public static OrgBatchCheckDto putOwnEnableFieldMap(DynamicObject dynamicObject, int operateType, Date effectDate) {
        OrgBatchCheckDto checkDto = new OrgBatchCheckDto();
        checkDto.setEntryId(dynamicObject.getLong("id"));
        long changeTypeId = dynamicObject.getLong("changescene.orgchangetype.id");
        if (changeTypeId == 1010L && operateType == 2) {
            Long orgId = dynamicObject.getLong("adminorg");
            checkDto.setOrgId(orgId);
            checkDto.setOrgBoId(orgId);
            checkDto.setOrgBsed(effectDate);
        } else {
            checkDto.setOrgId(dynamicObject.getLong("adminorg.id"));
            checkDto.setOrgBoId(dynamicObject.getLong("adminorg.boid"));
            checkDto.setOrgBsed(dynamicObject.getDate("adminorg.bsed"));
        }
        checkDto.setChangeTypeId(changeTypeId);
        checkDto.setOrgTypeStdId(dynamicObject.getLong("adminorgtype.adminorgtypestd.id"));
        checkDto.setParentOrgId(dynamicObject.getLong("parentorg.id"));
        checkDto.setParentOrgBoId(dynamicObject.getLong("parentorg.boid"));
        checkDto.setNumber(dynamicObject.getString("number"));
        checkDto.setName(dynamicObject.getString("name"));
        checkDto.setOrgNameObj(dynamicObject.get("name"));
        return checkDto;
    }

    public static DynamicObject converterEntityField(HRBaseServiceHelper baseHelper, String entryKey, DynamicObject dynamicObject) {
        DynamicObject newObj = baseHelper.generateEmptyDynamicObject();
        DataEntityPropertyCollection properties = newObj.getDataEntityType().getProperties();
        Set propSet = properties.stream().map(property -> property.getName()).collect(Collectors.toSet());
        List<String> fields = OrgBatchBillConverter.getFormFields("homs_orgbatchchgbill", entryKey);
        String prefix = EntryEntityEnum.getPrefixByEntryKey(entryKey);
        for (String field : fields) {
            String subField = field.substring(prefix.length());
            if (!propSet.contains(subField)) continue;
            newObj.set(subField, dynamicObject.get(field));
        }
        newObj.set("id", dynamicObject.get("id"));
        return newObj;
    }

    public static List<String> getFormFields(String entityName, String entryName) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        Map allEntities = dataEntityType.getAllEntities();
        if (CollectionUtils.isEmpty((Map)allEntities)) {
            return new ArrayList<String>(10);
        }
        EntityType entityType = (EntityType)allEntities.get(entryName);
        if (entityType == null) {
            return new ArrayList<String>(10);
        }
        Map allFields = entityType.getFields();
        if (CollectionUtils.isEmpty((Map)allFields)) {
            return new ArrayList<String>(10);
        }
        return new ArrayList<String>(allFields.keySet());
    }
}

