/*
 * Decompiled with CFR 0.152.
 */
package kd.odc.homs.mservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.haos.business.domain.repository.staff.OrgUseStaffDetailRepository;
import kd.hr.haos.business.domain.repository.staff.PersonChangeEventRepository;
import kd.hr.haos.business.service.staff.occupy.impl.StaffOccupyServiceImpl;
import kd.hr.hbp.common.model.org.staff.StaffQueryInParam;
import kd.hr.hbp.common.model.org.staff.StaffQueryOutParam;
import kd.hr.hbp.common.model.org.staff.StaffQueryOutParamMap;
import kd.hr.hbp.common.model.org.staff.StaffUseInParam;
import kd.hr.hbp.common.util.HRStringUtils;

public abstract class AbstractStaffUseCommonService {
    private static final Log logger = LogFactory.getLog(AbstractStaffUseCommonService.class);
    String DLOCK_STAFFUSE_MSG_PREFIX = "dlock_staffuse_msg_";

    public List<DLock> handleLock(List<StaffUseInParam> staffUseInParams) throws KDBizException {
        ArrayList<DLock> locks = new ArrayList<DLock>(10);
        Set bizBillIds = staffUseInParams.stream().map(staffUseInParam -> staffUseInParam.getBizBillId()).collect(Collectors.toSet());
        for (Long bizBillId : bizBillIds) {
            DLock lock = DLock.create((String)(this.DLOCK_STAFFUSE_MSG_PREFIX + bizBillId));
            if (lock.tryLock(2000L)) {
                locks.add(lock);
                continue;
            }
            for (DLock locked : locks) {
                locked.unlock();
            }
            throw new KDBizException(new ErrorCode("hrmp.haos.lock.error", "lock error in the staffuse msg consumption"), new Object[0]);
        }
        return locks;
    }

    public void checkTCCStatus(List<StaffUseInParam> staffUseInParams) throws KDBizException {
        Set bizBillIds = staffUseInParams.stream().map(staffUseInParam -> staffUseInParam.getBizBillId()).collect(Collectors.toSet());
        DynamicObject[] result = PersonChangeEventRepository.getInstance().queryScheduleEffectData(new ArrayList(bizBillIds));
        if (result != null && result.length > 0) {
            throw new KDBizException(new ErrorCode("hrmp.haos.checkTCCStatus.error", "TCC is not completed,cannot consume the msg"), new Object[0]);
        }
    }

    public List<StaffUseInParam> handleReConsumer(List<StaffUseInParam> staffUseInParams, String type) {
        logger.info("the staffmsg.params is {}", staffUseInParams);
        ArrayList<Long> depEmpIds = new ArrayList<Long>(staffUseInParams.size());
        ArrayList<StaffQueryInParam> newQueryDataList = new ArrayList<StaffQueryInParam>(staffUseInParams.size());
        for (StaffUseInParam staffUseInParam : staffUseInParams) {
            StaffQueryInParam staffQueryInParam = this.useInParamTransQueryParam(staffUseInParam);
            if (staffQueryInParam != null) {
                newQueryDataList.add(staffQueryInParam);
            }
            depEmpIds.add(staffUseInParam.getDepEmpId());
        }
        Set<Object> comsumeDoneStrSet = new HashSet(16);
        if ("haos_orgusestaffdetail".equals(type)) {
            DynamicObject[] comsumeDoneOrgUseStaffs = OrgUseStaffDetailRepository.getInstance().queryEffStaffInfoByDepId(depEmpIds);
            comsumeDoneStrSet = Arrays.asList(comsumeDoneOrgUseStaffs).stream().map(comsumeDoneOrgUseStaff -> comsumeDoneOrgUseStaff.getString("orgperson.id")).collect(Collectors.toSet());
        }
        HashMap noStaffInDepEmpIdMap = new HashMap(16);
        StaffQueryOutParamMap staffQueryOutParamMap = new StaffOccupyServiceImpl(newQueryDataList).queryStaffOccupyInfo();
        for (Map.Entry staffQueryOutParamEntry : staffQueryOutParamMap.entrySet()) {
            if (!((StaffQueryOutParam)staffQueryOutParamEntry.getValue()).isSpecialRule()) continue;
            noStaffInDepEmpIdMap.put(((StaffQueryOutParam)staffQueryOutParamEntry.getValue()).getDepEmpId(), staffQueryOutParamEntry.getValue());
        }
        ArrayList<StaffUseInParam> validStaffUseInParams = new ArrayList<StaffUseInParam>(staffUseInParams.size());
        for (StaffUseInParam staffUseInParam : staffUseInParams) {
            String comsumeDoneStr = "";
            if ("haos_orgusestaffdetail".equals(type)) {
                comsumeDoneStr = String.valueOf(staffUseInParam.getDepEmpId());
            }
            if (comsumeDoneStrSet.contains(comsumeDoneStr)) continue;
            if (noStaffInDepEmpIdMap.containsKey(staffUseInParam.getDepEmpId())) {
                staffUseInParam.getOther().put("haos_noWriteStaffData", true);
            }
            validStaffUseInParams.add(staffUseInParam);
        }
        logger.info("the validStaffMsg.params is {}", validStaffUseInParams);
        return validStaffUseInParams;
    }

    public List<StaffUseInParam> transStaffUseInParam(List<Map<String, Object>> params) {
        ArrayList<StaffUseInParam> staffUseInParams = new ArrayList<StaffUseInParam>(params.size());
        for (Map<String, Object> param : params) {
            StaffUseInParam staffUseInParam = new StaffUseInParam();
            staffUseInParam.setCandidateId((Long)param.get("candidateId"));
            staffUseInParam.setDepEmpId((Long)param.get("depEmpId"));
            staffUseInParam.setPersonId((Long)param.get("personId"));
            staffUseInParam.setOrgTeamId((Long)param.get("orgTeamId"));
            staffUseInParam.setJobId((Long)param.get("jobId"));
            staffUseInParam.setJobLevelId((Long)param.get("joblevelId"));
            staffUseInParam.setDutyWorkRoleId((Long)param.get("dutyWorkRoleId"));
            staffUseInParam.setLaborRelTypeId((Long)param.get("laborRelTypeId"));
            staffUseInParam.setEffDate((Date)param.get("effDate"));
            staffUseInParam.setBizBillId((Long)param.get("bizBillId"));
            staffUseInParam.setChangeEventNumber((String)param.get("changeEventNumber"));
            Map other = (Map)Optional.ofNullable(param.get("other")).orElseGet(() -> new HashMap());
            if (param.get("oldDepEmpId") != null) {
                other.put("oldDepEmpId", param.get("oldDepEmpId"));
            }
            staffUseInParam.setOther(other);
            staffUseInParams.add(staffUseInParam);
        }
        return staffUseInParams;
    }

    private StaffQueryInParam useInParamTransQueryParam(StaffUseInParam staffUseInParam) {
        if ("1020_S".equals(staffUseInParam.getChangeEventNumber()) || "1060_S".equals(staffUseInParam.getChangeEventNumber())) {
            StaffQueryInParam staffQueryInParam = new StaffQueryInParam();
            staffQueryInParam.setCandidateId(staffUseInParam.getCandidateId());
            staffQueryInParam.setDepEmpId(staffUseInParam.getDepEmpId());
            staffQueryInParam.setPersonId(staffUseInParam.getPersonId());
            staffQueryInParam.setOrgTeamId(staffUseInParam.getOrgTeamId());
            staffQueryInParam.setDutyWorkRoleId(staffUseInParam.getDutyWorkRoleId());
            staffQueryInParam.setJobId(staffUseInParam.getJobId());
            staffQueryInParam.setJobLevelId(staffUseInParam.getJobLevelId());
            staffQueryInParam.setEffDate(staffUseInParam.getEffDate());
            staffQueryInParam.setLaborRelTypeId(staffUseInParam.getLaborRelTypeId());
            staffQueryInParam.setUpdate(staffUseInParam.isUpdate());
            Map other = Optional.ofNullable(staffUseInParam.getOther()).orElseGet(() -> new HashMap());
            staffQueryInParam.setOther(other);
            return staffQueryInParam;
        }
        return null;
    }

    protected String getMsgContent(DynamicObject messageContext) {
        if (messageContext == null) {
            logger.info("the messageContext is null");
            return null;
        }
        logger.info("the msg number is {},the msgsubno is {}", (Object)messageContext.getString("number"), (Object)messageContext.getString("msgsubno"));
        String params = messageContext.getString("msgcontent");
        if (HRStringUtils.isEmpty((String)params)) {
            logger.info("the msgContent is null or '' ");
            return null;
        }
        return params;
    }

    protected List<StaffUseInParam> getStaffUseInParams(DynamicObject messageContext) {
        String params = this.getMsgContent(messageContext);
        if (StringUtils.isEmpty((CharSequence)params)) {
            return null;
        }
        return this.transStaffUseInParam((List)SerializationUtils.deSerializeFromBase64((String)params));
    }
}

