/*
 * Decompiled with CFR 0.152.
 */
package kd.odc.homs.mservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.haos.business.service.adminorg.AdminOrgOpService;
import kd.hr.haos.common.util.OrgDateTimeUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.chgbill.AdminOrgChgBillSaveService;
import kd.hr.homs.business.service.helper.AdminOrgBatchChgHelper;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;
import kd.odc.homs.mservice.api.IAdminOrgOperateService;

public class AdminOrgOperateService
implements IAdminOrgOperateService {
    private static final Log logger = LogFactory.getLog(AdminOrgOperateService.class);
    private static final String ADMIN_ORG_NUMBER = "adminorg.number";
    private final HRBaseServiceHelper billHelper = new HRBaseServiceHelper("homs_orgbatchchgbill");
    private final HRBaseServiceHelper entityHelper = new HRBaseServiceHelper("homs_batchorgentity");

    public Map<String, Object> merge(DynamicObject billDy, List<DynamicObject> dyList, Map<String, DynamicObject> mergeMap) {
        if (CollectionUtils.isEmpty(dyList) && CollectionUtils.isEmpty(mergeMap)) {
            logger.error("dyList and mergeMap is Empty");
            return this.getResultMap("dyList and mergeMap is Empty");
        }
        this.setBillDefaultValue(billDy);
        DynamicObject[] newOrgArray = null;
        HashMap<String, Long> numberIdMap = new HashMap<String, Long>(16);
        if (!CollectionUtils.isEmpty(dyList)) {
            newOrgArray = this.buildTempNewOrg(dyList.stream().filter(dy -> dy.getLong("changetype.id") == OrgBatchChgBillConstants.CHANGE_TYPE_ADD.longValue()).collect(Collectors.toList()));
            dyList.stream().filter(dy -> mergeMap != null && mergeMap.containsKey(dy.getString(ADMIN_ORG_NUMBER))).forEach(dy -> numberIdMap.put(dy.getString(ADMIN_ORG_NUMBER), dy.getLong("adminorg.id")));
            this.setEntityVersionValue(dyList);
            this.setEntityDefaultValue(dyList, billDy.getLong("id"));
        } else {
            dyList = new ArrayList<DynamicObject>(10);
        }
        List<DynamicObject> mergeEntityList = this.buildMergeEntity(billDy.getLong("id"), numberIdMap, mergeMap);
        if (!CollectionUtils.isEmpty(mergeEntityList)) {
            dyList.addAll(mergeEntityList);
        }
        this.save(newOrgArray, billDy, dyList);
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"homs_orgbatchchgbill", (DynamicObject[])new DynamicObject[]{billDy}, (OperateOption)this.createOperateOption());
        if (!operationResult.isSuccess()) {
            this.delete(newOrgArray, billDy, dyList);
            return this.getResultMap(this.getErrorInfo(operationResult));
        }
        operationResult = OperationServiceHelper.executeOperate((String)"effectivedata", (String)"homs_orgbatchchgbill", (DynamicObject[])new DynamicObject[]{billDy}, (OperateOption)this.createOperateOption());
        if (!operationResult.isSuccess()) {
            this.delete(newOrgArray, billDy, dyList);
            return this.getResultMap(this.getErrorInfo(operationResult));
        }
        billDy.set("billtype", (Object)"1");
        this.billHelper.saveOne(billDy);
        return this.getResultMap("");
    }

    private String getErrorInfo(OperationResult operationResult) {
        List errorList;
        List list;
        String errorInfo = "";
        ValidateResultCollection validateResult = operationResult.getValidateResult();
        if (validateResult != null && !CollectionUtils.isEmpty((Collection)(list = validateResult.getValidateErrors())) && !CollectionUtils.isEmpty((Collection)(errorList = ((ValidateResult)list.get(0)).getAllErrorInfo()))) {
            errorInfo = ((OperateErrorInfo)errorList.get(0)).getMessage();
        }
        if ("".equals(errorInfo)) {
            errorInfo = "unknown check error";
        }
        return errorInfo;
    }

    private Map<String, Object> getResultMap(String errorMsg) {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        if (HRStringUtils.isEmpty((String)errorMsg)) {
            map.put("status", "success");
        } else {
            map.put("status", "error");
        }
        map.put("errMsg", errorMsg);
        return map;
    }

    private void txHandle(Consumer<String> consumer) {
        try (TXHandle required = TX.required();){
            try {
                consumer.accept(null);
            }
            catch (Exception ex) {
                logger.error((Throwable)ex);
                required.markRollback();
                throw ex;
            }
        }
    }

    private void delete(DynamicObject[] orgArr, DynamicObject billDy, List<DynamicObject> entityDyList) {
        this.txHandle(str -> {
            if (orgArr != null) {
                List orgIdList = Arrays.stream(orgArr).map(dy -> dy.getLong("adminorg.id")).collect(Collectors.toList());
                AdminOrgBatchChgHelper.delAddMaster(orgIdList);
            }
            this.billHelper.deleteOne((Object)billDy.getLong("id"));
            this.entityHelper.delete(entityDyList.stream().map(dy -> dy.getLong("id")).toArray());
        });
    }

    private void save(DynamicObject[] orgArr, DynamicObject billDy, List<DynamicObject> entityDyList) {
        this.txHandle(str -> {
            if (orgArr != null) {
                AdminOrgOpService.getInstance().saveTemporary(orgArr, Long.valueOf(0L), false);
            }
            this.billHelper.saveOne(billDy);
            this.entityHelper.save(entityDyList.toArray(new DynamicObject[0]));
        });
    }

    private void setBillDefaultValue(DynamicObject billDy) {
        if (billDy.getLong("id") == 0L) {
            billDy.set("id", (Object)ORM.create().genLongId("homs_orgbatchchgbill"));
        }
        billDy.set("billstatus", (Object)"C");
        billDy.set("billtype", (Object)"2");
    }

    private void setEntityVersionValue(List<DynamicObject> dyList) {
        List boIdList = dyList.stream().map(dy -> dy.getLong("adminorg.boid")).collect(Collectors.toList());
        AdminOrgChgBillSaveService service = AdminOrgChgBillSaveService.getInstance();
        Map oldVersionMap = service.getOrgRelateVersion(boIdList);
        Map oldOrgBasicInfo = service.getOrgBeforeChangeVersionBasicInfo(boIdList);
        service.setBeforeBillEntryVersionId((DynamicObject[])dyList.stream().filter(dy -> oldOrgBasicInfo.containsKey(dy.getLong("adminorg.boid"))).toArray(DynamicObject[]::new), oldVersionMap, oldOrgBasicInfo);
    }

    private void setEntityDefaultValue(List<DynamicObject> dyList, Long billId) {
        long[] ids = ORM.create().genLongIds("homs_batchorgentity", dyList.size());
        for (int index = 0; index < dyList.size(); ++index) {
            DynamicObject entityDy = dyList.get(index);
            entityDy.set("id", (Object)ids[index]);
            entityDy.set("billid", (Object)billId);
        }
    }

    private DynamicObject[] buildTempNewOrg(List<DynamicObject> newEntityList) {
        if (CollectionUtils.isEmpty(newEntityList)) {
            return null;
        }
        MainEntityType adminOrgType = EntityMetadataCache.getDataEntityType((String)"haos_adminorgdetail");
        DynamicObject[] orgArr = new DynamicObject[newEntityList.size()];
        long[] ids = ORM.create().genLongIds("haos_adminorgdetail", newEntityList.size());
        for (int index = 0; index < newEntityList.size(); ++index) {
            DynamicObject entityDy = newEntityList.get(index);
            DynamicObject orgDy = new DynamicObject((DynamicObjectType)adminOrgType);
            HRDynamicObjectUtils.copy((DynamicObject)entityDy, (DynamicObject)orgDy);
            orgDy.set("id", (Object)ids[index]);
            orgDy.set("boid", (Object)ids[index]);
            orgDy.set("bsed", (Object)entityDy.getDate("establishmentdate"));
            orgDy.set("bsled", (Object)OrgDateTimeUtil.BSLED);
            entityDy.set("adminorg", (Object)orgDy);
            orgArr[index] = orgDy;
        }
        return orgArr;
    }

    private List<DynamicObject> buildMergeEntity(Long billId, Map<String, Long> numberIdMap, Map<String, DynamicObject> mergeMap) {
        if (CollectionUtils.isEmpty(mergeMap)) {
            return null;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"homs_batchorgentity");
        Set numberSet = mergeMap.keySet().stream().filter(number -> !numberIdMap.containsKey(number)).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(numberSet)) {
            DynamicObjectCollection orgCol = AdOrgRepository.getInstance().queryColByNumber("id,number", numberSet);
            orgCol.forEach(dy -> numberIdMap.put(dy.getString("number"), dy.getLong("id")));
        }
        ArrayList<DynamicObject> mergeList = new ArrayList<DynamicObject>(10);
        for (Map.Entry<String, DynamicObject> entry : mergeMap.entrySet()) {
            DynamicObject entityDy;
            DynamicObject mergeDy = entry.getValue();
            Long afterMergeOrgId = numberIdMap.get(entry.getKey());
            for (DynamicObject toMergeOrg : mergeDy.getDynamicObjectCollection("tobemergeorg")) {
                Long toMergeOrgId = toMergeOrg.getLong("fbasedataid");
                entityDy = new DynamicObject((DynamicObjectType)entityType);
                this.setMergeDefaultValue(mergeDy, entityDy);
                entityDy.set("adminorg", (Object)toMergeOrgId);
                entityDy.set("beforemergeorgid", (Object)toMergeOrgId);
                entityDy.set("aftermergeorgid", (Object)afterMergeOrgId);
                mergeList.add(entityDy);
            }
            entityDy = new DynamicObject((DynamicObjectType)entityType);
            this.setMergeDefaultValue(mergeDy, entityDy);
            entityDy.set("beforemergeorgid", (Object)0L);
            entityDy.set("aftermergeorgid", (Object)afterMergeOrgId);
            entityDy.set("adminorg", (Object)afterMergeOrgId);
            mergeList.add(entityDy);
        }
        this.setEntityDefaultValue(mergeList, billId);
        return mergeList;
    }

    private void setMergeDefaultValue(DynamicObject mergeDy, DynamicObject entityDy) {
        entityDy.set("changescene", mergeDy.get("changescene"));
        entityDy.set("changereason", mergeDy.get("changereason"));
        entityDy.set("changedescription", mergeDy.get("changedescription"));
        entityDy.set("changetype", (Object)OrgBatchChgBillConstants.CHANGE_TYPE_MERGE);
        entityDy.set("mergesplitstatus", (Object)"2");
        entityDy.set("index", (Object)0);
    }

    private OperateOption createOperateOption() {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ishasright", "true");
        return operateOption;
    }
}

