/*
 * Decompiled with CFR 0.152.
 */
package kd.odc.homs.mservice;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.service.adminorg.bean.TeamCoopRelBO;
import kd.hr.haos.common.constants.structproject.StructProjectConstants;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.homs.business.service.domain.repository.AdminOrgReviseLogRepository;
import kd.hr.homs.business.service.helper.AdminOrgBatchChgHelper;
import kd.odc.homs.mservice.OrgMsgService;
import kd.odc.homs.mservice.api.IHAOSAdminOrgMsgQueryService;

public class HAOSAdminOrgMsgQueryServiceImpl
implements IHAOSAdminOrgMsgQueryService {
    private static Set<Long> operateSet = new HashSet<Long>(){
        {
            this.add(1010L);
            this.add(1020L);
            this.add(1030L);
            this.add(1040L);
        }
    };

    public Map<String, Object> orgDisableMsgQueryDetail(Long fid) {
        DynamicObject dynamicObject = this.getAdminorgByFid(fid);
        if (dynamicObject == null) {
            return new HashMap<String, Object>(0);
        }
        Long orgId = dynamicObject.getLong("boid");
        Map<String, Object> resultMap = this.getResultMap(dynamicObject, orgId);
        resultMap.put("positioning", dynamicObject.getString("positioning"));
        resultMap.put("mainduty", dynamicObject.getString("mainduty"));
        resultMap.put("safelevelid", dynamicObject.getLong("safelevel.id"));
        resultMap.put("safetypeid", dynamicObject.getLong("safetype.id"));
        resultMap.put("adminorglayerid", dynamicObject.getLong("adminorglayer.id"));
        resultMap.put("adminorgfunctionid", dynamicObject.getLong("adminorgfunction.id"));
        HashSet<Long> orgids = new HashSet<Long>();
        orgids.add(orgId);
        Map<Long, List<TeamCoopRelBO>> longListMap = HAOSAdminOrgMsgQueryServiceImpl.getBeforeOrgCoopRel(orgids);
        List teamCoopRelBOS = longListMap.getOrDefault(orgId, new ArrayList());
        ArrayList teamCoopRellist = new ArrayList();
        teamCoopRelBOS.forEach(teamcooprelbo -> {
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("coopTypeId", teamcooprelbo.getCoopTypeId());
            map.put("coopTeamId", teamcooprelbo.getCoopTeamId());
            teamCoopRellist.add(map);
        });
        resultMap.put("teamCoopRelModelList", teamCoopRellist);
        return resultMap;
    }

    private Map<String, Object> getResultMap(DynamicObject dynamicObject, Long orgId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("orgid", orgId);
        resultMap.put("number", dynamicObject.getString("number"));
        resultMap.put("name", dynamicObject.getString("name"));
        resultMap.put("parentorgid", dynamicObject.getLong("parentorg.id"));
        resultMap.put("adminorgtypeid", dynamicObject.getLong("adminorgtype.id"));
        resultMap.put("belongcompanyid", dynamicObject.getLong("belongcompany.id"));
        resultMap.put("corporateorgid", dynamicObject.getLong("corporateorg.id"));
        resultMap.put("companyareaid", dynamicObject.getLong("companyarea.id"));
        resultMap.put("cityid", dynamicObject.getLong("city.id"));
        resultMap.put("workplaceid", dynamicObject.getLong("workplace.id"));
        resultMap.put("tobedisableflag", dynamicObject.getString("tobedisableflag"));
        resultMap.put("org", dynamicObject.getString("org.id"));
        return resultMap;
    }

    public Map<String, Object> orgDisableEffectMsgQueryDetail(Long fid) {
        DynamicObject dynamicObject = this.getAdminorgByFid(fid);
        if (dynamicObject == null) {
            return new HashMap<String, Object>(0);
        }
        Long orgId = dynamicObject.getLong("boid");
        Map<String, Object> resultMap = this.getResultMap(dynamicObject, orgId);
        resultMap.put("enable", dynamicObject.getString("enable"));
        return resultMap;
    }

    public Map<String, Map<String, Object>> orgInfoChgQueryDetail(Long billid, Long entryid) {
        DynamicObject entryBo = this.getEntryBoByEntryId(billid, entryid);
        if (entryBo == null) {
            return new HashMap<String, Map<String, Object>>(0);
        }
        long fid = entryBo.getLong("adminorg.id");
        DynamicObject dynamicObject = this.getAdminorgByFid(fid);
        Map<String, Object> beforeChgInfo = this.getBeforeChgInfo(dynamicObject);
        beforeChgInfo.put("positioning", dynamicObject.getString("positioning"));
        beforeChgInfo.put("mainduty", dynamicObject.getString("mainduty"));
        Map<String, Object> afterChgInfo = this.getAfterChgInfo(entryBo);
        afterChgInfo.put("positioning", entryBo.getString("positioning"));
        afterChgInfo.put("mainduty", entryBo.getString("mainduty"));
        return this.setReturnMap(beforeChgInfo, afterChgInfo);
    }

    public Map<String, Map<String, Object>> orgInfoChgEffectQueryDetail(Long billid, Long boid) {
        DynamicObject entryBo = this.getEntryBo(billid, boid);
        if (entryBo == null) {
            return new HashMap<String, Map<String, Object>>(0);
        }
        long fid = entryBo.getLong("adminorg.id");
        DynamicObject dynamicObject = this.getAdminorgByFid(fid);
        Map<String, Object> beforeChgInfo = this.getBeforeChgInfo(dynamicObject);
        beforeChgInfo.put("belongcompanyid", dynamicObject.getLong("belongcompany.id"));
        beforeChgInfo.put("adminorglayerid", dynamicObject.getLong("adminorglayer.id"));
        beforeChgInfo.put("adminorgfunctionid", dynamicObject.getLong("adminorgfunction.id"));
        Map<String, Object> afterChgInfo = this.getAfterChgInfo(entryBo);
        afterChgInfo.put("fid", entryBo.getLong("afterbaseinfoid"));
        afterChgInfo.put("belongcompanyid", dynamicObject.getLong("belongcompany.id"));
        afterChgInfo.put("adminorglayerid", entryBo.getLong("adminorglayer.id"));
        afterChgInfo.put("adminorgfunctionid", entryBo.getLong("adminorgfunction.id"));
        return this.setReturnMap(beforeChgInfo, afterChgInfo);
    }

    private Map<String, Map<String, Object>> setReturnMap(Map<String, Object> beforeChgInfo, Map<String, Object> afterChgInfo) {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        result.put("beforeChgInfo", beforeChgInfo);
        result.put("afterChgInfo", afterChgInfo);
        return result;
    }

    public Map<String, Map<String, Object>> orgParentChgQueryDetail(Long billid, Long entryid) {
        DynamicObject entryBo = this.getEntryBoByEntryId(billid, entryid);
        if (entryBo == null) {
            return new HashMap<String, Map<String, Object>>(0);
        }
        long fid = entryBo.getLong("adminorg.id");
        DynamicObject dynamicObject = this.getAdminorgByFid(fid);
        Map<String, Object> beforeChgInfo = this.getBeforeChgInfo(dynamicObject);
        beforeChgInfo.put("adminorglayerid", dynamicObject.getLong("adminorglayer.id"));
        beforeChgInfo.put("adminorgfunctionid", dynamicObject.getLong("adminorgfunction.id"));
        beforeChgInfo.put("positioning", dynamicObject.getString("positioning"));
        beforeChgInfo.put("mainduty", dynamicObject.getString("mainduty"));
        Map<String, Object> afterChgInfo = this.getAfterChgInfo(entryBo);
        afterChgInfo.put("positioning", entryBo.getString("positioning"));
        afterChgInfo.put("mainduty", entryBo.getString("mainduty"));
        afterChgInfo.put("adminorglayerid", entryBo.getLong("adminorglayer.id"));
        afterChgInfo.put("adminorgfunctionid", entryBo.getLong("adminorgfunction.id"));
        return this.setReturnMap(beforeChgInfo, afterChgInfo);
    }

    public Map<String, Map<String, Object>> orgParentChgEffectQueryDetail(Long billid, Long boid) {
        DynamicObject entryBo = this.getEntryBo(billid, boid);
        if (entryBo == null) {
            return new HashMap<String, Map<String, Object>>(0);
        }
        long fid = entryBo.getLong("adminorg.id");
        long afterbaseinfoid = entryBo.getLong("afterbaseinfoid");
        Map<Long, DynamicObject> map = this.getAdminorgChgByFids(new Long[]{fid, afterbaseinfoid});
        DynamicObject dynamicObjectBefore = map.get(fid);
        Map<String, Object> beforeChgInfo = this.getBeforeChgInfo(dynamicObjectBefore);
        beforeChgInfo.put("belongcompanyid", dynamicObjectBefore.getLong("belongcompany.id"));
        beforeChgInfo.put("structlongnumber", this.getStructlongnumber(dynamicObjectBefore.getLong("boid"), dynamicObjectBefore.getDate("bsed")));
        beforeChgInfo.put("adminorglayerid", dynamicObjectBefore.getLong("adminorglayer.id"));
        beforeChgInfo.put("adminorgfunctionid", dynamicObjectBefore.getLong("adminorgfunction.id"));
        beforeChgInfo.put("positioning", dynamicObjectBefore.getString("positioning"));
        beforeChgInfo.put("mainduty", dynamicObjectBefore.getString("mainduty"));
        Map<String, Object> afterChgInfo = this.getAfterChgInfo(entryBo);
        afterChgInfo.put("belongcompanyid", map.get(afterbaseinfoid).getLong("belongcompany.id"));
        afterChgInfo.put("fid", entryBo.getLong("afterbaseinfoid"));
        afterChgInfo.put("positioning", entryBo.getString("positioning"));
        afterChgInfo.put("mainduty", entryBo.getString("mainduty"));
        afterChgInfo.put("adminorglayerid", entryBo.getLong("adminorglayer.id"));
        afterChgInfo.put("adminorgfunctionid", entryBo.getLong("adminorgfunction.id"));
        afterChgInfo.put("structlongnumber", this.getAfterStructLongNumber(entryBo));
        return this.setReturnMap(beforeChgInfo, afterChgInfo);
    }

    public Map<String, Object> orgOrgAddQueryDetail(Long billid, Long entryid) {
        DynamicObject entryBo = this.getEntryBoByEntryId(billid, entryid);
        if (entryBo == null) {
            return new HashMap<String, Object>(0);
        }
        long fid = entryBo.getLong("adminorg.id");
        DynamicObjectCollection cooprelentryentity = entryBo.getDynamicObjectCollection("cooprelentryentity");
        DynamicObject dynamicObject = this.getAdminorgByFid(fid);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
        resultMap.put("number", dynamicObject.getString("number"));
        resultMap.put("name", dynamicObject.getString("name"));
        resultMap.put("simplename", dynamicObject.getString("simplename"));
        resultMap.put("parentorgid", dynamicObject.getLong("parentorg.id"));
        resultMap.put("adminorgtypeid", dynamicObject.getLong("adminorgtype.id"));
        resultMap.put("corporateorgid", dynamicObject.getLong("corporateorg.id"));
        resultMap.put("adminorgfunctionid", dynamicObject.getLong("adminorgfunction.id"));
        resultMap.put("adminorglayerid", dynamicObject.getLong("adminorglayer.id"));
        resultMap.put("companyareaid", dynamicObject.getLong("companyarea.id"));
        resultMap.put("cityid", dynamicObject.getLong("city.id"));
        resultMap.put("workplaceid", dynamicObject.getLong("workplace.id"));
        resultMap.put("establishmentdate", dynamicObject.getDate("establishmentdate"));
        resultMap.put("positioning", dynamicObject.getString("positioning"));
        resultMap.put("mainduty", dynamicObject.getString("mainduty"));
        resultMap.put("safelevelid", dynamicObject.getLong("safelevel.id"));
        resultMap.put("safetypeid", dynamicObject.getLong("safetype.id"));
        resultMap.put("org", dynamicObject.getString("org.id"));
        ArrayList teamCoopRelBOList = new ArrayList();
        for (DynamicObject dy : cooprelentryentity) {
            long coopreltyp = dy.getLong("coopreltyp.id");
            long cooporgteam = dy.getLong("cooporgteam.boid");
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("coopTypeId", coopreltyp);
            map.put("coopTeamId", cooporgteam);
            teamCoopRelBOList.add(map);
        }
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("coopTypeId", 1010L);
        map.put("coopTeamId", dynamicObject.getLong("parentorg.id"));
        teamCoopRelBOList.add(map);
        resultMap.put("teamCoopRelModelList", teamCoopRelBOList);
        return resultMap;
    }

    public Object orgMergeAndSplitDetailForEffect(Long changeoperatid, Long billid, Long boid, Long fid) {
        Long zero = 0L;
        if (!operateSet.contains(changeoperatid)) {
            return new HashMap();
        }
        if (changeoperatid.equals(1010L)) {
            if (fid == null || zero.equals(fid)) {
                return new HashMap();
            }
            OrgMsgService iOrgMsgService = new OrgMsgService();
            return iOrgMsgService.getOrgInfoByOrgVidForAdd(fid);
        }
        if (changeoperatid.equals(1020L)) {
            if (billid == null || zero.equals(billid) || boid == null || zero.equals(boid)) {
                return new HashMap();
            }
            return this.orgParentChgEffectQueryDetail(billid, boid);
        }
        if (changeoperatid.equals(1030L)) {
            if (billid == null || zero.equals(billid) || boid == null || zero.equals(boid)) {
                return new HashMap();
            }
            return this.orgInfoChgEffectQueryDetail(billid, boid);
        }
        if (changeoperatid.equals(1040L)) {
            if (fid == null || zero.equals(fid)) {
                return new HashMap();
            }
            return this.orgDisableEffectMsgQueryDetail(fid);
        }
        return new HashMap();
    }

    public Object orgMergeAndSplitDetailForSubmit(Long changeoperatid, Long billid, Long entryid, Long fid) {
        return this.orgMergeAndSplitDetailForApproval(changeoperatid, billid, entryid, fid);
    }

    public Object orgMergeAndSplitDetailForApproval(Long changeoperatid, Long billid, Long entryid, Long fid) {
        boolean invalid;
        Long zero = 0L;
        if (!operateSet.contains(changeoperatid)) {
            return new HashMap();
        }
        boolean bl = invalid = billid == null || zero.equals(billid) || entryid == null || zero.equals(entryid);
        if (changeoperatid.equals(1010L)) {
            if (invalid) {
                return new HashMap();
            }
            return this.orgOrgAddQueryDetail(billid, entryid);
        }
        if (changeoperatid.equals(1020L)) {
            if (invalid) {
                return new HashMap();
            }
            return this.orgParentChgQueryDetail(billid, entryid);
        }
        if (changeoperatid.equals(1030L)) {
            if (invalid) {
                return new HashMap();
            }
            return this.orgInfoChgQueryDetail(billid, entryid);
        }
        if (changeoperatid.equals(1040L)) {
            if (fid == null || zero.equals(fid)) {
                return new HashMap();
            }
            return this.orgDisableMsgQueryDetail(fid);
        }
        return new HashMap();
    }

    public Map<String, Object> adminOrgReviseQueryInfo(Long adminOrgBoId, Long eventId) {
        if (adminOrgBoId == null || adminOrgBoId == 0L || eventId == null || eventId == 0L) {
            return new HashMap<String, Object>();
        }
        QFilter qFilter = new QFilter("event", "=", (Object)eventId);
        QFilter boFilter = new QFilter("adminorgbo", "=", (Object)adminOrgBoId);
        DynamicObject[] query = AdminOrgReviseLogRepository.getInstance().query("id,orgentryentity,orgentryentity.beforeorg,orgentryentity.afterorg", new QFilter[]{qFilter, boFilter});
        if (query == null || query.length == 0) {
            return new HashMap<String, Object>();
        }
        HashSet allIds = new HashSet(10);
        Arrays.stream(query).forEach(dyn -> {
            if (dyn.getDynamicObjectCollection("orgentryentity") != null) {
                dyn.getDynamicObjectCollection("orgentryentity").forEach(dy -> {
                    if (dy.getLong("beforeorg.id") != 0L) {
                        allIds.add(dy.getLong("beforeorg.id"));
                    }
                    if (dy.getLong("afterorg.id") != 0L) {
                        allIds.add(dy.getLong("afterorg.id"));
                    }
                });
            }
        });
        if (allIds.size() == 0) {
            return new HashMap<String, Object>();
        }
        Map<Long, List<DynamicObject>> idToDynMap = Arrays.stream(AdminOrgBatchChgHelper.getOrgDyById(new ArrayList(allIds))).collect(Collectors.groupingBy(dyn -> dyn.getLong("id")));
        return this.buildResult(adminOrgBoId, query, idToDynMap);
    }

    private Map<String, Object> buildResult(Long adminOrgBoId, DynamicObject[] query, Map<Long, List<DynamicObject>> idToDynMap) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("adminOrgBoId", String.valueOf(adminOrgBoId));
        List reviseInfo = (List)map.computeIfAbsent("reviseInfo", k -> new ArrayList());
        Arrays.stream(query).forEach(dyn -> {
            if (dyn.getDynamicObjectCollection("orgentryentity") != null) {
                dyn.getDynamicObjectCollection("orgentryentity").forEach(dy -> {
                    List beforeorgid = (List)idToDynMap.get(dy.getLong("beforeorg.id"));
                    HashMap<String, Object> innerMap = new HashMap<String, Object>(16);
                    if (beforeorgid != null && beforeorgid.size() != 0) {
                        innerMap.put("beforeRevise", this.buildOrgInfo((DynamicObject)beforeorgid.get(0)));
                    } else {
                        innerMap.put("beforeRevise", "");
                    }
                    List afterorgid = (List)idToDynMap.get(dy.getLong("afterorg.id"));
                    if (afterorgid != null && afterorgid.size() != 0) {
                        innerMap.put("afterRevise", this.buildOrgInfo((DynamicObject)afterorgid.get(0)));
                    } else {
                        innerMap.put("afterRevise", "");
                    }
                    reviseInfo.add(innerMap);
                });
            }
        });
        return map;
    }

    private Map<String, Object> buildOrgInfo(DynamicObject orgInfo) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put("id", orgInfo.getString("id"));
        resultMap.put("number", orgInfo.getString("number"));
        resultMap.put("name", orgInfo.getString("name"));
        resultMap.put("parentOrgId", orgInfo.getString("parentorg.id"));
        resultMap.put("adminOrgTypeId", orgInfo.getString("adminorgtype.id"));
        resultMap.put("belongCompanyId", orgInfo.getString("belongcompany.id"));
        resultMap.put("corporateOrgId", orgInfo.getString("corporateorg.id"));
        resultMap.put("adminOrgFunctionId", orgInfo.getString("adminorgfunction.id"));
        resultMap.put("adminOrgLayer", orgInfo.getString("adminorglayer.id"));
        resultMap.put("companyAreaId", orgInfo.getString("companyarea.id"));
        resultMap.put("cityId", orgInfo.getString("city.id"));
        resultMap.put("workplace", orgInfo.getString("workplace.id"));
        resultMap.put("tobeDisableFlag", orgInfo.getBoolean("tobedisableflag"));
        resultMap.put("positioning", orgInfo.getString("positioning"));
        resultMap.put("mainDuty", orgInfo.getString("mainduty"));
        resultMap.put("safeLevel", orgInfo.getLong("safelevel.id"));
        resultMap.put("safeType", orgInfo.getLong("safetype.id"));
        resultMap.put("bsed", orgInfo.getDate("bsed"));
        resultMap.put("bsled", orgInfo.getDate("bsled"));
        resultMap.put("datastatus", orgInfo.getString("datastatus"));
        return resultMap;
    }

    private Map<Long, DynamicObject> getAdminorgChgByFids(Long[] fids) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter filter = new QFilter("id", "in", (Object)fids);
        DynamicObject[] dynamicObjects = helper.queryOriginalArray("id, boid,number,name,parentorg.id, adminorgtype.id,belongcompany.id,corporateorg.id,companyarea.id, city.id,workplace.id, tobedisableflag, positioning,mainduty,safelevel.id,safetype.id, adminorglayer.id, adminorgfunction.id, enable, bsed, bsled, org.id", filter.toArray());
        return Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity()));
    }

    private String getAfterStructLongNumber(DynamicObject entrybo) {
        long afterStructId = entrybo.getLong("afterstructid");
        HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_adminorgstruct");
        DynamicObject structDy = helper.queryOriginalOne("structlongnumber", new QFilter("id", "=", (Object)afterStructId).and((QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get()));
        return structDy.getString("structlongnumber");
    }

    private String getStructlongnumber(long boid, Date bsed) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_adminorgstruct");
        QFilter filter = new QFilter("adminorg", "=", (Object)boid);
        filter.and(new QFilter("bsed", "<=", (Object)bsed));
        filter.and(new QFilter("bsled", ">=", (Object)bsed));
        filter.and(new QFilter("datastatus", "in", (Object)new String[]{"1", "2"}));
        filter.and(new QFilter("enable", "=", (Object)"1"));
        filter.and((QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get());
        DynamicObject dynamicObject = helper.queryOriginalOne("structlongnumber", filter.toArray());
        return dynamicObject.getString("structlongnumber");
    }

    private DynamicObject getEntryBo(long billId, long boid) {
        if (billId == 0L || boid == 0L) {
            return null;
        }
        QFilter billIdFilter = new QFilter("billid", "=", (Object)billId);
        QFilter entryIdFilter = new QFilter("adminorg.boid", "=", (Object)boid);
        HRBaseServiceHelper entryHelp = new HRBaseServiceHelper("homs_batchorgentity");
        DynamicObject entrybo = entryHelp.loadDynamicObject(new QFilter[]{billIdFilter, entryIdFilter});
        return entrybo;
    }

    private DynamicObject getEntryBoByEntryId(Long billid, Long entryid) {
        QFilter billIdFilter = new QFilter("billid", "=", (Object)billid);
        QFilter entryIdFilter = new QFilter("id", "=", (Object)entryid);
        HRBaseServiceHelper entryHelp = new HRBaseServiceHelper("homs_batchorgentity");
        DynamicObject entryBo = entryHelp.loadDynamicObject(new QFilter[]{billIdFilter, entryIdFilter});
        return entryBo;
    }

    private Map<String, Object> getAfterChgInfo(DynamicObject entrybo) {
        HashMap<String, Object> afterChgMap = new HashMap<String, Object>();
        afterChgMap.put("number", entrybo.getString("number"));
        afterChgMap.put("name", entrybo.getString("name"));
        afterChgMap.put("parentorgid", entrybo.getLong("parentorg.boid"));
        afterChgMap.put("adminorgtypeid", entrybo.getLong("adminorgtype.id"));
        afterChgMap.put("corporateorgid", entrybo.getLong("corporateorg.id"));
        afterChgMap.put("companyareaid", entrybo.getLong("companyarea.id"));
        afterChgMap.put("cityid", entrybo.getLong("city.id"));
        afterChgMap.put("workplaceid", entrybo.getLong("workplace.id"));
        afterChgMap.put("tobedisableflag", entrybo.getString("tobedisableflag"));
        afterChgMap.put("safelevelid", entrybo.getLong("safelevel.id"));
        afterChgMap.put("safetypeid", entrybo.getLong("safetype.id"));
        afterChgMap.put("org", entrybo.getLong("org.id"));
        Map<Long, Long> afterOrgCoopRel = HAOSAdminOrgMsgQueryServiceImpl.getAfterOrgCoopRel(entrybo.getLong("id"), entrybo.getLong("parentorg.boid"));
        ArrayList teamCoopRelBOList = new ArrayList();
        afterOrgCoopRel.forEach((coopTypeId, coopTeamId) -> {
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("coopTypeId", (Long)coopTypeId);
            map.put("coopTeamId", (Long)coopTeamId);
            teamCoopRelBOList.add(map);
        });
        afterChgMap.put("teamCoopRelModelList", teamCoopRelBOList);
        return afterChgMap;
    }

    private Map<String, Object> getBeforeChgInfo(DynamicObject dynamicObject) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("fid", dynamicObject.getLong("id"));
        resultMap.put("number", dynamicObject.getString("number"));
        resultMap.put("name", dynamicObject.getString("name"));
        resultMap.put("parentorgid", dynamicObject.getLong("parentorg.id"));
        resultMap.put("adminorgtypeid", dynamicObject.getLong("adminorgtype.id"));
        resultMap.put("corporateorgid", dynamicObject.getLong("corporateorg.id"));
        resultMap.put("companyareaid", dynamicObject.getLong("companyarea.id"));
        resultMap.put("cityid", dynamicObject.getLong("city.id"));
        resultMap.put("workplaceid", dynamicObject.getLong("workplace.id"));
        resultMap.put("tobedisableflag", dynamicObject.getString("tobedisableflag"));
        resultMap.put("safelevelid", dynamicObject.getLong("safelevel.id"));
        resultMap.put("safetypeid", dynamicObject.getLong("safetype.id"));
        resultMap.put("org", dynamicObject.getString("org.id"));
        HashSet<Long> orgids = new HashSet<Long>();
        Long boid = dynamicObject.getLong("boid");
        orgids.add(boid);
        Map<Long, List<TeamCoopRelBO>> longListMap = HAOSAdminOrgMsgQueryServiceImpl.getBeforeOrgCoopRel(orgids);
        List teamCoopRelBOS = longListMap.getOrDefault(boid, new ArrayList());
        ArrayList teamCoopRellist = new ArrayList();
        teamCoopRelBOS.forEach(teamcooprelbo -> {
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("coopTypeId", teamcooprelbo.getCoopTypeId());
            map.put("coopTeamId", teamcooprelbo.getCoopTeamId());
            teamCoopRellist.add(map);
        });
        resultMap.put("teamCoopRelModelList", teamCoopRellist);
        return resultMap;
    }

    public DynamicObject getAdminorgByFid(Long fid) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter filter = new QFilter("id", "=", (Object)fid);
        DynamicObject dynamicObject = helper.queryOriginalOne("id, boid,number,name,parentorg.id, adminorgtype.id,belongcompany.id,corporateorg.id,establishmentdate,companyarea.id, city.id,workplace.id, simplename, tobedisableflag, positioning,mainduty,safelevel.id,safetype.id, adminorglayer.id, adminorgfunction.id, enable, bsed, bsled, org.id", filter);
        return dynamicObject;
    }

    public static Map<Long, List<TeamCoopRelBO>> getBeforeOrgCoopRel(Set<Long> orgIdSet) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_orgteamcooprel");
        QFilter filter = new QFilter("org", "in", orgIdSet);
        filter.and("datastatus", "in", (Object)new String[]{"1", "2"});
        filter.and("enable", "=", (Object)"1");
        filter.and("iscurrentversion", "=", (Object)"0");
        DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray(new QFilter[]{filter});
        HashMap<Long, List<TeamCoopRelBO>> oldOrgTeamCoopRelMap = new HashMap<Long, List<TeamCoopRelBO>>(orgIdSet.size());
        for (DynamicObject dynamicObject : dynamicObjects) {
            long orgTeamId = dynamicObject.getLong("org.id");
            long coopTypeId = dynamicObject.getLong("coopreltype.id");
            long coopTeamId = dynamicObject.getLong("cooporgteam.id");
            int index = dynamicObject.getInt("index");
            long boId = dynamicObject.getLong("boid");
            TeamCoopRelBO teamCoopRelBO = new TeamCoopRelBO(Long.valueOf(orgTeamId), Long.valueOf(coopTypeId), Long.valueOf(coopTeamId), index);
            teamCoopRelBO.setBoId(Long.valueOf(boId));
            teamCoopRelBO.setOldTeamCoopRelDyn(dynamicObject);
            ArrayList<TeamCoopRelBO> teamCoopRelBOS = (ArrayList<TeamCoopRelBO>)oldOrgTeamCoopRelMap.get(orgTeamId);
            if (Objects.isNull(teamCoopRelBOS)) {
                teamCoopRelBOS = new ArrayList<TeamCoopRelBO>(4);
            }
            teamCoopRelBOS.add(teamCoopRelBO);
            oldOrgTeamCoopRelMap.put(orgTeamId, teamCoopRelBOS);
        }
        return oldOrgTeamCoopRelMap;
    }

    public static Map<Long, Long> getAfterOrgCoopRel(Long entryid, Long parentboid) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("homs_batchentrycoop");
        QFilter filter = new QFilter("entryid", "=", (Object)entryid);
        DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray(new QFilter[]{filter});
        HashMap<Long, Long> map = new HashMap<Long, Long>(dynamicObjects.length + 1);
        for (DynamicObject dynamicObject : dynamicObjects) {
            long coopTypeId = dynamicObject.getLong("coopreltyp.id");
            long coopTeamId = dynamicObject.getLong("cooporgteam.boid");
            map.put(coopTypeId, coopTeamId);
        }
        map.put(1010L, parentboid);
        return map;
    }
}

