/*
 * Decompiled with CFR 0.152.
 */
package kd.odc.homs.mservice;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.odc.homs.mservice.api.IHOMSAdminChgDetailService;

public class HOMSAdminChgDetailServiceImpl
implements IHOMSAdminChgDetailService {
    private static final Log LOG = LogFactory.getLog(HOMSAdminChgDetailServiceImpl.class);

    public Map<String, Object> saveAdminChgDetail(List<Map<String, Object>> detailList) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)3);
        try {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("homs_orgchgrecord");
            helper.save(this.buildDynamicObjects(detailList));
            resultMap.put("code", 200);
            resultMap.put("status", "success");
            resultMap.put("errMsg", "");
        }
        catch (Exception ex) {
            LOG.error("HOMSAdminChgDetailServiceImpl method[HOMSAdminChgDetailServiceImpl] failed", (Throwable)ex);
            resultMap.put("code", 500);
            resultMap.put("status", "error");
            resultMap.put("errMsg", ex.getMessage());
        }
        return resultMap;
    }

    private DynamicObject[] buildDynamicObjects(List<Map<String, Object>> detailList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("homs_orgchgrecord");
        ArrayList adminChgDetailLists = Lists.newArrayListWithCapacity((int)detailList.size());
        for (Map<String, Object> map : detailList) {
            DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
            dynamicObject.set("adminorg", map.get("adminorg"));
            dynamicObject.set("initbatch", map.get("initbatch"));
            dynamicObject.set("initdatasource", map.get("initdatasource"));
            dynamicObject.set("initstatus", map.get("initstatus"));
            DynamicObjectCollection orgchgentryCollection = dynamicObject.getDynamicObjectCollection("orgchgentry");
            DynamicObjectType dynamicObjectType = orgchgentryCollection.getDynamicObjectType();
            DynamicObject orgchgentry = new DynamicObject(dynamicObjectType);
            Map orgchgentryMap = (Map)map.get("orgchgentry");
            orgchgentry.set("chgeffecttime", orgchgentryMap.get("chgeffecttime"));
            orgchgentry.set("changescene", orgchgentryMap.get("changescene"));
            orgchgentry.set("changetype", orgchgentryMap.get("changetype"));
            orgchgentry.set("operator", orgchgentryMap.get("operator"));
            orgchgentry.set("operationtime", orgchgentryMap.get("operationtime"));
            orgchgentry.set("afterchgorg", orgchgentryMap.get("afterchgorg"));
            orgchgentryCollection.add((Object)orgchgentry);
            dynamicObject.set("orgchgentry", (Object)orgchgentryCollection);
            adminChgDetailLists.add(dynamicObject);
        }
        return adminChgDetailLists.toArray(new DynamicObject[0]);
    }

    public Map<String, Object> deleteAdminChgByInitBatch(long initBatch) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)3);
        try {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("homs_orgchgrecord");
            helper.deleteByFilter(new QFilter[]{new QFilter("initbatch", "=", (Object)initBatch)});
            resultMap.put("code", 200);
            resultMap.put("status", "success");
            resultMap.put("errMsg", "");
        }
        catch (Exception ex) {
            LOG.error("HOMSAdminChgDetailServiceImpl method[deleteAdminChgByInitBatch] failed", (Throwable)ex);
            resultMap.put("code", 500);
            resultMap.put("status", "error");
            resultMap.put("errMsg", ex.getMessage());
        }
        return resultMap;
    }

    public Map<String, Object> updateAdminChgByInitBatch(long initBatch) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)3);
        try {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("homs_orgchgrecord");
            QFilter[] filters = new QFilter[]{new QFilter("initbatch", "=", (Object)initBatch)};
            int count = helper.count("homs_orgchgrecord", filters);
            int pageSize = this.getPageSize();
            int pageCount = (int)Math.ceil((double)count / (double)pageSize);
            DynamicObject[] dynamicObjects = null;
            for (int pageIndex = 0; pageIndex < pageCount; ++pageIndex) {
                for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"homs_orgchgrecord", (String)"initstatus", (QFilter[])filters, (String)"id", (int)pageIndex, (int)pageSize)) {
                    dynamicObject.set("initstatus", (Object)"2");
                }
                helper.update(dynamicObjects);
                dynamicObjects = null;
            }
            resultMap.put("code", 200);
            resultMap.put("status", "success");
            resultMap.put("errMsg", "");
        }
        catch (Exception ex) {
            LOG.error("HOMSAdminChgDetailServiceImpl method[updateAdminChgByInitBatch] failed", (Throwable)ex);
            resultMap.put("code", 500);
            resultMap.put("status", "error");
            resultMap.put("errMsg", ex.getMessage());
        }
        return resultMap;
    }

    private int getPageSize() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_odcconfigparam");
        DynamicObject dynamicObject = serviceHelper.queryOne("value", new QFilter[]{new QFilter("number", "=", (Object)"OrgInitPageSIze")});
        return Integer.parseInt(dynamicObject.getString("value"));
    }
}

