/*
 * Decompiled with CFR 0.152.
 */
package kd.odc.homs.mservice;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbpm.business.application.impl.position.DarkPositionApplicationImpl;
import kd.hrmp.hbpm.business.application.impl.position.OrgPositionMessageApplicationImpl;
import kd.hrmp.hbpm.business.application.position.IDarkPositionApplication;
import kd.hrmp.hbpm.business.application.position.IOrgPositionMessageApplication;
import kd.odc.homs.mservice.api.IPositionConsumerService;

public class PositionConsumerServiceImpl
implements IPositionConsumerService {
    private static final Log LOG = LogFactory.getLog(PositionConsumerServiceImpl.class);
    public IDarkPositionApplication darkPositionApplication = new DarkPositionApplicationImpl();
    public IOrgPositionMessageApplication orgPositionMessageApplication = new OrgPositionMessageApplicationImpl();

    public void disableDarkPosition(DynamicObject messageContext) {
        Map<String, Object> msgContent = this.getMsgContent(messageContext);
        if (msgContent != null && !msgContent.isEmpty()) {
            List darkPositionIds = (List)msgContent.get("position");
            this.darkPositionApplication.disableDarkPosition(darkPositionIds);
        }
    }

    public void enableDarkPosition(DynamicObject messageContext) {
        Map<String, Object> msgContent = this.getMsgContent(messageContext);
        if (msgContent != null && !msgContent.isEmpty()) {
            List darkPositionIds = (List)msgContent.get("position");
            this.darkPositionApplication.enableDarkPosition(darkPositionIds);
        }
    }

    public void orgDisablePosition(DynamicObject messageContext) {
        Map<String, Object> msgContent = this.getMsgContent(messageContext);
        if (msgContent != null && !msgContent.isEmpty()) {
            Long orgId = this.parseLong(msgContent.get("boid"));
            this.orgPositionMessageApplication.orgDisablePosition(Collections.singletonList(orgId));
        }
    }

    public void orgChangePosition(DynamicObject messageContext) {
        LOG.info("msghandle_orgChangePosition start");
        Map<String, Object> msgContent = this.getMsgContent(messageContext);
        LOG.info("msghandle_orgChangePosition msgcontent {}", msgContent);
        if (msgContent != null && !msgContent.isEmpty()) {
            Object orgId;
            if (!HRStringUtils.equals((String)"1", (String)msgContent.getOrDefault("datastatus", "1").toString())) {
                return;
            }
            List scenesub = (List)msgContent.get("scenesub");
            if (!CollectionUtils.isEmpty((Collection)scenesub) && scenesub.contains(1110L)) {
                Object toBeDisableFlag = msgContent.get("tobedisableflag");
                orgId = msgContent.get("boid");
                if (Objects.isNull(toBeDisableFlag) || Objects.isNull(orgId)) {
                    LOG.info(String.format(Locale.ROOT, "the params hasNull orgId: %s , toBeDisableFlag : %s", orgId, toBeDisableFlag));
                    return;
                }
                String toBeDisable = "0";
                if (((Boolean)toBeDisableFlag).booleanValue()) {
                    toBeDisable = "1";
                }
                this.orgPositionMessageApplication.orgChangePosition(Collections.singletonList(this.parseLong(orgId)), toBeDisable);
            }
            if (!CollectionUtils.isEmpty((Collection)scenesub) && scenesub.contains(1020L)) {
                Long orgId2 = this.parseLong(msgContent.get("boid"));
                Date bsed = (Date)msgContent.get("bsed");
                this.darkPositionApplication.handleLeaderDardPositionUpReport(orgId2, bsed);
            }
            if (!CollectionUtils.isEmpty((Collection)scenesub) && scenesub.contains(1120L)) {
                Object adminOrgId = msgContent.get("boid");
                orgId = msgContent.get("afterOrgId");
                Object bsed = msgContent.get("bsed");
                if (Objects.isNull(adminOrgId) || Objects.isNull(orgId) || Objects.isNull(bsed)) {
                    LOG.info(String.format(Locale.ROOT, "change org message the params hasNull adminOrgId is %1$s, orgId: %2$s, bsed : %3$s", adminOrgId, orgId, bsed));
                    return;
                }
                this.orgPositionMessageApplication.positionChangeOrg(this.parseLong(adminOrgId), this.parseLong(orgId), (Date)bsed);
            }
        }
        LOG.info("msghandle_orgChangePosition end");
    }

    private Long parseLong(Object orgId) {
        if (orgId instanceof String) {
            return Long.parseLong((String)orgId);
        }
        if (orgId instanceof Long) {
            return (Long)orgId;
        }
        if (orgId instanceof Integer) {
            return Long.parseLong(orgId + "");
        }
        return null;
    }

    private Map<String, Object> getMsgContent(DynamicObject messageContext) {
        if (messageContext == null) {
            LOG.info("the messageContext is null");
            return null;
        }
        String msgContent = messageContext.getString("msgContent");
        if (HRStringUtils.isEmpty((String)msgContent)) {
            LOG.info("the msgContent is null or '' ");
            return null;
        }
        return (Map)SerializationUtils.deSerializeFromBase64((String)msgContent);
    }
}

