/*
 * Decompiled with CFR 0.152.
 */
package kd.odc.homs.mservice;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.service.staff.service.impl.PersonStaffServiceImpl;
import kd.hr.hbp.common.model.org.staff.StaffUseInParam;
import kd.odc.homs.mservice.AbstractStaffUseCommonService;
import kd.odc.homs.mservice.api.IStaffUseAbortService;

public class StaffUseAbortServiceImpl
extends AbstractStaffUseCommonService
implements IStaffUseAbortService {
    private static final Log logger = LogFactory.getLog(StaffUseAbortServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void staffUseAbort(DynamicObject messageContext) {
        List<StaffUseInParam> staffUseInParamList = super.getStaffUseInParams(messageContext);
        if (CollectionUtils.isEmpty(staffUseInParamList)) {
            return;
        }
        List billIds = staffUseInParamList.stream().map(StaffUseInParam::getBizBillId).collect(Collectors.toList());
        logger.info("staffAbortMsg billid is {}", billIds);
        List<DLock> locks = this.handleLock(staffUseInParamList);
        try {
            this.checkTCCStatus(staffUseInParamList);
            try (TXHandle txHandle = TX.required();){
                try {
                    PersonStaffServiceImpl personStaffService = new PersonStaffServiceImpl();
                    personStaffService.msgAbortProcess(staffUseInParamList);
                }
                catch (Exception ex) {
                    txHandle.markRollback();
                    throw ex;
                }
            }
            catch (Exception ex) {
                logger.info("staffAbortMsg consume.exception is {}", (Object)ex.getMessage());
                throw ex;
            }
        }
        finally {
            for (DLock lock : locks) {
                lock.unlock();
            }
        }
    }
}

