/*
 * Decompiled with CFR 0.152.
 */
package kd.odc.homs.mservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.orgteam.OTQueryRepository;
import kd.hr.haos.business.domain.repository.staff.OrgPersonStaffInfoRepository;
import kd.hr.haos.business.service.staff.service.impl.PersonStaffServiceImpl;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.org.staff.StaffUseInParam;
import kd.hr.homs.business.service.helper.SystemParamHelper;
import kd.odc.homs.mservice.AbstractStaffUseCommonService;
import kd.odc.homs.mservice.api.IStaffUseActivityService;

public class StaffUseActivityServiceImpl
extends AbstractStaffUseCommonService
implements IStaffUseActivityService {
    private static final Log logger = LogFactory.getLog(StaffUseActivityServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void staffUseActivity(DynamicObject messageContext) throws Exception {
        List<StaffUseInParam> staffUseInParams = this.getStaffUseInParams(messageContext);
        List<DLock> locks = this.handleLock(staffUseInParams);
        try {
            this.checkTCCStatus(staffUseInParams);
            List<StaffUseInParam> transStaffInParamList = this.handleChangeEventNumber(staffUseInParams);
            List<StaffUseInParam> validStaffUseInParams = this.handleReConsumer(transStaffInParamList, "haos_staffactivity");
            this.validateLastEffected(validStaffUseInParams);
            try (TXHandle txHandle = TX.required();){
                try {
                    PersonStaffServiceImpl personStaffService = new PersonStaffServiceImpl();
                    if (!CollectionUtils.isEmpty(validStaffUseInParams)) {
                        personStaffService.msgEffect(validStaffUseInParams);
                    }
                }
                catch (Exception ex) {
                    txHandle.markRollback();
                    throw ex;
                }
            }
            catch (Exception ex) {
                logger.info("staffActivityMsg consume.exception is {}", (Object)ex.getMessage());
                throw ex;
            }
        }
        finally {
            for (DLock lock : locks) {
                lock.unlock();
            }
        }
    }

    private void validateLastEffected(List<StaffUseInParam> transStaffInParamList) {
        HashMap<Long, StaffUseInParam> candidateIdMap = new HashMap<Long, StaffUseInParam>(16);
        HashMap<Long, StaffUseInParam> depEmpIdMap = new HashMap<Long, StaffUseInParam>(16);
        for (StaffUseInParam staffUseInParam : transStaffInParamList) {
            if ("1020_S".equals(staffUseInParam.getChangeEventNumber())) {
                candidateIdMap.put(staffUseInParam.getCandidateId(), staffUseInParam);
                continue;
            }
            if (!"1040_S".equals(staffUseInParam.getChangeEventNumber())) continue;
            depEmpIdMap.put(staffUseInParam.getDepEmpId(), staffUseInParam);
        }
        this.eliminateDataByCandidate(transStaffInParamList, candidateIdMap);
        this.eliminateDataByDepEmp(transStaffInParamList, depEmpIdMap);
    }

    private void eliminateDataByDepEmp(List<StaffUseInParam> transStaffInParamList, Map<Long, StaffUseInParam> depEmpIdMap) {
        DynamicObject[] orgPersonStaffInfos;
        for (DynamicObject orgPersonStaffInfo : orgPersonStaffInfos = OrgPersonStaffInfoRepository.getInstance().queryPersonStaffInfoByDepEmpIds(new ArrayList<Long>(depEmpIdMap.keySet()))) {
            if (!orgPersonStaffInfo.getString("status").equals("2")) continue;
            transStaffInParamList.remove(depEmpIdMap.get(orgPersonStaffInfo.getLong("orgperson")));
        }
    }

    private void eliminateDataByCandidate(List<StaffUseInParam> transStaffInParamList, Map<Long, StaffUseInParam> candidateIdMap) {
        DynamicObject[] orgPersonStaffInfos;
        for (DynamicObject orgPersonStaffInfo : orgPersonStaffInfos = OrgPersonStaffInfoRepository.getInstance().queryPersonStaffInfoCandidateIds(new ArrayList<Long>(candidateIdMap.keySet()))) {
            transStaffInParamList.remove(candidateIdMap.get(orgPersonStaffInfo.getLong("candidate")));
        }
    }

    private List<StaffUseInParam> handleChangeEventNumber(List<StaffUseInParam> validStaffUseInParams) {
        ArrayList<StaffUseInParam> transStaffInParamList = new ArrayList<StaffUseInParam>(16);
        List<String> entryNumberList = this.getActivityNumerList("1WXB5G9/BL46");
        List<String> dismissionNumberList = this.getActivityNumerList("1WTT6K3V3TD/");
        Set orgTeamIds = validStaffUseInParams.stream().map(staffUseInParam -> staffUseInParam.getOrgTeamId()).collect(Collectors.toSet());
        DynamicObject[] orgTeamDyns = OTQueryRepository.getInstance().queryOrgById(orgTeamIds);
        Map<Long, Long> orgTeamToOrgIdMap = Arrays.stream(orgTeamDyns).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("org.id")));
        Map staffEffectOccupationParameter = SystemParamHelper.getStaffEffectOccupationParameter(new HashSet<Long>(orgTeamToOrgIdMap.values()));
        Map staffOccupationActivityParameterMap = SystemParamHelper.getStaffOccupationActivityParameter(new HashSet<Long>(orgTeamToOrgIdMap.values()));
        Map staffEffectReleaseParameter = SystemParamHelper.getStaffEffectReleaseParameter(new HashSet<Long>(orgTeamToOrgIdMap.values()));
        Map staffReleaseActivityParameterMap = SystemParamHelper.getStaffReleaseActivityParameter(new HashSet<Long>(orgTeamToOrgIdMap.values()));
        for (StaffUseInParam staffUseInParam2 : validStaffUseInParams) {
            String changeEventNumber = staffUseInParam2.getChangeEventNumber();
            Long orgId = orgTeamToOrgIdMap.get(staffUseInParam2.getOrgTeamId());
            Map staffOccupationActivityParameter = (Map)staffOccupationActivityParameterMap.get(orgId);
            Map staffReleaseActivityParameter = (Map)staffReleaseActivityParameterMap.get(orgId);
            if (staffOccupationActivityParameter != null && !staffOccupationActivityParameter.isEmpty()) {
                String occupationActivityNumber = staffOccupationActivityParameter.get("number") == null ? null : (String)staffOccupationActivityParameter.get("number");
                Boolean isNeedRecordForEntry = (Boolean)staffEffectOccupationParameter.get(orgId) == false && entryNumberList.contains(changeEventNumber) && changeEventNumber.equals(occupationActivityNumber);
                if (isNeedRecordForEntry.booleanValue()) {
                    staffUseInParam2.setChangeEventNumber("1020_S");
                    staffUseInParam2.getOther().put("haos_nodeEffect", true);
                    transStaffInParamList.add(staffUseInParam2);
                }
            }
            if (staffReleaseActivityParameter == null || staffReleaseActivityParameter.isEmpty()) continue;
            String releaseActivityNumber = staffReleaseActivityParameter.get("number") == null ? null : (String)staffReleaseActivityParameter.get("number");
            Boolean isNeedRecordForDismission = (Boolean)staffEffectReleaseParameter.get(orgId) == false && dismissionNumberList.contains(changeEventNumber) && changeEventNumber.equals(releaseActivityNumber);
            if (!isNeedRecordForDismission.booleanValue()) continue;
            staffUseInParam2.setChangeEventNumber("1040_S");
            staffUseInParam2.getOther().put("haos_nodeEffect", true);
            transStaffInParamList.add(staffUseInParam2);
        }
        return transStaffInParamList;
    }

    private List<String> getActivityNumerList(String appid) {
        HRBaseServiceHelper activityHelper = new HRBaseServiceHelper("hrcs_activity");
        QFilter entryFilter = new QFilter("app", "=", (Object)appid);
        DynamicObject[] entryDyns = activityHelper.query("id, number, name, app", new QFilter[]{entryFilter});
        return Arrays.stream(entryDyns).map(dyn -> dyn.getString("number")).collect(Collectors.toList());
    }
}

