/*
 * Decompiled with CFR 0.152.
 */
package kd.odc.homs.mservice;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.application.impl.staff.SyncPersonStaffApplicationImpl;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.odc.homs.mservice.AbstractStaffUseCommonService;
import kd.odc.homs.mservice.api.IStaffUseSyncAddService;

public class StaffUseSyncAddServiceImpl
extends AbstractStaffUseCommonService
implements IStaffUseSyncAddService {
    private static final Log logger = LogFactory.getLog(StaffUseSyncAddServiceImpl.class);

    public void staffUseSyncAdd(DynamicObject messageContext) throws Exception {
        LocalDateTime startTime = LocalDateTime.now();
        logger.info("staffUseInitAdd start, the start of time is {}", (Object)startTime);
        String params = super.getMsgContent(messageContext);
        if (StringUtils.isEmpty((CharSequence)params)) {
            return;
        }
        List personIdList = (List)SerializationUtils.deSerializeFromBase64((String)params);
        logger.info("after:the.total.number.of.init.add.personsize is {},the personId is {}", (Object)personIdList.size(), (Object)personIdList);
        if (CollectionUtils.isEmpty((Collection)personIdList)) {
            return;
        }
        SyncPersonStaffApplicationImpl syncPersonStaffApplication = new SyncPersonStaffApplicationImpl();
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                syncPersonStaffApplication.doSyncByPersonId(personIdList, HRDateTimeUtils.parseDate((String)"1900-01-01"), false);
            }
            catch (Exception ex) {
                txHandle.markRollback();
                logger.info("staffUseInitAdd_doSyncOnePerson consume.exception is {}", (Object)ex.getMessage());
                throw ex;
            }
        }
        LocalDateTime endTime = LocalDateTime.now();
        logger.info("staffUseInitAdd end, the end of time is{}", (Object)endTime);
        Duration duration = Duration.between(startTime, endTime);
        logger.info("staffUseInitAdd takes a total of time is {} millis", (Object)duration.toMillis());
    }
}

