/*
 * Decompiled with CFR 0.152.
 */
package kd.odc.homs.mservice.msg.impl;

import com.alibaba.fastjson.JSON;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.haos.business.servicehelper.ProjectTeamChangeBuHelper;
import kd.hr.haos.common.constants.changetransaction.ChangeTransactionConstants;
import kd.hr.hbp.common.mservice.HRMServiceResult;
import kd.odc.homs.mservice.msg.IProjectTeamMsgConsumerService;

public class ProjectTeamMsgConsumerService
implements IProjectTeamMsgConsumerService {
    private static final Log LOGGER = LogFactory.getLog(ProjectTeamMsgConsumerService.class);

    @Override
    public HRMServiceResult changeBuByAdminOrg(DynamicObject tplDy) {
        LOGGER.info("ProjectTeamMsgConsumerService_start");
        String content = tplDy.getString("msgcontent");
        Map contentMap = (Map)SerializationUtils.deSerializeFromBase64((String)content);
        LOGGER.info("ProjectRoleChangeMsgService consumerSaveMsg contentMap:{}", (Object)JSON.toJSONString((Object)contentMap));
        try {
            List<AdminOrgTempModel> adminOrgTempModelList = this.findNeedChangeAdminOrgAndConvertModel(contentMap);
            ProjectTeamChangeBuHelper projectTeamChangeBuHelper = new ProjectTeamChangeBuHelper();
            adminOrgTempModelList.forEach(adminOrgTempModel -> projectTeamChangeBuHelper.update(adminOrgTempModel.adminOrgBo, adminOrgTempModel.effectDate));
            LOGGER.info("ProjectTeamMsgConsumerService_biz_end");
        }
        catch (Exception ex) {
            LOGGER.error((Throwable)ex);
            throw ex;
        }
        LOGGER.info("ProjectTeamMsgConsumerService_all_end");
        return HRMServiceResult.success();
    }

    private List<AdminOrgTempModel> findNeedChangeAdminOrgAndConvertModel(Map<String, Object> paramMap) {
        List scenesub = paramMap.getOrDefault("scenesub", Collections.emptyList());
        for (int i = 0; i < scenesub.size(); ++i) {
            scenesub.set(i, Long.parseLong(scenesub.get(i) + ""));
        }
        boolean hasOrgChangeScene = scenesub.stream().anyMatch(ChangeTransactionConstants.SCENE_SUB_ORG::equals);
        if (hasOrgChangeScene) {
            AdminOrgTempModel adminOrgTempModel = new AdminOrgTempModel();
            adminOrgTempModel.effectDate = paramMap.getOrDefault("bsed", null);
            adminOrgTempModel.adminOrgBo = Long.parseLong(paramMap.getOrDefault("boid", "0").toString());
            return Collections.singletonList(adminOrgTempModel);
        }
        return Collections.emptyList();
    }

    static class AdminOrgTempModel {
        long adminOrgBo;
        Date effectDate;

        AdminOrgTempModel() {
        }
    }
}

