/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.adminorg;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FloatingDirection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.ITreeListView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.haos.formplugin.web.adminorg.template.AdminOrgPermTreeListBase;
import kd.hr.hbp.business.dao.factory.HRBaseDaoFactory;
import kd.hr.hbp.business.servicehelper.org.TreeTemplateHelper;
import kd.hr.hbp.business.servicehelper.org.util.OrgTreeUtils;
import kd.hr.hbp.common.constants.org.OrgTreeDynEnum;
import kd.hr.hbp.common.constants.org.OrgTreeSearchParam;
import kd.hr.hbp.common.constants.org.TreeTemplateConstants;
import kd.hr.hbp.common.model.AuthorizedOrgResultWithSub;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.org.model.OrgTreeModel;

public class AdminOrgFastPermTreeListPlugin
extends AdminOrgPermTreeListBase {
    private static final String CUR_SUB_TREE_STRUCT_FIELDS = "adminorg.id id, adminorg.boid boid, adminorg.name name, parentorg.id parentorg, structlongnumber, isleaf, adminorg.enable enable,adminorg.tobedisableflag tobedisableflag";
    private static final String ORG_SEARCH_NODE = "org_searchNode";

    public AdminOrgFastPermTreeListPlugin() {
        super(new OrgTreeModel(OrgTreeDynEnum.ADMIN_STRUCT.getDynEntity(), OrgTreeDynEnum.ADMIN_MAIN_ENTITY.getDynEntity(), Boolean.FALSE, Boolean.TRUE, Boolean.FALSE.booleanValue()));
    }

    public void filterColumnSetFilter(SetFilterEvent event) {
        AuthorizedOrgResultWithSub permOrgResultWithSub;
        super.filterColumnSetFilter(event);
        String fieldName = event.getFieldName();
        if ("parentorg.name".equals(fieldName) && !(permOrgResultWithSub = this.getPermOrgResultWithSub()).isHasAllOrgPerm()) {
            QFilter dataPermFilter = TreeTemplateHelper.getPermStructLongNumberFilter((AuthorizedOrgResultWithSub)permOrgResultWithSub, (String)"boid");
            dataPermFilter.and("iscurrentversion", "=", (Object)Character.valueOf('1'));
            event.setSpecialDataPermQFilter(dataPermFilter);
        }
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        setFilterEvent.getQFilters().add(this.getDataStatusAndBSedFilter());
    }

    public Date getDateParam() {
        if (this.getModel().isDataLoaded()) {
            return (Date)this.getModel().getValue("searchdate");
        }
        return new Date();
    }

    public boolean isInCludeChild() {
        return this.getModel().getDataEntity(true).getBoolean("chkincludechild");
    }

    public void initialize() {
        super.initialize();
        String billFormId = ((BillList)this.getView().getControl("billlistap")).getBillFormId();
        if (HRStringUtils.equalsIgnoreCase((String)billFormId, (String)"homs_adminorgdetail")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap3"});
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("btntreefilter".equals(control.getKey().toLowerCase(Locale.ROOT))) {
            FormShowParameter formShowParameter = this.showAdminOrgTreeFilterDialog();
            if (formShowParameter == null) {
                return;
            }
            String chkShowDisable = this.getPageCache().get("chkshowdisable");
            formShowParameter.setCustomParam("chkshowdisable", (Object)chkShowDisable);
            this.getView().showForm(formShowParameter);
        }
    }

    public FormShowParameter showAdminOrgTreeFilterDialog() {
        FormShowParameter formShowParameter = new FormShowParameter();
        OpenStyle openStyle = formShowParameter.getOpenStyle();
        openStyle.setShowType(ShowType.Floating);
        openStyle.setFloatingDirection(FloatingDirection.RightCenter);
        openStyle.setTargetKey("btntreefilter");
        StyleCss cssValue = new StyleCss();
        cssValue.setWidth("140px");
        cssValue.setHeight("50px");
        openStyle.setInlineStyleCss(cssValue);
        formShowParameter.setFormId("homs_orgtreefiter");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u663e\u793a\u7981\u7528", (String)"AdminOrgFastPermTreeListPlugin_0", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        return formShowParameter;
    }

    protected String getListPermProKey() {
        return "boid";
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"searchnode")) {
            TreeNode treeNode;
            TreeTemplateHelper.removeRootAndStructLongNumberCache((IPageCache)this.getPageCache());
            String nodeIdStr = this.getView().getPageCache().get("searchnode");
            String delNodeIdStr = this.getView().getPageCache().get("delnode");
            if (HRStringUtils.isEmpty((String)nodeIdStr)) {
                return;
            }
            DynamicObject dynamicObject = AdOrgRepository.getInstance().queryByPk("id,name", (Object)Long.parseLong(delNodeIdStr));
            if (dynamicObject != null && (treeNode = OrgTreeUtils.getNode((TreeNode)this.getTreeModel().getRoot(), (Object)delNodeIdStr)) != null) {
                treeNode.setText(dynamicObject.getString("name"));
            }
            if (!HRStringUtils.equals((String)nodeIdStr, (String)delNodeIdStr)) {
                TreeNode parentNode;
                TreeView treeView = this.getTreeListView().getTreeView();
                TreeNode treeNode2 = OrgTreeUtils.getNode((TreeNode)this.getTreeModel().getRoot(), (Object)delNodeIdStr);
                if (treeNode2 != null && HRStringUtils.isNotEmpty((String)treeNode2.getParentid()) && (parentNode = OrgTreeUtils.getNode((TreeNode)this.getTreeModel().getRoot(), (Object)treeNode2.getParentid())) != null && !CollectionUtils.isEmpty((Collection)parentNode.getChildren()) && parentNode.getChildren().size() == 1) {
                    parentNode.setLeaf(false);
                }
                treeView.deleteNode(delNodeIdStr);
            }
            long nodeId = Long.parseLong(nodeIdStr);
            this.clickNodeById(nodeId);
        }
    }

    private void clickNodeById(long orgId) {
        TreeNode treeNode = OrgTreeUtils.getNode((TreeNode)this.getTreeModel().getRoot(), (Object)orgId);
        if (treeNode != null) {
            TreeView treeView = this.getTreeListView().getTreeView();
            treeView.treeNodeClick(treeNode.getParentid(), treeNode.getId());
            ITreeListView treeListView = this.getTreeListView();
            treeListView.getTreeModel().setCurrentNodeId((Object)treeNode.getId());
            treeListView.getTreeView().focusNode(treeNode);
            this.getView().invokeOperation("refresh");
            return;
        }
        this.searchNodeById(orgId);
        this.getView().getPageCache().remove("searchnode");
    }

    private void searchNodeById(long orgId) {
        ArrayList treeNodes = Lists.newArrayListWithCapacity((int)16);
        QFilter idFilter = new QFilter("adminorg.id", "=", (Object)orgId);
        QFilter[] filters = new QFilter[]{idFilter, this.getSearchTreeStructFilter(), this.getOrgTreeFilter()};
        DynamicObjectCollection dynCol = HRBaseDaoFactory.getInstance((String)this.getEntityName()).queryColl(CUR_SUB_TREE_STRUCT_FIELDS, filters, null);
        if (CollectionUtils.isEmpty((Collection)dynCol)) {
            return;
        }
        this.setOrgLeaf(dynCol, "parentorg");
        DynamicObject dynamicObject = (DynamicObject)dynCol.get(0);
        TreeNode treeNode = new TreeNode(dynamicObject.getString("parentorg"), String.valueOf(dynamicObject.getLong("id")), dynamicObject.getString("name"));
        treeNode.setLongNumber(dynamicObject.getString("structlongnumber"));
        treeNode.setData((Object)dynamicObject.getString("boid"));
        treeNodes.add(treeNode);
        OrgTreeSearchParam searchParam = new OrgTreeSearchParam(treeNode.getText(), (ListView)this.getView());
        this.searchFromLazyOrgTree(searchParam, treeNodes, true);
        TreeView treeView = this.getTreeListView().getTreeView();
        treeView.addNodes((List)treeNodes);
        treeView.treeNodeClick(treeNode.getParentid(), treeNode.getId());
        searchParam.getTreeView().focusNode(treeNode);
        IFormView formView = searchParam.getFormView();
        if (formView instanceof ListView) {
            ITreeListView treeListView = ((ListView)formView).getTreeListView();
            treeListView.getTreeModel().setCurrentNodeId((Object)treeNode.getId());
        }
    }

    private void searchFromLazyOrgTree(OrgTreeSearchParam searchParam, List<TreeNode> treeNodes, boolean isFirstSearch) {
        IPageCache pageCache = searchParam.getPageCache();
        TreeView treeView = this.getTreeListView().getTreeView();
        treeView.uncheckNodes(treeView.getTreeState().getSelectedNodeId());
        TreeNode node = this.searchExistsNodeFromLazyOrgTree(searchParam, treeNodes, 0);
        if (node == null) {
            this.finishSearch(searchParam, treeNodes, isFirstSearch);
        } else {
            treeView.expand(searchParam.getRootNode().getId());
            if (searchParam.isClickNode() && !searchParam.isSearchById()) {
                treeView.treeNodeClick(node.getParentid(), node.getId());
            }
            searchParam.getCheckNodeIds().add(node.getId());
            treeView.uncheckNodes(treeView.getTreeState().getSelectedNodeId());
            treeView.checkNode(node);
            AdminOrgFastPermTreeListPlugin.focusNodeAfterSearch((OrgTreeSearchParam)searchParam, (TreeNode)node);
            if (!searchParam.isSearchById() && treeNodes != null && !treeNodes.isEmpty()) {
                treeNodes.remove(0);
            }
        }
        if (ObjectUtils.isEmpty(treeNodes) && !searchParam.isSearchById()) {
            pageCache.put(ORG_SEARCH_NODE, null);
            return;
        }
        if (searchParam.isSearchById()) {
            return;
        }
        pageCache.put(ORG_SEARCH_NODE, SerializationUtils.toJsonString(treeNodes));
    }

    private TreeNode searchExistsNodeFromLazyOrgTree(OrgTreeSearchParam searchParam, List<TreeNode> treeNodes, int recursionCount) {
        if (CollectionUtils.isEmpty(treeNodes) || recursionCount > 20) {
            return null;
        }
        TreeNode node = treeNodes.get(0);
        if (node == null) {
            return null;
        }
        String parentId = node.getParentid();
        TreeNode parentNode = OrgTreeUtils.getNode((TreeNode)searchParam.getRootNode(), (Object)parentId);
        if (OrgTreeUtils.isChildNode((TreeNode)parentNode, (TreeNode)node)) {
            HashSet loopController = Sets.newHashSetWithExpectedSize((int)16);
            ArrayList expendIds = Lists.newArrayListWithCapacity((int)16);
            OrgTreeUtils.expandParentNode((OrgTreeSearchParam)searchParam, (String)parentId, (Set)loopController, (List)expendIds, (int)0);
            for (int i = expendIds.size() - 1; i >= 0; --i) {
                searchParam.getTreeView().expand((String)expendIds.get(i));
            }
        } else {
            this.queryTreeNodeWithParent(searchParam, node);
        }
        node = OrgTreeUtils.getNode((TreeNode)searchParam.getRootNode(), (Object)node.getId());
        if (node == null) {
            TreeNode removeNode = treeNodes.remove(0);
            String subNodeLongNumber = removeNode.getLongNumber() + "!";
            ArrayList removeSubNodes = Lists.newArrayList();
            for (TreeNode subNode : treeNodes) {
                if (subNode.getLongNumber() == null || !subNode.getLongNumber().startsWith(subNodeLongNumber)) continue;
                removeSubNodes.add(subNode);
            }
            treeNodes.removeAll(removeSubNodes);
            return this.searchExistsNodeFromLazyOrgTree(searchParam, treeNodes, recursionCount);
        }
        return node;
    }

    private void queryTreeNodeWithParent(OrgTreeSearchParam searchParam, TreeNode node) {
        String notLoadParentLongNumber;
        int layerCount;
        Object currentNodeId = this.getTreeModel().getCurrentNodeId();
        TreeNode curTreeNode = OrgTreeUtils.getNode((TreeNode)this.getTreeModel().getRoot(), (Object)currentNodeId.toString());
        String structLongNumber = node.getLongNumber();
        if (StringUtils.equals((CharSequence)"999999999", (CharSequence)currentNodeId.toString())) {
            String[] splitedStructLongNumber = structLongNumber.split("!");
            layerCount = splitedStructLongNumber.length - 1;
            notLoadParentLongNumber = splitedStructLongNumber[0];
        } else {
            int nextLongNumberLength = curTreeNode.getLongNumber().length() + TreeTemplateConstants.LONG_NUMBER_AND_SPLIT_LENGTH;
            if (structLongNumber.length() < nextLongNumberLength) {
                return;
            }
            String newParentStructLongNumber = structLongNumber.substring(0, nextLongNumberLength);
            notLoadParentLongNumber = newParentStructLongNumber.substring(newParentStructLongNumber.lastIndexOf(33) + 1);
            layerCount = (structLongNumber.length() - newParentStructLongNumber.length()) / TreeTemplateConstants.LONG_NUMBER_AND_SPLIT_LENGTH;
        }
        ArrayList<String> structNumbers = new ArrayList<String>();
        structNumbers.add(notLoadParentLongNumber);
        this.getView().getFormShowParameter().setCustomParam("layerCount", (Object)layerCount);
        this.queryTreeNodeChildrenByStructNumbers(searchParam, structNumbers, node);
    }
}

