/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.adminorg;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.filter.CommonBaseDataFilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.homs.business.service.application.impl.AdminOrgReviseLogApplicationImpl;
import kd.hr.homs.business.service.domain.helper.AdminOrgReviseLogHelper;

public class AdminOrgReviseLogListPlugin
extends HRDataBaseList {
    private Map<Long, String> contentMap;

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        CommonBaseDataFilterColumn argsFilterColumn = (CommonBaseDataFilterColumn)args.getFilterColumn("creator.name");
        argsFilterColumn.setConstantDefaultValue((Object)"103");
    }

    public void packageData(PackageDataEvent event) {
        super.packageData(event);
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)event.getSource();
        DynamicObject rowData = event.getRowData();
        boolean displayContent = this.displayContent(rowData.getDynamicObjectType().getProperties());
        if (displayContent) {
            Long reviseDetailId = rowData.getLong("entryentity.id");
            String content = this.contentMap.get(reviseDetailId);
            if ("revisecontent".equals(columnDesc.getFieldKey()) && HRStringUtils.isNotEmpty((String)content)) {
                event.setFormatValue((Object)content);
            }
        }
    }

    public void beforePackageData(BeforePackageDataEvent event) {
        super.beforePackageData(event);
        DynamicObjectCollection data = event.getPageData();
        if (CollectionUtils.isEmpty((Collection)data)) {
            return;
        }
        boolean displayContent = this.displayContent(event.getPageData().getDynamicObjectType().getProperties());
        if (displayContent) {
            AdminOrgReviseLogApplicationImpl impl = new AdminOrgReviseLogApplicationImpl();
            this.contentMap = impl.getLogContent(data);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("viewdetail".equals(operateKey)) {
            ListShowParameter formShowParameter = new ListShowParameter();
            formShowParameter.setBillFormId("homs_reviseorglogview");
            formShowParameter.setFormId("homs_reviseorgloglistf7");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            StyleCss cssValue = new StyleCss();
            cssValue.setWidth("780px");
            cssValue.setHeight("480px");
            formShowParameter.getOpenStyle().setInlineStyleCss(cssValue);
            formShowParameter.setLookUp(true);
            formShowParameter.setMultiSelect(false);
            ListSelectedRowCollection listSelectedData = args.getListSelectedData();
            if (!CollectionUtils.isEmpty((Collection)listSelectedData)) {
                Object primaryKeyValue = listSelectedData.getPrimaryKeyValues()[0];
                QFilter filter = new QFilter("id", "=", primaryKeyValue);
                formShowParameter.getListFilterParameter().getQFilters().add(filter);
            }
            this.getView().showForm((FormShowParameter)formShowParameter);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public QueryBuilder getQueryBuilder() {
                QueryBuilder queryBuilder = super.getQueryBuilder();
                String orderBys = queryBuilder.getOrderBys();
                orderBys = HRStringUtils.isEmpty((String)orderBys) ? "entryentity.seq asc" : orderBys + ",entryentity.seq asc";
                queryBuilder.setOrderBys(orderBys);
                return queryBuilder;
            }
        });
    }

    public void setFilter(SetFilterEvent event) {
        List selectOrgIds = AdminOrgReviseLogHelper.getSelectOrgIds((IFormView)this.getView());
        String secondInit = this.getPageCache().get("secondInit");
        if (!CollectionUtils.isEmpty((Collection)selectOrgIds) && HRStringUtils.isEmpty((String)secondInit)) {
            Set adminOrgIds = selectOrgIds.stream().map(Long::parseLong).collect(Collectors.toSet());
            event.getCustomQFilters().add(new QFilter("adminorgbo", "in", adminOrgIds));
            this.getPageCache().put("secondInit", "secondInit");
        }
    }

    private boolean displayContent(DataEntityPropertyCollection props) {
        return props.stream().anyMatch(prop -> HRStringUtils.equals((String)prop.getName(), (String)"entryentity.id"));
    }
}

