/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.adminorg;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.entity.list.column.TextColumnDesc;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.homs.business.service.domain.helper.AdminOrgReviseLogHelper;
import kd.hr.homs.business.service.domain.repository.AdminOrgReviseLogRepository;
import kd.hr.homs.common.constants.fastchg.AdminOrgReviseLogConstants;

public class AdminOrgReviseLogViewDetailPlugin
extends HRDataBaseList
implements AdminOrgReviseLogConstants,
RowClickEventListener {
    private Map<String, Map<String, IDataEntityProperty>> entityDisplayNameMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<String, DynamicObject> reviseLogEntryMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<Long, DynamicObjectCollection> reviseLogOrgHIsEntryMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<String, Map<Long, DynamicObject>> reviseEntityBeforeAfterInfoMap = Maps.newHashMapWithExpectedSize((int)16);

    public void beforePackageData(BeforePackageDataEvent event) {
        Set reviseLogIds = event.getPageData().stream().map(data -> data.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] reviseInfoArr = AdminOrgReviseLogRepository.getInstance().loadLogInfoById(reviseLogIds);
        HashSet reviseEntityNameSet = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject reviseInfo : reviseInfoArr) {
            DynamicObjectCollection reviseEntry = reviseInfo.getDynamicObjectCollection("entryentity");
            reviseEntry.forEach(entry -> {
                reviseEntityNameSet.add(entry.getString("reviseentityname"));
                this.reviseLogEntryMap.put(reviseInfo.getLong("id") + "-" + entry.getLong("id"), (DynamicObject)entry);
            });
            DynamicObjectCollection reviseOrgHisEntry = reviseInfo.getDynamicObjectCollection("orgentryentity");
            this.reviseLogOrgHIsEntryMap.put(reviseInfo.getLong("id"), reviseOrgHisEntry);
        }
        this.entityDisplayNameMap = AdminOrgReviseLogHelper.getPropertyNameFromEntity((Set)reviseEntityNameSet);
        Map<String, List<DynamicObject>> reviseEntityMap = this.reviseLogEntryMap.values().stream().collect(Collectors.groupingBy(reviseDetail -> reviseDetail.getString("reviseentityname")));
        reviseEntityMap.forEach((entityName, reviseDetailList) -> {
            HRBaseServiceHelper helper = new HRBaseServiceHelper(entityName);
            ArrayList reviseFieldNameList = new ArrayList(reviseDetailList.size());
            ArrayList reviseBeforeAfter = new ArrayList(reviseDetailList.size());
            reviseDetailList.forEach(entry -> {
                reviseFieldNameList.add(entry.getString("revisefieldname"));
                reviseBeforeAfter.add(entry.getLong("revisebefore"));
                DynamicObjectCollection reviseAfterDynList = entry.getDynamicObjectCollection("reviseafter");
                reviseBeforeAfter.add(CollectionUtils.isEmpty((Collection)reviseAfterDynList) ? 0L : ((DynamicObject)reviseAfterDynList.get(0)).getLong("fbasedataid_id"));
            });
            QFilter filter = new QFilter("id", "in", reviseBeforeAfter);
            Map<Long, DynamicObject> reviseBeforeAfterInfoMap = Arrays.stream(helper.query(String.join((CharSequence)",", reviseFieldNameList), filter.toArray())).collect(Collectors.toMap(entity -> entity.getLong("id"), entity -> entity));
            this.reviseEntityBeforeAfterInfoMap.put((String)entityName, reviseBeforeAfterInfoMap);
        });
    }

    public void packageData(PackageDataEvent event) {
        Object source = event.getSource();
        long reviseLogId = this.getReviseLogId(event.getRowData());
        long reviseLogEntryId = event.getRowData().getLong("entryentity.id");
        if (source instanceof TextColumnDesc) {
            DynamicObject reviseDetail = this.reviseLogEntryMap.get(reviseLogId + "-" + reviseLogEntryId);
            String reviseEntityName = reviseDetail.getString("reviseentityname");
            String reviseFieldName = reviseDetail.getString("revisefieldname");
            Map<String, IDataEntityProperty> dataEntityPropertyMap = this.entityDisplayNameMap.get(reviseEntityName);
            IDataEntityProperty property = dataEntityPropertyMap.get(reviseFieldName);
            if (property == null) {
                return;
            }
            String key = ((TextColumnDesc)source).getKey();
            if ("involvedate".equals(key)) {
                if ("establishmentdate".equals(reviseFieldName)) {
                    event.getRowData().set("id", (Object)reviseDetail.getLong("id"));
                    return;
                }
                DynamicObjectCollection reviseLogOrgHisList = this.reviseLogOrgHIsEntryMap.get(reviseLogId);
                if (!CollectionUtils.isEmpty((Collection)reviseLogOrgHisList)) {
                    DynamicObject beforeOrgDyn = ((DynamicObject)reviseLogOrgHisList.get(0)).getDynamicObject("beforeorg");
                    Date startDate = beforeOrgDyn.getDate("bsed");
                    Date endDate = beforeOrgDyn.getDate("bsled");
                    event.setFormatValue((Object)(HRInteDateTimeUtil.formatDate((String)beforeOrgDyn.getDataEntityType().getName(), (String)"bsed", (Date)startDate) + "~" + HRInteDateTimeUtil.formatDate((String)beforeOrgDyn.getDataEntityType().getName(), (String)"bsled", (Date)endDate)));
                }
            } else if ("fieldnamevalue".equals(key)) {
                event.setFormatValue((Object)property.getDisplayName().getLocaleValue());
            } else if ("revisebeforevalue".equals(key)) {
                long reviseBefore = reviseDetail.getLong("revisebefore");
                Map<Long, DynamicObject> reviseBeforeAfterInfoMap = this.reviseEntityBeforeAfterInfoMap.get(reviseEntityName);
                DynamicObject reviseBeforeDyn = reviseBeforeAfterInfoMap.get(reviseBefore);
                if (reviseBeforeDyn != null) {
                    event.setFormatValue((Object)AdminOrgReviseLogHelper.getFieldValueByProperty((DynamicObject)reviseBeforeDyn, (IDataEntityProperty)property));
                }
            } else if ("reviseaftervalue".equals(key)) {
                DynamicObjectCollection reviseAfterList = reviseDetail.getDynamicObjectCollection("reviseafter");
                Map<Long, DynamicObject> reviseBeforeAfterInfoMap = this.reviseEntityBeforeAfterInfoMap.get(reviseEntityName);
                if (!CollectionUtils.isEmpty((Collection)reviseAfterList)) {
                    long baseDataId = ((DynamicObject)reviseAfterList.get(0)).getLong("fbasedataid_id");
                    DynamicObject reviseAfterDyn = reviseBeforeAfterInfoMap.get(baseDataId);
                    event.setFormatValue((Object)AdminOrgReviseLogHelper.getFieldValueByProperty((DynamicObject)reviseAfterDyn, (IDataEntityProperty)property));
                }
            }
        }
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        evt.setCancel(true);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public QueryBuilder getQueryBuilder() {
                QueryBuilder queryBuilder = super.getQueryBuilder();
                String orderBys = queryBuilder.getOrderBys();
                orderBys = HRStringUtils.isEmpty((String)orderBys) ? "entryentity.seq asc" : orderBys + ",entryentity.seq asc";
                queryBuilder.setOrderBys(orderBys);
                return queryBuilder;
            }
        });
    }

    private long getReviseLogId(DynamicObject reviseLogInfo) {
        long reviseLogId;
        String reviseLogIdStr = this.getPageCache().get("reviseOrgId");
        if (HRStringUtils.isEmpty((String)reviseLogIdStr)) {
            reviseLogId = reviseLogInfo.getLong("id");
            this.getPageCache().put("reviseOrgId", String.valueOf(reviseLogId));
        } else {
            reviseLogId = Long.parseLong(reviseLogIdStr);
        }
        return reviseLogId;
    }
}

