/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.adminorg;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.haos.business.rpc.HRCSRPCServiceHelper;
import kd.hr.haos.business.util.BaseDataHelper;
import kd.hr.haos.business.util.OrgPermHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.model.AuthorizedOrgResultWithSub;
import kd.hr.hbp.common.model.OrgSubInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.homs.business.service.helper.AdminOrgBatchChartHelper;
import kd.hr.homs.business.service.helper.AdminOrgBatchChgHelper;
import kd.hr.homs.business.service.helper.AdminOrgFastChgHelper;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.helper.SystemParamHelper;
import kd.hr.homs.business.service.utils.OrgChgUtil;
import kd.hr.homs.business.service.validcommon.BillEntryHelperEnum;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckDto;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;

public class AdminorgDetailListPlugin
extends HRDataBaseList
implements ClickListener {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate;
        String operateKey;
        super.beforeDoOperation(args);
        boolean rootInit = OrgChgUtil.checkRootInit((IFormView)this.getView());
        if (!rootInit) {
            args.setCancel(true);
        }
        if ("importchargeperson".equals(operateKey = (operate = (AbstractOperate)args.getSource()).getOperateKey())) {
            AdminOrgFastChgHelper.showChargePersonImportPage((AbstractFormPlugin)this);
            args.setCancel(true);
        } else if ("importdetailchargeperson".equals(operateKey)) {
            AdminOrgFastChgHelper.showChargePersonImportDetail((AbstractFormPlugin)this);
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        String opKey = eventArgs.getOperateKey();
        if (eventArgs.getOperationResult() != null && eventArgs.getOperationResult().isSuccess()) {
            this.openOperationPage(opKey);
        }
    }

    private void openOperationPage(String opKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        ListView listView = (ListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        List orgBoList = selectedRows.stream().map(org -> (Long)org.getPrimaryKeyValue()).collect(Collectors.toList());
        DynamicObject[] dynamicObjects = AdOrgRepository.getInstance().queryOrgInfoByBoId("id,boid,sourcevid,name,parentorg,enable,structlongnumber", orgBoList);
        List<Long> orgLists = Arrays.asList(dynamicObjects).stream().map(org -> org.getLong("sourcevid")).collect(Collectors.toList());
        switch (opKey) {
            case "addnew": {
                this.checkAddOrg();
                break;
            }
            case "parentchg": {
                if (!this.checkOrgParentChg(dynamicObjects)) break;
                AdminOrgFastChgHelper.openChgParentBillPage((IFormView)this.getView(), (Long)dynamicObjects[0].getLong("sourcevid"), (String)dynamicObjects[0].getString("name"));
                break;
            }
            case "infochg": {
                if (!this.checkOrgInfoChg(dynamicObjects)) break;
                AdminOrgFastChgHelper.showChangeInfoPage((AbstractFormPlugin)this, (DynamicObject[])dynamicObjects);
                break;
            }
            case "stopuse": {
                if (!this.checkOrgStopUse(orgLists)) break;
                AdminOrgFastChgHelper.showDisableInfoPage((AbstractFormPlugin)this, orgLists);
                break;
            }
            case "enableuse": {
                if (!this.checkOrgEnable(orgLists)) break;
                AdminOrgFastChgHelper.showEnableInfoPage((AbstractFormPlugin)this, orgLists);
                break;
            }
            case "showchargeperson": {
                AdminOrgFastChgHelper.showDeptLeaderSet((AbstractFormPlugin)this, (Long)((Long)orgBoList.get(0)));
                break;
            }
            case "revise": {
                if (!AdminOrgFastChgHelper.listCheckRevise((IFormView)this.getView(), (DynamicObject[])dynamicObjects)) break;
                AdminOrgFastChgHelper.showRevisePage((AbstractFormPlugin)this, (Long)orgLists.get(0), (String)dynamicObjects[0].getString("name"));
                break;
            }
            case "importchargeperson": {
                AdminOrgFastChgHelper.showChargePersonImportPage((AbstractFormPlugin)this);
                break;
            }
            case "viewchargepersonlog": {
                AdminOrgFastChgHelper.showLogPage((String)"hrpi_chargepersonlog", (IFormView)this.getView(), orgLists, (String)"adminorg.id", (String)"adminorg.org");
                break;
            }
            case "operate_steps": {
                AdminOrgFastChgHelper.showOperateStepsPage((IFormView)this.getView());
            }
        }
    }

    private void checkAddOrg() {
        HRBaseServiceHelper orgHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        TreeView orgTree = (TreeView)this.getView().getControl("treeview");
        Map focusNode = orgTree.getTreeState().getFocusNode();
        if (focusNode == null) {
            this.beforeTreeOpenAddOrgPage();
            return;
        }
        Long orgid = Long.valueOf((String)focusNode.get("id"));
        DynamicObject orgDy = orgHelper.queryOne("id,org,boid,adminorgtype.adminorgtypestd.id,sourcevid", (Object)orgid);
        QFilter qFilter = new QFilter("boid", "=", (Object)orgDy.getLong("boid"));
        qFilter.and("iscurrentversion", "=", (Object)Character.valueOf('1'));
        qFilter.and("enable", "=", (Object)"0");
        boolean orgEnable = orgHelper.isExists(qFilter);
        if (orgEnable) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u505c\u7528\uff0c\u4e0d\u80fd\u5728\u8be5\u7ec4\u7ec7\u4e0b\u65b0\u589e\u7ec4\u7ec7\u3002", (String)"AdminorgFastChgPlugin_22", (String)"odc-homs-formplugin", (Object[])new Object[]{orgDy.get("name")}));
            return;
        }
        qFilter = new QFilter("boid", "=", (Object)orgDy.getLong("boid"));
        qFilter.and("iscurrentversion", "=", (Object)Character.valueOf('1'));
        qFilter.and("enable", "=", (Object)"1");
        DynamicObject parentOrg = orgHelper.loadDynamicObject(qFilter);
        if (!SystemParamHelper.getAllowTobeDisableChg((Long)parentOrg.getLong("org.id")) && parentOrg.getBoolean("tobedisableflag")) {
            List tipList = HRCSRPCServiceHelper.queryPromptForString((IFormView)this.getView(), (String)"homs_adminorgdetail", (String)"promptadd");
            this.getView().showTipNotification(String.format((String)tipList.get(0), parentOrg.getString("name")));
            return;
        }
        this.openAddOrgPage(orgDy);
    }

    private boolean checkOrgInfoChg(DynamicObject[] dynamicObjects) {
        if (dynamicObjects.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"AdminorgDetailListPlugin_10", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            return false;
        }
        Long orgId = dynamicObjects[0].getLong("sourcevid");
        return AdminOrgFastChgHelper.checkInfoChgBefore((IFormView)this.getView(), (Long)orgId, (boolean)false);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        int result = event.getResult().getValue();
        String customVaule = event.getCustomVaule();
        switch (event.getCallBackId()) {
            case "checkOrgStopUse": 
            case "checkOrgEnable": {
                this.afterConfirmStopUse(result, customVaule, event.getCallBackId());
                break;
            }
        }
    }

    private void afterConfirmStopUse(int result, String customVaule, String callBackId) {
        if (result == MessageBoxResult.Yes.getValue()) {
            List orgIds = Arrays.asList(customVaule.split(",")).stream().filter(s -> !StringUtils.isBlank((String)s)).map(l -> Long.parseLong(l.trim())).collect(Collectors.toList());
            if (orgIds.size() == 0) {
                return;
            }
            switch (callBackId) {
                case "checkOrgStopUse": {
                    AdminOrgFastChgHelper.showDisableInfoPage((AbstractFormPlugin)this, orgIds);
                    break;
                }
                case "checkOrgEnable": {
                    AdminOrgFastChgHelper.showEnableInfoPage((AbstractFormPlugin)this, orgIds);
                    break;
                }
            }
        }
    }

    private boolean checkOrgParentChg(DynamicObject[] dynamicObjects) {
        if (dynamicObjects.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"AdminorgDetailListPlugin_0", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject orgDy = dynamicObjects[0];
        String orgResultString = this.getPageCache().get("perm_org_result_withsub");
        if (HRStringUtils.isEmpty((String)orgResultString)) {
            AuthorizedOrgResult orgAuth = AdminOrgFastChgHelper.getOrgAuth((IFormView)this.getView());
            List hasPermOrgs = orgAuth.getHasPermOrgs();
            if (!orgAuth.isHasAllOrgPerm() && Objects.nonNull(orgAuth.getHasPermOrgs()) && !hasPermOrgs.contains(orgDy.getLong("boid"))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6c92\u6709\u884c\u653f\u7ec4\u7ec7\u201c%s\u201d\u6570\u636e\u8303\u56f4\u6743\u9650\u3002", (String)"AdminorgDetailListPlugin_26", (String)"odc-homs-formplugin", (Object[])new Object[0]), orgDy.getString("name")));
                return false;
            }
        } else {
            AuthorizedOrgResultWithSub authorizedOrgResultWithSub = (AuthorizedOrgResultWithSub)SerializationUtils.fromJsonString((String)orgResultString, AuthorizedOrgResultWithSub.class);
            if (!authorizedOrgResultWithSub.isHasAllOrgPerm()) {
                String curStructLongNumber = orgDy.getString("structlongnumber");
                List permOrgWithSubList = authorizedOrgResultWithSub.getHasPermOrgsWithSub();
                boolean isNotHadPerm = false;
                for (OrgSubInfo orgSubInfo : permOrgWithSubList) {
                    String longStructNumber = orgSubInfo.getLongStructNumber();
                    if (longStructNumber.equals(curStructLongNumber) || orgSubInfo.isContainsSub() && curStructLongNumber.contains(longStructNumber)) {
                        isNotHadPerm = false;
                        break;
                    }
                    isNotHadPerm = true;
                }
                if (isNotHadPerm) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6c92\u6709\u884c\u653f\u7ec4\u7ec7\u201c%s\u201d\u6570\u636e\u8303\u56f4\u6743\u9650\u3002", (String)"AdminorgDetailListPlugin_26", (String)"odc-homs-formplugin", (Object[])new Object[0]), orgDy.getString("name")));
                    return false;
                }
            }
        }
        if (orgDy.getDynamicObject("parentorg") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5bf9\u6839\u7ec4\u7ec7\u8fdb\u884c\u201c\u8c03\u6574\u4e0a\u7ea7\u201d\u3002", (String)"AdminorgDetailListPlugin_1", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (HRStringUtils.equals((String)orgDy.getString("enable"), (String)"0")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u5df2\u505c\u7528\uff0c\u4e0d\u80fd\u8fdb\u884c\u201c\u8c03\u6574\u4e0a\u7ea7\u201d\u7684\u64cd\u4f5c\u3002", (String)"AdminorgDetailListPlugin_2", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!AdminOrgFastChgHelper.checkOrgBillStatus((Long)orgDy.getLong("boid"), (IFormView)this.getView())) {
            return false;
        }
        return AdminOrgFastChgHelper.checkOrgOperateTask(Collections.singletonList(orgDy.getLong("boid")), (IFormView)this.getView(), (boolean)true);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        IPageCache pageCache;
        super.closedCallBack(event);
        String action = event.getActionId();
        if (action.equals("addnew")) {
            if (this.getView().getPageCache().get("lastTimeAddEntryId") != null) {
                this.getView().invokeOperation("addnew");
            }
        } else if (("stopuse_callback".equals(action) || "infochg_callback".equals(action) || "enable_callback".equals(action)) && ((pageCache = this.getPageCache()).get("fastChgInfo_save") != null || pageCache.get("fastOrgDisable_save") != null || "enable_callback".equals(action))) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        if ("belongcompany.name".equals(args.getFieldName())) {
            args.addCustomQFilter(new QFilter("adminorgtype.adminorgtypestd.id", "in", Arrays.asList(1010L, 1020L)));
        }
    }

    private void openAddOrgPage(DynamicObject orgDy) {
        Long parentBoId = orgDy.getLong("boid");
        long adminOrgTypeStdId = orgDy.getLong("adminorgtype.adminorgtypestd.id");
        long l = adminOrgTypeStdId = adminOrgTypeStdId == 1010L ? 1020L : 1040L;
        if (adminOrgTypeStdId != 1040L) {
            boolean exists;
            AuthorizedOrgResult permResult;
            HRBaseServiceHelper orgHelper = new HRBaseServiceHelper("haos_adminorgdetail");
            QFilter filter = new QFilter("id", "=", (Object)parentBoId);
            HasPermOrgResult hrPermOrg = OrgPermHelper.getHRPermOrg();
            if (!hrPermOrg.hasAllOrgPerm()) {
                QFilter baseDataFilter = BaseDataHelper.getAdminOrgBaseDataFilter((String)"haos_adminorgdetail", (List)hrPermOrg.getHasPermOrgs());
                filter.and(baseDataFilter);
            }
            if ((permResult = AdminOrgBatchChgHelper.getOrgAuth((String)"homs_adminorgdetail", (String)"boid")) != null && !permResult.isHasAllOrgPerm()) {
                QFilter authFilter = new QFilter("boid", "in", (Object)permResult.getHasPermOrgs());
                filter.and(authFilter);
            }
            adminOrgTypeStdId = !(exists = orgHelper.isExists(filter.toArray())) ? 1040L : adminOrgTypeStdId;
        }
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.setFormId("homs_orgfastchgadd");
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCustomParam("adminOrgTypeStdId", (Object)String.valueOf(adminOrgTypeStdId));
        TreeView orgTree = (TreeView)this.getView().getControl("treeview");
        Map focusNode = orgTree.getTreeState().getFocusNode();
        formShowParameter.setCustomParam("parentorg", (Object)String.valueOf(orgDy.getLong("sourcevid")));
        formShowParameter.setCloseCallBack(new CloseCallBack(this.getPluginName(), "addnew"));
        this.toAddPageSetOrg(focusNode, formShowParameter);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private void toAddPageSetOrg(Map<String, Object> focusNode, BillShowParameter formShowParameter) {
        HRBaseServiceHelper parentOrgHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        DynamicObject parentOrg = parentOrgHelper.queryOne("id,boid,org", (Object)Long.valueOf(focusNode.get("id").toString()));
        AuthorizedOrgResult orgAuth = AdminOrgFastChgHelper.getOrgAuth((IFormView)this.getView());
        if (orgAuth.isHasAllOrgPerm()) {
            formShowParameter.setCustomParam("master_org", (Object)String.valueOf(parentOrg.getLong("org.id")));
        } else {
            HashSet authIdSet = new HashSet(orgAuth.getHasPermOrgs());
            if (authIdSet.contains(parentOrg.get("boid"))) {
                formShowParameter.setCustomParam("master_org", (Object)String.valueOf(parentOrg.getLong("org.id")));
            } else {
                formShowParameter.setCustomParam("master_org", (Object)this.getView().getPageCache().get("master_org"));
            }
        }
    }

    private boolean checkOrgStopUse(List<Long> orgIds) {
        if (orgIds.size() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u505c\u7528\u7684\u7ec4\u7ec7\u3002", (String)"AdminorgDetailListPlugin_4", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!AdminOrgFastChgHelper.checkOrgOperateTask(orgIds, (IFormView)this.getView(), (boolean)false)) {
            return false;
        }
        ArrayList<Long> paramList = new ArrayList<Long>(orgIds);
        AtomicBoolean isRootId = new AtomicBoolean(false);
        AdminOrgBatchChartHelper.queryAdminOrgByOrgIdSet(new HashSet<Long>(orgIds), (AtomicBoolean)isRootId);
        if (isRootId.get()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u505c\u7528\u6839\u7ec4\u7ec7\u3002", (String)"AdminorgDetailListPlugin_5", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean hasSpecificPerm = PermissionServiceHelper.hasSpecificPerm((long)RequestContext.get().getCurrUserId(), (String)"homs", (String)"homs_orgfastchgdisable", (String)"47150e89000000ac");
        if (!hasSpecificPerm) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u505c\u7528\u7ec4\u7ec7\u7684\u6743\u9650\u3002", (String)"AdminorgDetailListPlugin_14", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            return false;
        }
        Notification notification = new Notification();
        ArrayList needRemoveOrgIds = Lists.newArrayListWithCapacity((int)orgIds.size());
        DynamicObjectCollection orgDyCollectionByIds = AdminOrgFastChgHelper.getOrgDyCollectionByIds(orgIds);
        Map<Long, List<DynamicObject>> buOrgMap = orgDyCollectionByIds.stream().collect(Collectors.groupingBy(dy -> dy.getLong("org")));
        if (buOrgMap.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9700\u8981\u9009\u62e9\u540c\u4e00\u4e2a\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u4e0b\u7684\u884c\u653f\u7ec4\u7ec7\u8fdb\u884c\u201c\u505c\u7528\u201d\u64cd\u4f5c\u3002", (String)"AdminorgDetailListPlugin_28", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            return false;
        }
        Long buOrgId = new ArrayList<Long>(buOrgMap.keySet()).get(0);
        boolean isAllow = SystemParamHelper.getAllowPersonOnPosDisableParameter((Long)buOrgId);
        List ownDisableBoIdSet = orgDyCollectionByIds.stream().map(dyn -> dyn.getLong("boid")).collect(Collectors.toList());
        Map positionCountByOrg = OrgBatchBillCheckHelper.getPositionCountByOrg(ownDisableBoIdSet);
        notification.setAllow(isAllow);
        HashMap orgIdToName = Maps.newHashMapWithExpectedSize((int)orgDyCollectionByIds.size());
        HashMap orgBoIdToOrgId = Maps.newHashMapWithExpectedSize((int)orgDyCollectionByIds.size());
        HashMap orgIdToOrgBoId = Maps.newHashMapWithExpectedSize((int)orgDyCollectionByIds.size());
        orgDyCollectionByIds.stream().forEach(dyn -> {
            orgBoIdToOrgId.put(dyn.getLong("boid"), dyn.getLong("id"));
            orgIdToName.put(dyn.getLong("id"), dyn.getString("name"));
            orgIdToOrgBoId.put(dyn.getLong("id"), dyn.getLong("boid"));
        });
        List orgBatchCheckDtos = OrgBatchBillCheckHelper.queryBillOrgList();
        this.enablePositionCheck(buOrgId, orgIds, notification, orgIdToName, positionCountByOrg, orgIdToOrgBoId, needRemoveOrgIds);
        this.inWayBillCheck(orgIds, notification, needRemoveOrgIds, orgIdToName, orgBatchCheckDtos);
        this.adminDisabledCheck(notification, needRemoveOrgIds, orgDyCollectionByIds, orgBoIdToOrgId.keySet(), buOrgId, isAllow);
        this.dataRangeCheck(needRemoveOrgIds, orgBoIdToOrgId, orgIdToName, notification);
        needRemoveOrgIds.forEach(needRemoveOrgId -> orgIds.remove(needRemoveOrgId));
        if (needRemoveOrgIds.size() != 0 || notification.getOrgPeople().size() != 0 && notification.isAllow()) {
            String content = notification.getAllInfos();
            if (paramList.size() == 1) {
                this.getView().showTipNotification(content);
                return false;
            }
            ConfirmCallBackListener listener = new ConfirmCallBackListener("checkOrgStopUse", (IFormPlugin)this);
            String title = orgIds.size() != 0 ? String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u9009\u62e9\u7684\u7ec4\u7ec7\u6709\u6821\u9a8c\u4e0d\u901a\u8fc7\u7684\u6570\u636e\uff0c\u505c\u7528\u7ec4\u7ec7\u5c06\u81ea\u52a8\u53bb\u9664\u4ee5\u4e0b\u6821\u9a8c\u5931\u8d25\u7684\u7ec4\u7ec7\uff0c\u662f\u5426\u7ee7\u7eed\u505c\u7528\uff1f", (String)"AdminorgDetailListPlugin_7", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[0]) : String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u9009\u62e9\u7684\u7ec4\u7ec7\u6709\u6821\u9a8c\u4e0d\u901a\u8fc7\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AdminorgDetailListPlugin_27", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[0]);
            this.getView().showConfirm(title, content, MessageBoxOptions.OKCancel, ConfirmTypes.Default, listener, null, orgIds.stream().map(x -> x + "").collect(Collectors.joining(",")));
            return false;
        }
        return true;
    }

    private void enablePositionCheck(Long buOrgId, List<Long> orgIds, Notification notification, Map<Long, String> orgIdToName, Map<Long, Long> positionCountByOrg, Map<Long, Long> orgIdToOrgBoId, List<Long> needRemoveOrgIds) {
        for (Long orgId : orgIds) {
            if (SystemParamHelper.getAllowEnabledPosition((Long)buOrgId) || positionCountByOrg.getOrDefault(orgIdToOrgBoId.get(orgId), 0L).intValue() <= 0) continue;
            needRemoveOrgIds.add(orgId);
            notification.getResult().add(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\uff1a\u5b58\u5728\u542f\u7528\u4e2d\u7684\u5c97\u4f4d\uff0c\u4e0d\u5141\u8bb8\u505c\u7528\u3002", (String)"AdminorgDetailListPlugin_31", (String)"odc-homs-formplugin", (Object[])new Object[0]), orgIdToName.get(orgId)));
        }
    }

    private void dataRangeCheck(List<Long> needRemoveOrgIds, Map<Long, Long> orgBoIdToOrgId, Map<Long, String> orgIdToName, Notification notification) {
        AuthorizedOrgResult orgAuth = AdminOrgFastChgHelper.getOrgAuth((IFormView)this.getView());
        List hasPermOrgs = orgAuth.getHasPermOrgs();
        if (!orgAuth.isHasAllOrgPerm() && Objects.nonNull(orgAuth.getHasPermOrgs())) {
            for (Map.Entry<Long, Long> entry : orgBoIdToOrgId.entrySet()) {
                if (hasPermOrgs.contains(entry.getKey())) continue;
                needRemoveOrgIds.add(entry.getValue());
                notification.getNoDataRangePerm().add("[" + orgIdToName.get(entry.getValue()) + "]");
            }
        }
    }

    private void adminDisabledCheck(Notification notification, List<Long> needRemoveOrgIds, DynamicObjectCollection orgDyCollectionByIds, Set<Long> oweBoids, Long buOrgId, boolean isAllow) {
        Map parentToChildren = AdminOrgFastChgHelper.enabledChildren(oweBoids);
        Map orgIdPersonMap = OrgBatchBillCheckHelper.invokePersonService(oweBoids, (boolean)false);
        for (DynamicObject dy : orgDyCollectionByIds) {
            List names;
            Set children;
            Map childrenIdToName;
            if (HRStringUtils.equals((String)dy.getString("enable"), (String)"0")) {
                needRemoveOrgIds.add(dy.getLong("id"));
                notification.getDisabledOrgNames().add("[" + dy.getString("name") + "]");
            }
            if (!(Objects.isNull(childrenIdToName = (Map)parentToChildren.get(dy.getLong("boid"))) || CollectionUtils.isEmpty(children = childrenIdToName.keySet()) || oweBoids.containsAll(children))) {
                needRemoveOrgIds.add(dy.getLong("id"));
                for (Long childrenBoid : children) {
                    List orDefault = notification.getEnabledSubOrgNames().getOrDefault(dy.getString("name"), new ArrayList());
                    orDefault.add("[" + (String)((Map)parentToChildren.get(dy.getLong("boid"))).get(childrenBoid) + "]");
                    notification.getEnabledSubOrgNames().put(dy.getString("name"), orDefault);
                }
            }
            if (CollectionUtils.isEmpty((Collection)(names = (List)orgIdPersonMap.get(dy.getLong("boid"))))) continue;
            if (!isAllow) {
                needRemoveOrgIds.add(dy.getLong("id"));
            }
            notification.getOrgPeople().add("[" + dy.getString("name") + "]");
        }
    }

    private void inWayBillCheck(List<Long> orgIds, Notification notification, List<Long> needRemoveOrgIds, Map<Long, String> orgIdToName, List<OrgBatchCheckDto> orgBatchCheckDtos) {
        for (OrgBatchCheckDto dto : orgBatchCheckDtos) {
            Long parentOrgBoId = dto.getParentOrgId();
            if (orgIdToName.containsKey(parentOrgBoId) && !HRStringUtils.isEmpty((String)dto.getBillNo())) {
                needRemoveOrgIds.add(parentOrgBoId);
                notification.getResult().add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%1$s\u201d\u5728\u5355\u636e\u201c%2$s\u201d\u4e2d\u5b58\u5728\u4e0b\u7ea7\u7ec4\u7ec7\u201c%3$s\u201d\uff0c\u4e0d\u5141\u8bb8\u505c\u7528\u3002", (String)"AdminorgDetailListPlugin_18", (String)"odc-homs-formplugin", (Object[])new Object[0]), orgIdToName.get(parentOrgBoId), dto.getBillNo(), dto.getName()));
            }
            if (!orgIds.contains(dto.getOrgId()) || HRStringUtils.isEmpty((String)dto.getBillNo())) continue;
            needRemoveOrgIds.add(dto.getOrgId());
            notification.getResult().add(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5df2\u5b58\u5728\u5355\u636e\u201c%2$s\u201d\u7684\u201c%3$s\u201d\u4e2d,\u8bf7\u5148\u7b49\u5355\u636e\u751f\u6548\u540e\u518d\u64cd\u4f5c\u3002", (String)"AdminorgDetailListPlugin_12", (String)"odc-homs-formplugin", (Object[])new Object[0]), orgIdToName.get(dto.getOrgId()), dto.getBillNo(), BillEntryHelperEnum.getEntryDescriptionByChangeType((Long)dto.getChangeTypeId())));
        }
    }

    private boolean checkOrgEnable(List<Long> orgIds) {
        if (!AdminOrgFastChgHelper.checkOrgOperateTask(orgIds, (IFormView)this.getView(), (boolean)false)) {
            return false;
        }
        ArrayList<Long> needRemoveOrgIds = new ArrayList<Long>();
        DynamicObjectCollection orgs = AdminOrgFastChgHelper.getOrgDyCollectionByIds(orgIds);
        Map<Long, List<DynamicObject>> buOrgMap = orgs.stream().collect(Collectors.groupingBy(dy -> dy.getLong("org")));
        if (buOrgMap.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u540c\u4e00\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u4e0b\u7684\u884c\u653f\u7ec4\u7ec7\u8fdb\u884c\u542f\u7528\u3002", (String)"AdminorgDetailListPlugin_29", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            return false;
        }
        ArrayList<Long> paramList = new ArrayList<Long>(orgIds);
        HashMap<Long, Long> boidToId = new HashMap<Long, Long>(orgs.size());
        HashMap orgIdToName = Maps.newHashMapWithExpectedSize((int)orgs.size());
        HashSet oweEnableIds = Sets.newHashSetWithExpectedSize((int)orgs.size());
        List orgBatchCheckDtos = OrgBatchBillCheckHelper.queryBillOrgList();
        HashMap<Long, Long> parentIdToBoidMap = new HashMap<Long, Long>();
        HashMap<Long, Set<Long>> parentToChildren = new HashMap<Long, Set<Long>>();
        HashMap<Long, Long> childrenToParent = new HashMap<Long, Long>();
        List parentOrgIds = orgBatchCheckDtos.stream().map(dto -> dto.getOrgBoId()).collect(Collectors.toList());
        DynamicObjectCollection orgDyCollectionByIds = AdminOrgFastChgHelper.getOrgDyCollectionByIds(parentOrgIds);
        HashMap<Long, String> parentBoidToName = new HashMap<Long, String>();
        Notification notification = new Notification();
        orgDyCollectionByIds.forEach(dyn -> {
            parentIdToBoidMap.put(dyn.getLong("id"), dyn.getLong("boid"));
            parentBoidToName.put(dyn.getLong("boid"), dyn.getString("name"));
        });
        orgs.stream().forEach(dyn -> {
            Set orDefault = parentToChildren.getOrDefault(dyn.getLong("parentorg.id"), new HashSet());
            orDefault.add(dyn.getLong("id"));
            parentToChildren.put(dyn.getLong("parentorg.id"), orDefault);
            childrenToParent.put(dyn.getLong("id"), dyn.getLong("parentorg.id"));
            oweEnableIds.add(dyn.getLong("id"));
            boidToId.put(dyn.getLong("boid"), dyn.getLong("id"));
            orgIdToName.put(dyn.getLong("id"), dyn.getString("name"));
        });
        Map<Long, DynamicObject> parentMap = AdminOrgFastChgHelper.getOrgDyCollectionByIds(new ArrayList(parentToChildren.keySet())).stream().collect(Collectors.toMap(dyn -> dyn.getLong("boid"), dy -> dy));
        this.enabledAndDisabledParentCheck(notification, needRemoveOrgIds, orgs, boidToId, orgIdToName, oweEnableIds, childrenToParent, parentMap);
        this.inwayCheck(notification, needRemoveOrgIds, orgIdToName, orgBatchCheckDtos, parentIdToBoidMap, parentToChildren, parentBoidToName);
        this.dataRangeCheck(needRemoveOrgIds, boidToId, orgIdToName, notification);
        needRemoveOrgIds.forEach(needRemoveOrgId -> orgIds.remove(needRemoveOrgId));
        if (needRemoveOrgIds.size() != 0) {
            String content = notification.getAllInfos();
            if (paramList.size() == 1) {
                this.getView().showTipNotification(content);
                return false;
            }
            String title = orgIds.size() != 0 ? String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u9009\u62e9\u7684\u7ec4\u7ec7\u6709\u6821\u9a8c\u4e0d\u901a\u8fc7\u7684\u6570\u636e\uff0c\u542f\u7528\u7ec4\u7ec7\u5c06\u81ea\u52a8\u53bb\u9664\u4ee5\u4e0b\u6821\u9a8c\u5931\u8d25\u7684\u7ec4\u7ec7\uff0c\u662f\u5426\u7ee7\u7eed\u542f\u7528\uff1f", (String)"AdminorgDetailListPlugin_21", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[0]) : String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u9009\u62e9\u7684\u7ec4\u7ec7\u6709\u6821\u9a8c\u4e0d\u901a\u8fc7\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AdminorgDetailListPlugin_27", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[0]);
            ConfirmCallBackListener listener = new ConfirmCallBackListener("checkOrgEnable", (IFormPlugin)this);
            this.getView().showConfirm(title, content, MessageBoxOptions.OKCancel, ConfirmTypes.Default, listener, null, orgIds.stream().map(x -> x + "").collect(Collectors.joining(",")));
            return false;
        }
        return true;
    }

    private void enabledAndDisabledParentCheck(Notification notification, List<Long> needRemoveOrgIds, DynamicObjectCollection orgs, Map<Long, Long> boidToId, Map<Long, String> orgIdToName, Set<Long> oweEnableIds, Map<Long, Long> childrenToParent, Map<Long, DynamicObject> parentMap) {
        for (DynamicObject dy : orgs) {
            Long parentId;
            DynamicObject dynamicObject;
            Long orgId = dy.getLong("id");
            if (HRStringUtils.equals((String)dy.getString("enable"), (String)"1")) {
                needRemoveOrgIds.add(boidToId.get(dy.getLong("boid")));
                notification.getEnabledOrgNames().add("[" + dy.getString("name") + "]");
            }
            if (!Objects.nonNull(dynamicObject = parentMap.get(parentId = childrenToParent.get(orgId))) || !HRStringUtils.equals((String)dynamicObject.getString("enable"), (String)"0") || oweEnableIds.contains(boidToId.get(dynamicObject.getLong("id")))) continue;
            needRemoveOrgIds.add(boidToId.get(dy.getLong("boid")));
            notification.getDisabledParentOrgNames().add("[" + orgIdToName.get(orgId) + "]");
        }
    }

    private void inwayCheck(Notification notification, List<Long> needRemoveOrgIds, Map<Long, String> orgIdToName, List<OrgBatchCheckDto> orgBatchCheckDtos, Map<Long, Long> parentIdToBoidMap, Map<Long, Set<Long>> parentToChildren, Map<Long, String> parentBoidToName) {
        for (OrgBatchCheckDto dto : orgBatchCheckDtos) {
            Long orgId = dto.getOrgBoId();
            Long parentBoid = parentIdToBoidMap.get(orgId);
            if (HRStringUtils.isEmpty((String)dto.getBillNo()) || !parentToChildren.containsKey(parentBoid) || !OrgBatchChgBillConstants.CHANGE_TYPE_DISABLE.equals(dto.getChangeTypeId())) continue;
            for (Long child : parentToChildren.get(parentIdToBoidMap.get(orgId))) {
                needRemoveOrgIds.add(child);
                notification.getResult().add(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7684\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u201c%2$s\u201d\u5728\u7533\u8bf7\u5355\u201c%3$s\u201d\u4e2d\u88ab\u505c\u7528\uff0c\u4e0d\u5141\u8bb8\u542f\u7528\u3002", (String)"AdminorgDetailListPlugin_20", (String)"odc-homs-formplugin", (Object[])new Object[0]), orgIdToName.get(child), parentBoidToName.get(parentBoid), dto.getBillNo()));
            }
        }
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        super.afterQueryOfExport(e);
        DynamicObject[] queryValues = e.getQueryValues();
        List orgIdList = Arrays.stream(queryValues).map(value -> value.getLong("id")).collect(Collectors.toList());
        QFilter filter = new QFilter("id", "in", orgIdList);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_adminorgdetail");
        DynamicObject[] orgDetailArr = helper.query("id,boid", filter.toArray());
        Map<Long, Long> orgBoIdMap = Arrays.stream(orgDetailArr).collect(Collectors.toMap(org -> org.getLong("id"), org -> org.getLong("boid")));
        Map departmentMap = AdminOrgFastChgHelper.getDepartmentMap(new ArrayList<Long>(orgBoIdMap.values()));
        Map companyMap = AdminOrgFastChgHelper.getCompanyMap(new ArrayList<Long>(orgBoIdMap.values()));
        Map groupMap = AdminOrgFastChgHelper.getGroupMap(new ArrayList<Long>(orgBoIdMap.values()));
        Map<Long, List<DynamicObject>> orgBoId2CoopDynsMap = this.getOrgId2CoopDynsMap(new ArrayList<Long>(orgBoIdMap.values()));
        for (DynamicObject queryValue : queryValues) {
            long orgId;
            long orgBoId;
            List<DynamicObject> list;
            long adminOrgId = queryValue.getLong("id");
            long adminOrgBoId = orgBoIdMap.get(adminOrgId);
            this.setQueryValue(departmentMap, companyMap, groupMap, queryValue, adminOrgBoId);
            if (!queryValue.getDynamicObjectType().getProperties().containsKey((Object)"cooprelentryentity") || CollectionUtils.isEmpty(list = orgBoId2CoopDynsMap.get(orgBoId = orgBoIdMap.get(orgId = queryValue.getLong("id")).longValue()))) continue;
            DynamicObjectCollection collection = queryValue.getDynamicObjectCollection("cooprelentryentity");
            DynamicObjectType dynamicObjectType = collection.getDynamicObjectType();
            list.forEach(coopEntity -> {
                DynamicObject dynO = new DynamicObject(dynamicObjectType);
                DataEntityPropertyCollection properties = dynO.getDynamicObjectType().getProperties();
                if (properties.containsKey((Object)"coopreltyp")) {
                    dynO.set("coopreltyp", (Object)coopEntity.getDynamicObject("coopreltype"));
                }
                if (properties.containsKey((Object)"cooporgteam")) {
                    dynO.set("cooporgteam", (Object)coopEntity.getDynamicObject("cooporgteam"));
                }
                collection.add((Object)dynO);
            });
        }
    }

    private void setQueryValue(Map<Long, DynamicObject> departmentMap, Map<Long, DynamicObject> companyMap, Map<Long, DynamicObject> groupMap, DynamicObject queryValue, long adminOrgBoId) {
        if (queryValue.getDynamicObjectType().getProperties().containsKey((Object)"companytype")) {
            queryValue.set("companytype", companyMap.get(adminOrgBoId) != null ? companyMap.get(adminOrgBoId).get("companytype") : null);
        }
        if (queryValue.getDynamicObjectType().getProperties().containsKey((Object)"industrytype")) {
            queryValue.set("industrytype", companyMap.get(adminOrgBoId) != null ? companyMap.get(adminOrgBoId).get("industrytype") : null);
        }
        if (queryValue.getDynamicObjectType().getProperties().containsKey((Object)"departmenttype")) {
            queryValue.set("departmenttype", departmentMap.get(adminOrgBoId) != null ? departmentMap.get(adminOrgBoId).get("departmenttype") : null);
        }
        if (queryValue.getDynamicObjectType().getProperties().containsKey((Object)"groupvision")) {
            queryValue.set("groupvision", groupMap.get(adminOrgBoId) != null ? groupMap.get(adminOrgBoId).get("groupvision") : null);
        }
        if (queryValue.getDynamicObjectType().getProperties().containsKey((Object)"groupmission")) {
            queryValue.set("groupmission", groupMap.get(adminOrgBoId) != null ? groupMap.get(adminOrgBoId).get("groupmission") : null);
        }
    }

    private Map<Long, List<DynamicObject>> getOrgId2CoopDynsMap(List<Long> orgIdList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_orgteamcooprel");
        QFilter filter = new QFilter("org", "in", orgIdList);
        filter.and("iscurrentversion", "=", (Object)"1");
        filter.and("datastatus", "=", (Object)"1");
        filter.and("enable", "=", (Object)"1");
        DynamicObject[] dynamicObjects = serviceHelper.query("coopreltype,cooporgteam,org", new QFilter[]{filter});
        return Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(dyn -> dyn.getLong("org.id")));
    }

    private void beforeTreeOpenAddOrgPage() {
        Long adminOrgTypeStdId = 1040L;
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.setFormId("homs_orgfastchgadd");
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCustomParam("adminOrgTypeStdId", (Object)String.valueOf(adminOrgTypeStdId));
        formShowParameter.setCustomParam("parentorg", (Object)"0");
        formShowParameter.setCloseCallBack(new CloseCallBack(this.getPluginName(), "addnew"));
        formShowParameter.setCustomParam("master_org", (Object)this.getView().getPageCache().get("master_org"));
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public static class Notification {
        private Map<String, List<String>> enabledSubOrgNames = new HashMap<String, List<String>>();
        private List<String> disabledOrgNames = new ArrayList<String>();
        private List<String> enabledOrgNames = new ArrayList<String>();
        private List<String> disabledParentOrgNames = new ArrayList<String>();
        private List<String> orgPeople = new ArrayList<String>();
        private List<String> result = new ArrayList<String>();
        private List<String> noDataRangePerm = new ArrayList<String>();
        private boolean isAllow;

        public boolean isAllow() {
            return this.isAllow;
        }

        public void setAllow(boolean allow) {
            this.isAllow = allow;
        }

        public List<String> getDisabledParentOrgNames() {
            return this.disabledParentOrgNames;
        }

        public void setDisabledParentOrgNames(List<String> disabledParentOrgNames) {
            this.disabledParentOrgNames = disabledParentOrgNames;
        }

        public List<String> getEnabledOrgNames() {
            return this.enabledOrgNames;
        }

        public void setEnabledOrgNames(List<String> enabledOrgNames) {
            this.enabledOrgNames = enabledOrgNames;
        }

        public List<String> getNoDataRangePerm() {
            return this.noDataRangePerm;
        }

        public void setNoDataRangePerm(List<String> noDataRangePerm) {
            this.noDataRangePerm = noDataRangePerm;
        }

        public List<String> getOrgPeople() {
            return this.orgPeople;
        }

        public void setOrgPeople(List<String> orgPeople) {
            this.orgPeople = orgPeople;
        }

        public Map<String, List<String>> getEnabledSubOrgNames() {
            return this.enabledSubOrgNames;
        }

        public void setEnabledSubOrgNames(Map<String, List<String>> enabledSubOrgNames) {
            this.enabledSubOrgNames = enabledSubOrgNames;
        }

        public List<String> getDisabledOrgNames() {
            return this.disabledOrgNames;
        }

        public void setDisabledOrgNames(List<String> disabledOrgNames) {
            this.disabledOrgNames = disabledOrgNames;
        }

        public List<String> getResult() {
            return this.result;
        }

        public void setResult(List<String> result) {
            this.result = result;
        }

        public String getAllInfos() {
            StringBuilder sb = new StringBuilder();
            this.enabledSubOrgNames.forEach((parentOrg, sunOrg) -> sb.append(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0b\u5b58\u5728\u542f\u7528\u7684\u4e0b\u7ea7\u7ec4\u7ec7\u201c%2$s\u201d\uff0c\u4e0d\u80fd\u505c\u7528\u3002", (String)"AdminorgDetailListPlugin_17", (String)"odc-homs-formplugin", (Object[])new Object[0]), parentOrg, String.join((CharSequence)",", sunOrg))).append("\r\n"));
            if (this.enabledOrgNames.size() != 0) {
                sb.append(String.format(ResManager.loadKDString((String)"%s\u5df2\u542f\u7528\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u542f\u7528\u3002", (String)"AdminorgDetailListPlugin_19", (String)"odc-homs-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", this.enabledOrgNames))).append("\r\n");
            }
            if (this.disabledParentOrgNames.size() != 0) {
                sb.append(String.format(ResManager.loadKDString((String)"%s\u7684\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u5df2\u505c\u7528\uff0c\u4e0d\u80fd\u542f\u7528\u3002", (String)"AdminorgDetailListPlugin_22", (String)"odc-homs-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", this.disabledParentOrgNames))).append("\r\n");
            }
            if (this.disabledOrgNames.size() != 0) {
                sb.append(String.format(ResManager.loadKDString((String)"%s\u5df2\u505c\u7528\uff0c\u4e0d\u80fd\u518d\u6b21\u505c\u7528\u3002", (String)"AdminorgDetailListPlugin_6", (String)"odc-homs-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", this.disabledOrgNames))).append("\r\n");
            }
            if (this.orgPeople.size() != 0) {
                if (this.isAllow) {
                    sb.append(String.format(ResManager.loadKDString((String)"%s\u4e0b\u5b58\u5728\u5728\u804c\u4eba\u5458\uff0c\u662f\u5426\u505c\u7528\uff1f", (String)"AdminorgDetailListPlugin_30", (String)"odc-homs-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", this.orgPeople))).append("\r\n");
                } else {
                    sb.append(String.format(ResManager.loadKDString((String)"%s\u4e0b\u5b58\u5728\u5728\u804c\u4eba\u5458\uff0c\u4e0d\u80fd\u505c\u7528\u3002", (String)"AdminorgDetailListPlugin_16", (String)"odc-homs-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", this.orgPeople))).append("\r\n");
                }
            }
            if (this.noDataRangePerm.size() != 0) {
                sb.append(String.format(ResManager.loadKDString((String)"\u6c92\u6709\u884c\u653f\u7ec4\u7ec7\u201c%s\u201d\u6570\u636e\u8303\u56f4\u6743\u9650\u3002", (String)"AdminorgDetailListPlugin_41", (String)"odc-homs-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", this.noDataRangePerm))).append("\r\n");
            }
            this.result.forEach(res -> sb.append((String)res).append("\r\n"));
            return sb.toString();
        }
    }
}

