/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.adminorg;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FieldTip;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.TipsSupport;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.haos.business.rpc.HRCSRPCServiceHelper;
import kd.hr.haos.business.util.BaseDataHelper;
import kd.hr.haos.business.util.OrgPermHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.helper.AdminOrgBatchChgHelper;
import kd.hr.homs.business.service.helper.AdminOrgFastChgHelper;
import kd.hr.homs.business.service.helper.OrgBatchValidateHelper;

public class AdminorgFastAddBillPlugin
extends AbstractFormPlugin
implements ClickListener,
BeforeF7SelectListener {
    private static final String ORGTYPE = "adminorgtype";
    private static final String PARENT = "parentorg";
    private static final String[] TIPS_ARR = new String[]{"effdt", "number", "adminorgtype", "establishmentdate"};
    private static final Set<String> BASE_ARR = Sets.newHashSet((Object[])new String[]{"changescene", "changereason", "adminorgtype", "belongcompany", "adminorglayer", "adminorgfunction", "companytype", "departmenttype", "coopreltyp", "safelevel", "safetype", "corporateorg"});
    private static final String MASTER_ORG = "masterOrg";
    private static final Map<String, String> type2EntityType = new HashMap<String, String>(){
        {
            this.put(AdminorgFastAddBillPlugin.ORGTYPE, "haos_adminorgtype");
            this.put("adminorglayer", "haos_adminorglayer");
            this.put("adminorgfunction", "haos_adminorgfunction");
            this.put("safelevel", "haos_safelevel");
            this.put("safetype", "haos_safetype");
            this.put("companytype", "haos_companytype");
            this.put("departmenttype", "haos_departmenttype");
            this.put("changereason", "haos_orgchangereason");
            this.put("changescene", "haos_changescene");
            this.put("corporateorg", "hbss_lawentity");
            this.put("cooprelentryentity.coopreltyp", "haos_teamcoopreltype");
        }
    };

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getPageCache().remove(MASTER_ORG);
        this.getPageCache().put("paramsChangeSetNumber", "false");
        this.getView().getPageCache().put("isMasterOrg", "false");
        String masterOrg = (String)this.getView().getFormShowParameter().getCustomParam("master_org");
        HasPermOrgResult hrPermOrg = OrgPermHelper.getHRPermOrg((String)"homs_adminorgdetail");
        HashSet hrPermOrgSet = new HashSet(hrPermOrg.getHasPermOrgs());
        if (!StringUtils.isEmpty((CharSequence)masterOrg) && (hrPermOrg.hasAllOrgPerm() || hrPermOrgSet.contains(Long.parseLong(masterOrg)))) {
            this.getModel().setValue("org", (Object)Long.parseLong(masterOrg));
        } else {
            this.getModel().setValue("org", null);
        }
        String adminOrgTypeStdIdStr = (String)this.getView().getFormShowParameter().getCustomParam("adminOrgTypeStdId");
        Long adminOrgTypeStdId = Long.valueOf(adminOrgTypeStdIdStr);
        this.getPageCache().put("orgTypeStd", adminOrgTypeStdIdStr);
        this.getPageCache().put("initFlag", "true");
        long parentOrgId = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam(PARENT));
        this.setLastTimeAddOrgInfo();
        this.getModel().setValue(PARENT, (Object)parentOrgId);
        this.getPageCache().put(MASTER_ORG, StringUtils.isEmpty((CharSequence)masterOrg) ? "0" : masterOrg);
        AdminOrgBatchChgHelper.setOrgInfoViewByType((Long)adminOrgTypeStdId, (IFormView)this.getView());
        this.setTips();
        this.setChangeScenes();
        this.setOrgNumber(AdminOrgBatchChgHelper.getAdminorgHrDy((DynamicObject)this.getModel().getDataEntity()));
        this.getPageCache().put("paramsChangeSetNumber", "true");
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String codeRuleNumber = this.getView().getPageCache().get("codeRuleNumber");
        if (!StringUtils.isEmpty((CharSequence)codeRuleNumber)) {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                return;
            }
            String saveResult = this.getView().getPageCache().get("saveResult");
            if (!"true".equals(saveResult)) {
                long orgId = org.getLong("id");
                this.recycleNumber(orgId, codeRuleNumber, Boolean.FALSE, null, null);
            }
        }
    }

    private void setChangeScenes() {
        QFilter buFilter;
        QFilter changeTyeFilter;
        QFilter enableFilter;
        QFilter statusFilter;
        HRBaseServiceHelper serviceHelper;
        DynamicObject[] changeSceneDyns;
        List changeLists;
        if (this.getModel().getValue("org") == null) {
            return;
        }
        DynamicObject changeSence = this.getModel().getDataEntity().getDynamicObject("changescene");
        if (changeSence == null && (changeLists = Arrays.stream(changeSceneDyns = (serviceHelper = new HRBaseServiceHelper("haos_changescene")).loadDynamicObjectArray(new QFilter[]{statusFilter = new QFilter("status", "=", (Object)"C"), enableFilter = new QFilter("enable", "=", (Object)Character.valueOf('1')), changeTyeFilter = new QFilter("orgchangetype.id", "=", (Object)this.getModel().getDataEntity().getLong("changetype.id")), buFilter = BaseDataHelper.getBaseDataFilter((String)"haos_changescene", (long)((DynamicObject)this.getModel().getValue("org")).getLong("id"))})).filter(dyn -> dyn.getLong("id") != 1070L).collect(Collectors.toList())) != null && changeLists.size() == 1) {
            this.setDefaultValue((DynamicObject)changeLists.get(0));
        }
    }

    private void setDefaultValue(DynamicObject dynamicObject) {
        this.getModel().setValue("changescene", (Object)dynamicObject);
        Set changeReasonSet = dynamicObject.getDynamicObjectCollection("changereason").stream().map(dyn -> dyn.getLong("fbasedataid.id")).collect(Collectors.toSet());
        HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_orgchangereason");
        DynamicObject[] dynamicObjects = helper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", changeReasonSet), BaseDataHelper.getBaseDataFilter((String)"haos_orgchangereason", (long)((DynamicObject)this.getModel().getValue("org")).getLong("id")), new QFilter("enable", "=", (Object)"1")});
        if (dynamicObjects.length == 1) {
            this.getModel().setValue("changereason", (Object)dynamicObjects[0]);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.changeOrgFiledTip();
        AdminOrgBatchChgHelper.setStructProjectEntry((IFormView)this.getView(), (boolean)false, (boolean)false);
        this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
    }

    private void changeOrgFiledTip() {
        FieldTip orgTip = new FieldTip();
        orgTip.setFieldKey("org");
        orgTip.setSuccess(true);
        this.getView().showFieldTip(orgTip);
    }

    private void setOrgNumber(DynamicObject adminorgHrDy) {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (org == null) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
            return;
        }
        String number = this.getModel().getDataEntity().getString("number");
        if (HRStringUtils.isNotEmpty((String)number) && !HRStringUtils.equals((String)number, (String)this.getView().getPageCache().get("codeRuleNumber"))) {
            return;
        }
        long orgid = org.getLong("id");
        boolean cudeRule = CodeRuleServiceHelper.isExist((String)"haos_adminorghr", (DynamicObject)adminorgHrDy, (String)String.valueOf(orgid));
        if (cudeRule) {
            String orgNumber = CodeRuleServiceHelper.getNumber((String)"haos_adminorghr", (DynamicObject)adminorgHrDy, (String)String.valueOf(org.getLong("id")));
            if (CodeRuleServiceHelper.isModifiable((String)"haos_adminorghr", (DynamicObject)adminorgHrDy, (String)String.valueOf(org.getLong("id")))) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"number"});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
            }
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
            QFilter qFilter = new QFilter("number", "=", (Object)orgNumber);
            if (!hrBaseServiceHelper.isExists(qFilter)) {
                this.getModel().setValue("number", (Object)orgNumber);
                this.getView().getPageCache().put("codeRuleNumber", orgNumber);
            } else {
                this.setOrgNumber(adminorgHrDy);
            }
        } else {
            this.getModel().setValue("number", null);
            this.getView().getPageCache().put("codeRuleNumber", "");
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"number"});
        }
    }

    private void recycleNumber(Long orgId, String codeRuleNumber, Boolean paramsChg, String numberParams, Object numberParamsOb) {
        String number;
        DynamicObject adminorgHrDy = AdminOrgBatchChgHelper.getAdminorgHrDy((DynamicObject)this.getModel().getDataEntity());
        if (paramsChg.booleanValue()) {
            if (adminorgHrDy.get(numberParams) instanceof DynamicObject && numberParamsOb instanceof Long) {
                String baseName = adminorgHrDy.getDynamicObject(numberParams).getDataEntityType().getName();
                HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(baseName);
                DynamicObject paramDy = hrBaseServiceHelper.loadSingle(numberParamsOb);
                adminorgHrDy.set(numberParams, (Object)paramDy);
            } else {
                adminorgHrDy.set(numberParams, numberParamsOb);
            }
        }
        if (HRStringUtils.equals((String)(number = this.getModel().getDataEntity().getString("number")), (String)codeRuleNumber)) {
            CodeRuleServiceHelper.recycleNumber((String)"haos_adminorghr", (DynamicObject)adminorgHrDy, (String)String.valueOf(orgId), (String)codeRuleNumber);
        }
    }

    private void setLastTimeAddOrgInfo() {
        String orgIdStr = this.getView().getParentView().getPageCache().get("lastTimeAddEntryId");
        if (HRStringUtils.isEmpty((String)orgIdStr)) {
            return;
        }
        HRBaseServiceHelper billHelper = new HRBaseServiceHelper("homs_batchorgentity");
        Long lastTimeAddEntryId = Long.valueOf(orgIdStr);
        DynamicObject addOrgDy = billHelper.queryOne("changescene,changereason,changedescription,org", (Object)lastTimeAddEntryId);
        if (addOrgDy != null) {
            this.getModel().setValue("changescene", (Object)addOrgDy.getDynamicObject("changescene"));
            this.getModel().setValue("changereason", (Object)addOrgDy.getDynamicObject("changereason"));
            this.getModel().setValue("changedescription", addOrgDy.get("changedescription"));
            this.getView().getFormShowParameter().setCustomParam("master_org", (Object)String.valueOf(addOrgDy.getLong("org.id")));
        }
        this.getView().getParentView().getPageCache().remove("lastTimeAddEntryId");
    }

    public void propertyChanged(PropertyChangedArgs changedArgs) {
        String fieldKey = changedArgs.getProperty().getName();
        boolean isGetNumber = true;
        switch (fieldKey) {
            case "establishmentdate": {
                this.setEstablishmentdateToEffdt((Date)changedArgs.getChangeSet()[0].getNewValue());
                break;
            }
            case "adminorgtype": {
                String oldOrgTypeStd = this.getPageCache().get("orgTypeStd");
                if (changedArgs.getChangeSet()[0].getNewValue() == null) {
                    return;
                }
                Long orgTypeStd = this.getModel().getDataEntity().getDynamicObject(ORGTYPE).getLong("adminorgtypestd.id");
                String orgTypeStdStr = String.valueOf(orgTypeStd);
                if ("true".equals(this.getPageCache().get("initFlag"))) {
                    this.getPageCache().put("initFlag", null);
                    if (!oldOrgTypeStd.equals(orgTypeStdStr)) {
                        this.cleanAddOrgInfo();
                    }
                    this.propertyChangedGetNumber(fieldKey, changedArgs.getChangeSet()[0].getOldValue());
                    AdminOrgFastChgHelper.setBelongCompany((IFormView)this.getView());
                    return;
                }
                if (!oldOrgTypeStd.equals(orgTypeStdStr)) {
                    DynamicObject orgType = (DynamicObject)changedArgs.getChangeSet()[0].getOldValue();
                    Long orgTypeOld = orgType == null ? 0L : orgType.getLong("id");
                    this.getPageCache().put("orgtypeOld", String.valueOf(orgTypeOld));
                    ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("select_orgtype", (IFormPlugin)this);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u540e\uff0c\u9875\u9762\u5c06\u91cd\u65b0\u663e\u793a\u5bf9\u5e94\u7684\u4fe1\u606f\uff0c\u539f\u6765\u7684\u90e8\u5206\u4fe1\u606f\u5c06\u88ab\u6e05\u7a7a\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AdminorgFastChgPlugin_26", (String)"odc-homs-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBackListener, null, String.valueOf(orgTypeOld));
                    this.getView().getPageCache().put("numberByOrgType", "1");
                } else if (!HRStringUtils.equals((String)"0", (String)this.getView().getPageCache().get("numberByOrgType"))) {
                    this.propertyChangedGetNumber(ORGTYPE, changedArgs.getChangeSet()[0].getOldValue());
                    this.getView().getPageCache().put("numberByOrgType", "1");
                }
                isGetNumber = false;
                break;
            }
            case "name": {
                AdminOrgFastChgHelper.setBelongCompany((IFormView)this.getView());
                break;
            }
            case "org": {
                this.orgPropertyChanged(changedArgs);
            }
        }
        if (HRStringUtils.equals((String)"true", (String)this.getPageCache().get("paramsChangeSetNumber")) && isGetNumber) {
            this.propertyChangedGetNumber(fieldKey, changedArgs.getChangeSet()[0].getOldValue());
        }
    }

    private void orgPropertyChanged(PropertyChangedArgs changedArgs) {
        ChangeData changeData = changedArgs.getChangeSet()[0];
        DynamicObject newDy = (DynamicObject)changeData.getNewValue();
        DynamicObject oldDy = (DynamicObject)changeData.getOldValue();
        String masterOrg = this.getPageCache().get(MASTER_ORG);
        if (changedArgs.getChangeSet()[0].getNewValue() == null) {
            return;
        }
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("homs_orgbatchchgbill");
        boolean exists = hrBaseServiceHelper.isExists((Object)this.getModel().getDataEntity().getLong("id"));
        if (exists) {
            return;
        }
        Long orgIdNew = newDy.getLong("id");
        if (StringUtils.isNotEmpty((CharSequence)masterOrg) && !StringUtils.equals((CharSequence)masterOrg, (CharSequence)String.valueOf(orgIdNew))) {
            Long orgIDOld = oldDy == null ? 0L : oldDy.getLong("id");
            this.getPageCache().put(MASTER_ORG, String.valueOf(orgIDOld));
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(MASTER_ORG, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u540e\uff0c\u5c06\u6e05\u9664\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u4ee5\u53ca\u8be5\u7ec4\u7ec7\u4e0d\u53ef\u4f7f\u7528\u7684\u57fa\u7840\u8d44\u6599\u4fe1\u606f\uff0c\u662f\u5426\u5207\u6362\uff1f", (String)"AdminorgFastChgPlugin_30", (String)"odc-homs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
        }
    }

    private void propertyChangedGetNumber(String fieldKey, Object oldValue) {
        switch (fieldKey) {
            case "adminorgtype": 
            case "adminorglayer": 
            case "adminorgfunction": 
            case "companyarea": 
            case "parentorg": 
            case "belongcompany": 
            case "city": 
            case "workplace": 
            case "companytype": 
            case "departmenttype": 
            case "safelevel": 
            case "safetype": {
                if (HRStringUtils.equals((String)fieldKey, (String)PARENT)) {
                    fieldKey = "parent";
                } else if (HRStringUtils.equals((String)fieldKey, (String)ORGTYPE)) {
                    fieldKey = "orgtype";
                } else if (HRStringUtils.equals((String)fieldKey, (String)"belongcompany")) {
                    fieldKey = "company";
                }
                String codeRuleNumber = this.getView().getPageCache().get("codeRuleNumber");
                if (!StringUtils.isEmpty((CharSequence)codeRuleNumber)) {
                    DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
                    if (org == null) {
                        return;
                    }
                    long orgId = org.getLong("id");
                    this.recycleNumber(orgId, codeRuleNumber, Boolean.TRUE, fieldKey, oldValue);
                }
                this.setOrgNumber(AdminOrgBatchChgHelper.getAdminorgHrDy((DynamicObject)this.getModel().getDataEntity()));
            }
        }
    }

    private void setEstablishmentdateToEffdt(Date date) {
        if (date != null) {
            this.getModel().setValue("effdt", (Object)date);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgtype = (BasedataEdit)this.getView().getControl(ORGTYPE);
        orgtype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit parent = (BasedataEdit)this.getView().getControl(PARENT);
        parent.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if (HRStringUtils.equals((String)fieldKey, (String)ORGTYPE)) {
            if (this.getModel().getDataEntity().getDynamicObject(ORGTYPE) != null) {
                Long orgTypeStd = this.getModel().getDataEntity().getDynamicObject(ORGTYPE).getLong("adminorgtypestd.id");
                this.getPageCache().put("orgTypeStd", String.valueOf(orgTypeStd));
            }
        } else if (HRStringUtils.equals((String)fieldKey, (String)PARENT)) {
            QFilter dataStatusFilter = new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
            QFilter statusFilter = new QFilter("status", "=", (Object)"C");
            beforeF7SelectEvent.getCustomQFilters().add(statusFilter);
            beforeF7SelectEvent.getCustomQFilters().add(dataStatusFilter);
            HasPermOrgResult hrPermOrg = OrgPermHelper.getHRPermOrg();
            if (!hrPermOrg.hasAllOrgPerm()) {
                QFilter baseDataFilter = BaseDataHelper.getAdminOrgBaseDataFilter((String)"haos_adminorgdetail", (List)hrPermOrg.getHasPermOrgs());
                beforeF7SelectEvent.getCustomQFilters().add(baseDataFilter);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        int result = event.getResult().getValue();
        if (event.getCallBackId().equals("select_orgtype")) {
            if (result == MessageBoxResult.Yes.getValue()) {
                this.cleanAddOrgInfo();
                String orgTypeOldId = event.getCustomVaule();
                this.propertyChangedGetNumber(ORGTYPE, Long.valueOf(orgTypeOldId));
                AdminOrgFastChgHelper.setBelongCompany((IFormView)this.getView());
            } else {
                Long orgTypeId = Long.valueOf(this.getPageCache().get("orgtypeOld"));
                this.getView().getPageCache().put("numberByOrgType", "0");
                this.getModel().setValue(ORGTYPE, (Object)(orgTypeId.equals(0L) ? null : orgTypeId));
                if (orgTypeId.equals(0L)) {
                    this.getModel().setValue("belongcompany_name", null);
                    this.getModel().setValue("belongcompany", null);
                }
            }
        } else if (event.getCallBackId().equals(MASTER_ORG)) {
            if (result == MessageBoxResult.Yes.getValue()) {
                this.recycleNumber(Long.valueOf(this.getPageCache().get(MASTER_ORG)), this.getModel().getDataEntity().getString("number"), Boolean.FALSE, "org", Long.valueOf(this.getPageCache().get(MASTER_ORG)));
                this.getView().getPageCache().put(MASTER_ORG, String.valueOf(this.getModel().getDataEntity().getLong("org.id")));
                this.setOrgNumber(AdminOrgBatchChgHelper.getAdminorgHrDy((DynamicObject)this.getModel().getDataEntity()));
                this.cleanOrgBaseInfo();
            } else {
                Long masterOrgId = Long.valueOf(this.getPageCache().get(MASTER_ORG));
                this.getModel().setValue("org", (Object)(masterOrgId.equals(0L) ? null : masterOrgId));
            }
        }
    }

    private void cleanOrgBaseInfo() {
        this.getView().getModel().setValue(PARENT, null);
        Map baseDataIdsByHrOrgBuID = OrgBatchValidateHelper.getBaseDataIdsByHrOrgBuID(type2EntityType.values(), (long)this.getModel().getDataEntity().getLong("org.id"));
        for (String baseName : BASE_ARR) {
            Set baseSet = (Set)baseDataIdsByHrOrgBuID.get(type2EntityType.get(baseName));
            if (StringUtils.equals((CharSequence)baseName, (CharSequence)"coopreltyp")) {
                DynamicObjectCollection cooprelentryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection("cooprelentryentity");
                if (cooprelentryentity.size() <= 0) continue;
                for (int i = 0; i < cooprelentryentity.size(); ++i) {
                    DynamicObject dynamicObject = (DynamicObject)cooprelentryentity.get(i);
                    Long baseId = HRDyObjectPropUtil.getIdLongObject((DynamicObject)dynamicObject.getDynamicObject(baseName));
                    if (baseSet != null && baseSet.contains(baseId)) continue;
                    this.getModel().setValue(baseName, null, i);
                }
                continue;
            }
            Long baseId = HRDyObjectPropUtil.getIdLongObject((DynamicObject)this.getModel().getDataEntity().getDynamicObject(baseName));
            if (baseSet != null && baseSet.contains(baseId)) continue;
            this.getModel().setValue(baseName, null);
        }
    }

    private void cleanAddOrgInfo() {
        String oldAdminOrgTypeStd = this.getPageCache().get("orgTypeStd");
        if (StringUtils.equals((CharSequence)oldAdminOrgTypeStd, (CharSequence)String.valueOf(1010L))) {
            this.getModel().setValue("groupvision", null);
            this.getModel().setValue("groupmission", null);
        } else if (StringUtils.equals((CharSequence)oldAdminOrgTypeStd, (CharSequence)String.valueOf(1020L))) {
            this.getModel().setValue("companytype", null);
            this.getModel().setValue("industrytype", null);
        } else if (StringUtils.equals((CharSequence)oldAdminOrgTypeStd, (CharSequence)String.valueOf(1040L))) {
            this.getModel().setValue("departmenttype", null);
        }
        DynamicObject orgType = this.getModel().getDataEntity().getDynamicObject(ORGTYPE);
        Long adminOrgTypeStd = orgType.getLong("adminorgtypestd.id");
        this.getPageCache().put("orgTypeStd", String.valueOf(adminOrgTypeStd));
        AdminOrgBatchChgHelper.setOrgInfoViewByType((Long)adminOrgTypeStd, (IFormView)this.getView());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Long billId;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"new")) {
            this.getModel().setDataChanged(false);
        } else if (HRStringUtils.equals((String)operateKey, (String)"save") && ((billId = (Long)this.getView().getModel().getDataEntity().getPkValue()) == null || billId == 0L)) {
            this.getView().getModel().setValue("id", (Object)ORM.create().genLongId("homs_orgfastchgadd"));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        OperationResult result = eventArgs.getOperationResult();
        String operateKey = eventArgs.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"save") && result.isSuccess()) {
            this.getView().getPageCache().put("saveResult", "true");
        }
        if (!ObjectUtils.isEmpty((Object)result) && !result.isSuccess()) {
            return;
        }
        if (HRStringUtils.equals((String)eventArgs.getOperateKey(), (String)"saveandnew")) {
            this.getView().getParentView().getPageCache().put("lastTimeAddEntryId", String.valueOf(this.getModel().getDataEntity().getLong("entryid")));
        }
    }

    private void setTips() {
        for (String tipsName : TIPS_ARR) {
            Tips tips = new Tips();
            List tipList = HRCSRPCServiceHelper.queryPromptForString((IFormView)this.getView(), (String)"homs_orgfastchgadd", (String)tipsName);
            if (CollectionUtils.isEmpty((Collection)tipList)) continue;
            tips.setContent(new LocaleString((String)tipList.get(0)));
            tips.setType("text");
            tips.setTriggerType("hover");
            tips.setIsConfirm(false);
            tips.setShowIcon(true);
            TipsSupport control = (TipsSupport)this.getControl(tipsName);
            if (control == null) continue;
            control.addTips(tips);
        }
    }
}

