/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.adminorg;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.haos.business.servicehelper.OrgBatchBillHelper;
import kd.hr.haos.business.util.BaseDataHelper;
import kd.hr.haos.business.util.OrgPermHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.helper.AdminOrgBatchChgHelper;
import kd.hr.homs.business.service.helper.AdminOrgFastChgHelper;
import kd.hr.homs.business.service.orgfast.async.AsyncEffectingReformHelper;
import kd.hr.homs.business.service.utils.PatternUtil;
import kd.hr.homs.common.constants.fastchg.OrgFastChgBillConstants;

public class AdminorgFastChgParentBillPlugin
extends AbstractFormPlugin
implements ClickListener,
BeforeF7SelectListener,
UploadListener,
OrgFastChgBillConstants {
    private static final Log logger = LogFactory.getLog(AdminorgFastChgParentBillPlugin.class);
    private static final String MASTER_ORG = "masterOrg";

    public void remove(UploadEvent evt) {
        LinkedHashMap attachmentInfo = (LinkedHashMap)evt.getUrls()[0];
        HRBaseServiceHelper attachmentServiceHelper = new HRBaseServiceHelper("bos_attachment");
        QFilter filter = new QFilter("fbilltype", "=", (Object)"haos_adminorgdetail");
        filter.and("finterid", "=", (Object)this.getModel().getDataEntity(Boolean.TRUE.booleanValue()).getString("orgid"));
        filter.and("fnumber", "=", attachmentInfo.get("uid"));
        attachmentServiceHelper.deleteByFilter(new QFilter[]{filter});
        DynamicObject orgDy = this.getModel().getDataEntity().getDynamicObject("org");
        this.getPageCache().put(MASTER_ORG, orgDy != null ? String.valueOf(orgDy.getLong("id")) : "0");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getPageCache().remove(MASTER_ORG);
        String orgIdStr = this.getView().getFormShowParameter().getCustomParam("orgid").toString();
        Long orgId = Long.valueOf(orgIdStr);
        this.setOrgInfoToPage(orgId);
        AdminOrgFastChgHelper.setChangeScence((IDataModel)this.getModel());
        this.getView().setFormTitle(new LocaleString(String.format(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7-%s", (String)"FastAdminOrgInfoChange_1", (String)"odc-homs-business", (Object[])new Object[0]), this.getModel().getDataEntity().getString("name"))));
        DynamicObject orgDy = this.getModel().getDataEntity().getDynamicObject("org");
        this.getPageCache().put(MASTER_ORG, orgDy != null ? String.valueOf(orgDy.getLong("id")) : "0");
        AdminOrgBatchChgHelper.setStructProjectEntry((IFormView)this.getView(), (boolean)false, (boolean)false);
        this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
    }

    public void propertyChanged(PropertyChangedArgs changedArgs) {
        String fieldKey;
        switch (fieldKey = changedArgs.getProperty().getName()) {
            case "coopreltyp": {
                break;
            }
            case "cooporgteam": {
                break;
            }
            case "adminorg": {
                this.adminorgChanged(changedArgs);
                break;
            }
            case "adminorgtype": {
                if (!this.getPageCache().get("isChangeOrgType").equals("true") || changedArgs.getChangeSet()[0].getNewValue() == null) break;
                this.getPageCache().put("isChangeOrgType", "false");
                DynamicObject orgType = (DynamicObject)changedArgs.getChangeSet()[0].getOldValue();
                Long orgTypeOld = orgType != null ? orgType.getLong("id") : 0L;
                this.getPageCache().put("orgtypeOld", String.valueOf(orgTypeOld));
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("select_orgtype", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u540e\uff0c\u53ef\u80fd\u4f1a\u5bfc\u81f4\u672c\u7ec4\u7ec7\u53ca\u5176\u4e0b\u7ea7\u7ec4\u7ec7\u7684\u6240\u5c5e\u516c\u53f8\u53d1\u751f\u53d8\u5316\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AdminorgFastChgPlugin_1", (String)"odc-homs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
                break;
            }
            case "org": {
                AdminOrgFastChgHelper.orgPropertyChanged((PropertyChangedArgs)changedArgs, (IFormView)this.getView(), (IFormPlugin)this);
            }
        }
    }

    private void adminorgChanged(PropertyChangedArgs changedArgs) {
        if (this.getPageCache().get("isChangeOrg").equals("true")) {
            this.getPageCache().put("isChangeOrg", "false");
            DynamicObject org = (DynamicObject)changedArgs.getChangeSet()[0].getOldValue();
            DynamicObject newOrg = (DynamicObject)changedArgs.getChangeSet()[0].getNewValue();
            Long orgOld = org != null ? Long.valueOf(org.getLong("id")) : null;
            this.getPageCache().put("orgOld", orgOld == null ? "" : String.valueOf(orgOld));
            if (newOrg != null) {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("select_org", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u884c\u653f\u7ec4\u7ec7\u540e\uff0c\u5f53\u524d\u5df2\u4fee\u6539\u7684\u5185\u5bb9\u5c06\u4f1a\u4e22\u5931\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AdminorgFastChgPlugin_5", (String)"odc-homs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit parent = (BasedataEdit)this.getView().getControl("parentorg");
        parent.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit orgType = (BasedataEdit)this.getView().getControl("adminorgtype");
        orgType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey;
        switch (fieldKey = beforeF7SelectEvent.getProperty().getName()) {
            case "adminorg": {
                AuthorizedOrgResult permResult = AdminOrgFastChgHelper.getOrgAuth((IFormView)this.getView());
                if (permResult != null && !permResult.isHasAllOrgPerm()) {
                    QFilter authFilter = new QFilter("id", "in", (Object)permResult.getHasPermOrgs());
                    beforeF7SelectEvent.getCustomQFilters().add(authFilter);
                }
                beforeF7SelectEvent.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7", (String)"AdminorgFastChgPlugin_9", (String)"odc-homs-formplugin", (Object[])new Object[0]));
                this.getPageCache().put("isChangeOrg", "true");
                break;
            }
            case "parentorg": {
                HasPermOrgResult hrPermOrg;
                Long orgBoId = this.getModel().getDataEntity().getLong("adminorg.boid");
                QFilter dataStatusFilter = new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
                QFilter statusFilter = new QFilter("status", "=", (Object)"C");
                beforeF7SelectEvent.getCustomQFilters().add(statusFilter);
                beforeF7SelectEvent.getCustomQFilters().add(dataStatusFilter);
                QFilter orgAndChildrenFilter = AdminOrgFastChgHelper.getOrgAndChildrenFilter((Long)orgBoId);
                if (orgAndChildrenFilter != null) {
                    beforeF7SelectEvent.getCustomQFilters().add(orgAndChildrenFilter);
                }
                if ((hrPermOrg = OrgPermHelper.getHRPermOrg()).hasAllOrgPerm()) break;
                QFilter baseDataFilter = BaseDataHelper.getAdminOrgBaseDataFilter((String)"haos_adminorgdetail", (List)hrPermOrg.getHasPermOrgs());
                beforeF7SelectEvent.getCustomQFilters().add(baseDataFilter);
                break;
            }
            case "adminorgtype": {
                this.getPageCache().put("isChangeOrgType", "true");
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = ((FormOperate)afterDoOperationEventArgs.getSource()).getOperateKey();
        DynamicObject dataEntity = this.getView().getModel().getDataEntity();
        AsyncEffectingReformHelper.showConfirm((String)operateKey, (IFormView)this.getView(), (IDataModel)this.getModel(), (IFormPlugin)this, (DynamicObject)dataEntity);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        int result = event.getResult().getValue();
        switch (event.getCallBackId()) {
            case "select_orgtype": {
                if (result == MessageBoxResult.Yes.getValue()) {
                    this.setOrgtypeInfo(this.getModel().getDataEntity().getDynamicObject("adminorgtype").getLong("adminorgtypestd.id"));
                    AdminOrgFastChgHelper.setBelongCompany((IFormView)this.getView());
                    break;
                }
                Long orgTypeId = Long.valueOf(this.getPageCache().get("orgtypeOld"));
                this.getPageCache().put("isChangeOrgType", "false");
                this.getModel().setValue("adminorgtype", (Object)(orgTypeId == 0L ? null : orgTypeId));
                break;
            }
            case "select_org": {
                if (result == MessageBoxResult.Yes.getValue()) {
                    Long orgId = this.getModel().getDataEntity().getDynamicObject("adminorg").getLong("id");
                    this.setOrgInfoToPage(orgId);
                    break;
                }
                this.getModel().setValue("adminorg", (Object)this.getView().getPageCache().get("orgOld"));
                break;
            }
            case "chg_org": {
                if (event.getResult().getValue() == MessageBoxResult.Yes.getValue()) {
                    this.getView().getPageCache().put(MASTER_ORG, String.valueOf(this.getModel().getDataEntity().getLong("org.id")));
                    AdminOrgFastChgHelper.cleanOrgBaseInfo((long)this.getModel().getDataEntity().getLong("org.id"), (IFormView)this.getView());
                    break;
                }
                Long masterOrgId = Long.valueOf(this.getPageCache().get(MASTER_ORG));
                this.getModel().setValue("org", (Object)(masterOrgId.equals(0L) ? null : masterOrgId));
                break;
            }
            case "save_confirm": {
                if (event.getResult().getValue() == MessageBoxResult.Cancel.getValue() || event.getResult().getValue() != MessageBoxResult.Yes.getValue()) break;
                AsyncEffectingReformHelper.yesConfirm((IFormView)this.getView());
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"new")) {
            this.getModel().setDataChanged(false);
        }
    }

    private void setOrgtypeInfo(Long orgType) {
        AdminOrgFastChgHelper.getAnchorItemsByBillType((Long)orgType, (IFormView)this.getView());
        this.getModel().setValue("companytype", null);
        this.getModel().setValue("industrytype", null);
        this.getModel().setValue("groupvision", null);
        this.getModel().setValue("groupleader", null);
        this.getModel().setValue("departmenttype", null);
    }

    private void setOrgInfoToPage(Long orgId) {
        this.getPageCache().put("isChangeOrgType", "false");
        this.getPageCache().put("isChangeOrg", "false");
        this.getModel().deleteEntryData("cooprelentryentity");
        DynamicObject orgMasterInfo = AdminOrgFastChgHelper.getOrgDyById((Long)orgId);
        DynamicObject orgType = orgMasterInfo.getDynamicObject("adminorgtype");
        Long adminorgtypestd = orgType.getLong("adminorgtypestd.id");
        long orgBoId = orgMasterInfo.getLong("boid");
        DynamicObject orgDeptInfo = AdminOrgFastChgHelper.getDepartment((Long)orgBoId);
        DynamicObject orgCompanyInfo = AdminOrgFastChgHelper.getCompany((Long)orgBoId);
        DynamicObject orgGroupInfo = AdminOrgFastChgHelper.getGroup((Long)orgBoId);
        DynamicObject[] orgCoopInfoArr = AdminOrgBatchChgHelper.getOldOrgCoopArr((Long)orgMasterInfo.getLong("boid"));
        this.setCoopInfo(orgCoopInfoArr);
        this.getModel().setValue("adminorg", (Object)orgId);
        this.getModel().setValue("org", orgMasterInfo.get("org"));
        this.getModel().setValue("adminorgtype", (Object)orgMasterInfo.getLong("adminorgtype.id"));
        this.getModel().setValue("parentorgold", (Object)orgMasterInfo.getLong("parentorg.id"));
        String orgLongName = OrgBatchBillHelper.getOrgLongName((Long)orgMasterInfo.getLong("parentorg.id"), (Date)new Date(), null);
        this.getModel().setValue("parentorg_nameold", (Object)orgLongName);
        this.getModel().setValue("name", orgMasterInfo.get("name"));
        this.getModel().setValue("nameold", orgMasterInfo.get("name"));
        this.getModel().setValue("simplename", orgMasterInfo.get("simplename"));
        this.getModel().setValue("number", orgMasterInfo.get("number"));
        this.getModel().setValue("tobedisableflag", orgMasterInfo.get("tobedisableflag"));
        this.getModel().setValue("tobedisabledate", orgMasterInfo.get("tobedisabledate"));
        this.getModel().setValue("establishmentdate", orgMasterInfo.get("establishmentdate"));
        this.getModel().setValue("corporateorg", orgMasterInfo.get("corporateorg"));
        this.getModel().setValue("adminorglayer", orgMasterInfo.get("adminorglayer"));
        this.getModel().setValue("adminorgfunction", orgMasterInfo.get("adminorgfunction"));
        this.getModel().setValue("belongcompany", orgMasterInfo.get("belongcompany"));
        this.getModel().setValue("companyarea", orgMasterInfo.get("companyarea"));
        this.getModel().setValue("city", orgMasterInfo.get("city"));
        this.getModel().setValue("detailaddress", orgMasterInfo.get("detailaddress"));
        this.getModel().setValue("workplace", orgMasterInfo.get("workplace"));
        this.getModel().setValue("index", (Object)this.getOrgIndex(orgMasterInfo.getInt("index"), orgMasterInfo));
        this.getModel().setValue("description", orgMasterInfo.get("description"));
        if (orgCompanyInfo != null) {
            this.getModel().setValue("companytype", orgCompanyInfo.get("companytype"));
            this.getModel().setValue("industrytype", orgCompanyInfo.get("industrytype"));
        }
        if (orgGroupInfo != null) {
            this.getModel().setValue("groupvision", orgGroupInfo.get("groupvision"));
            this.getModel().setValue("groupleader", orgGroupInfo.get("groupleader"));
        }
        if (orgDeptInfo != null) {
            this.getModel().setValue("departmenttype", orgDeptInfo.get("departmenttype"));
        }
        this.getModel().setValue("positioning", orgMasterInfo.get("positioning"));
        this.getModel().setValue("mainduty", orgMasterInfo.get("mainduty"));
        this.getModel().setValue("safelevel", orgMasterInfo.get("safelevel"));
        this.getModel().setValue("safetype", orgMasterInfo.get("safetype"));
        this.getModel().setValue("safedescription", orgMasterInfo.get("safedescription"));
        MainEntityType dataEntityType = this.getModel().getDataEntityType();
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        Map allFields = ((MainEntityType)orgMasterInfo.getDataEntityType()).getAllFields();
        for (IDataEntityProperty property : properties) {
            if (!PatternUtil.isExProperty((String)property.getName()) || !allFields.containsKey(property.getName())) continue;
            this.getModel().setValue(property.getName(), orgMasterInfo.get(property.getName()));
        }
        AdminOrgFastChgHelper.getAnchorItemsByBillType((Long)adminorgtypestd, (IFormView)this.getView());
    }

    private int getOrgIndex(Integer index, DynamicObject orgMasterInfo) {
        if (index == null || index < 1 || index > 99999) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
            QFilter qFilter = new QFilter("parentorg", "=", (Object)orgMasterInfo.getLong("parentorg.id")).and("id", "!=", (Object)orgMasterInfo.getLong("id")).and("iscurrentversion", "=", (Object)"1");
            DynamicObjectCollection dynamicObjects = serviceHelper.queryOriginalCollection("id,parentorg.id,index", qFilter.toArray());
            index = 1;
            if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
                for (DynamicObject dy : dynamicObjects) {
                    if (dy.getInt("index") < index || index >= 100000) continue;
                    index = dy.getInt("index") + 1;
                }
            }
        }
        return index;
    }

    private void setCoopInfo(DynamicObject[] orgCoopInfoArr) {
        if (orgCoopInfoArr.length > 0) {
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("coopreltyp", new Object[0]);
            vs.addField("cooporgteam", new Object[0]);
            vs.addField("cooprelid", new Object[0]);
            for (DynamicObject coop : orgCoopInfoArr) {
                if (coop.getLong("coopreltype.id") == 1010L) continue;
                vs.addRow(new Object[]{coop.getDynamicObject("coopreltype") != null ? Long.valueOf(coop.getLong("coopreltype.id")) : null, coop.getDynamicObject("cooporgteam") != null ? Long.valueOf(coop.getLong("cooporgteam.id")) : null, coop.get("id")});
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            model.batchCreateNewEntryRow("cooprelentryentity", vs);
            model.endInit();
            this.getView().updateView("cooprelentryentity");
        }
        this.getModel().setDataChanged(false);
    }
}

