/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.adminorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.portal.pluginnew.GridCardPlugin;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.haos.business.util.HAOSPermUtils;
import kd.hr.haos.business.util.OrgPermHelper;
import kd.hr.haos.common.constants.masterdata.AdminOrgConstants;
import kd.hr.haos.common.constants.structproject.StructProjectConstants;
import kd.hr.haos.common.util.PlatformRootUtils;
import kd.hr.hbp.business.servicehelper.AppIdServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.formplugin.web.util.perm.HRPermUtil;

public class AdminorgFastHomePagePlugin
extends GridCardPlugin
implements ClickListener {
    private static final Log logger = LogFactory.getLog(AdminorgFastHomePagePlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"vectorap_update", "select_number", "select_name"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.updateSelectOrgNumber();
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Button) {
            Button button = (Button)evt.getSource();
            String buttonType = button.getKey();
            if (buttonType.equals("vectorap_update")) {
                this.updateSelectOrgNumber();
                return;
            }
            if (buttonType.equals("select_number") || buttonType.equals("select_name")) {
                this.openOrgListPage();
                return;
            }
        }
    }

    private void updateSelectOrgNumber() {
        Long userId = RequestContext.get().getCurrUserId();
        String permItemId = "47150e89000000ac";
        String appId = this.getAppIdWithDealThirdApp(this.getView().getFormShowParameter(), "haos_adminorgdetail");
        boolean entityPermission = PermissionServiceHelper.checkPermission((Long)userId, (String)appId, (String)"haos_adminorgdetail", (String)"47150e89000000ac");
        Integer orgNumber = 0;
        if (entityPermission) {
            String propKey = "boid";
            AuthorizedOrgResult permResult = (AuthorizedOrgResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getUserAdminOrgs", (Object[])new Object[]{userId, appId, "haos_adminorgdetail", permItemId, propKey, HAOSPermUtils.getStructProjectCustomInParam((String)propKey, (long)AdminOrgConstants.ADMINORG_STRUCT)});
            HasPermOrgResult hrPermOrg = OrgPermHelper.getHRPermOrg();
            orgNumber = this.getAllOrgNumber(permResult, hrPermOrg);
        }
        Label label = (Label)this.getView().getControl("select_number");
        label.setText(orgNumber.toString());
    }

    private int getAllOrgNumber(AuthorizedOrgResult permResult, HasPermOrgResult ODCOrgPermOrg) {
        HRBaseServiceHelper rootHeleper = new HRBaseServiceHelper("haos_adminorgstruct");
        QFilter rootQf = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1'));
        rootQf.and("adminorg", "=", (Object)PlatformRootUtils.getLongRootIdOfPlatform());
        rootQf.and((QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get());
        DynamicObject rootDy = rootHeleper.queryOne("structlongnumber", rootQf.toArray());
        if (rootDy == null) {
            return 0;
        }
        String longnumber = rootDy.getString("structlongnumber");
        Date dateParam = new Date();
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Arrays.asList("1", "2"));
        dataStatusFilter.and(new QFilter("initstatus", "=", (Object)Character.valueOf('2')));
        QFilter bsedFilter = new QFilter("bsed", "<=", (Object)dateParam);
        QFilter bsledFilter = new QFilter("bsled", ">=", (Object)dateParam);
        dataStatusFilter.and(new QFilter("iscurrentversion", "=", (Object)"0"));
        bsedFilter.and(bsledFilter).and(dataStatusFilter);
        QFilter structQf = new QFilter("structlongnumber", "like", (Object)("%" + longnumber + "%"));
        structQf.and((QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get());
        if (!permResult.isHasAllOrgPerm()) {
            QFilter orgDilter = new QFilter("adminorg", "in", (Object)permResult.getHasPermOrgs());
            structQf.and(bsedFilter).and(orgDilter);
        }
        if (!ODCOrgPermOrg.hasAllOrgPerm()) {
            QFilter odcOrgFilter = new QFilter("adminorg.org", "in", (Object)ODCOrgPermOrg.getHasPermOrgs());
            structQf.and(odcOrgFilter);
        }
        HRBaseServiceHelper structHelper = new HRBaseServiceHelper("haos_adminorgstruct");
        DynamicObject[] structArr = structHelper.queryOriginalArray("adminorg", structQf.toArray());
        ArrayList<Long> orgBoids = new ArrayList<Long>(structArr.length);
        for (DynamicObject dynamicObject : structArr) {
            orgBoids.add(dynamicObject.getLong("adminorg"));
        }
        QFilter orgQf = new QFilter("boid", "in", orgBoids);
        orgQf.and(bsedFilter).and("enable", "=", (Object)Character.valueOf('1'));
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        int orgNumber = hrBaseServiceHelper.count("haos_adminorgdetail", orgQf.toArray());
        return orgNumber;
    }

    private String getAppIdWithDealThirdApp(FormShowParameter showParameter, String entityNumber) {
        String entryAppId = HRPermUtil.getAppIdFromShowParam((FormShowParameter)showParameter);
        return AppIdServiceHelper.getPermAppId((String)entryAppId, (String)entityNumber);
    }

    private void openOrgListPage() {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setFormId("haos_adminorglist");
        listShowParameter.setBillFormId(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey());
        this.getView().showForm((FormShowParameter)listShowParameter);
    }
}

