/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.adminorg;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.haos.business.domain.repository.adorg.AdOrgTypeRepository;
import kd.hr.haos.business.servicehelper.OrgBatchBillHelper;
import kd.hr.haos.business.util.BaseDataHelper;
import kd.hr.haos.business.util.OrgPermHelper;
import kd.hr.haos.common.constants.structproject.StructProjectConstants;
import kd.hr.haos.common.util.HaosOrgUnitServiceHelper;
import kd.hr.haos.common.util.OrgDateTimeUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.helper.AdminOrgBatchChgHelper;
import kd.hr.homs.business.service.helper.AdminOrgFastChgHelper;
import kd.hr.homs.business.service.helper.SystemParamHelper;
import kd.hr.homs.business.service.repository.HOMSAdminOrgBillRepository;
import kd.hr.homs.business.service.repository.HOMSAdminOrgRepository;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;
import kd.hr.homs.common.constants.fastchg.OrgFastChgBillConstants;
import kd.hr.homs.formplugin.web.adminorg.AdminorgFastChgBillPlugin;

public class AdminorgReviseInfoPlugin
extends AbstractFormPlugin
implements ClickListener,
BeforeF7SelectListener {
    private static HRBaseServiceHelper ADMIN_ORG_TYPE = new HRBaseServiceHelper("haos_adminorgdetail");
    private static Log logger = LogFactory.getLog(AdminorgReviseInfoPlugin.class);
    private static final String TOBEDISABLEFLAG = "tobedisableflag";
    private static final String BSED = "bsed";
    private static final String TOBEDISABLEDATE = "tobedisabledate";
    private static final String DISABLEDATE = "disabledate";
    private static final String DEPARTMENT_TYPE = "departmenttype";
    private static final String STRUCT_LONG_NUMBER = "structlongnumber";
    private static final String STRUCT_NUMBER = "structnumber";
    private static final String ADMIN_ORG = "adminorg";
    private static final String DEPT_LONG_NAME = "deptlongname";
    private static final String CHG_ORG_TYPE = "chgOrgType";
    private static final String CHG_PARENT_ORG = "chgParentOrg";
    private static final String BEFORE_BIND_DATA = "beforeBindData";
    private static final String IS_FIRST_VERSION_NO_PARENT = "isfirstversionnoparent";
    private static final Set<String> BASE_ARR = Sets.newHashSet((Object[])new String[]{"changereason", "adminorgtype", "parentorg", "corporateorg", "belongcompany", "adminorgfunction", "adminorglayer", "companyarea", "workplace", "city", "companytype", "industrytype", "departmenttype", "safelevel", "safetype"});
    private boolean originalTobeDisableFlag;
    private Date originalTobeDisableDate;

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().getPageCache().put("initRevise", "0");
        DynamicObject dataEntity = this.getModel().getDataEntity();
        this.showStatusAndDate(dataEntity);
        this.originalTobeDisableFlag = dataEntity.getBoolean(TOBEDISABLEFLAG);
        this.originalTobeDisableDate = dataEntity.getDate(TOBEDISABLEDATE);
        this.getModel().setValue(DEPT_LONG_NAME, (Object)"-");
        DynamicObject belongCompany = ADMIN_ORG_TYPE.queryOne("id", this.buildHisFilter("boid", dataEntity.getLong("belongcompany.boid")));
        this.getModel().setValue("belongcompany", (Object)belongCompany);
        DynamicObject parentOrg = ADMIN_ORG_TYPE.queryOne("id", this.buildHisFilter("boid", dataEntity.getLong("parentorg.boid")));
        this.getModel().setValue("parentorg", (Object)parentOrg);
        Long adminOrgTypeId = (Long)this.getModel().getDataEntity().get("adminorgtype.adminorgtypestd.id");
        long boId = dataEntity.getLong("boid");
        if (Objects.nonNull(adminOrgTypeId)) {
            this.handleOrgType(boId, String.valueOf(adminOrgTypeId));
        }
        this.getView().getPageCache().put(BEFORE_BIND_DATA, "true");
        DynamicObject parentorg = dataEntity.getDynamicObject("parentorg");
        if (parentorg == null && dataEntity.getDate(BSED).equals(dataEntity.getDate("establishmentdate"))) {
            dataEntity.set(IS_FIRST_VERSION_NO_PARENT, (Object)"1");
        }
        this.setParamsEnable();
        this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
        AdminOrgFastChgHelper.setTips((String)"adminorgtype", (IFormView)this.getView(), (String)"homs_adminorgdetailrevise");
        AdminOrgFastChgHelper.setTips((String)"belongcompany", (IFormView)this.getView(), (String)"homs_adminorgdetailrevise");
        AdminOrgFastChgHelper.setTips((String)"establishmentdate", (IFormView)this.getView(), (String)"homs_adminorgdetailrevise");
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        if (boId == rootOrgId) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"parentorg"});
            dataEntity.set(IS_FIRST_VERSION_NO_PARENT, (Object)"1");
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView parentView = this.getView().getParentView();
        parentView.getPageCache().put("initRevise", "1");
        this.getView().getPageCache().put("initRevise", "1");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        for (String baseName : BASE_ARR) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(baseName);
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey;
        switch (fieldKey = beforeF7SelectEvent.getProperty().getName()) {
            case "changereason": {
                AdminOrgBatchChgHelper.setChangeReasonF7Filter((BeforeF7SelectEvent)beforeF7SelectEvent, (IDataModel)this.getModel(), (String)"", (Boolean)Boolean.FALSE);
                break;
            }
            case "city": {
                AdminOrgBatchChgHelper.setCityF7Filter((BeforeF7SelectEvent)beforeF7SelectEvent, (IDataModel)this.getModel(), (String)"companyarea");
                break;
            }
            case "parentorg": {
                this.setParentOrgFilter(beforeF7SelectEvent);
                break;
            }
            case "adminorgtype": {
                this.setAdminOrgTypeFilter(beforeF7SelectEvent);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Donothing donothing;
        String operateKey;
        if (args.getSource() instanceof Donothing && "save".equals(operateKey = (donothing = (Donothing)args.getSource()).getOperateKey())) {
            if ("1".equals(donothing.getView().getModel().getValue(IS_FIRST_VERSION_NO_PARENT))) {
                if (donothing.getView().getModel().getValue("parentorg") == null) {
                    DynamicObject dynamicObject = ADMIN_ORG_TYPE.generateEmptyDynamicObject();
                    dynamicObject.set("id", (Object)OrgUnitServiceHelper.getRootOrgId());
                    donothing.getView().getModel().setValue("parentorg", (Object)dynamicObject);
                } else {
                    donothing.getView().getModel().setValue(IS_FIRST_VERSION_NO_PARENT, (Object)"0");
                }
            }
            this.getView().getParentView().getPageCache().put("name", this.getModel().getDataEntity().getString("name"));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        Donothing donothing;
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("save".equals(operateKey) && afterDoOperationEventArgs.getSource() instanceof Donothing && "1".equals((donothing = (Donothing)afterDoOperationEventArgs.getSource()).getView().getModel().getValue(IS_FIRST_VERSION_NO_PARENT))) {
            donothing.getView().getModel().setValue("parentorg", null);
        }
    }

    private void setAdminOrgTypeFilter(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObject parentOrg = this.getModel().getDataEntity().getDynamicObject("parentorg");
        if (Objects.nonNull(parentOrg) && Objects.nonNull(parentOrg.getDynamicObject("adminorgtype"))) {
            String number = parentOrg.getDynamicObject("adminorgtype").getString("number");
            DynamicObject adminOrgTypeObject = AdOrgTypeRepository.getInstance().query("adminorgtypestd", new QFilter[]{new QFilter("number", "=", (Object)number)});
            if (adminOrgTypeObject != null) {
                long adminOrgStdId = adminOrgTypeObject.getLong("adminorgtypestd.id");
                beforeF7SelectEvent.addCustomQFilter(new QFilter("adminorgtypestd", "in", AdminorgFastChgBillPlugin.ADMIN_ORG_TYPE_MAP.get(adminOrgStdId)));
            }
        }
    }

    private void setParentOrgFilter(BeforeF7SelectEvent beforeF7SelectEvent) {
        HasPermOrgResult hrPermOrg;
        if (this.getModel().getDataEntity().get("adminorgtype") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u3002", (String)"AdminorgFastChgPlugin_2", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(Boolean.TRUE.booleanValue());
        }
        AdminOrgFastChgHelper.setParentFilter((DynamicObject)this.getModel().getDataEntity(), (BeforeF7SelectEvent)beforeF7SelectEvent, (Date)this.getSearchDate(), (IFormView)this.getView());
        Long orgBoId = this.getModel().getDataEntity().getLong("boid");
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        beforeF7SelectEvent.getCustomQFilters().add(statusFilter);
        beforeF7SelectEvent.getCustomQFilters().add(dataStatusFilter);
        beforeF7SelectEvent.getFormShowParameter().setCustomParam("searchdate", (Object)this.getSearchDate());
        List orgIds = AdminOrgFastChgHelper.getOrgAndChildren((Long)orgBoId);
        if (!CollectionUtils.isEmpty((Collection)orgIds)) {
            beforeF7SelectEvent.getCustomQFilters().add(new QFilter("boid", "not in", (Object)orgIds));
        }
        if (!(hrPermOrg = OrgPermHelper.getHRPermOrg()).hasAllOrgPerm() && !CollectionUtils.isEmpty((Collection)hrPermOrg.getHasPermOrgs())) {
            QFilter baseDataFilter = BaseDataHelper.getAdminOrgBaseDataFilter((String)"haos_adminorgdetail", (List)hrPermOrg.getHasPermOrgs());
            beforeF7SelectEvent.getCustomQFilters().add(baseDataFilter);
        }
        beforeF7SelectEvent.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7", (String)"AdminorgFastChgPlugin_7", (String)"odc-homs-formplugin", (Object[])new Object[0]));
    }

    private void orgTypeChgCallBack(PropertyChangedArgs changedArgs) {
        DynamicObject newOrgTypeDy = (DynamicObject)changedArgs.getChangeSet()[0].getNewValue();
        if (newOrgTypeDy == null || newOrgTypeDy.getLong("id") == 0L) {
            return;
        }
        DynamicObject oldOrgTypeDy = (DynamicObject)changedArgs.getChangeSet()[0].getOldValue();
        long oldOrgTypeId = oldOrgTypeDy == null ? 0L : oldOrgTypeDy.getLong("id");
        Long typeStd = oldOrgTypeDy != null ? oldOrgTypeDy.getLong("adminorgtypestd.id") : 0L;
        if (!typeStd.equals(newOrgTypeDy.getLong("adminorgtypestd.id"))) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(CHG_ORG_TYPE, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u540e\uff0c\u53ef\u80fd\u4f1a\u5bfc\u81f4\u672c\u7ec4\u7ec7\u53ca\u5176\u4e0b\u7ea7\u7ec4\u7ec7\u7684\u6240\u5c5e\u516c\u53f8\u53d1\u751f\u53d8\u5316\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AdminorgFastChgPlugin_1", (String)"odc-homs-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBackListener, null, String.valueOf(oldOrgTypeId));
        }
    }

    private void parentOrgChgdCallBack(PropertyChangedArgs changedArgs) {
        HRBaseServiceHelper orgBoIdHepler = new HRBaseServiceHelper("haos_adminorgdetail");
        DynamicObject newParentDy = (DynamicObject)changedArgs.getChangeSet()[0].getNewValue();
        if (newParentDy == null || newParentDy.getLong("id") == 0L) {
            return;
        }
        Boolean isCurrentVersion = (Boolean)this.getView().getFormShowParameter().getCustomParam("isCurrentVersion");
        Long orgId = newParentDy.getLong("id");
        DynamicObject parentDy = orgBoIdHepler.queryOne("id,boid,tobedisableflag", (Object)orgId);
        if (HRStringUtils.equals((String)"1", (String)this.getView().getPageCache().get("initRevise"))) {
            DynamicObject currentVersionDy = HOMSAdminOrgRepository.getInstance().getOrgDyByBoId(Long.valueOf(parentDy.getLong("boid")));
            if (currentVersionDy != null && HRStringUtils.equals((String)currentVersionDy.getString("enable"), (String)"0")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u5df2\u505c\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AdminorgReviseInfoPlugin_0", (String)"odc-homs-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject billDy = HOMSAdminOrgBillRepository.getInstance().getOrgEnableBill(Long.valueOf(parentDy.getLong("boid")));
            if (billDy != null) {
                this.getView().showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u5728\u5728\u9014\u5355\u636e\uff08\u7f16\u53f7\uff1a%s\uff09\u4e2d\u505a\u4e86\u201c\u505c\u7528\u201d\u64cd\u4f5c\uff0c\u4e0d\u80fd\u8c03\u6574\u5230\u8be5\u7ec4\u7ec7\u4e0b\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminorgReviseInfoPlugin_3", (String)"odc-homs-formplugin", (Object[])new Object[0]), billDy.getString("billno")));
                this.getView().getModel().setValue("parentorg", null);
                return;
            }
            if (!SystemParamHelper.getAllowTobeDisableChg((Long)this.getModel().getDataEntity().getLong("org.id"))) {
                if (parentDy.getBoolean(TOBEDISABLEFLAG)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u5df2\u5f85\u505c\u7528\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminorgReviseInfoPlugin_2", (String)"odc-homs-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject tobeDisableFlagDy = HOMSAdminOrgBillRepository.getInstance().getOrgWillEnableBill(Long.valueOf(parentDy.getLong("boid")));
                if (Boolean.TRUE.equals(isCurrentVersion) && tobeDisableFlagDy != null && !HRStringUtils.isEmpty((String)tobeDisableFlagDy.getString("billno"))) {
                    this.getView().showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u5728\u5728\u9014\u5355\u636e\uff08\u7f16\u53f7\uff1a%s\uff09\u4e2d\u505a\u4e86\u201c\u5f85\u505c\u7528\u201d\u64cd\u4f5c\uff0c\u4e0d\u80fd\u8c03\u6574\u5230\u8be5\u7ec4\u7ec7\u4e0b\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminorgReviseInfoPlugin_1", (String)"odc-homs-formplugin", (Object[])new Object[0]), tobeDisableFlagDy.getString("billno")));
                    return;
                }
            }
        }
        this.propChgForParentOrg(newParentDy);
        this.setBelongCompany();
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String actionId = event.getCallBackId();
        if (actionId.equals(CHG_ORG_TYPE)) {
            if (event.getResult() == MessageBoxResult.Yes) {
                this.setOrgTypeInfo(this.getModel().getDataEntity().getDynamicObject("adminorgtype").getLong("adminorgtypestd.id"));
                this.setBelongCompany();
            } else {
                DynamicObject dynamicObject = this.getModel().getDataEntity();
                HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_adminorgtype");
                DynamicObject orgType = helper.queryOne(new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(event.getCustomVaule()))});
                dynamicObject.set("adminorgtype", orgType != null ? orgType : Long.valueOf(0L));
                this.getView().updateView("adminorgtype");
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs changedArgs) {
        String fieldKey = changedArgs.getProperty().getName();
        DynamicObject workplace = this.getModel().getDataEntity().getDynamicObject("workplace");
        switch (fieldKey) {
            case "companyarea": {
                AdminOrgBatchChgHelper.propChgForCountryArea((PropertyChangedArgs)changedArgs, (IDataModel)this.getModel(), (DynamicObject)workplace, (String)"");
                break;
            }
            case "city": {
                AdminOrgBatchChgHelper.propChgForCity((PropertyChangedArgs)changedArgs, (IDataModel)this.getModel(), (DynamicObject)workplace, (String)"");
                break;
            }
            case "parentorg": {
                this.parentOrgChgdCallBack(changedArgs);
                break;
            }
            case "changescene": {
                Set changeReasonSet = ((DynamicObject)changedArgs.getChangeSet()[0].getNewValue()).getDynamicObjectCollection("changereason").stream().map(dyn -> dyn.getLong("fbasedataid.id")).collect(Collectors.toSet());
                HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_orgchangereason");
                DynamicObject[] dynamicObjects = helper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", changeReasonSet), BaseDataHelper.getBaseDataFilter((String)"haos_orgchangereason", (long)((DynamicObject)this.getModel().getValue("org")).getLong("id")), new QFilter("enable", "=", (Object)"1")});
                if (dynamicObjects.length == 1) {
                    this.getModel().setValue("changereason", (Object)dynamicObjects[0]);
                    break;
                }
                this.getModel().setValue("changereason", null);
                break;
            }
            case "adminorgtype": {
                this.orgTypeChgCallBack(changedArgs);
                break;
            }
            case "tobedisableflag": {
                if (((Boolean)changedArgs.getChangeSet()[0].getNewValue()).booleanValue() && !this.originalTobeDisableFlag) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{TOBEDISABLEDATE});
                    if (!this.originalTobeDisableFlag) {
                        Date tobeDisabledDate = this.getTobeDisabledDate();
                        this.getModel().setValue(TOBEDISABLEDATE, (Object)tobeDisabledDate);
                        break;
                    }
                    this.getModel().setValue(TOBEDISABLEDATE, (Object)this.originalTobeDisableDate);
                    break;
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{TOBEDISABLEDATE});
                if (this.originalTobeDisableFlag) {
                    this.getModel().setValue(TOBEDISABLEDATE, null);
                    break;
                }
                this.getModel().setValue(TOBEDISABLEDATE, (Object)this.originalTobeDisableDate);
            }
        }
    }

    private Date getTobeDisabledDate() {
        Object boId = this.getModel().getValue("boid");
        if (boId == null) {
            return null;
        }
        DynamicObject[] allHisAdminOrg = AdOrgRepository.getInstance().load(new QFilter("boid", "=", boId));
        Arrays.sort(allHisAdminOrg, Comparator.comparing(dyn -> dyn.getDate(BSED)));
        int index = -1;
        for (int i = allHisAdminOrg.length - 1; i >= 0; --i) {
            if (allHisAdminOrg[i].getBoolean(TOBEDISABLEFLAG)) {
                index = i;
                continue;
            }
            if (!allHisAdminOrg[i].getBoolean(TOBEDISABLEFLAG) && i != allHisAdminOrg.length - 1) break;
        }
        Date tobeDisabledDate = null;
        if (index >= 0 && index < allHisAdminOrg.length) {
            tobeDisabledDate = allHisAdminOrg[index].getDate(TOBEDISABLEDATE);
        } else if (this.getModel().getValue(BSED) instanceof Date) {
            tobeDisabledDate = (Date)this.getModel().getValue(BSED);
        }
        return tobeDisabledDate;
    }

    private void setOrgTypeInfo(Long orgType) {
        this.setOrgInfoViewByType(orgType);
        this.getModel().setValue("companytype", null);
        this.getModel().setValue("industrytype", null);
        this.getModel().setValue("groupvision", null);
        this.getModel().setValue("groupmission", null);
        this.getModel().setValue(DEPARTMENT_TYPE, null);
    }

    private QFilter buildHisFilter(String property, Object ... id) {
        Date searchDate = this.getSearchDate();
        QFilter filter = new QFilter(property, "in", (Object)id);
        if (searchDate == null) {
            filter.and(new QFilter("iscurrentversion", "in", (Object)"1"));
        } else {
            filter.and(new QFilter(BSED, "<=", (Object)searchDate).and(new QFilter("bsled", ">=", (Object)searchDate)));
            QFilter statusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "2"}).and("iscurrentversion", "=", (Object)"0");
            filter.and(statusFilter);
        }
        return filter;
    }

    private Date getSearchDate() {
        DynamicObject orgDy = HOMSAdminOrgRepository.getInstance().getOrgDyByBoId(Long.valueOf(this.getModel().getDataEntity().getLong("boid")));
        Long orgId = this.getModel().getDataEntity().getLong("id");
        if (orgId.equals(orgDy.getLong("sourcevid"))) {
            return OrgDateTimeUtil.getStartOfDay((Date)new Date());
        }
        return this.getModel().getDataEntity().getDate(BSED);
    }

    private void handleOrgType(Long boId, String orgTypeId) {
        QFilter buildDateFilter = this.buildHisFilter(ADMIN_ORG, boId);
        HRBaseServiceHelper companyHelper = new HRBaseServiceHelper("haos_adminorgcompany");
        DynamicObject companyObject = companyHelper.queryOriginalOne("companytype,industrytype,bsed", new QFilter[]{buildDateFilter});
        switch (orgTypeId) {
            case "1010": {
                this.groupSetting(buildDateFilter, companyObject);
                break;
            }
            case "1020": {
                this.companySetting(companyObject);
                break;
            }
            case "1030": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"companyinfoflex", "groupinfoflex", "deptinfoflex"});
                break;
            }
            case "1040": {
                this.departmentSetting(boId, buildDateFilter);
                break;
            }
        }
    }

    private void companySetting(DynamicObject companyObject) {
        if (companyObject != null) {
            this.getModel().setValue("companytype", companyObject.get("companytype"));
            this.getModel().setValue("industrytype", companyObject.get("industrytype"));
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"groupinfoflex", "deptinfoflex"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"companyinfoflex"});
    }

    private void departmentSetting(Long boId, QFilter buildDateFilter) {
        HRBaseServiceHelper deptHelper = new HRBaseServiceHelper("haos_adminorgdepartment");
        DynamicObject deptObject = deptHelper.queryOriginalOne("departmenttype,bsed", new QFilter[]{buildDateFilter});
        if (deptObject != null) {
            this.getModel().setValue(DEPARTMENT_TYPE, deptObject.get(DEPARTMENT_TYPE));
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"companyinfoflex", "groupinfoflex"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"deptinfoflex"});
        this.setDeptLongName(boId);
    }

    private void groupSetting(QFilter buildDateFilter, DynamicObject companyObject) {
        HRBaseServiceHelper groupHelper = new HRBaseServiceHelper("haos_adminorggroup");
        DynamicObject groupObject = groupHelper.queryOne("groupvision,groupmission,bsed", new QFilter[]{buildDateFilter});
        if (groupObject != null) {
            this.getModel().setValue("groupvision", groupObject.get("groupvision"));
            this.getModel().setValue("groupmission", groupObject.get("groupmission"));
        }
        if (companyObject != null) {
            this.getModel().setValue("companytype", companyObject.get("companytype"));
            this.getModel().setValue("industrytype", companyObject.get("industrytype"));
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"deptinfoflex"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"groupinfoflex", "companyinfoflex"});
    }

    private void setDeptLongName(Long boId) {
        String structNumber;
        String name;
        HRBaseServiceHelper adminstruct = new HRBaseServiceHelper("haos_adminorgstruct");
        DynamicObject[] query = adminstruct.query(STRUCT_LONG_NUMBER, new QFilter[]{this.buildHisFilter(ADMIN_ORG, boId), (QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get()});
        if (query == null || query.length == 0) {
            return;
        }
        String structlongnumber = query[0].getString(STRUCT_LONG_NUMBER);
        Object[] structNumbers = structlongnumber.split("!");
        DynamicObject[] adminorgtypestds = ADMIN_ORG_TYPE.query("id,structnumber,name", new QFilter[]{new QFilter("adminorgtype.adminorgtypestd.id", "=", (Object)1040L), this.buildHisFilter(STRUCT_NUMBER, structNumbers)});
        Map<String, String> structNumberMap = Arrays.stream(adminorgtypestds).collect(Collectors.toMap(dy -> dy.getString(STRUCT_NUMBER), dy -> dy.getString("name")));
        List reverseStructLongNumbers = Lists.reverse(Arrays.asList(structNumbers));
        ArrayList<String> deptName = new ArrayList<String>(16);
        Iterator iterator = reverseStructLongNumbers.iterator();
        while (iterator.hasNext() && !HRStringUtils.isEmpty((String)(name = structNumberMap.get(structNumber = (String)iterator.next())))) {
            deptName.add(name);
        }
        if (deptName.size() == 0) {
            logger.info(String.format("==setDeptLongName,reverseStructLongNumbers:%s", reverseStructLongNumbers));
            return;
        }
        String deptLongName = String.join((CharSequence)HaosOrgUnitServiceHelper.getFullNameSep(), Lists.reverse(deptName));
        this.getModel().setValue(DEPT_LONG_NAME, (Object)deptLongName);
    }

    private void showStatusAndDate(DynamicObject dataEntity) {
        Object tobedisableflag = dataEntity.get(TOBEDISABLEFLAG);
        boolean flag = tobedisableflag == null ? Boolean.FALSE : (Boolean)tobedisableflag;
        String enable = dataEntity.getString("enable");
        this.getView().setVisible(Boolean.FALSE, new String[]{BSED, TOBEDISABLEDATE, DISABLEDATE, TOBEDISABLEFLAG});
        this.getView().setVisible(Boolean.TRUE, new String[]{"enable"});
        if (enable.equals("0")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{DISABLEDATE});
        } else if (flag) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"enable"});
            this.getView().setVisible(Boolean.TRUE, new String[]{TOBEDISABLEDATE, TOBEDISABLEFLAG});
        }
    }

    private void setParamsEnable() {
        if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.EDIT)) {
            DynamicObject[] orgInfoDys;
            Long orgBoId = this.getModel().getDataEntity().getLong("boid");
            Long orgId = this.getModel().getDataEntity().getLong("id");
            if (orgId.equals((orgInfoDys = HOMSAdminOrgRepository.getInstance().getDynamicObjectArrOrderDesc(orgBoId, ""))[orgInfoDys.length - 1].getLong("id"))) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"establishmentdate"});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"establishmentdate"});
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{"index"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"index"});
            Boolean isCurrentVersion = (Boolean)this.getView().getFormShowParameter().getCustomParam("isCurrentVersion");
            if (isCurrentVersion.booleanValue()) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"statusinfoflex"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"enable"});
                this.getView().setVisible(Boolean.TRUE, new String[]{TOBEDISABLEFLAG});
                if (HRStringUtils.equals((String)this.getModel().getDataEntity().getString(TOBEDISABLEFLAG), (String)"1")) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{TOBEDISABLEDATE});
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"statusinfoflex"});
            }
            this.getModel().setValue("changetype", (Object)OrgBatchChgBillConstants.CHANGE_TYPE_REVISE);
            this.getModel().setValue("changescene", (Object)OrgBatchChgBillConstants.CHANGE_SCENE_REVISE);
            this.getView().setVisible(Boolean.TRUE, new String[]{"parentorg_name"});
            this.getView().setVisible(Boolean.FALSE, new String[]{DEPT_LONG_NAME});
            if (this.getModel().getDataEntity().getDynamicObject("parentorg") != null) {
                Long parentOrgId = this.getModel().getDataEntity().getDynamicObject("parentorg").getLong("id");
                Date modifyTime = this.getModel().getDataEntity().getDate("bsled");
                String orgLongName = OrgBatchBillHelper.getOrgLongName((Long)parentOrgId, (Date)modifyTime, (String)String.valueOf(1010L));
                this.getModel().setValue("parentorg_name", (Object)orgLongName);
            }
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"statusinfoflex", "index"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"parentorg_name"});
            this.getView().setVisible(Boolean.TRUE, new String[]{DEPT_LONG_NAME});
        }
        Long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        Long boid = this.getModel().getDataEntity().getLong("boid");
        if (rootOrgId.equals(boid)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{TOBEDISABLEFLAG});
        }
    }

    private void propChgForParentOrg(DynamicObject newValue) {
        if (newValue == null) {
            this.getModel().setValue("parentorg_name", null);
            return;
        }
        Long adminOrgId = newValue.getLong("id");
        Date modifyTime = this.getModel().getDataEntity().getDate("modifytime");
        String orgLongName = OrgBatchBillHelper.getOrgLongName((Long)adminOrgId, (Date)modifyTime, null);
        this.getModel().setValue("parentorg_name", (Object)orgLongName);
    }

    private void setBelongCompany() {
        DynamicObject orgTypeDy = this.getModel().getDataEntity().getDynamicObject("adminorgtype");
        DynamicObject parentDy = this.getModel().getDataEntity().getDynamicObject("parentorg");
        if (orgTypeDy != null) {
            DynamicObject parentBelongCompany;
            Long typestd = orgTypeDy.getLong("adminorgtypestd.id");
            if (OrgFastChgBillConstants.ID_ORGTYPE_GROUP.equals(typestd) || OrgFastChgBillConstants.ID_ORGTYPE_COMPANY.equals(typestd)) {
                this.getModel().setValue("belongcompany", (Object)this.getModel().getDataEntity().getLong("id"));
            } else if ((OrgFastChgBillConstants.ID_ORGTYPE_REGION.equals(typestd) || OrgFastChgBillConstants.ID_ORGTYPE_DEPARTMENT.equals(typestd)) && parentDy != null && (parentBelongCompany = parentDy.getDynamicObject("belongcompany")) != null) {
                Date searchDate = this.getSearchDate();
                DynamicObject hisBelongCompany = HOMSAdminOrgRepository.getInstance().getDynamicObjecByBoIdAndBsed(Long.valueOf(parentBelongCompany.getLong("id")), searchDate, searchDate);
                this.getModel().setValue("belongcompany", (Object)hisBelongCompany);
            }
        }
    }

    private void setOrgInfoViewByType(Long adminOrgTypeId) {
        this.getView().setVisible(Boolean.TRUE, new String[]{"groupinfoflex", "companyinfoflex", "deptinfoflex"});
        if (adminOrgTypeId.equals(OrgFastChgBillConstants.ID_ORGTYPE_GROUP)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"deptinfoflex"});
        } else if (adminOrgTypeId.equals(OrgFastChgBillConstants.ID_ORGTYPE_COMPANY)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"deptinfoflex", "groupinfoflex"});
        } else if (adminOrgTypeId.equals(OrgFastChgBillConstants.ID_ORGTYPE_REGION)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"deptinfoflex", "groupinfoflex", "companyinfoflex"});
        } else if (adminOrgTypeId.equals(OrgFastChgBillConstants.ID_ORGTYPE_DEPARTMENT)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"groupinfoflex", "companyinfoflex"});
        }
    }
}

