/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.adminorg;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.haos.business.util.TabOperateUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.domain.service.orgfast.AdminOrgReviseService;
import kd.hr.homs.business.service.helper.AdminOrgFastChgHelper;
import kd.hr.homs.business.service.repository.HOMSAdminOrgRepository;
import kd.hr.homs.common.model.OrgReviseRequest;
import kd.hr.homs.common.model.ReviseOrgInfoDto;

public class AdminorgRevisePlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String SAVE_OP = "save";
    private static final String CANCEL_OP = "cancel";
    private static final String REVISE_OP = "revise";
    private static final String REVISE_RECORD_OP = "reviserecord";
    private static final String REFRESH_OP = "refresh";
    private static final String CUSTOM_CONTROL_AP = "customcontrolap";
    private static final String ORG_BO_ID = "orgBoId";
    private static final String ORG_ID = "orgId";
    private static final String BSED = "bsed";
    private static final String SELECT_ORG = "selectOrg";
    private static final String CLOSE = "close";
    private static final String EXT_PARAMS = "extParams";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        long userId = RequestContext.get().getCurrUserId();
        String appId = this.getView().getFormShowParameter().getAppId();
        boolean hasSelectPermission = PermissionServiceHelper.checkPermission((Long)userId, (String)appId, (String)"homs_adminorgdetailrevise", (String)"47150e89000000ac");
        if (!hasSelectPermission) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5386\u53f2\u8bb0\u5f55\u67e5\u770b\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AdminorgRevisePlugin_3", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap2", "left_flex"});
            return;
        }
        this.setDataToPage("init");
    }

    private void setDataToPage(String eventName) {
        String orgBoIdStr = (String)this.getView().getFormShowParameter().getCustomParam(ORG_BO_ID);
        this.getView().setVisible(Boolean.FALSE, new String[]{CANCEL_OP, SAVE_OP});
        Long orgBoId = Long.valueOf(orgBoIdStr);
        AdminOrgReviseService adminOrgReviseService = new AdminOrgReviseService();
        DynamicObject[] orgInfoDys = adminOrgReviseService.getHisVersions(orgBoId);
        Long orgId = orgInfoDys[0].getLong("id");
        Long versionId = (Long)this.getView().getFormShowParameter().getCustomParam("versionId");
        if (versionId != null && versionId != 0L) {
            orgId = versionId;
        }
        this.setReviseButtonStatus(Long.valueOf(orgBoIdStr), orgId, Boolean.FALSE);
        if (HRStringUtils.equals((String)eventName, (String)"update") && HRStringUtils.equals((String)this.getView().getPageCache().get("initRevise"), (String)"1")) {
            IFormView infoView = this.getInfoView();
            this.selectOrgToRevisePage(infoView, orgId);
        } else {
            this.openAdminorgDetailRevise(orgId, orgBoId, OperationStatus.VIEW);
        }
        adminOrgReviseService.customControlData(orgInfoDys, String.valueOf(orgId), this.getView(), eventName, eventName);
        this.getView().getPageCache().put(ORG_ID, String.valueOf(orgId));
    }

    private IFormView getInfoView() {
        String pageId = "homs_adminorgdetailrevise_" + this.getView().getPageId();
        IFormView infoView = this.getView().getView(pageId);
        return infoView;
    }

    public void customEvent(CustomEventArgs evt) {
        String key = evt.getKey();
        if (!HRStringUtils.equals((String)key, (String)CUSTOM_CONTROL_AP)) {
            return;
        }
        OrgReviseRequest orgReviseRequest = (OrgReviseRequest)JSONObject.parseObject((String)evt.getEventArgs(), OrgReviseRequest.class);
        ReviseOrgInfoDto reviseOrgInfoDto = orgReviseRequest.getEventArgs();
        if (HRStringUtils.isEmpty((String)reviseOrgInfoDto.getOrgId())) {
            return;
        }
        Long orgId = Long.valueOf(reviseOrgInfoDto.getOrgId());
        if (HRStringUtils.equals((String)this.getView().getPageCache().get("initRevise"), (String)"1")) {
            IFormView infoView = this.getInfoView();
            long userId = RequestContext.get().getCurrUserId();
            String appId = this.getView().getFormShowParameter().getAppId();
            boolean hasSelectPermission = PermissionServiceHelper.checkPermission((Long)userId, (String)appId, (String)"homs_adminorgdetailrevise", (String)"47150e89000000ac");
            if (!hasSelectPermission) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5386\u53f2\u8bb0\u5f55\u67e5\u770b\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AdminorgRevisePlugin_3", (String)"odc-homs-formplugin", (Object[])new Object[0]));
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap2", "left_flex"});
                return;
            }
            this.getView().getPageCache().put(SELECT_ORG, String.valueOf(orgId));
            if (this.closeConfirm(infoView, SELECT_ORG)) {
                this.selectOrgToRevisePage(infoView, orgId);
                this.getView().getPageCache().put(ORG_ID, String.valueOf(orgId));
            }
        }
    }

    private void changeSelect(Boolean changeselect) {
        CustomControl customcontrol = (CustomControl)this.getView().getControl(CUSTOM_CONTROL_AP);
        HashMap resultMap = Maps.newHashMap();
        HashMap dataMap = Maps.newHashMap();
        dataMap.put("changeselect", changeselect);
        resultMap.put("data", dataMap);
        resultMap.put("code", "200");
        resultMap.put("errorMessage", "");
        resultMap.put("eventName", "select");
        resultMap.put("eventStatus", "update");
        resultMap.put("time", System.currentTimeMillis());
        customcontrol.setData((Object)resultMap);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        long userId = RequestContext.get().getCurrUserId();
        String appId = this.getView().getFormShowParameter().getAppId();
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        Long orgBoId = Long.valueOf((String)this.getView().getFormShowParameter().getCustomParam(ORG_BO_ID));
        QFilter authQf = new QFilter("id", "in", (Object)new Long[]{orgBoId});
        if (HRStringUtils.equals((String)operateKey, (String)REVISE_OP) || HRStringUtils.equals((String)operateKey, (String)SAVE_OP)) {
            String dataStatus;
            DynamicObject hisAdminFromDb;
            boolean hasRevisePermission = PermissionServiceHelper.checkPermission((Long)userId, (String)appId, (String)"homs_adminorgdetailrevise", (String)"37LU0YWHT9+2");
            if (!hasRevisePermission) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5386\u53f2\u8bb0\u5f55\u67e5\u770b\u201d\u7684\u201c\u7ec4\u7ec7\u4fee\u8ba2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AdminorgRevisePlugin_2", (String)"odc-homs-formplugin", (Object[])new Object[0]));
                args.setCancel(Boolean.TRUE.booleanValue());
            } else {
                Map authMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSDataPermissionService", (String)"matchDataRule", (Object[])new Object[]{userId, appId, "homs_adminorgdetailrevise", "37LU0YWHT9+2", new QFilter[]{authQf}, new HashMap()});
                if (authMap.containsKey(orgBoId) && !((Boolean)authMap.get(orgBoId)).booleanValue()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5386\u53f2\u8bb0\u5f55\u67e5\u770b\u201d\u7684\u201c\u7ec4\u7ec7\u4fee\u8ba2\u201d\u6570\u636e\u89c4\u5219\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AdminorgRevisePlugin_4", (String)"odc-homs-formplugin", (Object[])new Object[0]));
                    args.setCancel(Boolean.TRUE.booleanValue());
                }
            }
            String currentVersionId = this.getView().getPageCache().get("currentVersionId");
            if (!HRStringUtils.isEmpty((String)currentVersionId) && (hisAdminFromDb = AdminOrgFastChgHelper.getOrgDyById((Long)Long.valueOf(currentVersionId))) != null && !"1".equals(dataStatus = hisAdminFromDb.getString("datastatus"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u88ab\u66f4\u6539\uff0c\u60a8\u9700\u8981\u91cd\u65b0\u5237\u65b0\uff0c\u57fa\u4e8e\u8be5\u7ec4\u7ec7\u7684\u6700\u65b0\u4fe1\u606f\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AdminorgRevisePlugin_8", (String)"odc-homs-formplugin", (Object[])new Object[]{hisAdminFromDb.getString("name")}));
                args.setCancel(Boolean.TRUE.booleanValue());
            }
        } else if (HRStringUtils.equals((String)operateKey, (String)REVISE_RECORD_OP)) {
            boolean hasSelectPermission = PermissionServiceHelper.checkPermission((Long)userId, (String)appId, (String)"homs_adminorgdetailrevise", (String)"37LU1RS4KXOK");
            if (!hasSelectPermission) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5386\u53f2\u8bb0\u5f55\u67e5\u770b\u201d\u7684\u201c\u67e5\u770b\u4fee\u8ba2\u65e5\u5fd7\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AdminorgRevisePlugin_6", (String)"odc-homs-formplugin", (Object[])new Object[0]));
                args.setCancel(Boolean.TRUE.booleanValue());
            } else {
                Map authMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSDataPermissionService", (String)"matchDataRule", (Object[])new Object[]{userId, appId, "homs_adminorgdetailrevise", "37LU1RS4KXOK", new QFilter[]{authQf}, new HashMap()});
                if (authMap.containsKey(orgBoId) && !((Boolean)authMap.get(orgBoId)).booleanValue()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5386\u53f2\u8bb0\u5f55\u67e5\u770b\u201d\u7684\u201c\u67e5\u770b\u4fee\u8ba2\u65e5\u5fd7\u201d\u6570\u636e\u89c4\u5219\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AdminorgRevisePlugin_7", (String)"odc-homs-formplugin", (Object[])new Object[0]));
                    args.setCancel(Boolean.TRUE.booleanValue());
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        String operateKey = eventArgs.getOperateKey();
        IFormView infoView = this.getInfoView();
        if (infoView == null || infoView.getFormShowParameter() == null) {
            if (HRStringUtils.equals((String)operateKey, (String)CLOSE)) {
                this.getView().close();
            }
            return;
        }
        BaseShowParameter baseShowParameter = (BaseShowParameter)infoView.getFormShowParameter();
        String orgIdStr = this.getView().getPageCache().get(ORG_ID);
        Long orgId = Long.valueOf(orgIdStr);
        Long orgBoId = Long.valueOf((String)this.getView().getFormShowParameter().getCustomParam(ORG_BO_ID));
        switch (operateKey) {
            case "save": {
                OperateOption option = OperateOption.create();
                OperationResult operationResult = infoView.invokeOperation(SAVE_OP, option);
                if (operationResult.isSuccess()) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{SAVE_OP, CANCEL_OP});
                    this.getView().setVisible(Boolean.TRUE, new String[]{REVISE_OP, REVISE_RECORD_OP});
                    infoView.setStatus(OperationStatus.VIEW);
                    infoView.getModel().setDataChanged(Boolean.FALSE.booleanValue());
                    String newOrgIdStr = option.getVariableValue("newOrgIdStr");
                    orgId = Long.valueOf(newOrgIdStr);
                    this.getView().getPageCache().put(ORG_ID, String.valueOf(orgId));
                    AdminOrgReviseService adminOrgReviseService = new AdminOrgReviseService();
                    DynamicObject[] orgInfoDys = adminOrgReviseService.getHisVersions(orgBoId);
                    adminOrgReviseService.customControlData(orgInfoDys, String.valueOf(orgId), this.getView(), "update", "update");
                    ((BaseShowParameter)infoView.getFormShowParameter()).setPkId((Object)orgId);
                    infoView.getModel().setValue("id", (Object)orgId);
                    infoView.invokeOperation(REFRESH_OP);
                    String caption = String.format(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7-%s", (String)"FastAdminOrgInfoChange_1", (String)"odc-homs-business", (Object[])new Object[0]), this.getView().getPageCache().get("name"));
                    IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
                    parentView.getControl("_submaintab_");
                    TabOperateUtils.refreshTabName((IFormView)this.getView(), (String)caption);
                }
                this.getView().sendFormAction(infoView);
                break;
            }
            case "cancel": {
                if (!this.closeConfirm(infoView, CANCEL_OP)) break;
                this.setRevisePageView(infoView, baseShowParameter, orgId);
                break;
            }
            case "revise": {
                if (!AdminOrgFastChgHelper.checkReviseBefore((IFormView)this.getView(), (Long)orgBoId, (Long)orgId)) break;
                this.getView().setVisible(Boolean.TRUE, new String[]{SAVE_OP, CANCEL_OP});
                this.getView().setVisible(Boolean.FALSE, new String[]{REVISE_OP, REVISE_RECORD_OP});
                infoView.setStatus(OperationStatus.EDIT);
                baseShowParameter.setPkId((Object)orgId);
                infoView.getModel().setValue("id", (Object)orgId);
                infoView.invokeOperation(REFRESH_OP);
                this.getView().sendFormAction(infoView);
                break;
            }
            case "close": {
                if (!this.closeConfirm(infoView, CLOSE)) break;
                this.getView().close();
                break;
            }
            case "refresh": {
                if (!HRStringUtils.equals((String)this.getView().getPageCache().get("initRevise"), (String)"1")) break;
                this.setDataToPage("update");
                break;
            }
            case "reviserecord": {
                String orgBoIdStr = (String)this.getView().getFormShowParameter().getCustomParam(ORG_BO_ID);
                AdminOrgFastChgHelper.showLogPage((String)"homs_reviseorglog", (IFormView)this.getView(), Collections.singletonList(Long.valueOf(orgBoIdStr)), (String)"adminorgbo", (String)"adminorgbo.org");
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String actionId = event.getCallBackId();
        IFormView infoView = this.getInfoView();
        BaseShowParameter baseShowParameter = (BaseShowParameter)infoView.getFormShowParameter();
        String orgIdStr = this.getView().getPageCache().get(ORG_ID);
        Long orgId = Long.valueOf(orgIdStr);
        if (event.getResult() == MessageBoxResult.Yes) {
            if (actionId.equals(CANCEL_OP)) {
                this.setRevisePageView(infoView, baseShowParameter, orgId);
            } else if (actionId.equals(SELECT_ORG)) {
                Long newOrgId = Long.valueOf(this.getView().getPageCache().get(SELECT_ORG));
                this.selectOrgToRevisePage(infoView, newOrgId);
            } else if (actionId.equals(CLOSE)) {
                this.getView().close();
            }
        } else if (actionId.equals(SELECT_ORG)) {
            this.changeSelect(false);
            this.getView().getPageCache().put(ORG_ID, String.valueOf(orgId));
        }
    }

    private void setRevisePageView(IFormView infoView, BaseShowParameter baseShowParameter, Long orgId) {
        this.getView().setVisible(Boolean.FALSE, new String[]{SAVE_OP, CANCEL_OP});
        this.getView().setVisible(Boolean.TRUE, new String[]{REVISE_OP, REVISE_RECORD_OP});
        baseShowParameter.setPkId((Object)orgId);
        infoView.getModel().setValue("id", (Object)orgId);
        infoView.setStatus(OperationStatus.VIEW);
        infoView.invokeOperation(REFRESH_OP);
        this.getView().sendFormAction(infoView);
    }

    private void selectOrgToRevisePage(IFormView infoView, Long orgId) {
        this.changeSelect(true);
        BaseShowParameter baseShowParameter = (BaseShowParameter)infoView.getFormShowParameter();
        this.getView().setVisible(Boolean.FALSE, new String[]{SAVE_OP, CANCEL_OP});
        String orgBoIdStr = (String)this.getView().getFormShowParameter().getCustomParam(ORG_BO_ID);
        this.setReviseButtonStatus(Long.valueOf(orgBoIdStr), orgId, Boolean.TRUE);
        baseShowParameter.setPkId((Object)orgId);
        if (this.isCurrentVersion(orgId, Long.valueOf(orgBoIdStr))) {
            baseShowParameter.setCustomParam("isCurrentVersion", (Object)Boolean.TRUE);
        } else {
            baseShowParameter.setCustomParam("isCurrentVersion", (Object)Boolean.FALSE);
        }
        infoView.getModel().setValue("id", (Object)orgId);
        infoView.setStatus(OperationStatus.VIEW);
        infoView.invokeOperation(REFRESH_OP);
        this.getView().sendFormAction(infoView);
        this.getView().getPageCache().put(ORG_ID, String.valueOf(orgId));
    }

    private void openAdminorgDetailRevise(Long orgId, Long orgBoId, OperationStatus status) {
        BaseShowParameter formShowParameter = new BaseShowParameter();
        formShowParameter.getOpenStyle().setTargetKey("revise_info");
        formShowParameter.setFormId("homs_adminorgdetailrevise");
        formShowParameter.setPageId("homs_adminorgdetailrevise_" + this.getView().getPageId());
        formShowParameter.setPkId((Object)orgId);
        formShowParameter.setCustomParam("fromPage", (Object)"page_custom_param");
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        if (this.isCurrentVersion(orgId, orgBoId)) {
            formShowParameter.setCustomParam("isCurrentVersion", (Object)Boolean.TRUE);
        } else {
            formShowParameter.setCustomParam("isCurrentVersion", (Object)Boolean.FALSE);
        }
        formShowParameter.setStatus(status);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private boolean isCurrentVersion(Long orgId, Long orgBoId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        DynamicObject currentVersion = hrBaseServiceHelper.queryOne("id,sourcevid", (Object)orgBoId);
        return currentVersion != null && orgId.equals(currentVersion.getLong("sourcevid"));
    }

    private void setReviseButtonStatus(Long orgBoId, Long orgId, boolean hisVersion) {
        DynamicObject orgDy = HOMSAdminOrgRepository.getInstance().getOrgDyByBoId(orgBoId);
        if (!hisVersion) {
            if (orgDy != null && HRStringUtils.equals((String)orgDy.getString("enable"), (String)"0")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{REVISE_OP});
                this.getView().setVisible(Boolean.TRUE, new String[]{REVISE_RECORD_OP});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{REVISE_OP, REVISE_RECORD_OP});
            }
        } else if (orgDy != null && HRStringUtils.equals((String)orgDy.getString("enable"), (String)"1")) {
            DynamicObject hisOrgDy = HOMSAdminOrgRepository.getInstance().getOrgDyById(orgId);
            if (hisOrgDy != null && HRStringUtils.equals((String)hisOrgDy.getString("enable"), (String)"0")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{REVISE_OP});
                this.getView().setVisible(Boolean.TRUE, new String[]{REVISE_RECORD_OP});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{REVISE_OP, REVISE_RECORD_OP});
            }
        }
    }

    private boolean closeConfirm(IFormView infoView, String callBackId) {
        if (infoView.getModel().getDataChanged()) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(callBackId, (IFormPlugin)this);
            HashMap btnNameMaps = Maps.newHashMapWithExpectedSize((int)16);
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"BillView_0", (String)"bos-form-mvc", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"BillView_1", (String)"bos-form-mvc", (Object[])new Object[0]));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\u82e5\u76f4\u63a5\u9000\u51fa\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"AdminorgRevisePlugin_0", (String)"odc-homs-formplugin", (Object[])new Object[0]), infoView.getModel().getChangeDesc(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBackListener, (Map)btnNameMaps);
            return false;
        }
        return true;
    }
}

