/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.impo;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.hr.homs.business.service.helper.AdminOrgBatchChgHelper;
import kd.hr.homs.business.service.utils.OrgChgUtil;
import kd.hr.homs.common.constants.impo.ImportConstants;
import kd.hr.homs.common.enums.AuditStatusEnum;
import kd.hr.homs.formplugin.web.impo.MultiSheetImportHelper;

public class ImportStartPlugin
extends HRCoreBaseBillEdit {
    private static final Log log = LogFactory.getLog(ImportStartPlugin.class);
    private static final String IMPORT_ACTION_ID = "import";
    private static final String EXCEL_PROCESS_PLUGIN = "kd.hr.homs.formplugin.web.impo.MultiSheetImportProcessPlugin";
    private static Map<Long, String> chgSceneAndEntryEntityMap = Maps.newHashMapWithExpectedSize((int)4);

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        if (HRStringUtils.equals((String)"donothing_import", (String)operate.getOperateKey())) {
            Date effdt;
            if (this.getModel().getValue("org") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u3002", (String)"MainDutyUnitTip", (String)"odc-homs-business", (Object[])new Object[0]));
                args.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("homs_orgbatchchgbill");
            DynamicObject dataEntity = this.getModel().getDataEntity(Boolean.TRUE.booleanValue());
            long billId = dataEntity.getLong("id");
            DynamicObject[] dynamicObjects = serviceHelper.query("billstatus", new QFilter[]{new QFilter("id", "=", (Object)billId)});
            if (dynamicObjects.length > 0 && !Sets.newHashSet((Object[])new String[]{"A", "G"}).contains(dynamicObjects[0].getString("billstatus"))) {
                String auditStatus = dynamicObjects[0].getString("billstatus");
                this.getView().showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u7684\u5355\u636e\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"ImportStartPlugin_0", (String)"odc-homs-formplugin", (Object[])new Object[0]), AuditStatusEnum.getName((String)auditStatus)));
                args.setCancel(Boolean.TRUE.booleanValue());
            }
            if ((effdt = dataEntity.getDate("effdt")) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7ec4\u7ec7\u8c03\u6574\u751f\u6548\u65e5\u671f\u3002", (String)"ImportStartPlugin_1", (String)"odc-homs-formplugin", (Object[])new Object[0]));
                args.setCancel(Boolean.TRUE.booleanValue());
            }
            if (!args.isCancel()) {
                this.openImportPage();
            }
        } else if (HRStringUtils.equals((String)"donothing_tempdownload", (String)operate.getOperateKey())) {
            this.openDownloadTemplatePage();
        }
    }

    private void openDownloadTemplatePage() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hrcs_dlmultientitytmpl");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("BillFormId", (Object)"homs_batchorgentityadd");
        showParameter.setCustomParam("TemplateType", (Object)"IMPT");
        this.getView().showForm(showParameter);
    }

    private void openImportPage() {
        FormShowParameter formShowParameter = new FormShowParameter();
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.Modal);
        formShowParameter.setOpenStyle(openStyle);
        formShowParameter.setParentFormId(this.getView().getEntityId());
        formShowParameter.setFormId("hrcs_multientityimptstart");
        FormConfig config = FormMetadataCache.getFormConfig((String)this.getView().getEntityId());
        String entityId = config.getEntityTypeId();
        String listName = config.getCaption().toString();
        FormShowParameter formParameter = this.getView().getFormShowParameter();
        formShowParameter.setCustomParam("oppluginPath", (Object)EXCEL_PROCESS_PLUGIN);
        formShowParameter.setCustomParam("ServiceAppId", (Object)formParameter.getServiceAppId());
        formShowParameter.setCustomParam("CheckRightAppId", (Object)formParameter.getCheckRightAppId());
        DynamicObject dataEntity = this.getModel().getDataEntity(Boolean.TRUE.booleanValue());
        long billId = dataEntity.getLong("id");
        Date effdt = dataEntity.getDate("effdt");
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("billid", billId);
        customParams.put("effDate", effdt);
        customParams.put("org", dataEntity.getDynamicObject("org").getLong("id") + "");
        customParams.put("org.name", dataEntity.getString("org.name"));
        formShowParameter.setCustomParam("customParams", customParams);
        formShowParameter.setCustomParam("BillFormId", (Object)"homs_batchorgentityadd");
        formShowParameter.setCustomParam("ListName", (Object)listName);
        formShowParameter.setCustomParam("entityid", (Object)entityId);
        formShowParameter.setCustomParam("radiofield1", (Object)false);
        formShowParameter.setCustomParam("radiofield2", (Object)false);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, IMPORT_ACTION_ID));
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (HRStringUtils.equals((String)closedCallBackEvent.getActionId(), (String)IMPORT_ACTION_ID)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(Boolean.FALSE.booleanValue());
            String appKey = this.getModel().getDataEntityType().getAppId();
            IAppCache appCache = AppCache.get((String)appKey);
            Boolean importSucceed = (Boolean)appCache.get("homs_orgbatchchgbill_import_succeed", Boolean.class);
            if (importSucceed != null && importSucceed.booleanValue()) {
                this.deleteCurPageData(dataEntity, appCache);
                this.getView().getPageCache().put("isFromImport", "true");
                this.getView().updateView();
                AdminOrgBatchChgHelper.activeHasDataEntryAfterDelete((String)"add", (IFormView)this.getView());
                if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.VIEW)) {
                    this.getView().setStatus(OperationStatus.EDIT);
                }
            }
            MultiSheetImportHelper.clearCache(Arrays.asList("homs_orgbatchchgbill_import_success_batchnos", "homs_orgbatchchgbill_import_succeed"), appKey);
            Object isEdit = this.getView().getFormShowParameter().getCustomParams().get("isEdit");
            if (HRStringUtils.equals((String)this.getView().getFormShowParameter().getAppId(), (String)"wftask") && (isEdit == null || HRStringUtils.equals((String)"1", (String)((String)isEdit)))) {
                ((BillView)this.getView()).setBillStatus(BillOperationStatus.EDIT);
            }
        }
    }

    private void deleteCurPageData(DynamicObject dataEntity, IAppCache appCache) {
        Long successBatchNo = (Long)appCache.get("homs_orgbatchchgbill_import_success_batchnos", Long.class);
        if (successBatchNo == null) {
            return;
        }
        QFilter qFilter = new QFilter("importbatch", "!=", (Object)successBatchNo);
        qFilter.and("billid", "=", (Object)dataEntity.getLong("id"));
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("homs_batchorgentity");
        this.deleteNewAddOrgFromDb(serviceHelper, qFilter);
        serviceHelper.deleteByFilter(new QFilter[]{qFilter});
        chgSceneAndEntryEntityMap.forEach((key, value) -> this.getModel().deleteEntryData(value));
    }

    private void deleteNewAddOrgFromDb(HRBaseServiceHelper entryServiceHelper, QFilter filter) {
        QFilter changeSceneFilter = new QFilter("changetype", "=", (Object)ImportConstants.CHANGE_TYPE_ADD_NEW);
        DynamicObject[] newAddFailedOrgs = entryServiceHelper.query("adminorg", new QFilter[]{filter, changeSceneFilter});
        List newAddFailedOrgIdList = Arrays.stream(newAddFailedOrgs).map(dy -> dy.getDynamicObject("adminorg").getLong("id")).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(newAddFailedOrgIdList)) {
            OrgChgUtil.deleteOrgAndRelateInfo(newAddFailedOrgIdList);
        }
    }

    static {
        chgSceneAndEntryEntityMap.put(ImportConstants.CHANGE_TYPE_ADD_NEW, "entryentity_add");
        chgSceneAndEntryEntityMap.put(ImportConstants.CHANGE_TYPE_PARENT, "entryentity_parent");
        chgSceneAndEntryEntityMap.put(ImportConstants.CHANGE_TYPE_INFO, "entryentity_info");
        chgSceneAndEntryEntityMap.put(ImportConstants.CHANGE_TYPE_DISABLE, "entryentity_disable");
    }
}

