/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.impo;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.homs.formplugin.web.impo.importdata.MultiSheetRowData;

public class MultiSheetImportHelper {
    public static List<String> baseDataEntityType = Arrays.asList("haos_adminorgtype", "haos_adminorglayer", "haos_adminorgfunction", "haos_safelevel", "haos_safetype", "haos_companytype", "haos_departmenttype", "haos_orgchangereason", "haos_changescene", "hbss_lawentity");
    public static Map<String, String> type2EntityType = new HashMap<String, String>(){
        {
            this.put("adminorgtype", "haos_adminorgtype");
            this.put("adminorglayer", "haos_adminorglayer");
            this.put("adminorgfunction", "haos_adminorgfunction");
            this.put("safelevel", "haos_safelevel");
            this.put("safetype", "haos_safetype");
            this.put("companytype", "haos_companytype");
            this.put("departmenttype", "haos_departmenttype");
            this.put("changereason", "haos_orgchangereason");
            this.put("changescene", "haos_changescene");
            this.put("corporateorg", "hbss_lawentity");
        }
    };

    public static boolean isValidationPass(Map<String, ImportLogger> importLoggerMap) {
        AtomicBoolean pass = new AtomicBoolean(true);
        for (Map.Entry<String, ImportLogger> loggerEntry : importLoggerMap.entrySet()) {
            int failed = loggerEntry.getValue().getLogCache().size();
            if (failed <= 0) continue;
            pass.set(false);
            break;
        }
        return pass.get();
    }

    public static void clearCache(List<String> cacheKeys, String appKey) {
        IAppCache appCache = AppCache.get((String)appKey);
        cacheKeys.forEach(arg_0 -> ((IAppCache)appCache).remove(arg_0));
    }

    public static void logOpFailedInfo(String whatException, String exceptionMsg, Map<String, ImportLogger> importLoggerMap, List<MultiSheetRowData> rowDataList) {
        rowDataList.forEach(rowData -> {
            ImportLogger importLogger = (ImportLogger)importLoggerMap.get(rowData.getMainEntity());
            importLogger.log(rowData.getRownum(), whatException);
        });
    }

    public static void feedbackProgress(ImportContext conf, Map<String, ImportLogger> importLoggerMap, int alreadyProcessedDataCount) {
        int failNum = 0;
        int total = 0;
        int headRowCount = conf.isNewFormat() ? 4 : 3;
        for (Map.Entry<String, ImportLogger> entry : importLoggerMap.entrySet()) {
            ImportLogger logger = entry.getValue();
            total += logger.getLastRowIndex() - headRowCount;
            failNum += logger.getLogCache().size();
        }
        for (String url : conf.getAllUrls()) {
            ImportLogger logger = conf.getLogger(url);
            logger.setTotal(alreadyProcessedDataCount);
        }
        if (failNum > 0) {
            failNum = alreadyProcessedDataCount;
        }
        conf.feedbackProgress(alreadyProcessedDataCount * 100 / total - 1, alreadyProcessedDataCount, failNum);
    }

    public static Map<String, Set<Long>> getBaseDataIdsByHrOrgBuID(List<String> entityTypes, long orgId) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)entityTypes.size());
        entityTypes.forEach(entityType -> {
            HRBaseServiceHelper helper = new HRBaseServiceHelper(entityType);
            result.put(entityType, Arrays.stream(helper.query("id", new QFilter[]{BaseDataServiceHelper.getBaseDataFilter((String)entityType, (Long)orgId)})).map(dy -> dy.getLong("id")).collect(Collectors.toSet()));
        });
        return result;
    }
}

