/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.impo;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.ImportLogHelper;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.multimport.HRMultiEntityFileParse;
import kd.hr.hbp.formplugin.web.multimport.HRMultipleEntitiesImportPlugin;
import kd.hr.hbp.formplugin.web.multimport.MultiEntityImportFailedSheetHandler;
import kd.hr.homs.business.service.utils.OrgChgUtil;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;
import kd.hr.homs.common.constants.impo.ImportConstants;
import kd.hr.homs.formplugin.web.impo.MultiSheetImportHelper;
import kd.hr.homs.formplugin.web.impo.importdata.BaseDataContainer;
import kd.hr.homs.formplugin.web.impo.importdata.MultiEntityCallOp;
import kd.hr.homs.formplugin.web.impo.importdata.MultiEntityConvertToDy;
import kd.hr.homs.formplugin.web.impo.importdata.MultiEntityQueryBaseData;
import kd.hr.homs.formplugin.web.impo.importdata.MultiEntityResolveData;
import kd.hr.homs.formplugin.web.impo.importdata.MultiSheetRowData;
import kd.hr.homs.formplugin.web.impo.impvalidator.OrgMultiSheetImportValidator;

public class MultiSheetImportProcessPlugin
extends BatchImportPlugin
implements OrgBatchChgBillConstants {
    private static final Log LOG = LogFactory.getLog(HRMultipleEntitiesImportPlugin.class);
    private static final String DEFAULT_SAVE = "save";
    private List<MultiSheetRowData> rowDataList = Lists.newArrayListWithExpectedSize((int)16);
    private BaseDataContainer container = new BaseDataContainer();
    private Map<String, ImportLogger> importLoggerMap = Maps.newHashMap();
    private Map<String, Set<String>> entityUniqueMap = Maps.newHashMap();
    private Map<String, String> entityQueryFieldMap = Maps.newHashMap();
    private OrgMultiSheetImportValidator validator = new OrgMultiSheetImportValidator();
    private long batchNo = ORM.create().genLongId("homs_orgbatchchgbill");
    private int totalDataCount;
    private Map<String, Object> customParams;

    protected void resolveExcel() {
        HRMultiEntityFileParse.resolveExcel((ImportContext)this.ctx, this.importLoggerMap);
    }

    protected void importData() throws Throwable {
        this.ctx.setFromTask(Boolean.valueOf(false));
        this.importData(this.ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void importData(ImportContext conf) {
        HashMap<String, Object> retdata;
        long startTimeStamp = System.currentTimeMillis();
        try {
            for (String url : conf.getAllUrls()) {
                LinkedBlockingQueue dataQ = conf.getDataQueue(url);
                ArrayList delRows = new ArrayList();
                ImportLogger importLogger = conf.getLogger(url);
                importLogger.setDelRows(delRows);
                this.fecthBacthQueenData(conf, url, dataQ);
            }
            retdata = new HashMap<String, Object>();
            retdata.put("complete", Boolean.TRUE);
        }
        catch (Exception e) {
            HashMap<String, Object> retdata2;
            try {
                LOG.error("MultiSheetImportProcessPlugin.importData() error", (Throwable)e);
                LOG.error((Throwable)e);
                MultiSheetImportHelper.logOpFailedInfo(ResManager.loadKDString((String)"\u4ece\u961f\u5217\u83b7\u53d6\u89e3\u6790\u540e\u7684\u6570\u636e\u5f02\u5e38", (String)"MultiSheetImportProcessPlugin_1", (String)"odc-homs-formplugin", (Object[])new Object[0]), e.getMessage(), this.importLoggerMap, this.rowDataList);
                this.importLoggerProcess();
                retdata2 = new HashMap<String, Object>();
                retdata2.put("complete", Boolean.TRUE);
            }
            catch (Throwable throwable) {
                HashMap<String, Object> retdata3 = new HashMap<String, Object>();
                retdata3.put("complete", Boolean.TRUE);
                retdata3.put("info", this.ctx.getUrlLoggers());
                int total = 0;
                int failed = 0;
                ImportLogger logger = null;
                for (String url : this.ctx.getAllUrls()) {
                    logger = this.ctx.getLogger(url);
                    total += logger.getTotal();
                    failed += logger.getFailed();
                    if (!"\r\n".equals(logger.toString()) && logger.getFailed() == 0) {
                        ++failed;
                    }
                    if (failed <= 0) continue;
                    this.deleteSavedData();
                    this.outputFailedForData(url, logger);
                }
                IAppCache appCache = AppCache.get((String)this.ctx.getAppId());
                if (failed > 0) {
                    appCache.put("homs_orgbatchchgbill_import_succeed", (Object)Boolean.FALSE);
                    this.ctx.feedbackProgress(100, logger, null);
                } else {
                    appCache.put("homs_orgbatchchgbill_import_success_batchnos", (Object)this.batchNo);
                    appCache.put("homs_orgbatchchgbill_import_succeed", (Object)Boolean.TRUE);
                    this.ctx.feedbackProgress(100, null, null);
                }
                this.rowDataList.clear();
                OrgChgUtil.THREAD_LOCAL.remove();
                ImportLogHelper.logAll((Object)this.ctx.getLogId(), (String)JSON.toJSONString(retdata3), (int)total, (int)failed);
                LOG.info(String.format(Locale.ROOT, "MultiSheetImportProcessPlugin.importData() total cost %s milliseconds", System.currentTimeMillis() - startTimeStamp));
                throw throwable;
            }
            retdata2.put("info", this.ctx.getUrlLoggers());
            int total = 0;
            int failed = 0;
            ImportLogger logger = null;
            for (String url : this.ctx.getAllUrls()) {
                logger = this.ctx.getLogger(url);
                total += logger.getTotal();
                failed += logger.getFailed();
                if (!"\r\n".equals(logger.toString()) && logger.getFailed() == 0) {
                    ++failed;
                }
                if (failed <= 0) continue;
                this.deleteSavedData();
                this.outputFailedForData(url, logger);
            }
            IAppCache appCache = AppCache.get((String)this.ctx.getAppId());
            if (failed > 0) {
                appCache.put("homs_orgbatchchgbill_import_succeed", (Object)Boolean.FALSE);
                this.ctx.feedbackProgress(100, logger, null);
            } else {
                appCache.put("homs_orgbatchchgbill_import_success_batchnos", (Object)this.batchNo);
                appCache.put("homs_orgbatchchgbill_import_succeed", (Object)Boolean.TRUE);
                this.ctx.feedbackProgress(100, null, null);
            }
            this.rowDataList.clear();
            OrgChgUtil.THREAD_LOCAL.remove();
            ImportLogHelper.logAll((Object)this.ctx.getLogId(), (String)JSON.toJSONString(retdata2), (int)total, (int)failed);
            LOG.info(String.format(Locale.ROOT, "MultiSheetImportProcessPlugin.importData() total cost %s milliseconds", System.currentTimeMillis() - startTimeStamp));
        }
        retdata.put("info", this.ctx.getUrlLoggers());
        int total = 0;
        int failed = 0;
        ImportLogger logger = null;
        for (String url : this.ctx.getAllUrls()) {
            logger = this.ctx.getLogger(url);
            total += logger.getTotal();
            failed += logger.getFailed();
            if (!"\r\n".equals(logger.toString()) && logger.getFailed() == 0) {
                ++failed;
            }
            if (failed <= 0) continue;
            this.deleteSavedData();
            this.outputFailedForData(url, logger);
        }
        IAppCache appCache = AppCache.get((String)this.ctx.getAppId());
        if (failed > 0) {
            appCache.put("homs_orgbatchchgbill_import_succeed", (Object)Boolean.FALSE);
            this.ctx.feedbackProgress(100, logger, null);
        } else {
            appCache.put("homs_orgbatchchgbill_import_success_batchnos", (Object)this.batchNo);
            appCache.put("homs_orgbatchchgbill_import_succeed", (Object)Boolean.TRUE);
            this.ctx.feedbackProgress(100, null, null);
        }
        this.rowDataList.clear();
        OrgChgUtil.THREAD_LOCAL.remove();
        ImportLogHelper.logAll((Object)this.ctx.getLogId(), (String)JSON.toJSONString(retdata), (int)total, (int)failed);
        LOG.info(String.format(Locale.ROOT, "MultiSheetImportProcessPlugin.importData() total cost %s milliseconds", System.currentTimeMillis() - startTimeStamp));
    }

    private void deleteSavedData() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("homs_batchorgentity");
        QFilter batchNoFilter = new QFilter("importbatch", "=", (Object)this.batchNo);
        QFilter changeTypeFilter = new QFilter("changetype", "=", (Object)ImportConstants.CHANGE_TYPE_ADD_NEW);
        DynamicObject[] newAddOrgs = serviceHelper.query("adminorg", new QFilter[]{batchNoFilter, changeTypeFilter});
        List orgIdList = Arrays.stream(newAddOrgs).map(dy -> dy.getLong("adminorg.id")).collect(Collectors.toList());
        try {
            serviceHelper.deleteByFilter(new QFilter[]{batchNoFilter});
            if (CollectionUtils.isEmpty(orgIdList)) {
                return;
            }
            OrgChgUtil.deleteOrgAndRelateInfo(orgIdList);
        }
        catch (Exception e) {
            LOG.error("MultiSheetImportProcessPlugin.deleteSavedData() error" + e);
            LOG.error((Throwable)e);
            MultiSheetImportHelper.logOpFailedInfo(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4ece\u6570\u636e\u5e93\u5220\u9664\u5931\u8d25\u6279\u6b21[%s]\u6570\u636e\u5f02\u5e38", (String)"MultiSheetImportProcessPlugin_3", (String)"odc-homs-formplugin", (Object[])new Object[0]), this.batchNo), e.getMessage(), this.importLoggerMap, this.rowDataList);
        }
    }

    private void fecthBacthQueenData(ImportContext conf, String url, LinkedBlockingQueue<ImportBillData> dataQ) throws InterruptedException {
        int timeout = 0;
        ArrayList rowdatas = Lists.newArrayListWithExpectedSize((int)30);
        while (!(conf.isResolveComplete(url) && dataQ.isEmpty() || timeout > 5)) {
            ImportBillData rowdata = dataQ.poll(10L, TimeUnit.SECONDS);
            if (rowdata == null || rowdata.isEmpty()) {
                ++timeout;
                continue;
            }
            rowdatas.add(rowdata);
            dataQ.drainTo(rowdatas, 2000);
            rowdatas.removeIf(ImportBillData::isEmpty);
            timeout = 0;
            if (rowdatas.size() > 0) {
                this.totalDataCount += rowdatas.size();
                this.importBatchData(rowdatas, conf.getOption());
            }
            MultiSheetImportHelper.feedbackProgress(conf, this.importLoggerMap, this.totalDataCount);
            rowdatas.clear();
        }
        try {
            this.rowDataList = this.validator.finalStopUseChgValidate(this.importLoggerMap, this.customParams);
            this.saveImportData();
        }
        catch (Exception e) {
            LOG.error("finalStopUseChgValidate process data exception: " + e);
            LOG.error((Throwable)e);
            MultiSheetImportHelper.logOpFailedInfo(ResManager.loadKDString((String)"\u6570\u636e\u89e3\u6790\u5f02\u5e38", (String)"MultiSheetImportProcessPlugin_0", (String)"odc-homs-formplugin", (Object[])new Object[0]), e.getMessage(), this.importLoggerMap, this.rowDataList);
            this.importLoggerProcess();
        }
        try {
            this.rowDataList = this.validator.finalTobeDisabledValidate(this.importLoggerMap, this.customParams);
            this.saveImportData();
        }
        catch (Exception e) {
            LOG.error("finalTobeDisabledValidate process data exception: " + e);
            LOG.error((Throwable)e);
            MultiSheetImportHelper.logOpFailedInfo(ResManager.loadKDString((String)"\u6570\u636e\u89e3\u6790\u5f02\u5e38", (String)"MultiSheetImportProcessPlugin_0", (String)"odc-homs-formplugin", (Object[])new Object[0]), e.getMessage(), this.importLoggerMap, this.rowDataList);
            this.importLoggerProcess();
        }
        MultiSheetImportHelper.feedbackProgress(conf, this.importLoggerMap, this.totalDataCount);
    }

    private void outputFailedForData(String url, ImportLogger importLogger) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        try {
            new ExcelReader().read(service.getInputStream(url), (SheetHandler)new MultiEntityImportFailedSheetHandler(this.ctx, importLogger, service, this.importLoggerMap, Boolean.TRUE.booleanValue()));
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            importLogger.log(Integer.valueOf(0), (Throwable)e);
        }
    }

    private boolean importBatchData(List<ImportBillData> rowdatas, Map<String, Object> option) throws KDBizException {
        try {
            if (rowdatas.get(0).getData().containsKey((Object)"errCode")) {
                throw new KDBizException((String)rowdatas.get(0).getData().get((Object)"errCode"));
            }
            String optionCode = (String)option.get("importtype");
            this.wrapOriginalJson(rowdatas, this.importLoggerMap, optionCode);
            this.addBatchQueenData(rowdatas, optionCode);
        }
        catch (Exception e) {
            LOG.error("MultiSheetImportProcessPlugin.importBatchData() exception: " + e);
            LOG.error((Throwable)e);
            String whatException = e instanceof KDBizException ? ResManager.loadKDString((String)"\u6821\u9a8c\u6a21\u677f\u6570\u636e\u5f02\u5e38", (String)"MultiSheetImportProcessPlugin_2", (String)"odc-homs-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6570\u636e\u89e3\u6790\u5f02\u5e38", (String)"MultiSheetImportProcessPlugin_0", (String)"odc-homs-formplugin", (Object[])new Object[0]);
            MultiSheetImportHelper.logOpFailedInfo(whatException, e.getMessage(), this.importLoggerMap, this.rowDataList);
            this.importLoggerProcess();
            return false;
        }
        return true;
    }

    protected void wrapOriginalJson(List<ImportBillData> rowdatas, Map<String, ImportLogger> importLoggerMap, String optionCode) {
    }

    protected void addBatchQueenData(List<ImportBillData> rowData, String optionCode) throws KDBizException {
        long startTimeStamp = System.currentTimeMillis();
        MultiEntityResolveData.resolveRowData(rowData, this.importLoggerMap, optionCode, this.container, this.rowDataList, this.entityUniqueMap, this.entityQueryFieldMap);
        MultiEntityConvertToDy.convertExcelRowDataToDynamicObjs(this.importLoggerMap, this.rowDataList);
        MultiEntityQueryBaseData.queryBaseDataRef(this.container, this.importLoggerMap);
        MultiEntityQueryBaseData.setDynamicObjValues(this.importLoggerMap, optionCode, this.rowDataList, this.container);
        LOG.info(String.format(Locale.ROOT, "MultiSheetImportProcessPlugin.addBatchQueenData() process excel data cost %s milliseconds", System.currentTimeMillis() - startTimeStamp));
        long secondTimeStamp = System.currentTimeMillis();
        if (this.customParams == null) {
            this.customParams = (Map)this.ctx.getOption().get("customParams");
            this.customParams.put("importbatch", this.batchNo);
        }
        this.validator.doValidate(this.rowDataList, this.importLoggerMap, this.customParams);
        LOG.info(String.format(Locale.ROOT, "MultiSheetImportProcessPlugin.addBatchQueenData() validate data cost %s milliseconds", System.currentTimeMillis() - secondTimeStamp));
        this.saveImportData();
    }

    private void saveImportData() {
        if (MultiSheetImportHelper.isValidationPass(this.importLoggerMap)) {
            long thirdTimeStamp = System.currentTimeMillis();
            MultiEntityCallOp.callOpSave(this.importLoggerMap, opService -> {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("import", "1");
                operateOption.setVariableValue("isImport", String.valueOf(Boolean.TRUE));
                Map<String, List<DynamicObject>> callOpSaveMap = this.callOpSave(this.rowDataList);
                Map<String, String> opNameMap = this.initOpName(callOpSaveMap);
                return callOpSaveMap.entrySet().stream().filter(entry -> !CollectionUtils.isEmpty((Collection)((Collection)entry.getValue()))).map(entry -> OperationServiceHelper.executeOperate((String)((String)opNameMap.get(entry.getKey())), (String)((String)entry.getKey()), (DynamicObject[])((List)entry.getValue()).toArray(new DynamicObject[0]), (OperateOption)operateOption)).collect(Collectors.toList());
            }, this.rowDataList);
            LOG.info(String.format(Locale.ROOT, "MultiSheetImportProcessPlugin.addBatchQueenData() save data cost %s milliseconds, and %s orgs saved.", System.currentTimeMillis() - thirdTimeStamp, this.rowDataList.size()));
        }
        this.importLoggerProcess();
    }

    private void importLoggerProcess() {
        ImportLogger logger;
        int failNum = 0;
        for (Map.Entry<String, ImportLogger> entry : this.importLoggerMap.entrySet()) {
            logger = entry.getValue();
            failNum += logger.getLogCache().size();
        }
        if (failNum > 0) {
            failNum = this.totalDataCount;
        }
        for (String url : this.ctx.getAllUrls()) {
            logger = this.ctx.getLogger(url);
            logger.setTotal(this.totalDataCount);
            logger.setFailed(failNum);
        }
    }

    private Map<String, List<DynamicObject>> callOpSave(List<MultiSheetRowData> rowDataList) {
        HashMap callOpSaveMap = Maps.newHashMapWithExpectedSize((int)rowDataList.size());
        rowDataList.stream().forEach(rowData -> {
            String entityName = rowData.getMainEntity();
            if (callOpSaveMap.containsKey(entityName)) {
                ArrayList<DynamicObject> tempEntities = new ArrayList<DynamicObject>();
                tempEntities.addAll((Collection)callOpSaveMap.get(entityName));
                tempEntities.add(rowData.getOpEntity());
                callOpSaveMap.put(entityName, tempEntities);
            } else {
                callOpSaveMap.put(entityName, Collections.singletonList(rowData.getOpEntity()));
            }
        });
        return callOpSaveMap;
    }

    private Map<String, String> initOpName(Map<String, List<DynamicObject>> callOpSaveMap) {
        HashMap opNameMap = Maps.newHashMapWithExpectedSize((int)callOpSaveMap.size());
        callOpSaveMap.keySet().stream().forEach(entityName -> opNameMap.put(entityName, DEFAULT_SAVE));
        this.customOpName(opNameMap);
        return opNameMap;
    }

    protected void customOpName(Map<String, String> opNameMap) {
    }

    public BatchImportPlugin setContext(RequestContext rc, ImportContext ctx, List<String> startArgs) {
        return super.setContext(rc, ctx, startArgs);
    }
}

