/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.impo.importdata;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.homs.formplugin.web.impo.importdata.BaseDataQueryDesc;

public class BaseDataContainer {
    private static final Log LOG = LogFactory.getLog(BaseDataContainer.class);
    private static final String SEPARATOR = ".";
    private Table<String, String, Map<String, DynamicObject>> basedataTable = HashBasedTable.create();
    private Table<String, String, Map<String, DynamicObjectCollection>> basedataCollectionTable = HashBasedTable.create();
    private Map<String, BaseDataQueryDesc> baseDataQueryDescMap = Maps.newHashMapWithExpectedSize((int)16);

    public void queryBasedataFromStore(Map<String, ImportLogger> importLoggerMap) {
        this.baseDataQueryDescMap.entrySet().stream().forEach(query -> {
            BaseDataQueryDesc dataQueryDesc = (BaseDataQueryDesc)query.getValue();
            QFilter[] qFilters = dataQueryDesc.getQFilters();
            Optional.ofNullable(qFilters).ifPresent(filters -> {
                Object[] basedataArr = BusinessDataServiceHelper.load((String)dataQueryDesc.getProp().getBaseEntityId(), (String)String.join((CharSequence)",", dataQueryDesc.getSelectProp()), (QFilter[])qFilters);
                if (!ObjectUtils.isEmpty((Object[])basedataArr)) {
                    try {
                        HashMap objectMap = Maps.newHashMapWithExpectedSize((int)basedataArr.length);
                        HashMap propSameValueTimeRecord = Maps.newHashMapWithExpectedSize((int)basedataArr.length);
                        for (Object dynamicObject : basedataArr) {
                            String propValue = dynamicObject.getString(dataQueryDesc.getImportKey());
                            propSameValueTimeRecord.put(propValue, propSameValueTimeRecord.computeIfAbsent(propValue, key -> 0) + 1);
                            if (objectMap.containsKey(propValue)) {
                                if ((Integer)propSameValueTimeRecord.get(propValue) > 2) continue;
                                this.logErrorInImportLogger(dataQueryDesc, importLoggerMap, propValue);
                                objectMap.remove(propValue);
                                continue;
                            }
                            objectMap.put(propValue, dynamicObject);
                        }
                        Map dynamicObjectMap = (Map)this.basedataTable.get((Object)dataQueryDesc.getProp().getBaseEntityId(), (Object)dataQueryDesc.getImportKey());
                        if (CollectionUtils.isEmpty((Map)dynamicObjectMap)) {
                            this.basedataTable.put((Object)dataQueryDesc.getProp().getBaseEntityId(), (Object)dataQueryDesc.getImportKey(), (Object)objectMap);
                        } else {
                            dynamicObjectMap.putAll(objectMap);
                        }
                    }
                    catch (Exception e) {
                        LOG.error("BaseDataContainer.queryBasedataFromStore() error: " + e.getMessage());
                        LOG.error((Throwable)e);
                    }
                }
            });
            dataQueryDesc.getImportValues().clear();
        });
    }

    private void logErrorInImportLogger(BaseDataQueryDesc dataQueryDesc, Map<String, ImportLogger> importLoggerMap, String importValue) {
        Map<String, List<Integer>> importValueRowNumRecord = dataQueryDesc.getImportValueRowNumRecord();
        String propName = dataQueryDesc.getProp().getDisplayName().getLocaleValue();
        importValueRowNumRecord.forEach((key, value) -> {
            if (key.contains(importValue)) {
                String entityNumber = key.split("\\.")[0];
                ImportLogger importLogger = (ImportLogger)importLoggerMap.get(entityNumber);
                for (Integer rowNum : value) {
                    importLogger.log(rowNum, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%1$s\u201d\u5b58\u5728\u591a\u6761\u540d\u79f0\u4e3a\u201c%2$s\u201d\u7684\u6570\u636e\uff0c\u8bf7\u586b\u5199\u7f16\u7801", (String)"BaseDataContainer_0", (String)"odc-homs-formplugin", (Object[])new Object[0]), propName, importValue));
                }
            }
            value.clear();
        });
    }

    public Map<String, DynamicObject> getBasedata(String baseEntityId, String propName) {
        Map dynamicObjectMap = (Map)this.basedataTable.get((Object)baseEntityId, (Object)propName);
        if (Objects.nonNull(dynamicObjectMap)) {
            return dynamicObjectMap;
        }
        return Maps.newHashMapWithExpectedSize((int)0);
    }

    public Map<String, DynamicObjectCollection> getBasedataCollection(String baseEntityId, String propName) {
        Map dynamicObjectMap = (Map)this.basedataCollectionTable.get((Object)baseEntityId, (Object)propName);
        if (Objects.nonNull(dynamicObjectMap)) {
            return dynamicObjectMap;
        }
        return Maps.newHashMapWithExpectedSize((int)0);
    }

    public Map<String, BaseDataQueryDesc> getBaseDataQueryDescMap() {
        return this.baseDataQueryDescMap;
    }
}

