/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.impo.importdata;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class BaseDataQueryDesc {
    private IBasedataField prop;
    private Map<String, Object> whereMap;
    private Set<String> importValues;
    private String importKey;
    private Set<String> selectProp;
    private Map<String, List<Integer>> importValueRowNumRecord;

    public BaseDataQueryDesc(BasedataProp prop, String importKey) {
        this(prop, importKey, (Set<String>)Sets.newHashSet((Object[])"id,name,number,status,enable".split(",")));
    }

    public BaseDataQueryDesc(BasedataProp prop, String importKey, Set<String> selectProp) {
        this.prop = prop;
        this.importKey = importKey;
        this.selectProp = selectProp;
        this.whereMap = Maps.newHashMap();
        this.importValues = Sets.newHashSet();
    }

    public BaseDataQueryDesc(MulBasedataProp prop, String importKey, Set<String> selectProp) {
        this.prop = prop;
        this.importKey = importKey;
        this.selectProp = selectProp;
        this.whereMap = Maps.newHashMap();
        this.importValues = Sets.newHashSet();
    }

    public QFilter[] getQFilters() {
        if (this.importValues.size() == 0) {
            return null;
        }
        List<QFilter> filters = this.whereMap.entrySet().stream().map(entry -> new QFilter((String)entry.getKey(), "=", entry.getValue())).collect(Collectors.toList());
        filters.add(new QFilter(this.importKey, "in", this.importValues));
        if (this.hasProp("enable")) {
            filters.add(new QFilter("enable", "=", (Object)"1"));
        }
        if (HRStringUtils.equals((String)this.prop.getBaseEntityId(), (String)"hbss_lawentity")) {
            filters.add(new QFilter("oprsts", "=", (Object)"1"));
        }
        return filters.toArray(new QFilter[0]);
    }

    private boolean hasProp(String propName) {
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)this.prop.getBaseEntityId());
        return mainType.getProperties().stream().map(IMetadata::getName).anyMatch(pro -> pro.equals(propName));
    }

    public void putWhere(String queryField, Object value) {
        this.whereMap.put(queryField, value);
    }

    public IBasedataField getProp() {
        return this.prop;
    }

    public Map<String, Object> getWhereMap() {
        return this.whereMap;
    }

    public Set<String> getSelectProp() {
        return this.selectProp;
    }

    public String getImportKey() {
        return this.importKey;
    }

    public void setImportKey(String importKey) {
        this.importKey = importKey;
    }

    public Set<String> getImportValues() {
        return this.importValues;
    }

    public void setImportValues(Set<String> importValues) {
        this.importValues = importValues;
    }

    public Map<String, List<Integer>> getImportValueRowNumRecord() {
        return this.importValueRowNumRecord;
    }

    public void setImportValueRowNumRecord(Map<String, List<Integer>> importValueRowNumRecord) {
        this.importValueRowNumRecord = importValueRowNumRecord;
    }
}

