/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.impo.importdata;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.AbstractOperationResult;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.formplugin.web.impo.MultiSheetImportHelper;
import kd.hr.homs.formplugin.web.impo.importdata.MultiSheetRowData;

public class MultiEntityCallOp {
    private static final Log LOG = LogFactory.getLog(MultiEntityCallOp.class);

    public static void callOpSave(Map<String, ImportLogger> importLoggerMap, Function<OperationServiceImpl, List<OperationResult>> func, List<MultiSheetRowData> rowDataList) {
        DynamicObject[] opEntityArr = MultiEntityCallOp.convertDy(rowDataList);
        if (opEntityArr.length == 0) {
            return;
        }
        OperationResult localOperationResult = new OperationResult();
        ArrayList pkList = Lists.newArrayList();
        String saveExceptionMsg = ResManager.loadKDString((String)"\u6570\u636e\u5e93\u4fdd\u5b58\u6570\u636e\u5f02\u5e38", (String)"MultiEntityCallOp_0", (String)"odc-homs-formplugin", (Object[])new Object[0]);
        try {
            OperationServiceImpl opImpl = new OperationServiceImpl();
            List<OperationResult> operationResultList = func.apply(opImpl);
            operationResultList.forEach(operationResult -> {
                pkList.addAll(operationResult.getSuccessPkIds());
                MultiEntityCallOp.logOpFaileInfo(operationResult, importLoggerMap, rowDataList);
            });
            List failedMessages = operationResultList.stream().filter(operationResult -> !operationResult.isSuccess()).filter(operationResult -> CollectionUtils.isEmpty((Collection)operationResult.getAllErrorOrValidateInfo())).map(AbstractOperationResult::getMessage).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(failedMessages)) {
                String messages = String.join((CharSequence)";", failedMessages);
                MultiSheetImportHelper.logOpFailedInfo(saveExceptionMsg, messages, importLoggerMap, rowDataList);
            } else {
                MultiEntityCallOp.logOpSuccessInfo(pkList, importLoggerMap, rowDataList);
            }
        }
        catch (Exception exception) {
            LOG.error("MultiEntityCallOp.callOpSave() exception: ", (Throwable)exception);
            LOG.error((Throwable)exception);
            MultiSheetImportHelper.logOpFailedInfo(saveExceptionMsg, exception.getMessage(), importLoggerMap, rowDataList);
            localOperationResult.setSuccess(false);
        }
    }

    private static DynamicObject[] convertDy(List<MultiSheetRowData> rowDataList) {
        DynamicObject[] dynamicObjects;
        for (DynamicObject dynamicObject : dynamicObjects = (DynamicObject[])rowDataList.stream().filter(rowData -> Objects.nonNull(rowData.getOpEntity())).map(MultiSheetRowData::getOpEntity).toArray(DynamicObject[]::new)) {
            if (!dynamicObject.containsProperty("mergesplitstatus")) continue;
            dynamicObject.set("mergesplitstatus", (Object)"2");
        }
        return dynamicObjects;
    }

    private static void logOpFaileInfo(OperationResult op, Map<String, ImportLogger> importLoggerMap, List<MultiSheetRowData> rowDataList) {
        List operateInfos = op.getAllErrorOrValidateInfo();
        for (IOperateInfo info : operateInfos) {
            String pkId = String.valueOf(info.getPkValue());
            MultiSheetRowData mulRowData = rowDataList.stream().filter(rowData -> HRStringUtils.equals((String)rowData.getOpEntity().getString("id"), (String)pkId)).findFirst().orElse(null);
            ImportLogger importLogger = importLoggerMap.get(mulRowData.getMainEntity());
            importLogger.log(mulRowData.getRownum(), String.join((CharSequence)";", info.getMessage()));
        }
    }

    private static void logOpSuccessInfo(List<Object> pkList, Map<String, ImportLogger> importLoggerMap, List<MultiSheetRowData> rowDataList) {
        if (CollectionUtil.isNotEmpty(pkList)) {
            int size = pkList.size();
            for (int i = 0; i < size; ++i) {
                long pkId = Long.parseLong(pkList.get(i).toString());
                rowDataList.stream().filter(rowData -> HRStringUtils.equals((String)rowData.getOpEntity().getString("id"), (String)String.valueOf(pkId))).findAny().ifPresent(rowData -> {
                    ImportBillData row = rowData.getBillData();
                    int startindex = row.getStartIndex();
                    int endindex = row.getEndIndex();
                    ImportLogger importLogger = (ImportLogger)importLoggerMap.get(rowData.getMainEntity());
                    long count = importLogger.getDelRows().stream().filter(ints -> ints[0] == startindex && ints[1] == endindex).count();
                    if (count == 0L) {
                        importLogger.getDelRows().add(new int[]{endindex, endindex});
                    }
                });
            }
        }
    }
}

