/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.impo.importdata;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.imp.ImportEntity;
import kd.hr.homs.formplugin.web.impo.importdata.BaseDataContainer;
import kd.hr.homs.formplugin.web.impo.importdata.MultiSheetRowData;

public class MultiEntityQueryBaseData {
    public static void queryBaseDataRef(BaseDataContainer container, Map<String, ImportLogger> importLoggerMap) {
        container.queryBasedataFromStore(importLoggerMap);
    }

    public static void setDynamicObjValues(Map<String, ImportLogger> importLoggerMap, String optionCode, List<MultiSheetRowData> rowDataList, BaseDataContainer container) {
        rowDataList.forEach(rowData -> {
            ImportLogger importLogger = (ImportLogger)importLoggerMap.get(rowData.getMainEntity());
            MultiEntityQueryBaseData.setBasedataValues(rowData, importLogger, container, rowDataList);
            DynamicObject mainDy = rowData.getMainEntityDy();
            rowData.getEntityMap().entrySet().forEach(entry -> {
                ImportEntity importEntity = (ImportEntity)entry.getValue();
                if (!importEntity.isMainEntity() && !importEntity.isBaseRef()) {
                    DynamicObject subDy = rowData.getRowDynamicObjectMap().get(entry.getKey());
                    subDy.set(importEntity.getProperty(), (Object)mainDy);
                }
            });
        });
        DynamicObject opEntity = null;
        Iterator<MultiSheetRowData> iterator = rowDataList.iterator();
        while (iterator.hasNext()) {
            MultiSheetRowData rowData2 = iterator.next();
            opEntity = MultiEntityQueryBaseData.convertToOpEntity(rowData2);
            if (Objects.isNull(opEntity)) {
                iterator.remove();
                continue;
            }
            rowData2.setOpEntity(opEntity);
        }
    }

    private static void setBasedataValues(MultiSheetRowData rowData, ImportLogger importLogger, BaseDataContainer container, List<MultiSheetRowData> rowDataList) {
        rowData.getEntityBasedataMap().entries().stream().forEach(entry -> {
            String entityName = (String)entry.getKey();
            String entityFieldKeyProp = (String)entry.getValue();
            rowData.getEntityBasedataRefTable().row((Object)entityFieldKeyProp).entrySet().stream().forEach(baseEntry -> {
                String[] split = entityFieldKeyProp.split("\\.");
                IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)MetadataServiceHelper.getDataEntityType((String)entityName).getProperties().get((Object)split[0]);
                if (iDataEntityProperty instanceof MulBasedataProp) {
                    MultiEntityQueryBaseData.setValueToMulBaseData(rowData, importLogger, container, rowDataList, entityName, split, (String)baseEntry.getKey(), (String)baseEntry.getValue());
                } else {
                    MultiEntityQueryBaseData.setValueToBaseData(rowData, importLogger, container, rowDataList, entityName, split, (String)baseEntry.getKey(), (String)baseEntry.getValue());
                }
            });
        });
    }

    private static void setValueToBaseData(MultiSheetRowData rowData, ImportLogger importLogger, BaseDataContainer container, List<MultiSheetRowData> rowDataList, String entityName, String[] split, String baseEntryKey, String importValue) {
        Map<String, DynamicObject> basedataMap = container.getBasedata(baseEntryKey, split[1]);
        ArrayList filterRefList = Lists.newArrayListWithExpectedSize((int)1);
        boolean validatePass = MultiEntityQueryBaseData.validateBaseDataRef(split[0], basedataMap, importValue, () -> filterRefList);
        String propDisplayName = ((IDataEntityProperty)MetadataServiceHelper.getDataEntityType((String)entityName).getProperties().get((Object)split[0])).getDisplayName().getLocaleValue();
        if (!CollectionUtils.isEmpty((Collection)filterRefList) && validatePass) {
            DynamicObject entityDy = rowData.getRowDynamicObjectMap().get(entityName);
            entityDy.set(split[0], filterRefList.get(0));
            MultiEntityQueryBaseData.baseDataNameNumberMatchCheck(split[0], rowData, (DynamicObject)filterRefList.get(0), importLogger, propDisplayName);
        } else if (CollectionUtils.isEmpty((Collection)filterRefList)) {
            if (HRStringUtils.equalsIgnoreCase((String)"adminorg", (String)split[0])) {
                importLogger.log(rowData.getRownum(), String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5df2\u505c\u7528\u6216\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539", (String)"MultiEntityQueryBaseData_2", (String)"odc-homs-formplugin", (Object[])new Object[0]), propDisplayName));
            } else if (HRStringUtils.equalsIgnoreCase((String)"corporateorg", (String)split[0])) {
                importLogger.log(rowData.getRownum(), String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5df2\u505c\u7528\u6216\u5df2\u6ce8\u9500\u6216\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539", (String)"MultiEntityQueryBaseData_3", (String)"odc-homs-formplugin", (Object[])new Object[0]), propDisplayName));
            } else if (!(HRStringUtils.equalsIgnoreCase((String)"aftermerge_org", (String)split[0]) || HRStringUtils.equalsIgnoreCase((String)"beforesplit_org", (String)split[0]) || HRStringUtils.equalsIgnoreCase((String)"null", (String)importValue) || HRStringUtils.equals((String)"parentorg", (String)split[0]))) {
                AtomicBoolean haveMultiValueInDB = new AtomicBoolean(false);
                List logCache = (List)importLogger.getLogCache().get(rowData.getRownum());
                if (logCache != null) {
                    logCache.forEach(logErr -> {
                        if (logErr.msg.contains(importValue)) {
                            haveMultiValueInDB.set(true);
                        }
                    });
                }
                if (haveMultiValueInDB.get()) {
                    return;
                }
                importLogger.log(rowData.getRownum(), String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5df2\u7981\u7528\u6216\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539", (String)"MultiEntityQueryBaseData_0", (String)"odc-homs-formplugin", (Object[])new Object[0]), propDisplayName));
            }
        }
    }

    private static void setValueToMulBaseData(MultiSheetRowData rowData, ImportLogger importLogger, BaseDataContainer container, List<MultiSheetRowData> rowDataList, String entityName, String[] split, String baseEntryKey, String importValue) {
        Map<String, DynamicObject> basedataMap = container.getBasedata(baseEntryKey, split[1]);
        DynamicObject entityDy = rowData.getRowDynamicObjectMap().get(entityName);
        DynamicObjectCollection filterRefList = entityDy.getDynamicObjectCollection(split[0]);
        MultiEntityQueryBaseData.validateMulBaseDataRef(basedataMap, importValue, () -> filterRefList);
    }

    private static void baseDataNameNumberMatchCheck(String prop, MultiSheetRowData rowData, DynamicObject dynamicObject, ImportLogger importLogger, String propDisplayName) {
        JSONObject importData = rowData.getBillData().getData().getJSONObject("data").getJSONObject(rowData.getMainEntity());
        JSONObject jsonObject = importData.getJSONObject(prop);
        String name = jsonObject.getString("name");
        String number = jsonObject.getString("number");
        if (HRStringUtils.isNotEmpty((String)name) && HRStringUtils.isNotEmpty((String)number) && (!HRStringUtils.equals((String)name, (String)dynamicObject.getString("name")) || !HRStringUtils.equals((String)number, (String)dynamicObject.getString("number")))) {
            importLogger.log(rowData.getRownum(), String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u7684\u7f16\u7801\u548c\u540d\u79f0\u4e0d\u5339\u914d", (String)"MultiEntityQueryBaseData_1", (String)"odc-homs-formplugin", (Object[])new Object[0]), propDisplayName));
        }
    }

    private static DynamicObject convertToOpEntity(MultiSheetRowData rowData) {
        return rowData.getRowDynamicObjectMap().get(rowData.getMainEntity());
    }

    private static boolean validateBaseDataRef(String importName, Map<String, DynamicObject> basedataMap, String importValue, Supplier<List<DynamicObject>> filterRefListSuppier) {
        if (basedataMap != null && basedataMap.containsKey(importValue)) {
            filterRefListSuppier.get().add(basedataMap.get(importValue));
            return true;
        }
        return false;
    }

    private static void validateMulBaseDataRef(Map<String, DynamicObject> baseDataMap, String importValue, Supplier<List<DynamicObject>> filterRefListSuppier) {
        if (HRStringUtils.isEmpty((String)importValue)) {
            return;
        }
        if (baseDataMap == null) {
            return;
        }
        String[] importValueArr = importValue.split(",");
        MulBasedataDynamicObjectCollection mulBaseDataColl = (MulBasedataDynamicObjectCollection)filterRefListSuppier.get();
        DynamicObjectType entryType = mulBaseDataColl.getDynamicObjectType();
        for (String value : importValueArr) {
            if (!baseDataMap.containsKey(value)) continue;
            DynamicObject row = new DynamicObject(entryType);
            row.set("fbasedataid", (Object)baseDataMap.get(value));
            mulBaseDataColl.add(row);
        }
    }
}

