/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.impo.importdata;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.imp.ImportEntity;
import kd.hr.hbp.formplugin.web.imp.MultiEntityQueryConfig;
import kd.hr.homs.business.service.utils.OrgChgUtil;
import kd.hr.homs.formplugin.web.impo.importdata.BaseDataContainer;
import kd.hr.homs.formplugin.web.impo.importdata.BaseDataQueryDesc;
import org.apache.commons.lang3.tuple.Pair;

public class MultiSheetRowData {
    private static final Log LOG = LogFactory.getLog(MultiSheetRowData.class);
    private static final String HR_HBP_FORMPLUGIN = "hr-hbp-formplugin";
    private final Map<Function<IDataEntityProperty, Boolean>, BiConsumer<Pair<String, Object>, DynamicObject>> instanceofMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<String, JSONObject> entityJson = Maps.newHashMap();
    private Map<String, DynamicObject> rowDynamicObjectMap = Maps.newHashMap();
    private Table<String, String, String> entityBasedataRefTable = HashBasedTable.create();
    private Multimap<String, String> entityBasedataMap = ArrayListMultimap.create();
    private Map<String, ImportEntity> entityMap = Maps.newHashMap();
    private ImportBillData billData;
    private String tempCode;
    private String optionCode;
    private String mainEntity;
    private ImportLogger importLogger;
    private Integer rownum;
    private BaseDataContainer container;
    private DynamicObject opEntity;
    private List<String> keyfields = Lists.newArrayList();
    private MultiEntityQueryConfig queryConfig;

    public MultiSheetRowData(MultiEntityQueryConfig queryConfig, ImportBillData billData, String optionCode, ImportLogger importLogger, BaseDataContainer container, String tempCode) {
        this.billData = billData;
        this.optionCode = optionCode;
        this.importLogger = importLogger;
        this.container = container;
        this.queryConfig = queryConfig;
        this.init();
        this.tempCode = tempCode;
    }

    private void init() {
        this.instanceofMap.put(prop -> prop instanceof MuliLangTextProp, (pair, dy) -> this.parseTextProp((String)pair.getLeft(), pair.getRight(), (DynamicObject)dy));
        this.instanceofMap.put(prop -> prop instanceof VarcharProp, (pair, dy) -> dy.set((String)pair.getLeft(), pair.getRight()));
        this.instanceofMap.put(prop -> prop instanceof LargeTextProp, (pair, dy) -> dy.set((String)pair.getLeft(), pair.getRight()));
        this.instanceofMap.put(prop -> prop instanceof TextProp, (pair, dy) -> this.parseTextProp((String)pair.getLeft(), pair.getRight(), (DynamicObject)dy));
        this.instanceofMap.put(prop -> prop instanceof ComboProp, (pair, dy) -> dy.set((String)pair.getLeft(), pair.getRight()));
        this.instanceofMap.put(prop -> prop instanceof BooleanProp, (pair, dy) -> dy.set((String)pair.getLeft(), pair.getRight()));
        this.instanceofMap.put(prop -> prop instanceof DecimalProp, (pair, dy) -> this.parseNumericProp((String)pair.getLeft(), pair.getRight(), (DynamicObject)dy));
        this.instanceofMap.put(prop -> prop instanceof DateProp, (pair, dy) -> this.parseDateTimePropData((String)pair.getLeft(), pair.getRight(), (DynamicObject)dy));
        this.instanceofMap.put(prop -> prop instanceof DateTimeProp, (pair, dy) -> this.parseDateTimePropData((String)pair.getLeft(), pair.getRight(), (DynamicObject)dy));
    }

    private void parseTextProp(String fieldKey, Object fieldValue, DynamicObject dy) {
        DynamicProperty property = dy.getDynamicObjectType().getProperty(fieldKey);
        if (property instanceof MuliLangTextProp) {
            Map multiLangData = (Map)fieldValue;
            HashMap copy = Maps.newHashMapWithExpectedSize((int)multiLangData.size());
            multiLangData.forEach((code, val) -> {
                if (!HRStringUtils.equalsIgnoreCase((String)((String)multiLangData.get(code)), (String)"null")) {
                    copy.put(code, val);
                }
            });
            dy.set(fieldKey, (Object)copy);
        } else {
            dy.set(fieldKey, fieldValue);
        }
    }

    private void parseNumericProp(String fieldKey, Object fieldValue, DynamicObject dy) {
        if (HRStringUtils.equalsIgnoreCase((String)"null", (String)String.valueOf(fieldValue))) {
            return;
        }
        try {
            dy.set(fieldKey, (Object)new BigDecimal(String.valueOf(fieldValue)));
        }
        catch (NumberFormatException e) {
            LOG.error("MultiSheetRowData.parseNumberProp() exception: " + e);
        }
    }

    public void buildRowData(List<ImportEntity> entitiesList) {
        Set jsonFieldSet = this.billData.getData().getJSONObject("data").keySet();
        this.rownum = this.billData.getData().getInteger("rownum");
        Map tempEntityMap = entitiesList.stream().collect(Collectors.toMap(ImportEntity::getEntityName, Function.identity()));
        Set diffEntitySet = Sets.difference((Set)jsonFieldSet, tempEntityMap.keySet()).copyInto((Set)Sets.newHashSetWithExpectedSize((int)jsonFieldSet.size()));
        if (diffEntitySet.size() > 0) {
            this.importLogger.log(this.rownum, ResManager.loadKDString((String)"\u6a21\u677f\u6821\u9a8c\u5931\u8d25", (String)"MultiSheetRowData_0", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u6821\u9a8c\u5931\u8d25", (String)"MultiSheetRowData_0", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        }
        Iterator iterator = tempEntityMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry next = iterator.next();
            if (jsonFieldSet.contains(next.getKey())) continue;
            iterator.remove();
        }
        this.entityMap = tempEntityMap;
        entitiesList.stream().filter(ImportEntity::isMainEntity).findAny().map(ImportEntity::getEntityName).ifPresent(entityName -> {
            this.mainEntity = entityName;
        });
        this.getBillData().getData().getJSONObject("data").entrySet().forEach(entry -> this.entityJson.put((String)entry.getKey(), (JSONObject)entry.getValue()));
    }

    public void convertToDynamicObject(Function<String, Set<String>> basedatPropsFunc, BiConsumer<MultiSheetRowData, DynamicObject> consumer) {
        this.entityMap.entrySet().stream().forEach(entry -> this.convertToDynamicObject((String)entry.getKey(), basedatPropsFunc, consumer));
    }

    private void convertToDynamicObject(String entityName, Function<String, Set<String>> basedatPropsFunc, BiConsumer<MultiSheetRowData, DynamicObject> consumer) {
        JSONObject jsonObject = this.entityJson.get(entityName);
        if (Objects.isNull(jsonObject)) {
            return;
        }
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        DynamicObject dynamicObject = (DynamicObject)entityType.createInstance();
        Long pkId = ORM.create().genLongId(entityName);
        dynamicObject.set(entityType.getPrimaryKey().getName(), (Object)pkId);
        this.rowDynamicObjectMap.put(entityName, dynamicObject);
        for (IDataEntityProperty prop : entityType.getProperties()) {
            Object fieldValue = this.getPropValues((Map<String, Object>)jsonObject, prop);
            String fieldKey = prop.getName();
            if (Objects.isNull(fieldValue) || HRStringUtils.equalsIgnoreCase((String)String.valueOf(fieldValue), (String)"null")) continue;
            if (prop instanceof BasedataProp) {
                this.convertToDynamicObject(jsonObject, prop, basedatPropsFunc, fieldKey, entityName);
            } else if (prop instanceof MulBasedataProp) {
                this.convertToDynamicObjectCollection(jsonObject, prop, basedatPropsFunc, fieldKey, entityName);
            }
            for (Map.Entry<Function<IDataEntityProperty, Boolean>, BiConsumer<Pair<String, Object>, DynamicObject>> entry : this.instanceofMap.entrySet()) {
                if (!entry.getKey().apply(prop).booleanValue()) continue;
                entry.getValue().accept((Pair<String, Object>)Pair.of((Object)fieldKey, (Object)fieldValue), dynamicObject);
                break;
            }
            consumer.accept(this, dynamicObject);
        }
    }

    private void convertToDynamicObject(JSONObject jsonObject, IDataEntityProperty prop, Function<String, Set<String>> basedatPropsFunc, String fieldKey, String entityName) {
        JSONObject basedata = jsonObject.getJSONObject(prop.getName());
        String importProp = basedata.getString("importprop");
        String importValue = basedata.getString(importProp);
        BasedataProp basedataProp = (BasedataProp)prop;
        Map<String, DynamicObject> baseDataMap = this.container.getBasedata(basedataProp.getBaseEntityId(), importProp);
        if (!baseDataMap.containsKey(importValue)) {
            String importValueRowNumRecordKey = this.getMainEntity() + "." + importValue;
            String queryDescMapKey = basedataProp.getBaseEntityId() + "." + importProp;
            Map<String, BaseDataQueryDesc> baseDataQueryDescMap = this.container.getBaseDataQueryDescMap();
            if (baseDataQueryDescMap.containsKey(queryDescMapKey)) {
                BaseDataQueryDesc baseDataQueryDesc = baseDataQueryDescMap.get(queryDescMapKey);
                baseDataQueryDesc.getImportValues().add(importValue);
                baseDataQueryDesc.getImportValueRowNumRecord().computeIfAbsent(importValueRowNumRecordKey, key -> Lists.newArrayListWithExpectedSize((int)4)).add(this.rownum);
            } else {
                BaseDataQueryDesc desc = new BaseDataQueryDesc(basedataProp, importProp, basedatPropsFunc.apply(basedataProp.getBaseEntityId()));
                if (HRStringUtils.equals((String)fieldKey, (String)"adminorg") || HRStringUtils.equals((String)fieldKey, (String)"parentorg") || HRStringUtils.equals((String)fieldKey, (String)"beforemerge_org") || HRStringUtils.equals((String)fieldKey, (String)"aftermerge_org") || HRStringUtils.equals((String)fieldKey, (String)"beforesplit_org") || HRStringUtils.equals((String)fieldKey, (String)"aftersplit_org")) {
                    desc.putWhere("iscurrentversion", "1");
                    desc.putWhere("datastatus", "1");
                    desc.putWhere("initstatus", "2");
                }
                if (HRStringUtils.equals((String)fieldKey, (String)"beforemerge_org") || HRStringUtils.equals((String)fieldKey, (String)"aftersplit_org")) {
                    desc.getWhereMap().remove("enable");
                }
                HashMap importValueRowNumRecord = Maps.newHashMapWithExpectedSize((int)4);
                importValueRowNumRecord.computeIfAbsent(importValueRowNumRecordKey, key -> Lists.newArrayListWithExpectedSize((int)4)).add(this.rownum);
                desc.setImportValueRowNumRecord(importValueRowNumRecord);
                desc.getImportValues().add(importValue);
                baseDataQueryDescMap.put(queryDescMapKey, desc);
            }
        }
        String entityFieldKeyProp = fieldKey + "." + importProp;
        this.entityBasedataRefTable.put((Object)entityFieldKeyProp, (Object)basedataProp.getBaseEntityId(), (Object)importValue);
        this.entityBasedataMap.put((Object)entityName, (Object)entityFieldKeyProp);
    }

    private void convertToDynamicObjectCollection(JSONObject jsonObject, IDataEntityProperty prop, Function<String, Set<String>> basedatPropsFunc, String fieldKey, String entityName) {
        String[] importValueArr;
        JSONObject basedata = jsonObject.getJSONObject(prop.getName());
        String importProp = basedata.getString("importprop");
        String importValue = basedata.getString(importProp);
        MulBasedataProp mulBasedataProp = (MulBasedataProp)prop;
        Map<String, DynamicObjectCollection> baseDataMap = this.container.getBasedataCollection(mulBasedataProp.getBaseEntityId(), importProp);
        for (String importValueStr : importValueArr = importValue.split(",")) {
            if (baseDataMap.containsKey(importValueStr)) continue;
            String importValueRowNumRecordKey = this.getMainEntity() + "." + importValue;
            String queryDescMapKey = mulBasedataProp.getBaseEntityId() + "." + importProp;
            Map<String, BaseDataQueryDesc> baseDataQueryDescMap = this.container.getBaseDataQueryDescMap();
            if (baseDataQueryDescMap.containsKey(queryDescMapKey)) {
                BaseDataQueryDesc baseDataQueryDesc = baseDataQueryDescMap.get(queryDescMapKey);
                baseDataQueryDesc.getImportValues().add(importValueStr);
                baseDataQueryDesc.getImportValueRowNumRecord().computeIfAbsent(importValueRowNumRecordKey, key -> Lists.newArrayListWithExpectedSize((int)4)).add(this.rownum);
                continue;
            }
            BaseDataQueryDesc desc = new BaseDataQueryDesc(mulBasedataProp, importProp, basedatPropsFunc.apply(mulBasedataProp.getBaseEntityId()));
            if (HRStringUtils.equals((String)fieldKey, (String)"adminorg") || HRStringUtils.equals((String)fieldKey, (String)"parentorg") || HRStringUtils.equals((String)fieldKey, (String)"beforemerge_org") || HRStringUtils.equals((String)fieldKey, (String)"aftermerge_org") || HRStringUtils.equals((String)fieldKey, (String)"beforesplit_org") || HRStringUtils.equals((String)fieldKey, (String)"aftersplit_org")) {
                desc.putWhere("iscurrentversion", "1");
                desc.putWhere("datastatus", "1");
                desc.putWhere("initstatus", "2");
            }
            if (HRStringUtils.equals((String)fieldKey, (String)"beforemerge_org") || HRStringUtils.equals((String)fieldKey, (String)"aftersplit_org")) {
                desc.getWhereMap().remove("enable");
            }
            HashMap importValueRowNumRecord = Maps.newHashMapWithExpectedSize((int)4);
            importValueRowNumRecord.computeIfAbsent(importValueRowNumRecordKey, key -> Lists.newArrayListWithExpectedSize((int)4)).add(this.rownum);
            desc.setImportValueRowNumRecord(importValueRowNumRecord);
            desc.getImportValues().add(importValueStr);
            baseDataQueryDescMap.put(queryDescMapKey, desc);
        }
        String entityFieldKeyProp = fieldKey + "." + importProp;
        this.entityBasedataRefTable.put((Object)entityFieldKeyProp, (Object)mulBasedataProp.getBaseEntityId(), (Object)importValue);
        this.entityBasedataMap.put((Object)entityName, (Object)entityFieldKeyProp);
    }

    private Object getPropValues(Map<String, Object> dataMap, IDataEntityProperty dp) {
        Object val = null;
        if (dp instanceof BasedataProp) {
            JSONObject basedata = (JSONObject)dataMap.get(dp.getName());
            if (Objects.isNull(basedata)) {
                return null;
            }
            val = basedata.getString(basedata.getString("importprop"));
        } else {
            val = dataMap.get(dp.getName());
        }
        return val;
    }

    private void parseDateTimePropData(String fieldKey, Object fieldValue, DynamicObject dyobj) {
        try {
            String fieldValueStr = String.valueOf(fieldValue);
            if (fieldValueStr.length() > 10) {
                throw new ParseException("The input date format error", 0);
            }
            dyobj.set(fieldKey, (Object)OrgChgUtil.parseDate((String)fieldValueStr));
        }
        catch (ParseException e) {
            this.importLogger.log(this.rownum, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u9519\u8bef\uff0c\u65e0\u6548\u503c\u4e3a\uff1a%s", (String)"MultiSheetRowData_1", (String)"odc-homs-formplugin", (Object[])new Object[0]), fieldValue));
        }
    }

    public void addKey(String key) {
        this.keyfields.add(key);
    }

    public DynamicObject getMainEntityDy() {
        return this.getRowDynamicObjectMap().get(this.getMainEntity());
    }

    public Map<String, DynamicObject> getRowDynamicObjectMap() {
        return this.rowDynamicObjectMap;
    }

    public Table<String, String, String> getEntityBasedataRefTable() {
        return this.entityBasedataRefTable;
    }

    public Multimap<String, String> getEntityBasedataMap() {
        return this.entityBasedataMap;
    }

    public Map<String, ImportEntity> getEntityMap() {
        return this.entityMap;
    }

    public ImportBillData getBillData() {
        return this.billData;
    }

    public void setBillData(ImportBillData billData) {
        this.billData = billData;
    }

    public String getTempCode() {
        return this.tempCode;
    }

    public String getOptionCode() {
        return this.optionCode;
    }

    public String getMainEntity() {
        return this.mainEntity;
    }

    public void setMainEntity(String mainEntity) {
        this.mainEntity = mainEntity;
    }

    public ImportLogger getImportLogger() {
        return this.importLogger;
    }

    public Integer getRownum() {
        return this.rownum;
    }

    public BaseDataContainer getContainer() {
        return this.container;
    }

    public DynamicObject getOpEntity() {
        return this.opEntity;
    }

    public void setOpEntity(DynamicObject opEntity) {
        this.opEntity = opEntity;
    }

    public List<String> getKeyfields() {
        return this.keyfields;
    }

    public MultiEntityQueryConfig getQueryConfig() {
        return this.queryConfig;
    }

    public Map<Function<IDataEntityProperty, Boolean>, BiConsumer<Pair<String, Object>, DynamicObject>> getInstanceofMap() {
        return this.instanceofMap;
    }
}

