/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.impo.impvalidator;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.helper.SystemParamHelper;
import kd.hr.homs.common.constants.impo.ImportConstants;
import kd.hr.homs.common.model.CalibratorBean;
import kd.hr.homs.formplugin.web.impo.impvalidator.IValidator;
import kd.hr.homs.formplugin.web.impo.impvalidator.ImportCommonValidator;
import kd.hr.homs.formplugin.web.impo.impvalidator.ImportValidationModel;
import kd.hr.homs.formplugin.web.impo.impvalidator.OrgInfoVO;
import kd.hr.homs.formplugin.web.impo.impvalidator.ext.BatchExtendValidator;

public class DisableChgImportValidator
implements IValidator<ImportValidationModel> {
    private ImportCommonValidator importCommonValidator;
    private List<BatchExtendValidator> batchExtendValidators;

    public DisableChgImportValidator(ImportCommonValidator importCommonValidator, List<BatchExtendValidator> batchExtendValidators) {
        this.importCommonValidator = importCommonValidator;
        this.batchExtendValidators = batchExtendValidators;
    }

    @Override
    public List<CalibratorBean> validate(ImportValidationModel importValidationModel, Object ... args) {
        String billNo;
        List<String> personList;
        ArrayList<CalibratorBean> allList = new ArrayList<CalibratorBean>(20);
        allList.addAll(this.importCommonValidator.baseDataWithBuCheck(importValidationModel));
        allList.addAll(this.importCommonValidator.validateFiledTextLength(Lists.newArrayList((Object[])new String[]{"changedescription"})));
        allList.addAll(this.importCommonValidator.validateNotNullableProp(ImportValidationModel.rowData.get(), Collections.singletonList("adminorg")));
        allList.addAll(this.importCommonValidator.validateOrg(importValidationModel, ImportConstants.CHANGE_TYPE_DISABLE));
        allList.addAll(this.importCommonValidator.validateChangeInfo(importValidationModel, ImportConstants.CHANGE_TYPE_DISABLE));
        if (this.validateEnabledChildren(importValidationModel)) {
            allList.add(new CalibratorBean("DisableChgImportValidator_0", ResManager.loadKDString((String)"\u505c\u7528\u5931\u8d25\uff0c\u5b58\u5728\u542f\u7528\u4e2d\u7684\u4e0b\u7ea7\u7ec4\u7ec7", (String)"DisableChgImportValidator_0", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[0]));
        }
        if (!CollectionUtils.isEmpty(personList = this.getOrgIdPersonList(importValidationModel))) {
            allList.add(new CalibratorBean("DisableChgImportValidator_1", ResManager.loadKDString((String)"\u5b58\u5728\u5728\u804c\u4eba\u5458\u4eba\u6570\uff1a%s\uff0c\u4e0d\u5141\u8bb8\u505c\u7528", (String)"DisableChgImportValidator_1", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{personList.size()}));
        }
        if (HRStringUtils.isNotEmpty((String)(billNo = this.getApplyingSubBillNo(importValidationModel)))) {
            allList.add(new CalibratorBean("DisableChgImportValidator_2", ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u5b58\u5728\u542f\u7528\u7684\u4e0b\u7ea7\u7ec4\u7ec7\uff0c\u4e0d\u5141\u8bb8\u505c\u7528", (String)"DisableChgImportValidator_2", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{billNo}));
        }
        int enablePositionNumber = this.getOrgIdPositionNumber(importValidationModel);
        if (!SystemParamHelper.getAllowEnabledPosition((Long)importValidationModel.getOrg()) && enablePositionNumber > 0) {
            allList.add(new CalibratorBean("DisableChgImportValidator_3", ResManager.loadKDString((String)"\u505c\u7528\u5931\u8d25\uff0c\u5b58\u5728\u542f\u7528\u4e2d\u7684\u5c97\u4f4d", (String)"DisableChgImportValidator_3", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[0]));
        }
        this.executeExtendValidator(importValidationModel, this.batchExtendValidators, allList, BatchExtendValidator.DISABLE_SCENE);
        return allList;
    }

    private String getApplyingSubBillNo(ImportValidationModel importValidationModel) {
        String billNo = null;
        DynamicObject dy = ImportValidationModel.rowData.get().getOpEntity().getDynamicObject("adminorg");
        if (dy == null) {
            return billNo;
        }
        Collection<OrgInfoVO> dObjectList = importValidationModel.getApplyingChgOrgMap().values();
        long orgId = dy.getLong("id");
        StringBuilder sb = new StringBuilder();
        DynamicObject subDy = null;
        String subBillNo = null;
        for (OrgInfoVO dObject : dObjectList) {
            subDy = dObject.getDy();
            Long changeTypeId = subDy.getLong("changetype.id");
            if (ImportConstants.CHANGE_TYPE_DISABLE.equals(changeTypeId) || ImportConstants.CHANGE_TYPE_INFO.equals(changeTypeId) || subDy.getLong("parentorg.boid") != orgId || sb.indexOf(subBillNo = dObject.getBillNo()) != -1) continue;
            sb.append(subBillNo).append('\u3001');
        }
        if (sb.length() > 0) {
            billNo = sb.substring(0, sb.length() - 1);
        }
        return billNo;
    }

    private List<String> getOrgIdPersonList(ImportValidationModel importValidationModel) {
        ArrayList personList = Lists.newArrayList();
        DynamicObject orgDy = ImportValidationModel.rowData.get().getOpEntity().getDynamicObject("adminorg");
        if (orgDy == null) {
            return personList;
        }
        Long orgId = orgDy.getLong("id");
        Map<Long, List<String>> personMap = importValidationModel.getOrgIdPersonMap(importValidationModel.stopUseOrgInCurExcel, importValidationModel.getOrg());
        personList = CollectionUtils.isEmpty(personMap) ? personList : personMap.get(orgId);
        return personList;
    }

    private int getOrgIdPositionNumber(ImportValidationModel importValidationModel) {
        int positionNumber = 0;
        DynamicObject orgDy = ImportValidationModel.rowData.get().getOpEntity().getDynamicObject("adminorg");
        if (orgDy == null) {
            return 0;
        }
        Long orgId = orgDy.getLong("id");
        Map<Long, Long> positionMap = importValidationModel.getOrgIdPositionMap(importValidationModel.stopUseOrgInCurExcel);
        positionNumber = !CollectionUtils.isEmpty(positionMap) && positionMap.get(orgId) != null ? positionMap.get(orgId).intValue() : 0;
        return positionNumber;
    }

    private boolean validateEnabledChildren(ImportValidationModel importValidationModel) {
        Set<String> set;
        boolean flag = false;
        DynamicObject orgDyn = ImportValidationModel.rowData.get().getOpEntity().getDynamicObject("adminorg");
        if (orgDyn == null) {
            return flag;
        }
        Set<Long> excelSet = importValidationModel.stopUseOrgInCurExcel;
        long orgId = orgDyn.getLong("id");
        Set<Long> enabledSet = importValidationModel.getDisableAllSubOrgMap(excelSet).get(orgId);
        if (!CollectionUtils.isEmpty(enabledSet)) {
            int i = 0;
            for (Long id : enabledSet) {
                if (!excelSet.contains(id)) continue;
                ++i;
            }
            if (enabledSet.size() != i) {
                flag = true;
                return flag;
            }
        }
        if (!CollectionUtils.isEmpty(set = importValidationModel.getParentNumberAndChildrenNumberMapInExcel().get(orgDyn.getString("number")))) {
            flag = true;
            return flag;
        }
        return flag;
    }
}

