/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.impo.impvalidator;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.haos.business.service.adminorg.bean.Pair;
import kd.hr.haos.common.constants.MultiLangEnum;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.helper.SystemParamHelper;
import kd.hr.homs.business.service.orgbatch.OrgBatchBaseDataWithBuCheckServiceImpl;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;
import kd.hr.homs.common.constants.impo.ImportConstants;
import kd.hr.homs.common.model.CalibratorBean;
import kd.hr.homs.common.model.OrgNameBean;
import kd.hr.homs.formplugin.web.impo.MultiSheetImportHelper;
import kd.hr.homs.formplugin.web.impo.importdata.MultiSheetRowData;
import kd.hr.homs.formplugin.web.impo.impvalidator.ImportValidationModel;
import kd.hr.homs.formplugin.web.impo.impvalidator.Org4LayerModelValidator;
import kd.hr.homs.formplugin.web.impo.impvalidator.OrgCoopRelLoopValidator;
import kd.hr.homs.formplugin.web.impo.impvalidator.OrgInfoVO;

public class ImportCommonValidator {
    private static final Log logger = LogFactory.getLog(ImportCommonValidator.class);
    private static List<String> textLenNeedCheckProps = Lists.newArrayList((Object[])new String[]{"changedescription", "number", "name", "simplename", "description", "positioning", "mainduty", "safedescription", "detailaddress", "groupvision", "groupmission"});
    private OrgCoopRelLoopValidator coopRelLoopValidator;
    private Org4LayerModelValidator org4LayerModelValidator;

    public ImportCommonValidator(OrgCoopRelLoopValidator coopRelLoopValidator, Org4LayerModelValidator org4LayerModelValidator) {
        this.coopRelLoopValidator = coopRelLoopValidator;
        this.org4LayerModelValidator = org4LayerModelValidator;
    }

    public static List<String> getTextLenNeedCheckProps() {
        return textLenNeedCheckProps;
    }

    public List<CalibratorBean> validateOrg(ImportValidationModel importValidationModel, Long changeTypeId) {
        ArrayList errorList = Lists.newArrayListWithCapacity((int)4);
        MultiSheetRowData rowData = ImportValidationModel.rowData.get();
        String mainEntity = rowData.getMainEntity();
        if (HRStringUtils.equals((String)mainEntity, (String)"homs_batchorgmerge")) {
            DynamicObjectCollection beforeMergeOrgS = rowData.getOpEntity().getDynamicObjectCollection("beforemerge_org");
            DynamicObject afterMergeOrg = rowData.getOpEntity().getDynamicObject("aftermerge_org");
            for (DynamicObject beforeMergeOrg : beforeMergeOrgS) {
                this.validateOneOrg(importValidationModel, changeTypeId, beforeMergeOrg, errorList);
                this.validateInOtherChg(importValidationModel, beforeMergeOrg, errorList, changeTypeId);
            }
            this.validateOneOrg(importValidationModel, changeTypeId, afterMergeOrg, errorList);
            this.validateInOtherChg(importValidationModel, afterMergeOrg, errorList, changeTypeId);
        } else if (HRStringUtils.equals((String)mainEntity, (String)"homs_batchorgsplit")) {
            DynamicObjectCollection afterSplitOrgS = rowData.getOpEntity().getDynamicObjectCollection("aftersplit_org");
            DynamicObject beforeSplitOrg = rowData.getOpEntity().getDynamicObject("beforesplit_org");
            for (DynamicObject afterSplitOrg : afterSplitOrgS) {
                this.validateOneOrg(importValidationModel, changeTypeId, afterSplitOrg, errorList);
                this.validateInOtherChg(importValidationModel, afterSplitOrg, errorList, changeTypeId);
            }
            this.validateOneOrg(importValidationModel, changeTypeId, beforeSplitOrg, errorList);
            this.validateInOtherChg(importValidationModel, beforeSplitOrg, errorList, changeTypeId);
        } else {
            DynamicObject orgDyn = rowData.getOpEntity().getDynamicObject("adminorg");
            this.validateOneOrg(importValidationModel, changeTypeId, orgDyn, errorList);
            this.validateInOtherChg(importValidationModel, orgDyn, errorList, changeTypeId);
        }
        return errorList;
    }

    private void validateOneOrg(ImportValidationModel importValidationModel, Long changeTypeId, DynamicObject orgDyn, List<CalibratorBean> errorList) {
        if (orgDyn == null) {
            return;
        }
        if (changeTypeId.equals(OrgBatchChgBillConstants.CHANGE_TYPE_MERGE) || changeTypeId.equals(OrgBatchChgBillConstants.CHANGE_TYPE_SPLIT)) {
            for (Pair<String, String> numberNamePair : importValidationModel.newAddOrgNumberNamePairMap.keySet()) {
                if (!HRStringUtils.equals((String)orgDyn.getString("number"), (String)((String)numberNamePair.getKey()))) continue;
                return;
            }
        }
        if (!this.validatePerm(importValidationModel, orgDyn.getLong("id"))) {
            errorList.add(new CalibratorBean("ImportCommonValidator_15", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u201c%s\u201d\u4e0d\u5728\u7528\u6237\u6743\u9650\u8303\u56f4\u5185\uff0c\u8bf7\u4fee\u6539", (String)"ImportCommonValidator_15", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{orgDyn.getString("number") + "/" + orgDyn.getString("name")}));
        }
        if (!this.validatePermWithBu(importValidationModel, orgDyn)) {
            errorList.add(new CalibratorBean("ImportCommonValidator_27", ResManager.loadKDString((String)"\u53ea\u80fd\u8c03\u6574\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u4e3a\u201c%s\u201d\u7684\u884c\u653f\u7ec4\u7ec7", (String)"ImportCommonValidator_27", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{importValidationModel.getOrgName()}));
        }
    }

    public List<CalibratorBean> validateCoopRelLoop(ImportValidationModel importValidationModel) {
        return this.coopRelLoopValidator.validate(importValidationModel);
    }

    public List<CalibratorBean> validateFiledTextLength(List<String> textLenCheckProps) {
        ArrayList errorList = Lists.newArrayListWithCapacity((int)1);
        DynamicObject opEntity = ImportValidationModel.rowData.get().getOpEntity();
        DynamicObjectType objectType = opEntity.getDynamicObjectType();
        textLenCheckProps.forEach(prop -> {
            DynamicProperty property = objectType.getProperty(prop);
            String propChValue = "";
            String propEnValue = "";
            if (property instanceof MuliLangTextProp) {
                propChValue = opEntity.getLocaleString(prop).getLocaleValue_zh_CN();
                propEnValue = opEntity.getLocaleString(prop).getLocaleValue_en();
            } else {
                propChValue = opEntity.getString(prop);
            }
            TextProp textProp = (TextProp)property;
            int maxLenth = textProp.getMaxLenth();
            String propDisplayName = textProp.getDisplayName().getLocaleValue();
            if (HRStringUtils.isNotEmpty((String)propChValue) && propChValue.length() > maxLenth) {
                errorList.add(new CalibratorBean("ImportCommonValidator_0", ResManager.loadKDString((String)"\u201c%1$s\u201d\u5185\u5bb9\u8d85\u957f\uff0c\u53ea\u652f\u6301\u586b\u5199\u201c%2$s\u201d", (String)"ImportCommonValidator_0", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{propDisplayName + ".zh_CN", maxLenth}));
            }
            if (HRStringUtils.isNotEmpty((String)propEnValue) && propEnValue.length() > maxLenth) {
                errorList.add(new CalibratorBean("ImportCommonValidator_0", ResManager.loadKDString((String)"\u201c%1$s\u201d\u5185\u5bb9\u8d85\u957f\uff0c\u53ea\u652f\u6301\u586b\u5199\u201c%2$s\u201d", (String)"ImportCommonValidator_0", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{propDisplayName + ".en_US", maxLenth}));
            }
        });
        return errorList;
    }

    public List<CalibratorBean> validateIndex() {
        long decimalNum;
        ArrayList errorList = Lists.newArrayListWithCapacity((int)1);
        MultiSheetRowData curRowData = ImportValidationModel.rowData.get();
        String index = curRowData.getOpEntity().getString("index");
        if (null == index) {
            return errorList;
        }
        JSONObject importData = curRowData.getBillData().getData().getJSONObject("data").getJSONObject(curRowData.getMainEntity());
        long indexValue = Long.parseLong(index);
        CalibratorBean bean = new CalibratorBean("ImportCommonValidator_1", ResManager.loadKDString((String)"\u6392\u5e8f\u53f7\u53ea\u80fd\u586b\u51991-99999\u4e4b\u95f4\u7684\u6574\u6570", (String)"ImportCommonValidator_1", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[0]);
        String indexStr = importData.getString("index");
        long l = decimalNum = indexStr.contains(".") ? Long.parseLong(indexStr.split("\\.")[1]) : -1L;
        if (indexValue < 1L || indexValue > 99999L) {
            errorList.add(bean);
        } else if (decimalNum >= 0L) {
            errorList.add(bean);
        }
        return errorList;
    }

    public List<CalibratorBean> validateCompanyAreaCity(ImportValidationModel importValidationModel) {
        ArrayList errorList = Lists.newArrayListWithCapacity((int)2);
        DynamicObject countryareaDo = ImportValidationModel.rowData.get().getOpEntity().getDynamicObject("companyarea");
        DynamicObject cityDo = ImportValidationModel.rowData.get().getOpEntity().getDynamicObject("city");
        if (countryareaDo != null && cityDo != null) {
            Long cityCountryId = importValidationModel.cityCompanyareaMapDB.get(cityDo.getLong("id"));
            long countryId = countryareaDo.getLong("id");
            if (cityCountryId != null && countryId != 0L && cityCountryId != countryId) {
                errorList.add(new CalibratorBean("ImportCommonValidator_2", ResManager.loadKDString((String)"\u6240\u5728\u57ce\u5e02\u201c%1$s\u201d\u4e0d\u5c5e\u4e8e\u56fd\u5bb6/\u5730\u533a\u201c%2$s\u201d\uff0c\u8bf7\u4fee\u6539", (String)"ImportCommonValidator_2", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{cityDo.getString("name"), countryareaDo.getString("name")}));
            }
        }
        return errorList;
    }

    public List<CalibratorBean> validateEstablishmentDate(ImportValidationModel importValidationModel) {
        ArrayList errorList = Lists.newArrayListWithCapacity((int)1);
        DynamicObject opEntity = ImportValidationModel.rowData.get().getOpEntity();
        Date establishmentdate = opEntity.getDate("establishmentdate");
        if (HRStringUtils.equals((String)ImportValidationModel.rowData.get().getMainEntity(), (String)"homs_batchorgentityadd")) {
            Optional.ofNullable(establishmentdate).ifPresent(date -> {
                LocalDate localEffDate;
                LocalDate LocalEstablishDate = LocalDate.parse(DateUtils.formatDate((Date)date, (Object[])new Object[0]));
                if (LocalEstablishDate.isAfter(localEffDate = LocalDate.parse(DateUtils.formatDate((Date)importValidationModel.getEffDate(), (Object[])new Object[0])))) {
                    errorList.add(new CalibratorBean("ImportCommonValidator_18", ResManager.loadKDString((String)"\u6210\u7acb\u65e5\u671f\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u7ec4\u7ec7\u8c03\u6574\u751f\u6548\u65e5\u671f", (String)"ImportCommonValidator_18", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[0]));
                }
            });
        } else {
            DynamicObject curOrg = opEntity.getDynamicObject("adminorg");
            if (Objects.nonNull(curOrg) && Objects.nonNull(establishmentdate)) {
                LocalDate newEstablishDate = LocalDate.parse(DateUtils.formatDate((Date)establishmentdate, (Object[])new Object[0]));
                DynamicObject curOrgOldInfo = importValidationModel.curBatchChgOrgInfoInDB.get(curOrg.getLong("id"));
                Date oldEstablishDate = curOrgOldInfo.getDate("establishmentdate");
                Optional.ofNullable(oldEstablishDate).ifPresent(date -> {
                    LocalDate localEffDate = LocalDate.parse(DateUtils.formatDate((Date)date, (Object[])new Object[0]));
                    if (!newEstablishDate.isEqual(localEffDate)) {
                        errorList.add(new CalibratorBean("ImportCommonValidator_23", ResManager.loadKDString((String)"\u6210\u7acb\u65e5\u671f\u4e0d\u5141\u8bb8\u4fee\u6539", (String)"ImportCommonValidator_23", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[0]));
                    }
                });
            }
        }
        return errorList;
    }

    public List<CalibratorBean> validateOrg4LayerModel(ImportValidationModel importValidationModel) {
        return this.org4LayerModelValidator.doValidation(importValidationModel);
    }

    private void validateInOtherChg(ImportValidationModel importValidationModel, DynamicObject curOrg, List<CalibratorBean> errorList, Long changeTypeId) {
        if (curOrg == null) {
            return;
        }
        Long orgId = curOrg.getLong("id");
        Long sceneTypeId = this.getSceneTypeByChgSceneOrg(importValidationModel.applyingChgTypeOrgMap, orgId);
        if (sceneTypeId.equals(0L)) {
            return;
        }
        String billNo = "";
        for (Map.Entry<String, Set<Long>> entry : importValidationModel.billNoOrgMap.entrySet()) {
            if (!entry.getValue().contains(orgId)) continue;
            billNo = entry.getKey();
            break;
        }
        if (!HRStringUtils.isEmpty((String)billNo)) {
            errorList.add(new CalibratorBean("ImportCommonValidator_3", ResManager.loadKDString((String)"\u201c%1$s\u201d/\u201c%2$s\u201d\u4e2d\u5df2\u5b58\u5728\u5355\u636e\u201c%3$s\u201d\u7684\u201c%4$s\u201d\uff0c\u4e0d\u5141\u8bb8\u540c\u65f6\u5bf9\u7ec4\u7ec7\u8fdb\u884c\u591a\u79cd\u53d8\u52a8\u64cd\u4f5c", (String)"ImportCommonValidator_3", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{curOrg.getString("number"), curOrg.getString("name"), billNo, importValidationModel.getChangeTypeInfo().get(sceneTypeId).getString("name")}));
        }
    }

    private Long getSceneTypeByChgSceneOrg(Map<Long, Set<Long>> chgSceneOrgMap, Long orgId) {
        Long sceneTypeId = 0L;
        if (CollectionUtils.isEmpty(chgSceneOrgMap)) {
            return sceneTypeId;
        }
        for (Map.Entry<Long, Set<Long>> entry : chgSceneOrgMap.entrySet()) {
            if (!entry.getValue().contains(orgId)) continue;
            sceneTypeId = entry.getKey();
            break;
        }
        return sceneTypeId;
    }

    public List<CalibratorBean> validateChangeInfo(ImportValidationModel importValidationModel, Long changeTypeId) {
        ArrayList errorList = Lists.newArrayListWithCapacity((int)2);
        DynamicObjectCollection changeReasons = this.validateChangeScene(importValidationModel, errorList, changeTypeId);
        this.validateChangeReason(importValidationModel, errorList, changeReasons, changeTypeId);
        return errorList;
    }

    private boolean notExistsField(MultiSheetRowData rowData, String fieldName) {
        JSONObject importData = rowData.getBillData().getData().getJSONObject("data").getJSONObject(rowData.getMainEntity());
        return importData.get((Object)fieldName) == null;
    }

    private DynamicObjectCollection validateChangeScene(ImportValidationModel importValidationModel, List<CalibratorBean> errorList, Long changeTypeId) {
        DynamicObjectCollection changeReasons = null;
        MultiSheetRowData rowData = ImportValidationModel.rowData.get();
        if (this.notExistsField(rowData, "changescene")) {
            return changeReasons;
        }
        List<CalibratorBean> list = this.validateNotNullableProp(rowData, Collections.singletonList("changescene"));
        if (!CollectionUtils.isEmpty(list)) {
            errorList.addAll(list);
            return changeReasons;
        }
        DynamicObject changeScene = (DynamicObject)ImportValidationModel.rowData.get().getOpEntity().get("changescene");
        if (changeScene == null) {
            return changeReasons;
        }
        if (!changeTypeId.equals(changeScene.getLong("orgchangetype.id"))) {
            errorList.add(new CalibratorBean("ImportCommonValidator_7", ResManager.loadKDString((String)"\u9700\u586b\u5199\u53d8\u52a8\u7c7b\u578b\u4e3a\u201c%s\u201d\u7684\u53d8\u52a8\u573a\u666f\uff0c\u8bf7\u4fee\u6539", (String)"ImportCommonValidator_7", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{importValidationModel.getChangeTypeInfo().get(changeTypeId).getLocaleString("name").getLocaleValue()}));
            return changeReasons;
        }
        changeReasons = (DynamicObjectCollection)changeScene.get("changereason");
        return changeReasons;
    }

    private void validateChangeReason(ImportValidationModel importValidationModel, List<CalibratorBean> errorList, DynamicObjectCollection changeReasons, Long changeTypeId) {
        MultiSheetRowData rowData = ImportValidationModel.rowData.get();
        if (this.notExistsField(rowData, "changereason")) {
            return;
        }
        List<CalibratorBean> list = this.validateNotNullableProp(rowData, Collections.singletonList("changereason"));
        if (!CollectionUtils.isEmpty(list)) {
            return;
        }
        DynamicObject changeReasonDo = (DynamicObject)ImportValidationModel.rowData.get().getOpEntity().get("changereason");
        if (changeReasonDo == null) {
            return;
        }
        String changeTypeName = importValidationModel.getChangeTypeInfo().get(changeTypeId).getLocaleString("name").getLocaleValue();
        if (CollectionUtils.isEmpty((Collection)changeReasons)) {
            errorList.add(new CalibratorBean("ImportCommonValidator_9", ResManager.loadKDString((String)"\u9700\u586b\u5199\u53d8\u52a8\u573a\u666f\u4e3a\u201c%s\u201d\u5173\u8054\u7684\u7684\u53d8\u52a8\u539f\u56e0\uff0c\u8bf7\u4fee\u6539", (String)"ImportCommonValidator_9", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{changeTypeName}));
            return;
        }
        boolean exists = false;
        for (DynamicObject changeReason : changeReasons) {
            if (changeReason.getDynamicObject("fbasedataid").getLong("id") != changeReasonDo.getLong("id")) continue;
            exists = true;
            break;
        }
        if (!exists) {
            errorList.add(new CalibratorBean("ImportCommonValidator_9", ResManager.loadKDString((String)"\u9700\u586b\u5199\u53d8\u52a8\u573a\u666f\u4e3a\u201c%s\u201d\u5173\u8054\u7684\u7684\u53d8\u52a8\u539f\u56e0\uff0c\u8bf7\u4fee\u6539", (String)"ImportCommonValidator_9", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{changeTypeName}));
        }
    }

    public List<CalibratorBean> validateNotNullableProp(MultiSheetRowData curRowData, List<String> props) {
        JSONObject data = curRowData.getBillData().getData().getJSONObject("data");
        JSONObject importData = data.getJSONObject(curRowData.getMainEntity());
        DynamicObject opEntity = curRowData.getOpEntity();
        DataEntityPropertyCollection properties = opEntity.getDynamicObjectType().getProperties();
        ArrayList result = Lists.newArrayListWithCapacity((int)2);
        props.forEach(prop -> {
            IDataEntityProperty property = (IDataEntityProperty)properties.get(prop);
            if (importData.get(prop) == null) {
                return;
            }
            AtomicBoolean isSetToNull = new AtomicBoolean(false);
            if (property instanceof BasedataProp) {
                DynamicObject dynamicObject = opEntity.getDynamicObject(prop);
                JSONObject jsonObject = importData.getJSONObject(prop);
                if (dynamicObject == null && jsonObject != null) {
                    isSetToNull.set(true);
                    jsonObject.forEach((key, value) -> {
                        if (HRStringUtils.equals((String)key, (String)"importprop")) {
                            return;
                        }
                        if (!HRStringUtils.equalsIgnoreCase((String)"null", (String)String.valueOf(value))) {
                            isSetToNull.set(false);
                        }
                    });
                }
            } else if (property instanceof MuliLangTextProp) {
                isSetToNull.set(true);
                JSONObject jsonObject = importData.getJSONObject(prop);
                if (jsonObject != null && !jsonObject.isEmpty()) {
                    jsonObject.forEach((code, val) -> {
                        if (!HRStringUtils.equalsIgnoreCase((String)"null", (String)jsonObject.getString(code))) {
                            isSetToNull.set(false);
                        }
                    });
                }
            } else if (HRStringUtils.equalsIgnoreCase((String)"null", (String)importData.getString(prop))) {
                isSetToNull.set(true);
            }
            if (isSetToNull.get()) {
                result.add(new CalibratorBean("ImportCommonValidator_10", ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\uff0c \u8bf7\u4fee\u6539", (String)"ImportCommonValidator_10", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{property.getDisplayName()}));
            }
        });
        return result;
    }

    public List<CalibratorBean> orgNameAndNumberCheck(ImportValidationModel importValidationModel) {
        ArrayList result = Lists.newArrayListWithCapacity((int)2);
        String newNumber = ImportValidationModel.importValidationOrgBO.get().getNewNumber();
        MultiSheetRowData curRowData = ImportValidationModel.rowData.get();
        if (newNumber != null && !HRStringUtils.equalsIgnoreCase((String)"null", (String)newNumber)) {
            Map<String, List<DynamicObject>> curBatchNewNumberExistInDb = importValidationModel.getCurBatchNewNumberExistInDb();
            if (curBatchNewNumberExistInDb.containsKey(newNumber)) {
                boolean numberExist = false;
                Date effDate = importValidationModel.getEffDate();
                if (HRStringUtils.equals((String)curRowData.getMainEntity(), (String)"homs_batchorgentityadd")) {
                    effDate = curRowData.getOpEntity().getDate("establishmentdate");
                }
                if (Objects.isNull(effDate)) {
                    effDate = new Date();
                }
                List<DynamicObject> numbers = curBatchNewNumberExistInDb.get(newNumber);
                for (DynamicObject number : numbers) {
                    Date endDate = number.getDate("bsled");
                    if (effDate.compareTo(endDate) > 0) continue;
                    numberExist = true;
                    break;
                }
                if (numberExist && HRStringUtils.equals((String)curRowData.getMainEntity(), (String)"homs_batchorgentityadd")) {
                    result.add(new CalibratorBean("ImportCommonValidator_13", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u201c%s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539", (String)"ImportCommonValidator_13", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{newNumber}));
                } else if (numberExist && !HRStringUtils.equals((String)newNumber, (String)ImportValidationModel.importValidationOrgBO.get().getOldNumber())) {
                    result.add(new CalibratorBean("ImportCommonValidator_19", ResManager.loadKDString((String)"\u8c03\u6574\u540e\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u201c%s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539", (String)"ImportCommonValidator_19", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{newNumber}));
                }
            }
            if (importValidationModel.applyingOrgNumbers.contains(newNumber)) {
                if (HRStringUtils.equals((String)curRowData.getMainEntity(), (String)"homs_batchorgentityadd")) {
                    result.add(new CalibratorBean("ImportCommonValidator_14", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\uff08\u7f16\u7801\uff1a%s\uff09\u5df2\u5b58\u5728\u5728\u9014\u5355\u636e\uff0c\u8bf7\u4fee\u6539", (String)"ImportCommonValidator_14", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{newNumber}));
                } else if (!HRStringUtils.equals((String)newNumber, (String)ImportValidationModel.importValidationOrgBO.get().getOldNumber())) {
                    result.add(new CalibratorBean("ImportCommonValidator_20", ResManager.loadKDString((String)"\u8c03\u6574\u540e\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u201c%s\u201d\u5df2\u5b58\u5728\u5728\u9014\u5355\u636e\u4e2d\uff0c\u8bf7\u4fee\u6539", (String)"ImportCommonValidator_20", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{newNumber}));
                }
            }
            if (importValidationModel.bosOrgNumbers.contains(newNumber)) {
                if (HRStringUtils.equals((String)curRowData.getMainEntity(), (String)"homs_batchorgentityadd")) {
                    result.add(new CalibratorBean("ImportCommonValidator_17", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u201c%s\u201d\u4e0e\u201c\u57fa\u7840\u670d\u52a1\u4e91>\u4f01\u4e1a\u5efa\u6a21>\u7ec4\u7ec7\u7ba1\u7406>\u884c\u653f\u7ec4\u7ec7/\u4e1a\u52a1\u5355\u5143\u201d\u4e2d\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u4fee\u6539", (String)"ImportCommonValidator_17", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{newNumber}));
                } else if (!HRStringUtils.equals((String)newNumber, (String)ImportValidationModel.importValidationOrgBO.get().getOldNumber())) {
                    result.add(new CalibratorBean("ImportCommonValidator_21", ResManager.loadKDString((String)"\u8c03\u6574\u540e\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u201c%s\u201d\u4e0e\u201c\u57fa\u7840\u670d\u52a1\u4e91>\u4f01\u4e1a\u5efa\u6a21>\u7ec4\u7ec7\u7ba1\u7406>\u884c\u653f\u7ec4\u7ec7/\u4e1a\u52a1\u5355\u5143\u201d\u4e2d\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u4fee\u6539", (String)"ImportCommonValidator_21", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{newNumber}));
                }
            }
            if (newNumber.contains("!") || newNumber.contains("\uff01")) {
                result.add(new CalibratorBean("ImportCommonValidator_28", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u4e2d\u4e0d\u5141\u8bb8\u6709\u7279\u6b8a\u7684\u5206\u9694\u7b26\u201c!\u201d\uff0c\u8bf7\u4fee\u6539", (String)"ImportCommonValidator_28", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[0]));
            }
        }
        if (HRStringUtils.equals((String)curRowData.getMainEntity(), (String)"homs_batchorgentityadd")) {
            this.addOrgNameExistCheck(importValidationModel, result);
        } else {
            this.infoOrgNameExistCheck(importValidationModel, result);
        }
        return result;
    }

    private void addOrgNameExistCheck(ImportValidationModel importValidationModel, List<CalibratorBean> errorList) {
        long orgId;
        MultiSheetRowData curRowData = ImportValidationModel.rowData.get();
        DynamicObject parentOrg = curRowData.getOpEntity().getDynamicObject("parentorg");
        long parentOrgId = 0L;
        if (parentOrg != null) {
            parentOrgId = parentOrg.getLong("id");
        } else if (!HRStringUtils.equals((String)curRowData.getMainEntity(), (String)"homs_batchorgentityadd") && curRowData.getOpEntity().getDynamicObject("adminorg") != null && Objects.nonNull(parentOrg = importValidationModel.curBatchChgOrgInfoInDB.get(orgId = curRowData.getOpEntity().getLong("adminorg.id")).getDynamicObject("parentorg"))) {
            parentOrgId = parentOrg.getLong("id");
        }
        if (parentOrgId != 0L) {
            Map<String, Set<OrgNameBean>> nameMultiLangMap = importValidationModel.curBatchUnderParentOrgNameSetMap.get(parentOrgId);
            Map<String, Set<String>> applyingNameMultiLangMap = importValidationModel.applyingOrgNameUnderParent.get(parentOrgId);
            ILocaleString nameLocaleString = curRowData.getOpEntity().getLocaleString("name");
            DynamicObject finalParentOrg = parentOrg;
            nameLocaleString.forEach((code, nameVal) -> {
                Set nameSet;
                if (HRStringUtils.equalsIgnoreCase((String)"GLang", (String)code)) {
                    return;
                }
                if (nameMultiLangMap != null && (nameSet = (Set)nameMultiLangMap.get(code)) != null) {
                    Date effDate = importValidationModel.getEffDate();
                    if (HRStringUtils.equals((String)"homs_batchorgentityadd", (String)curRowData.getMainEntity())) {
                        effDate = curRowData.getOpEntity().getDate("establishmentdate");
                    }
                    if (effDate == null) {
                        effDate = new Date();
                    }
                    for (OrgNameBean orgNameBean : nameSet) {
                        if (!HRStringUtils.equals((String)nameVal, (String)orgNameBean.getName()) || effDate.compareTo(orgNameBean.getBsled()) > 0) continue;
                        errorList.add(new CalibratorBean("ImportCommonValidator_11", ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0b\u5df2\u5b58\u5728\u201c%2$s\u201d\u540d\u79f0\u201c%3$s\u201d\u7684\u884c\u653f\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539", (String)"ImportCommonValidator_11", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{finalParentOrg.getString("name"), MultiLangEnum.getName((String)code), nameVal}));
                        break;
                    }
                }
                if (applyingNameMultiLangMap != null && (nameSet = (Set)applyingNameMultiLangMap.get(code)) != null && nameSet.contains(nameVal)) {
                    errorList.add(new CalibratorBean("ImportCommonValidator_12", ResManager.loadKDString((String)"\u5728\u9014\u5355\u636e\u4e2d\u201c%1$s\u201d\u4e0b\u5df2\u5b58\u5728\u201c%2$s\u201d\u540d\u79f0\u201c%3$s\u201d\u7684\u884c\u653f\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539", (String)"ImportCommonValidator_12", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{finalParentOrg.getString("name"), MultiLangEnum.getName((String)code), nameVal}));
                }
            });
        }
    }

    private void infoOrgNameExistCheck(ImportValidationModel importValidationModel, List<CalibratorBean> errorList) {
        long orgId;
        MultiSheetRowData curRowData = ImportValidationModel.rowData.get();
        DynamicObject parentOrg = curRowData.getOpEntity().getDynamicObject("parentorg");
        long parentOrgId = 0L;
        if (parentOrg != null) {
            parentOrgId = parentOrg.getLong("id");
        } else if (!HRStringUtils.equals((String)curRowData.getMainEntity(), (String)"homs_batchorgentityadd") && curRowData.getOpEntity().getDynamicObject("adminorg") != null && Objects.nonNull(parentOrg = importValidationModel.curBatchChgOrgInfoInDB.get(orgId = curRowData.getOpEntity().getLong("adminorg.id")).getDynamicObject("parentorg"))) {
            parentOrgId = parentOrg.getLong("id");
        }
        if (parentOrgId != 0L) {
            Map<String, Set<OrgNameBean>> nameMultiLangMap = importValidationModel.curBatchUnderParentOrgNameSetMap.get(parentOrgId);
            Map<String, Set<String>> applyingNameMultiLangMap = importValidationModel.applyingOrgNameUnderParent.get(parentOrgId);
            ILocaleString nameLocaleString = curRowData.getOpEntity().getLocaleString("name");
            DynamicObject finalParentOrg = parentOrg;
            if (curRowData.getOpEntity().getDynamicObject("adminorg") == null) {
                return;
            }
            ILocaleString oldNameLocaleString = curRowData.getOpEntity().getDynamicObject("adminorg").getLocaleString("name");
            nameLocaleString.forEach((code, nameVal) -> {
                Set nameSet;
                if (HRStringUtils.equalsIgnoreCase((String)"GLang", (String)code)) {
                    return;
                }
                String oldName = (String)oldNameLocaleString.get(code);
                if (nameMultiLangMap != null && (nameSet = (Set)nameMultiLangMap.get(code)) != null) {
                    Date effDate = importValidationModel.getEffDate();
                    if (HRStringUtils.equals((String)"homs_batchorgentityadd", (String)curRowData.getMainEntity())) {
                        effDate = curRowData.getOpEntity().getDate("establishmentdate");
                    }
                    if (effDate == null) {
                        effDate = new Date();
                    }
                    for (OrgNameBean orgNameBean : nameSet) {
                        if (!HRStringUtils.equals((String)nameVal, (String)orgNameBean.getName()) || effDate.compareTo(orgNameBean.getBsled()) > 0 || HRStringUtils.equals((String)nameVal, (String)oldName)) continue;
                        errorList.add(new CalibratorBean("ImportCommonValidator_11", ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0b\u5df2\u5b58\u5728\u201c%2$s\u201d\u540d\u79f0\u201c%3$s\u201d\u7684\u884c\u653f\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539", (String)"ImportCommonValidator_11", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{finalParentOrg.getString("name"), MultiLangEnum.getName((String)code), nameVal}));
                        break;
                    }
                }
                if (applyingNameMultiLangMap != null && (nameSet = (Set)applyingNameMultiLangMap.get(code)) != null && nameSet.contains(nameVal) && !HRStringUtils.equals((String)nameVal, (String)oldName)) {
                    errorList.add(new CalibratorBean("ImportCommonValidator_12", ResManager.loadKDString((String)"\u5728\u9014\u5355\u636e\u4e2d\u201c%1$s\u201d\u4e0b\u5df2\u5b58\u5728\u201c%2$s\u201d\u540d\u79f0\u201c%3$s\u201d\u7684\u884c\u653f\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539", (String)"ImportCommonValidator_12", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{finalParentOrg.getString("name"), MultiLangEnum.getName((String)code), nameVal}));
                }
            });
        }
    }

    public boolean validatePerm(ImportValidationModel importValidationModel, Long orgId) {
        boolean flag = false;
        AuthorizedOrgResult permResult = importValidationModel.getPermResult();
        if (permResult == null) {
            return flag;
        }
        if (permResult.isHasAllOrgPerm()) {
            return true;
        }
        flag = !CollectionUtils.isEmpty((Collection)permResult.getHasPermOrgs()) && permResult.getHasPermOrgs().contains(orgId);
        return flag;
    }

    public boolean validateHrPerm(ImportValidationModel importValidationModel, Long orgId) {
        HasPermOrgResult hrPermResult = importValidationModel.getHrPermResult();
        if (hrPermResult == null) {
            return false;
        }
        if (hrPermResult.hasAllOrgPerm()) {
            return true;
        }
        DynamicObject dynamicObject = importValidationModel.curBatchChgOrgInfoInDB.get(orgId);
        if (dynamicObject == null) {
            logger.error(" importValidationModel.curBatchChgOrgInfoInDB can not find org info");
            return false;
        }
        long buId = dynamicObject.getLong("org.id");
        boolean flag = !CollectionUtils.isEmpty((Collection)hrPermResult.getHasPermOrgs()) && hrPermResult.getHasPermOrgs().contains(buId);
        return flag;
    }

    public boolean validatePermWithBu(ImportValidationModel importValidationModel, DynamicObject parentOrg) {
        boolean flag = false;
        long org = importValidationModel.getOrg();
        AuthorizedOrgResult permResult = importValidationModel.getPermResult();
        if (permResult == null) {
            return flag;
        }
        DynamicObject dynamicObject = importValidationModel.curBatchChgOrgInfoInDB.get(parentOrg.getLong("id"));
        if (dynamicObject == null) {
            logger.error(" importValidationModel.curBatchChgOrgInfoInDB can not find org info");
            return flag;
        }
        long buId = dynamicObject.getLong("org.id");
        return buId == 0L || buId == org;
    }

    public void whetherPropChangedCheck(ImportValidationModel importValidationModel, List<CalibratorBean> errorList) {
        MultiSheetRowData curRowData = ImportValidationModel.rowData.get();
        DynamicObject opEntity = curRowData.getOpEntity();
        DynamicObject curOrg = opEntity.getDynamicObject("adminorg");
        if (curOrg == null) {
            return;
        }
        DynamicObject oldOrgInfo = importValidationModel.curBatchChgOrgInfoInDB.get(curOrg.getLong("id"));
        ImportBillData billData = curRowData.getBillData();
        JSONObject importData = billData.getData().getJSONObject("data").getJSONObject(curRowData.getMainEntity());
        DynamicObjectType dynamicObjectType = oldOrgInfo.getDynamicObjectType();
        AtomicBoolean hashChanged = new AtomicBoolean(false);
        importData.forEach((prop, data) -> {
            if (hashChanged.get()) {
                return;
            }
            if (HRStringUtils.equals((String)prop, (String)"adminorg") || HRStringUtils.equals((String)prop, (String)"changedescription")) {
                return;
            }
            if (this.hasProp(dynamicObjectType, (String)prop)) {
                DynamicProperty property = dynamicObjectType.getProperty(prop);
                if (property instanceof BasedataProp) {
                    if (oldOrgInfo.getDynamicObject(prop) == null) {
                        hashChanged.set(true);
                        return;
                    }
                    if (!OrgBatchBillCheckHelper.dynIsSame((DynamicObject)opEntity.getDynamicObject(prop), (DynamicObject)oldOrgInfo.getDynamicObject(prop))) {
                        hashChanged.set(true);
                    }
                } else if (property instanceof MuliLangTextProp) {
                    Map multiLangData = (Map)data;
                    ILocaleString oldLocaleString = oldOrgInfo.getLocaleString(prop);
                    Optional.of(multiLangData).ifPresent(impMultiLangData -> impMultiLangData.forEach((code, val) -> {
                        if (HRStringUtils.equalsIgnoreCase((String)val, (String)"null") && HRStringUtils.isNotEmpty((String)((String)oldLocaleString.get(code))) || !HRStringUtils.equals((String)val, (String)((String)oldLocaleString.get(code)))) {
                            hashChanged.set(true);
                        }
                    }));
                } else {
                    String oldPropValue;
                    String curPropValue = opEntity.getString(prop);
                    if (!HRStringUtils.equals((String)curPropValue, (String)(oldPropValue = oldOrgInfo.getString(prop)))) {
                        hashChanged.set(true);
                    }
                }
            }
        });
        if (!hashChanged.get()) {
            errorList.add(new CalibratorBean("ImportCommonValidator_22", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u4fe1\u606f\u672a\u53d1\u751f\u4efb\u4f55\u53d8\u5316", (String)"ImportCommonValidator_22", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[0]));
        }
    }

    private boolean isMultiLangeFieldPropChanged(ILocaleString oldLocaleString, Map<String, String> multiLangData) {
        AtomicBoolean hashChanged = new AtomicBoolean(false);
        if (multiLangData != null) {
            multiLangData.forEach((code, val) -> {
                if (HRStringUtils.equalsIgnoreCase((String)val, (String)"null") && HRStringUtils.isNotEmpty((String)((String)oldLocaleString.get(code))) || !HRStringUtils.equals((String)val, (String)((String)oldLocaleString.get(code)))) {
                    hashChanged.set(true);
                }
            });
        }
        return hashChanged.get();
    }

    private boolean hasProp(DynamicObjectType dynamicObjectType, String prop) {
        return dynamicObjectType.getProperties().stream().map(IMetadata::getName).anyMatch(p -> p.equals(prop));
    }

    public List<CalibratorBean> doParentOrgCheck(ImportValidationModel importValidationModel, Long changeTypeId) {
        DynamicObject parentOrg = ImportValidationModel.rowData.get().getOpEntity().getDynamicObject("parentorg");
        String parentOrgName = ImportValidationModel.importValidationOrgBO.get().getParentOrgName();
        String parentOrgNumber = ImportValidationModel.importValidationOrgBO.get().getParentOrgNumber();
        ArrayList errorList = Lists.newArrayListWithCapacity((int)1);
        if (parentOrg != null) {
            long oldParentOrgId;
            DynamicObject curOrg;
            OrgInfoVO orgInfoVO;
            DynamicObject parentOrgDyn;
            long parentOrgId = parentOrg.getLong("id");
            Set<Long> orgIdSet = importValidationModel.applyingChgTypeOrgMap.get(ImportConstants.CHANGE_TYPE_DISABLE);
            if (orgIdSet != null && orgIdSet.contains(parentOrgId)) {
                errorList.add(new CalibratorBean("ImportCommonValidator_25", ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u5b58\u5728\u5728\u9014\u5355\u505c\u7528\u4e1a\u52a1\uff0c\u8bf7\u4fee\u6539", (String)"ImportCommonValidator_25", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[0]));
            }
            if (importValidationModel.stopUseOrgInCurExcel.contains(parentOrgId)) {
                errorList.add(new CalibratorBean("ParentChgImportValidator_0", ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u5728\u672c\u5355\u5df2\u505c\u7528\uff0c\u8bf7\u4fee\u6539", (String)"ParentChgImportValidator_0", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[0]));
            }
            if (!this.validatePerm(importValidationModel, parentOrgId)) {
                errorList.add(new CalibratorBean("ParentChgImportValidator_3", ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u201c%s\u201d\u4e0d\u5728\u7528\u6237\u6743\u9650\u8303\u56f4\u5185\uff0c\u8bf7\u4fee\u6539", (String)"ParentChgImportValidator_3", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{parentOrgNumber + "/" + parentOrg.getString("name")}));
            }
            if (!this.validateHrPerm(importValidationModel, parentOrgId)) {
                errorList.add(new CalibratorBean("ParentChgImportValidator_3", ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u201c%s\u201d\u4e0d\u5728\u7528\u6237\u6743\u9650\u8303\u56f4\u5185\uff0c\u8bf7\u4fee\u6539", (String)"ParentChgImportValidator_3", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{parentOrgNumber + "/" + parentOrg.getString("name")}));
            }
            if ((parentOrgDyn = importValidationModel.parentBoIdToDyn.get(parentOrgId)) != null && "true".equals(parentOrgDyn.getString("isvirtualorg"))) {
                errorList.add(new CalibratorBean("ImportCommonValidator_29", ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u4e3a\u865a\u62df\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539", (String)"ImportCommonValidator_29", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[0]));
            }
            if (!ImportConstants.CHANGE_TYPE_PARENT.equals(changeTypeId)) {
                if (parentOrgDyn != null) {
                    if (!SystemParamHelper.getAllowTobeDisableChg((Long)importValidationModel.getOrg()) && parentOrgDyn.getBoolean("tobedisableflag")) {
                        errorList.add(new CalibratorBean("ParentChgImportValidator_4", ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u201c%s\u201d\u4e3a\u5f85\u505c\u7528\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u5728\u8be5\u7ec4\u7ec7\u4e0b\u65b0\u589e\u7ec4\u7ec7", (String)"ParentChgImportValidator_4", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{parentOrgDyn.getString("name")}));
                    }
                    if (!SystemParamHelper.getAllowTobeDisableChg((Long)importValidationModel.getOrg()) && importValidationModel.inCurCellTobeDiSabledOrg.contains(parentOrg.getLong("id"))) {
                        errorList.add(new CalibratorBean("ParentChgImportValidator_9", ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u201c%s\u201d\u5728\u672c\u5355\u4e2d\u5df2\u8bbe\u7f6e\u4e3a\u5f85\u505c\u7528\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u5728\u8be5\u7ec4\u7ec7\u4e0b\u65b0\u589e\u7ec4\u7ec7", (String)"ParentChgImportValidator_9", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{parentOrgDyn.getString("name")}));
                    }
                }
                if (!SystemParamHelper.getAllowTobeDisableChg((Long)importValidationModel.getOrg()) && importValidationModel.inWayOrgBoIdMap.containsKey(parentOrgId) && parentOrgDyn != null && (orgInfoVO = importValidationModel.inWayOrgBoIdMap.get(parentOrgId)) != null && orgInfoVO.getDy() != null && !HRStringUtils.isEmpty((String)orgInfoVO.getBillNo()) && orgInfoVO.getDy().getBoolean("tobedisableflag")) {
                    errorList.add(new CalibratorBean("ParentChgImportValidator_6", ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u201c%1$s\u201d\u5728\u5728\u9014\u5355\u636e\uff08\u7f16\u53f7\uff1a%2$s\uff09\u4e2d\u5df2\u8bbe\u7f6e\u4e3a\u5f85\u505c\u7528\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u5728\u8be5\u7ec4\u7ec7\u4e0b\u65b0\u589e\u7ec4\u7ec7", (String)"ParentChgImportValidator_6", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{parentOrgDyn.getString("name"), importValidationModel.inWayOrgBoIdMap.get(parentOrgId).getBillNo()}));
                }
            }
            if (!ImportConstants.CHANGE_TYPE_PARENT.equals(changeTypeId)) {
                return errorList;
            }
            if (parentOrgDyn != null) {
                if (!SystemParamHelper.getAllowTobeDisableChg((Long)importValidationModel.getOrg()) && parentOrgDyn.getBoolean("tobedisableflag")) {
                    errorList.add(new CalibratorBean("ParentChgImportValidator_5", ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u201c%s\u201d\u4e3a\u5f85\u505c\u7528\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u8c03\u6574\u5230\u8be5\u7ec4\u7ec7\u4e0b", (String)"ParentChgImportValidator_5", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{parentOrgDyn.getString("name")}));
                }
                if (!SystemParamHelper.getAllowTobeDisableChg((Long)importValidationModel.getOrg()) && importValidationModel.inCurCellTobeDiSabledOrg.contains(parentOrg.getLong("id"))) {
                    errorList.add(new CalibratorBean("ParentChgImportValidator_8", ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u201c%s\u201d\u5728\u672c\u5355\u4e2d\u5df2\u8bbe\u7f6e\u4e3a\u5f85\u505c\u7528\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u8c03\u6574\u5230\u8be5\u7ec4\u7ec7\u4e0b", (String)"ParentChgImportValidator_8", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{parentOrgDyn.getString("name")}));
                }
            }
            if (parentOrgDyn != null && !SystemParamHelper.getAllowTobeDisableChg((Long)importValidationModel.getOrg()) && importValidationModel.inWayOrgBoIdMap.containsKey(parentOrgId) && (orgInfoVO = importValidationModel.inWayOrgBoIdMap.get(parentOrgId)) != null && orgInfoVO.getDy() != null && orgInfoVO.getDy().getBoolean("tobedisableflag")) {
                errorList.add(new CalibratorBean("ParentChgImportValidator_7", ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u201c%1$s\u201d\u5728\u5728\u9014\u5355\u636e\uff08\u7f16\u53f7\uff1a%2$s\uff09\u4e2d\u5df2\u8bbe\u7f6e\u4e3a\u5f85\u505c\u7528\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u8c03\u6574\u5230\u8be5\u7ec4\u7ec7\u4e0b", (String)"ParentChgImportValidator_7", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{parentOrgDyn.getString("name"), importValidationModel.inWayOrgBoIdMap.get(parentOrgId).getBillNo()}));
            }
            if ((curOrg = ImportValidationModel.rowData.get().getOpEntity().getDynamicObject("adminorg")) != null && parentOrgId == (oldParentOrgId = importValidationModel.curBatchChgOrgInfoInDB.get(curOrg.getLong("id")).getLong("parentorg.id"))) {
                errorList.add(new CalibratorBean("ParentChgImportValidator_2", ResManager.loadKDString((String)"\u8c03\u6574\u540e\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u672a\u53d8\u5316", (String)"ParentChgImportValidator_2", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[0]));
            }
        } else if (HRStringUtils.isNotEmpty((String)parentOrgNumber) && !HRStringUtils.equalsIgnoreCase((String)"null", (String)parentOrgNumber)) {
            Pair<String, String> pair = null;
            for (Pair<String, String> numberNamePair : importValidationModel.newAddOrgNumberNamePairMap.keySet()) {
                if (!HRStringUtils.equals((String)parentOrgNumber, (String)((String)numberNamePair.getKey()))) continue;
                pair = numberNamePair;
                break;
            }
            if (pair == null) {
                errorList.add(new CalibratorBean("ParentChgImportValidator_1", ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u5df2\u505c\u7528\u6216\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539", (String)"ParentChgImportValidator_1", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[0]));
            } else if (!HRStringUtils.isEmpty((String)parentOrgName) && !HRStringUtils.equals((String)((String)pair.getValue()), (String)parentOrgName)) {
                errorList.add(new CalibratorBean("ImportCommonValidator_24", ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7684\u7f16\u7801\u548c\u540d\u79f0\u4e0d\u5339\u914d", (String)"ImportCommonValidator_24", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[0]));
            }
        }
        return errorList;
    }

    public List<CalibratorBean> baseDataWithBuCheck(ImportValidationModel importValidationModel) {
        ArrayList errorList = Lists.newArrayListWithCapacity((int)1);
        MultiSheetRowData multiSheetRowData = ImportValidationModel.rowData.get();
        DynamicObject opEntity = multiSheetRowData.getOpEntity();
        MultiSheetImportHelper.type2EntityType.forEach((key, value) -> {
            long id;
            if (opEntity.containsProperty(key) && (id = opEntity.getLong(key + ".id")) != 0L && !importValidationModel.getEntity2BaseData().get(value).contains(id)) {
                String type = ResManager.loadKDString((String)((String)OrgBatchBaseDataWithBuCheckServiceImpl.descriptionMap.get(key)), (String)((String)OrgBatchBaseDataWithBuCheckServiceImpl.resourceMap.get(key)), (String)"odc-homs-business", (Object[])new Object[0]);
                errorList.add(new CalibratorBean("ImportCommonValidator_26", ResManager.loadKDString((String)"\u201c%1$s\u201d\u5bfc\u5165\u5931\u8d25\uff0c\u53ef\u80fd\u7684\u539f\u56e0\uff1a1\u3001\u7f16\u7801\u4e0d\u51c6\u786e\uff1b2\u3001\u4e0d\u7b26\u5408\u57fa\u7840\u8d44\u6599\u67e5\u8be2\u6761\u4ef6\uff1b3\u3001\u8be5\u57fa\u7840\u8d44\u6599\u5728\u4f7f\u7528\u7ec4\u7ec7\u201c%2$s\u201d\u6216\u5176\u4e0b\u7ea7\u7ec4\u7ec7\u4e2d\u4e0d\u5b58\u5728\u6216\u6ca1\u6709\u4f7f\u7528\u6743\u9650\u3002", (String)"ImportCommonValidator_26", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{type, opEntity.getString(key + ".name"), importValidationModel.getOrgName()}));
            }
        });
        return errorList;
    }

    public List<CalibratorBean> doMergeOrgCheck(ImportValidationModel importValidationModel) {
        DynamicObject opEntity = ImportValidationModel.rowData.get().getOpEntity();
        DynamicObject afterMergeOrg = opEntity.getDynamicObject("aftermerge_org");
        DynamicObjectCollection beforeMergeOrgs = opEntity.getDynamicObjectCollection("beforemerge_org");
        ArrayList errorList = Lists.newArrayListWithCapacity((int)1);
        DataEntityPropertyCollection properties = MetadataServiceHelper.getDataEntityType((String)"homs_batchorgmerge").getProperties();
        if (afterMergeOrg == null) {
            String propDisplayName = ((IDataEntityProperty)properties.get((Object)"aftermerge_org")).getDisplayName().getLocaleValue();
            String afterMergeName = ImportValidationModel.importValidationOrgBO.get().getAfterMergeName();
            String afterMergeNumber = ImportValidationModel.importValidationOrgBO.get().getAfterMergeNumber();
            this.checkOrgBillSatus(errorList, afterMergeNumber, afterMergeName, importValidationModel, propDisplayName);
        } else if (importValidationModel.stopUseOrgInCurExcel.contains(afterMergeOrg.getLong("id"))) {
            errorList.add(new CalibratorBean("MergeImportValidator_1", ResManager.loadKDString((String)"\u201c%1$s\u201d/\u201c%2$s\u201d\u5df2\u5b58\u5728\u505c\u7528\u7ec4\u7ec7\u4e2d\uff0c\u4e0d\u5141\u8bb8\u5408\u5e76\u7ec4\u7ec7", (String)"MergeImportValidator_1", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{afterMergeOrg.getString("number"), afterMergeOrg.getString("name")}));
        }
        String beforeMergeName = ImportValidationModel.importValidationOrgBO.get().getBeforeMergeName();
        String beforeMergeNumber = ImportValidationModel.importValidationOrgBO.get().getBeforeMergeNumber();
        String propDisplayName = ((IDataEntityProperty)properties.get((Object)"beforemerge_org")).getDisplayName().getLocaleValue();
        ImportCommonValidator.mulOrgStatusCheck(errorList, beforeMergeOrgs, beforeMergeNumber, beforeMergeName, importValidationModel, propDisplayName);
        return errorList;
    }

    public List<CalibratorBean> doSplitOrgCheck(ImportValidationModel importValidationModel) {
        DynamicObject opEntity = ImportValidationModel.rowData.get().getOpEntity();
        DynamicObject beforeSplitOrg = opEntity.getDynamicObject("beforesplit_org");
        DynamicObjectCollection afterSplitOrgs = opEntity.getDynamicObjectCollection("aftersplit_org");
        ArrayList errorList = Lists.newArrayListWithCapacity((int)1);
        DataEntityPropertyCollection properties = MetadataServiceHelper.getDataEntityType((String)"homs_batchorgsplit").getProperties();
        if (beforeSplitOrg == null) {
            String propDisplayName = ((IDataEntityProperty)properties.get((Object)"beforesplit_org")).getDisplayName().getLocaleValue();
            String afterSplitName = ImportValidationModel.importValidationOrgBO.get().getBeforeSplitName();
            String afterSplitNumber = ImportValidationModel.importValidationOrgBO.get().getBeforeSplitNumber();
            this.checkOrgBillSatus(errorList, afterSplitNumber, afterSplitName, importValidationModel, propDisplayName);
        }
        String afterSplitName = ImportValidationModel.importValidationOrgBO.get().getAfterSplitName();
        String afterSplitNumber = ImportValidationModel.importValidationOrgBO.get().getAfterSplitNumber();
        String propDisplayName = ((IDataEntityProperty)properties.get((Object)"aftersplit_org")).getDisplayName().getLocaleValue();
        ImportCommonValidator.mulOrgStatusCheck(errorList, afterSplitOrgs, afterSplitNumber, afterSplitName, importValidationModel, propDisplayName);
        for (DynamicObject afterSplitOrg : afterSplitOrgs) {
            if (!importValidationModel.stopUseOrgInCurExcel.contains(afterSplitOrg.getLong("id"))) continue;
            errorList.add(new CalibratorBean("SplitImportValidator_1", ResManager.loadKDString((String)"\u201c%1$s\u201d/\u201c%2$s\u201d\u5df2\u5b58\u5728\u505c\u7528\u7ec4\u7ec7\u4e2d\uff0c\u4e0d\u5141\u8bb8\u62c6\u5206\u7ec4\u7ec7", (String)"SplitImportValidator_1", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{afterSplitOrg.getString("number"), afterSplitOrg.getString("name")}));
        }
        return errorList;
    }

    private void checkOrgBillSatus(List<CalibratorBean> errorList, String number, String name, ImportValidationModel importValidationModel, String propDisplayName) {
        if (HRStringUtils.isNotEmpty((String)number) && !HRStringUtils.equalsIgnoreCase((String)"null", (String)number)) {
            Pair<String, String> pair = null;
            for (Pair<String, String> numberNamePair : importValidationModel.newAddOrgNumberNamePairMap.keySet()) {
                if (!HRStringUtils.equals((String)number, (String)((String)numberNamePair.getKey()))) continue;
                pair = numberNamePair;
                break;
            }
            if (pair == null) {
                errorList.add(new CalibratorBean("MultiEntityQueryBaseData_2", ResManager.loadKDString((String)"%s\u5df2\u505c\u7528\u6216\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539", (String)"MultiEntityQueryBaseData_2", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{propDisplayName}));
            } else if (!HRStringUtils.isEmpty((String)name) && !HRStringUtils.equals((String)((String)pair.getValue()), (String)name)) {
                errorList.add(new CalibratorBean("MultiEntityQueryBaseData_1", ResManager.loadKDString((String)"%s\u7684\u7f16\u7801\u548c\u540d\u79f0\u4e0d\u5339\u914d", (String)"MultiEntityQueryBaseData_1", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{propDisplayName}));
            }
        }
    }

    private static void mulOrgStatusCheck(List<CalibratorBean> errorList, DynamicObjectCollection orgDys, String numberStr, String nameStr, ImportValidationModel importValidationModel, String propDisplayName) {
        Map<String, String> orgNameNumberMap = orgDys.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getString("number"), dynamicObject -> dynamicObject.getString("name")));
        if (HRStringUtils.isEmpty((String)numberStr)) {
            return;
        }
        String[] nameArr = StringUtils.isEmpty((Object)nameStr) ? new String[]{} : nameStr.split(",");
        String[] numberArr = numberStr.split(",");
        HashMap<Object, Object> addOrgMap = new HashMap<Object, Object>(importValidationModel.newAddOrgNumberNamePairMap.size());
        for (Pair<String, String> numberNamePair : importValidationModel.newAddOrgNumberNamePairMap.keySet()) {
            addOrgMap.put(numberNamePair.getKey(), numberNamePair.getValue());
        }
        if (nameArr.length != 0) {
            if (nameArr.length != numberArr.length) {
                errorList.add(new CalibratorBean("MultiEntityQueryBaseData_1", ResManager.loadKDString((String)"%s\u7684\u7f16\u7801\u548c\u540d\u79f0\u4e0d\u5339\u914d", (String)"MultiEntityQueryBaseData_1", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{propDisplayName}));
            } else {
                for (int i = 0; i < numberArr.length; ++i) {
                    String name = nameArr[i];
                    String number = numberArr[i];
                    if ((!orgNameNumberMap.containsKey(number) || HRStringUtils.equals((String)name, (String)orgNameNumberMap.get(number))) && (!addOrgMap.containsKey(number) || HRStringUtils.equals((String)name, (String)((String)addOrgMap.get(number))))) continue;
                    errorList.add(new CalibratorBean("MultiEntityQueryBaseData_1", ResManager.loadKDString((String)"%s\u7684\u7f16\u7801\u548c\u540d\u79f0\u4e0d\u5339\u914d", (String)"MultiEntityQueryBaseData_1", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{propDisplayName}));
                }
            }
        }
        for (int i = 0; i < numberArr.length; ++i) {
            String orgNumber = numberArr[i];
            if (orgNameNumberMap.containsKey(orgNumber) || addOrgMap.containsKey(orgNumber)) continue;
            errorList.add(new CalibratorBean("MultiEntityQueryBaseData_2", ResManager.loadKDString((String)"%s\u5df2\u505c\u7528\u6216\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539", (String)"MultiEntityQueryBaseData_2", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{orgNumber}));
        }
    }
}

