/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.impo.impvalidator;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.archive.ArchiveRoute;
import kd.bos.db.archive.LogicArchiveRoute;
import kd.bos.db.pktemptable.config.PKTempTableConfig;
import kd.bos.db.pktemptable.service.AbstractPKTempTable;
import kd.bos.db.pktemptable.service.PKTempTableServiceFactory;
import kd.bos.db.temptable.pk.PKTempTable;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.fs.util.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.hugein.HugeInConfig;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.haos.business.service.adminorg.AdminOrgHisServiceHelper;
import kd.hr.haos.business.service.adminorg.bean.Pair;
import kd.hr.haos.business.util.BaseDataHelper;
import kd.hr.haos.common.constants.structproject.StructProjectConstants;
import kd.hr.haos.common.util.tree.TreeAssistUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.helper.AdminOrgBatchChgHelper;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckConstants;
import kd.hr.homs.common.constants.impo.ImportConstants;
import kd.hr.homs.common.model.OrgNameBean;
import kd.hr.homs.formplugin.web.impo.importdata.MultiSheetRowData;
import kd.hr.homs.formplugin.web.impo.impvalidator.ImportValidationModel;
import kd.hr.homs.formplugin.web.impo.impvalidator.ImportValidationOrgBO;
import kd.hr.homs.formplugin.web.impo.impvalidator.OrgInfoVO;

public class ImportValidationHelper {
    private static final Log LOG = LogFactory.getLog(ImportValidationHelper.class);

    public static Set<String> getStopUseOrgNumbers() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter qFilter = new QFilter("enable", "=", (Object)"0");
        qFilter.and("iscurrentversion", "=", (Object)"1");
        DynamicObject[] dynamicObjects = serviceHelper.query("number", new QFilter[]{qFilter});
        Set<String> orgNumbers = Arrays.stream(dynamicObjects).map(dy -> dy.getString("number")).collect(Collectors.toSet());
        HRBaseServiceHelper orgChgBillServiceHelper = new HRBaseServiceHelper("homs_orgbatchchgbill");
        QFilter auditFilter = new QFilter("auditstatus", "in", Arrays.asList("D", "B"));
        Object[] orgChgBill = orgChgBillServiceHelper.query("id", new QFilter[]{auditFilter});
        if (ObjectUtils.isEmpty((Object[])orgChgBill)) {
            return orgNumbers;
        }
        List chgBillIdList = Arrays.stream(orgChgBill).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        HRBaseServiceHelper orgChgEntryServiceHelper = new HRBaseServiceHelper("homs_batchorgentity");
        QFilter billIdFilter = new QFilter("billid", "in", chgBillIdList);
        billIdFilter.and("changescene", "=", (Object)ImportConstants.CHANGE_TYPE_DISABLE);
        DynamicObject[] chgBillEntryDyns = orgChgEntryServiceHelper.query("adminorg", new QFilter[]{billIdFilter});
        Set numbers = Arrays.stream(chgBillEntryDyns).map(dy -> dy.getDynamicObject("adminorg").getString("number")).collect(Collectors.toSet());
        orgNumbers.addAll(numbers);
        return orgNumbers;
    }

    public static Map<String, DynamicObject> getEffectOrg(int enable) {
        String selectFields = "id,name,number,adminorgtype.number,enable,tobedisableflag,parentorg.name,parentorg.id,parentorg.number";
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter filter = new QFilter("enable", "=", (Object)enable);
        filter.and("iscurrentversion", "=", (Object)"1");
        DynamicObject[] orgs = serviceHelper.queryOriginalArray(selectFields, new QFilter[]{filter});
        HashMap<String, DynamicObject> effectOrgs = new HashMap<String, DynamicObject>();
        for (DynamicObject org : orgs) {
            String name = org.getString("number");
            if (!StringUtils.isNotEmpty((String)name)) continue;
            effectOrgs.put(name, org);
        }
        return effectOrgs;
    }

    public static Map<String, List<DynamicObject>> getHisEnableOrgs(Date queryDate) {
        String selectFields = "id,name,number,adminorgtype.number,enable,tobedisableflag,parentorg.name,parentorg.id,parentorg.number";
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        QFilter hisQFilter = AdminOrgHisServiceHelper.queryHisQFilter((Date)queryDate, (boolean)true);
        DynamicObject[] orgs = serviceHelper.queryOriginalArray(selectFields, new QFilter[]{filter, hisQFilter});
        return Arrays.stream(orgs).collect(Collectors.groupingBy(dy -> dy.getString("number")));
    }

    public static Map<String, List<DynamicObject>> queryExistNumber(Set<String> numberSet) {
        long startTimeStamp = System.currentTimeMillis();
        if (CollectionUtils.isEmpty(numberSet)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter numberFilter = new QFilter("number", "in", numberSet);
        QFilter versionFilter = new QFilter("iscurrentversion", "in", (Object)"0");
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Arrays.asList("1", "2"));
        DynamicObject[] objects = serviceHelper.queryOriginalArray("number,bsed,bsled", new QFilter[]{numberFilter, dataStatusFilter, versionFilter});
        LOG.info(String.format(Locale.ROOT, "ImportValidationHelper.queryExistNumber() cost %s milliseconds", System.currentTimeMillis() - startTimeStamp));
        return Arrays.stream(objects).collect(Collectors.groupingBy(dy -> dy.getString("number")));
    }

    public static Map<Long, Map<String, Set<OrgNameBean>>> queryExistName(Set<String> nameSet, Date queryDate) {
        if (CollectionUtils.isEmpty(nameSet)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        long startTimeStamp = System.currentTimeMillis();
        Map<Long, Set<Pair<String, String>>> orgNameMap = ImportValidationHelper.getAdminOrgIdNameMap(nameSet);
        if (CollectionUtils.isEmpty(orgNameMap)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter idFilter = new QFilter("id", "in", orgNameMap.keySet());
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Arrays.asList("1", "2"));
        Object[] dynamicObjects = serviceHelper.queryOriginalArray("id,parentorg.id,bsed,bsled", new QFilter[]{idFilter, enableFilter, dataStatusFilter});
        if (ObjectUtils.isEmpty((Object[])dynamicObjects)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)dynamicObjects.length);
        for (Object dynamicObject : dynamicObjects) {
            long orgId = dynamicObject.getLong("id");
            long parentOrgId = dynamicObject.getLong("parentorg.id");
            orgNameMap.get(orgId).forEach(arg_0 -> ImportValidationHelper.lambda$queryExistName$7(result, parentOrgId, (DynamicObject)dynamicObject, arg_0));
        }
        LOG.info(String.format(Locale.ROOT, "ImportValidationHelper.queryExistName() cost %s milliseconds", System.currentTimeMillis() - startTimeStamp));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Long, Set<Pair<String, String>>> getAdminOrgIdNameMap(Set<String> nameSet) {
        HashMap orgNameMap;
        StringBuilder sqlBuilder = new StringBuilder("SELECT FID AS ID,FLOCALEID AS LOCALEID,FNAME AS NAME FROM T_HAOS_ADMINORG_L WHERE FNAME IN (");
        Object[] params = null;
        AbstractPKTempTable abstractTempTable = null;
        PKTempTable tempTable = null;
        DataSet rs = null;
        try {
            DBRoute dbRoute = new DBRoute("hr");
            DBRoute ofRoute = DBRoute.of((String)LogicArchiveRoute.of((String)ArchiveRoute.getMapRoute((String)dbRoute.getRouteKey())).getRealArchiveKey());
            LOG.info("of db route :\t" + ofRoute.toString());
            if (nameSet.size() > HugeInConfig.inThreshold()) {
                if (PKTempTableConfig.isNewVersion()) {
                    abstractTempTable = PKTempTableServiceFactory.getService((DBRoute)dbRoute).createPKBigString(true);
                    abstractTempTable.insert(nameSet);
                    sqlBuilder.append(" SELECT FID FROM ").append(abstractTempTable.getName()).append(" WHERE ").append(abstractTempTable.getVersionFieldName()).append(" = ").append(abstractTempTable.getVersion());
                } else {
                    tempTable = PKTempTable.createPKBigString((DBRoute)dbRoute);
                    tempTable.insert(nameSet);
                    sqlBuilder.append("SELECT FID FROM ").append(tempTable.getTable());
                }
            } else {
                nameSet.forEach(n -> sqlBuilder.append("?,"));
                sqlBuilder.deleteCharAt(sqlBuilder.length() - 1);
                params = nameSet.toArray();
            }
            sqlBuilder.append(")");
            orgNameMap = Maps.newHashMapWithExpectedSize((int)4);
            rs = HRDBUtil.queryDataSet((String)"ImportValidationHelper.queryExistName", (DBRoute)dbRoute, (String)sqlBuilder.toString(), (Object[])params);
            while (rs.hasNext()) {
                Row row = rs.next();
                orgNameMap.computeIfAbsent(row.getLong("id"), k -> Sets.newHashSetWithExpectedSize((int)2)).add(new Pair((Object)row.getString("localeid"), (Object)row.getString("name")));
            }
        }
        finally {
            if (tempTable != null) {
                tempTable.close();
            }
            if (abstractTempTable != null) {
                abstractTempTable.close();
            }
            if (rs != null) {
                rs.close();
            }
        }
        return orgNameMap;
    }

    public static Map<Long, DynamicObject> batchQueryOrgInfoByIds(Set<Long> orgIdSet) {
        if (CollectionUtils.isEmpty(orgIdSet)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        long startTimeStamp = System.currentTimeMillis();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter orgIdFilter = new QFilter("id", "in", orgIdSet);
        QFilter versionFilter = new QFilter("iscurrentversion", "in", (Object)"1");
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)"1");
        DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray(new QFilter[]{orgIdFilter, versionFilter, dataStatusFilter});
        Map<Long, DynamicObject> objectMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        Map curBatchOrg4LayerModelBOMap = OrgBatchBillCheckHelper.batchQueryOrgCompDepGroupInfo(objectMap.keySet());
        curBatchOrg4LayerModelBOMap.forEach((orgId, org4LayerModelBO) -> {
            DynamicObject orgDyn = (DynamicObject)objectMap.get(orgId);
            for (String fieldKey : OrgBatchCheckConstants.INFOCHG_CHECK_COMPANY_GROUP_FIELD) {
                Optional.ofNullable(org4LayerModelBO.getPropValue(fieldKey)).ifPresent(fieldVal -> orgDyn.set(fieldKey, fieldVal));
            }
        });
        LOG.info(String.format(Locale.ROOT, "ImportValidationHelper.batchQueryOrgInfoByIds() cost %s milliseconds, and the size of orgId is: %s", System.currentTimeMillis() - startTimeStamp, orgIdSet.size()));
        return objectMap;
    }

    public static Map<Long, DynamicObject> queryBaseDataInfo(String entityNumber, String selectProperties, long orgId, boolean includeDisable) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        if (includeDisable) {
            enable = new QFilter("enable", "in", Arrays.asList("1", "0"));
        }
        if (orgId != 0L) {
            enable.and(BaseDataHelper.getBaseDataFilter((String)entityNumber, (long)orgId));
        }
        DynamicObject[] objects = serviceHelper.query(selectProperties, new QFilter[]{enable});
        return Arrays.stream(objects).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
    }

    public static DynamicObject[] queryApplyingChangeOrgInfo(Map<Long, String> billIdNoMap) {
        DynamicObject[] dynamicObjects = null;
        Object[] applyingBillObjects = ImportValidationHelper.queryApplyingChangeBill();
        if (ObjectUtils.isEmpty((Object[])applyingBillObjects)) {
            return dynamicObjects;
        }
        billIdNoMap.putAll(Arrays.stream(applyingBillObjects).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("billno"))));
        HRBaseServiceHelper billEntryServiceHelper = new HRBaseServiceHelper("homs_batchorgentity");
        QFilter billIdFilter = new QFilter("billid", "in", billIdNoMap.keySet());
        dynamicObjects = billEntryServiceHelper.query("changetype,name,number,adminorg.boid,parentorg.boid,adminorgtype,billid,tobedisableflag", new QFilter[]{billIdFilter});
        return dynamicObjects;
    }

    public static DynamicObject[] queryApplyingChangeBill() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("homs_orgbatchchgbill");
        QFilter qFilter = new QFilter("auditstatus", "in", Arrays.asList("D", "B"));
        return serviceHelper.query("id,billno,effdt", new QFilter[]{qFilter});
    }

    public static void constructApplyingChgInfos(Set<String> applyingOrgNumbers, Map<Long, Map<String, Set<String>>> applyingOrgNameUnderParent, Map<Long, Set<Long>> applyingChgSceneOrgMap, Map<String, Set<Long>> billNoOrgMap, Map<Long, OrgInfoVO> applyingChgOrgMap, Map<Long, OrgInfoVO> inWayOrgBoIdMap) {
        HashMap billIdNoMap = Maps.newHashMapWithExpectedSize((int)4);
        DynamicObject[] applyingChangeOrgInfo = ImportValidationHelper.queryApplyingChangeOrgInfo(billIdNoMap);
        if (applyingChangeOrgInfo == null) {
            return;
        }
        for (DynamicObject dynamicObject : applyingChangeOrgInfo) {
            long parentOrgId;
            long changeTypeId;
            String billNo = (String)billIdNoMap.get(dynamicObject.getLong("billid"));
            applyingChgOrgMap.put(dynamicObject.getLong("adminorg.boid"), new OrgInfoVO(dynamicObject, billNo));
            inWayOrgBoIdMap.put(dynamicObject.getLong("adminorg.boid"), new OrgInfoVO(dynamicObject, billNo));
            String number = dynamicObject.getString("number");
            if (HRStringUtils.isNotEmpty((String)number)) {
                applyingOrgNumbers.add(number);
            }
            if ((changeTypeId = dynamicObject.getLong("changetype.id")) != 0L && changeTypeId != ImportConstants.CHANGE_TYPE_ADD_NEW) {
                long orgId = dynamicObject.getLong("adminorg.boid");
                HashSet orgIdSet = applyingChgSceneOrgMap.get(changeTypeId);
                if (orgIdSet == null) {
                    orgIdSet = Sets.newHashSetWithExpectedSize((int)16);
                }
                orgIdSet.add(orgId);
                applyingChgSceneOrgMap.put(changeTypeId, orgIdSet);
                HashSet orgIdUnderBillNO = billNoOrgMap.get(billNo);
                if (orgIdUnderBillNO == null) {
                    orgIdUnderBillNO = Sets.newHashSetWithExpectedSize((int)16);
                }
                orgIdUnderBillNO.add(orgId);
                billNoOrgMap.put(billNo, orgIdUnderBillNO);
            }
            if ((parentOrgId = dynamicObject.getLong("parentorg.boid")) == 0L) continue;
            ILocaleString nameLocaleString = dynamicObject.getLocaleString("name");
            nameLocaleString.forEach((code, nameVal) -> {
                Set nameSet;
                if (HRStringUtils.isEmpty((String)nameVal) || HRStringUtils.equalsIgnoreCase((String)code, (String)"GLang")) {
                    return;
                }
                Map nameMultiLangMap = (Map)applyingOrgNameUnderParent.get(parentOrgId);
                if (nameMultiLangMap == null) {
                    nameMultiLangMap = Maps.newHashMapWithExpectedSize((int)4);
                }
                if ((nameSet = (Set)nameMultiLangMap.get(code)) == null) {
                    nameSet = Sets.newHashSetWithExpectedSize((int)applyingChangeOrgInfo.length);
                }
                nameSet.add(nameVal);
                nameMultiLangMap.put(code, nameSet);
                applyingOrgNameUnderParent.put(parentOrgId, nameMultiLangMap);
            });
        }
    }

    public static void orgTypeAndTypeStdMap(Map<Long, Long> orgTypeAndTypeStdMap, Map<Long, List<String>> orgTypeStdIdAndTypeNameMap, Map<Long, DynamicObject> orgTypeMap, long orgId) {
        Map<Long, DynamicObject> adminOrgType = ImportValidationHelper.queryBaseDataInfo("haos_adminorgtype", "id,name,adminorgtypestd", 0L, true);
        adminOrgType.values().forEach(dyn -> {
            long orgTypeStdId = dyn.getLong("adminorgtypestd.id");
            long orgTypeId = dyn.getLong("id");
            orgTypeMap.put(orgTypeId, (DynamicObject)dyn);
            orgTypeAndTypeStdMap.put(orgTypeId, orgTypeStdId);
        });
        Map<Long, DynamicObject> adminOrgTypes = ImportValidationHelper.queryBaseDataInfo("haos_adminorgtype", "id,name,adminorgtypestd", orgId, false);
        HashMap map = Maps.newHashMapWithExpectedSize((int)orgTypeAndTypeStdMap.size());
        adminOrgTypes.values().forEach(dyn -> {
            long orgTypeStdId = dyn.getLong("adminorgtypestd.id");
            long orgTypeId = dyn.getLong("id");
            map.put(orgTypeId, orgTypeStdId);
            String orgTypeName = dyn.getString("name");
            List orgTypeNames = (List)orgTypeStdIdAndTypeNameMap.get(orgTypeStdId);
            if (orgTypeNames == null) {
                orgTypeNames = Lists.newArrayListWithCapacity((int)2);
            }
            orgTypeNames.add(orgTypeName);
            orgTypeStdIdAndTypeNameMap.put(orgTypeStdId, orgTypeNames);
        });
    }

    public static Pair<String, String> getCurOrgAndParentOrgPair(DynamicObject orgDyn, DynamicObject parentOrg, String entityNumber, String newNumber, JSONObject importData) {
        String orgNumber = null;
        String coopOrgNumber = null;
        if (HRStringUtils.equals((String)entityNumber, (String)"homs_batchorgentityadd")) {
            orgNumber = newNumber;
        } else if (orgDyn != null) {
            orgNumber = orgDyn.getString("number");
        }
        coopOrgNumber = parentOrg == null ? importData.getJSONObject("parentorg").getString("number") : parentOrg.getString("number");
        return new Pair((Object)orgNumber, (Object)coopOrgNumber);
    }

    public static String getParentOrgNumber(ImportValidationModel importValidationModel) {
        MultiSheetRowData curRowData = ImportValidationModel.rowData.get();
        DynamicObject opEntity = curRowData.getOpEntity();
        DynamicObject curOrg = opEntity.getDynamicObject("adminorg");
        DynamicObject parentOrg = opEntity.getDynamicObject("parentorg");
        if (parentOrg != null) {
            return parentOrg.getString("number");
        }
        JSONObject importData = curRowData.getBillData().getData().getJSONObject("data").getJSONObject(curRowData.getMainEntity());
        JSONObject parentJsonObj = importData.getJSONObject("parentorg");
        if (parentJsonObj != null) {
            return parentJsonObj.getString("number");
        }
        if (curOrg != null) {
            DynamicObject curOrgInDB = importValidationModel.curBatchChgOrgInfoInDB.get(curOrg.getLong("id"));
            return curOrgInDB.getString("parentorg.number");
        }
        return null;
    }

    public static String getCurOrgNumber(ImportValidationModel importValidationModel) {
        MultiSheetRowData curRowData = ImportValidationModel.rowData.get();
        DynamicObject opEntity = curRowData.getOpEntity();
        if (HRStringUtils.equals((String)"homs_batchorgentityadd", (String)curRowData.getMainEntity())) {
            return opEntity.getString("number");
        }
        DynamicObject curOrg = opEntity.getDynamicObject("adminorg");
        if (curOrg != null) {
            return curOrg.getString("number");
        }
        return null;
    }

    public static ImportValidationOrgBO constructImportValidationOrgBO(ImportBillData billData, String entityNumber) {
        JSONObject afterSplit;
        JSONObject beforeSplit;
        JSONObject afterMerge;
        JSONObject beforeMerge;
        JSONObject corporateOrg;
        JSONObject adminOrgType;
        JSONObject parentOrgData;
        JSONObject adminOrg;
        ImportValidationOrgBO validationOrgBO = new ImportValidationOrgBO();
        JSONObject data = billData.getData().getJSONObject("data");
        JSONObject importData = data.getJSONObject(entityNumber);
        JSONObject nameJsonObj = importData.getJSONObject("name");
        if (nameJsonObj != null) {
            validationOrgBO.setNewChName(nameJsonObj.getString("zh_CN"));
            validationOrgBO.setNewEnName(nameJsonObj.getString("en_US"));
        }
        validationOrgBO.setNewNumber(importData.getString("number"));
        JSONObject changeScene = importData.getJSONObject("changescene");
        if (changeScene != null) {
            validationOrgBO.setChangeSceneName(changeScene.getString("name"));
            validationOrgBO.setChangeSceneNumber(changeScene.getString("number"));
        }
        if ((adminOrg = importData.getJSONObject("adminorg")) != null) {
            validationOrgBO.setOldName(adminOrg.getString("name"));
            validationOrgBO.setOldNumber(adminOrg.getString("number"));
        }
        if ((parentOrgData = importData.getJSONObject("parentorg")) != null) {
            validationOrgBO.setParentOrgName(parentOrgData.getString("name"));
            validationOrgBO.setParentOrgNumber(parentOrgData.getString("number"));
        }
        if ((adminOrgType = importData.getJSONObject("adminorgtype")) != null) {
            validationOrgBO.setOrgTypeName(adminOrgType.getString("name"));
            validationOrgBO.setOrgTypeNumber(adminOrgType.getString("number"));
        }
        if ((corporateOrg = importData.getJSONObject("corporateorg")) != null) {
            validationOrgBO.setCorporateOrgName(corporateOrg.getString("name"));
            validationOrgBO.setCorporateOrgNumber(corporateOrg.getString("number"));
        }
        if ((beforeMerge = importData.getJSONObject("beforemerge_org")) != null) {
            validationOrgBO.setBeforeMergeName(beforeMerge.getString("name"));
            validationOrgBO.setBeforeMergeNumber(beforeMerge.getString("number"));
        }
        if ((afterMerge = importData.getJSONObject("aftermerge_org")) != null) {
            validationOrgBO.setAfterMergeName(afterMerge.getString("name"));
            validationOrgBO.setAfterMergeNumber(afterMerge.getString("number"));
        }
        if ((beforeSplit = importData.getJSONObject("beforesplit_org")) != null) {
            validationOrgBO.setBeforeSplitName(beforeSplit.getString("name"));
            validationOrgBO.setBeforeSplitNumber(beforeSplit.getString("number"));
        }
        if ((afterSplit = importData.getJSONObject("aftersplit_org")) != null) {
            validationOrgBO.setAfterSplitName(afterSplit.getString("name"));
            validationOrgBO.setAfterSplitNumber(afterSplit.getString("number"));
        }
        return validationOrgBO;
    }

    public static Map<Long, Long> queryCityCompanyareaMap(Set<Long> cityIds) {
        HRBaseServiceHelper adminDivisionHelper = new HRBaseServiceHelper("bd_admindivision");
        QFilter idFilter = new QFilter("id", "in", cityIds);
        DynamicObjectCollection collection = adminDivisionHelper.queryOriginalCollection("id,country", new QFilter[]{idFilter});
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            return collection.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("country")));
        }
        return new HashMap<Long, Long>(16);
    }

    private static List<String> getCommonParentNodes(List<String> structLongNumberList) {
        if (!CollectionUtils.isEmpty(structLongNumberList) && structLongNumberList.size() < 30) {
            return structLongNumberList;
        }
        String minStructLongNumber = TreeAssistUtils.getCommonPrefixStructLongNumber(structLongNumberList);
        return Collections.singletonList(minStructLongNumber);
    }

    private static List<String> filterSubStructLongNumber(List<String> structLongNumberList) {
        structLongNumberList.sort(Comparator.comparing(String::length));
        ArrayList<String> filteredStructLongNumber = new ArrayList<String>(structLongNumberList.size());
        for (String structLongNumber : structLongNumberList) {
            if (!filteredStructLongNumber.stream().noneMatch(structLongNumber::contains)) continue;
            filteredStructLongNumber.add(structLongNumber);
        }
        return filteredStructLongNumber;
    }

    public static Map<Long, Set<Long>> getDisableAllSubOrgMap(Set<Long> orgList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey());
        QFilter commonFilter = new QFilter("iscurrentversion", "=", (Object)"1").and(new QFilter("datastatus", "=", (Object)"1")).and((QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get()).and(new QFilter("initstatus", "=", (Object)"2")).and(new QFilter("enable", "=", (Object)"1"));
        QFilter filter = new QFilter("adminorg", "in", orgList);
        String selectProperties = "adminorg.id,structlongnumber";
        DynamicObjectCollection dynamicObjects = serviceHelper.queryOriginalCollection(selectProperties, new QFilter[]{filter, commonFilter});
        List<String> structLongNumberList = dynamicObjects.stream().map(dy -> dy.getString("structlongnumber")).collect(Collectors.toList());
        List<String> filterStructLongNumberList = ImportValidationHelper.filterSubStructLongNumber(structLongNumberList);
        filterStructLongNumberList = ImportValidationHelper.getCommonParentNodes(filterStructLongNumberList);
        QFilter structLongNumberFilter = new QFilter("structlongnumber", "like", (Object)(filterStructLongNumberList.get(0) + "!%"));
        for (int i = 1; i < filterStructLongNumberList.size(); ++i) {
            structLongNumberFilter.or("structlongnumber", "like", (Object)(filterStructLongNumberList.get(i) + "!%"));
        }
        DynamicObjectCollection dynamicObjectArray = serviceHelper.queryOriginalCollection(selectProperties, new QFilter[]{structLongNumberFilter, commonFilter});
        HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>(dynamicObjects.size());
        Long orgId = null;
        Set subList = null;
        String subStructLongNumber = null;
        for (DynamicObject dy2 : dynamicObjects) {
            String parentStructLongNumber = dy2.getString("structlongnumber") + "!";
            for (DynamicObject subDy : dynamicObjectArray) {
                subStructLongNumber = subDy.getString("structlongnumber");
                if (!subStructLongNumber.contains(parentStructLongNumber)) continue;
                orgId = dy2.getLong("adminorg.id");
                subList = map.computeIfAbsent(orgId, k -> new HashSet());
                subList.add(subDy.getLong("adminorg.id"));
            }
        }
        return map;
    }

    public static AuthorizedOrgResult getAuthorizedOrgResult() {
        return AdminOrgBatchChgHelper.getOrgAuth(null);
    }

    public static Set<String> queryBosOrgNumbers(Set<String> numbers) {
        long startTimeStamp = System.currentTimeMillis();
        HRBaseServiceHelper bosOrgHelper = new HRBaseServiceHelper("bos_org");
        DynamicObjectCollection numberDynamicObjects = bosOrgHelper.queryOriginalCollection("id", new QFilter[]{new QFilter("number", "in", numbers)});
        if (CollectionUtils.isEmpty((Collection)numberDynamicObjects)) {
            return Sets.newHashSetWithExpectedSize((int)0);
        }
        HashSet orgIds = Sets.newHashSetWithExpectedSize((int)numberDynamicObjects.size());
        numberDynamicObjects.forEach(dy -> orgIds.add(dy.getLong("id")));
        QFilter bosOrgFilter = new QFilter("isfreeze", "=", (Object)"0");
        bosOrgFilter.and("org.id", "in", (Object)orgIds);
        bosOrgHelper = new HRBaseServiceHelper("bos_org_structure");
        DynamicObjectCollection orgColl = bosOrgHelper.queryOriginalCollection("org.number", new QFilter[]{bosOrgFilter});
        LOG.info(String.format(Locale.ROOT, "ImportValidationHelper.queryBosOrgNumbers() cost %s milliseconds", System.currentTimeMillis() - startTimeStamp));
        return orgColl.stream().map(dy -> dy.getString("org.number")).collect(Collectors.toSet());
    }

    public static Map<Long, List<DynamicObject>> batchGetOrgCoopInfo(Set<Long> orgIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_orgteamcooprel");
        QFilter filter = new QFilter("org", "in", orgIds);
        filter.and("iscurrentversion", "=", (Object)"1");
        filter.and("datastatus", "=", (Object)"1");
        filter.and("enable", "=", (Object)"1");
        filter.and("coopreltype", "!=", (Object)1010L);
        DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray(new QFilter[]{filter});
        return Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(dy -> dy.getLong("org.id")));
    }

    public static Map<Long, List<DynamicObject>> queryChildrenOrgSpecInfo(Set<Long> orgIdSet) {
        long startTimeStamp = System.currentTimeMillis();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter orgIdFilter = new QFilter("parentorg", "in", orgIdSet);
        QFilter versionFilter = new QFilter("iscurrentversion", "in", (Object)"1");
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)"1");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] dynamicObjects = serviceHelper.queryOriginalArray("id,number,parentorg.id,adminorgtype.id", new QFilter[]{orgIdFilter, versionFilter, dataStatusFilter, enableFilter});
        LOG.info(String.format(Locale.ROOT, "ImportValidationHelper.queryChildrenOrgSpecInfo() cost %s milliseconds, and %s org found", System.currentTimeMillis() - startTimeStamp, dynamicObjects.length));
        return Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getLong("parentorg.id")));
    }

    public static Map<Long, DynamicObject> queryAdminOrgByBoId(Set<Long> orgIdSet) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter orgIdFilter = new QFilter("id", "in", orgIdSet);
        QFilter versionFilter = new QFilter("iscurrentversion", "in", (Object)"1");
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)"1");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray(new QFilter[]{orgIdFilter, versionFilter, dataStatusFilter, enableFilter});
        HashMap<Long, DynamicObject> boIdToDyn = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject dyn : dynamicObjects) {
            boIdToDyn.putIfAbsent(dyn.getLong("id"), dyn);
        }
        return boIdToDyn;
    }

    private static /* synthetic */ void lambda$queryExistName$7(Map result, long parentOrgId, DynamicObject dynamicObject, Pair pair) {
        result.computeIfAbsent(parentOrgId, k -> Maps.newHashMapWithExpectedSize((int)2)).computeIfAbsent(pair.getKey(), k -> Sets.newHashSetWithExpectedSize((int)2)).add(new OrgNameBean((String)pair.getValue(), dynamicObject.getDate("bsed"), dynamicObject.getDate("bsled")));
    }
}

