/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.impo.impvalidator;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.homs.common.model.CalibratorBean;
import kd.hr.homs.formplugin.web.impo.importdata.MultiSheetRowData;
import kd.hr.homs.formplugin.web.impo.impvalidator.IValidator;
import kd.hr.homs.formplugin.web.impo.impvalidator.ImportValidationHelper;
import kd.hr.homs.formplugin.web.impo.impvalidator.ImportValidationModel;

public class ImportValidationService
implements Callable {
    private static final Log LOG = LogFactory.getLog(ImportValidationService.class);
    private final Object lock;
    private List<MultiSheetRowData> importBatchData;
    private ImportValidationModel importValidationModel;
    private Map<String, ImportLogger> importLoggerMap;
    private Map<String, IValidator<ImportValidationModel>> chgSceneActualValidators;

    public ImportValidationService(List<MultiSheetRowData> importBatchData, ImportValidationModel importValidationModel, Map<String, ImportLogger> importLoggerMap, Map<String, IValidator<ImportValidationModel>> chgSceneActualValidators, Object lock) {
        this.importBatchData = importBatchData;
        this.importValidationModel = importValidationModel;
        this.importLoggerMap = importLoggerMap;
        this.chgSceneActualValidators = chgSceneActualValidators;
        this.lock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() {
        for (MultiSheetRowData curRowData : this.importBatchData) {
            String entryEntity = curRowData.getMainEntity();
            ImportLogger importLogger = this.importLoggerMap.get(entryEntity);
            Integer rowNum = curRowData.getRownum();
            ImportValidationModel.rowData.set(curRowData);
            try {
                ImportValidationModel.importValidationOrgBO.set(ImportValidationHelper.constructImportValidationOrgBO(curRowData.getBillData(), curRowData.getMainEntity()));
                IValidator<ImportValidationModel> validator = this.chgSceneActualValidators.get(entryEntity);
                if (validator == null) continue;
                List<CalibratorBean> validateResults = validator.validate(this.importValidationModel, new Object[0]);
                Object object = this.lock;
                synchronized (object) {
                    if (!CollectionUtils.isEmpty(validateResults)) {
                        for (CalibratorBean calibratorBean : validateResults) {
                            importLogger.log(rowNum, calibratorBean.getMessage("odc-homs-common"));
                        }
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                LOG.error("ImportValidationService.validate() exception: ", (Throwable)e);
                importLogger.log(rowNum, e.getMessage());
            }
            finally {
                ImportValidationModel.rowData.remove();
                ImportValidationModel.importValidationOrgBO.remove();
            }
        }
    }

    public Object call() {
        this.validate();
        return null;
    }
}

