/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.impo.impvalidator;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.service.adminorg.bean.Pair;
import kd.hr.haos.common.constants.MultiLangEnum;
import kd.hr.haos.common.constants.masterdata.AdminOrgType;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.common.model.CalibratorBean;
import kd.hr.homs.formplugin.web.impo.importdata.MultiSheetRowData;
import kd.hr.homs.formplugin.web.impo.impvalidator.ImportValidationModel;
import kd.hr.homs.formplugin.web.impo.impvalidator.OrgInfoVO;

public class Org4LayerModelValidator {
    private static final Set<AdminOrgType> LAYER4_ABOVE_GROUP = Sets.newHashSet((Object[])new AdminOrgType[]{AdminOrgType.GROUP, AdminOrgType.REGION});
    private static final Set<AdminOrgType> LAYER4_ABOVE_COMPANY = Sets.newHashSet((Object[])new AdminOrgType[]{AdminOrgType.GROUP, AdminOrgType.COMPANY, AdminOrgType.REGION});
    private static final Set<AdminOrgType> LAYER4_LOWER_COMPANY = Sets.newHashSet((Object[])new AdminOrgType[]{AdminOrgType.COMPANY, AdminOrgType.REGION, AdminOrgType.DEPARTMENT});
    private static final Set<AdminOrgType> LAYER4_LOWER_DEPT = Sets.newHashSet((Object[])new AdminOrgType[]{AdminOrgType.REGION, AdminOrgType.DEPARTMENT});
    private Map<Long, List<DynamicObject>> applyingChgOrgUnderParent;
    private boolean initiated = false;

    private synchronized void init(ImportValidationModel importValidationModel) {
        if (!this.initiated) {
            this.initiated = true;
            this.applyingChgOrgUnderParent = importValidationModel.getApplyingChgOrgMap().values().stream().map(OrgInfoVO::getDy).collect(Collectors.groupingBy(orgInfo -> orgInfo.getLong("parentorg.boid")));
        }
    }

    public List<CalibratorBean> doValidation(ImportValidationModel importValidationModel) {
        this.init(importValidationModel);
        ArrayList validateResult = Lists.newArrayListWithCapacity((int)2);
        DynamicObject curOrgType = this.validateWithParent(importValidationModel, validateResult);
        if (curOrgType != null) {
            this.validateWithChildren(importValidationModel, validateResult, curOrgType);
            this.relatedInfoFillCheck(importValidationModel, validateResult, curOrgType);
        }
        return validateResult;
    }

    private void relatedInfoFillCheck(ImportValidationModel importValidationModel, List<CalibratorBean> validateResult, DynamicObject curOrgType) {
        Long curOrgTypeStdId = importValidationModel.getOrgTypeAndTypeStdMap().get(curOrgType.getLong("id"));
        AdminOrgType orgType = AdminOrgType.getById((long)curOrgTypeStdId);
        ArrayList errorFillProp = Lists.newArrayListWithCapacity((int)2);
        MultiSheetRowData rowData = ImportValidationModel.rowData.get();
        JSONObject importExcelData = rowData.getBillData().getData().getJSONObject("data").getJSONObject(rowData.getMainEntity());
        DynamicObjectType dynamicObjectType = rowData.getOpEntity().getDynamicObjectType();
        switch (orgType) {
            case DEPARTMENT: 
            case REGION: {
                this.shouldNotFillPropCheck(dynamicObjectType, Lists.newArrayList((Object[])new String[]{"companytype", "industrytype"}), importExcelData, errorFillProp);
            }
            case COMPANY: {
                this.shouldNotFillPropCheck(dynamicObjectType, Lists.newArrayList((Object[])new String[]{"groupvision", "groupmission"}), importExcelData, errorFillProp);
            }
            case GROUP: {
                if (orgType == AdminOrgType.DEPARTMENT) break;
                this.shouldNotFillPropCheck(dynamicObjectType, Lists.newArrayList((Object[])new String[]{"departmenttype"}), importExcelData, errorFillProp);
                break;
            }
        }
        if (!CollectionUtils.isEmpty((Collection)errorFillProp)) {
            validateResult.add(new CalibratorBean("Org4LayerModelValidator_4", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u4e3a\u201c%1$s\u201d\u4e0d\u80fd\u586b\u5199\u201c%2$s\u201d", (String)"Org4LayerModelValidator_4", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{curOrgType.getString("name"), ((Object)errorFillProp).toString()}));
        }
    }

    private void shouldNotFillPropCheck(DynamicObjectType dynamicObjectType, List<String> propNames, JSONObject importExcelData, List<String> errorFillProp) {
        for (String propName : propNames) {
            Object propValue = importExcelData.get((Object)propName);
            if (propValue == null) continue;
            boolean haveValue = false;
            DynamicProperty property = dynamicObjectType.getProperty(propName);
            if (property instanceof BasedataProp) {
                String importProp;
                JSONObject baseDataPropData = importExcelData.getJSONObject(propName);
                String value = baseDataPropData.getString(importProp = baseDataPropData.getString("importprop"));
                if (!HRStringUtils.equalsIgnoreCase((String)"null", (String)value)) {
                    haveValue = true;
                }
            } else if (property instanceof MuliLangTextProp) {
                JSONObject multiLangPropData = importExcelData.getJSONObject(propName);
                for (MultiLangEnum multiLangEnum : MultiLangEnum.values()) {
                    if (HRStringUtils.equalsIgnoreCase((String)"null", (String)multiLangPropData.getString(multiLangEnum.getCode()))) continue;
                    haveValue = true;
                    break;
                }
            } else if (!HRStringUtils.equalsIgnoreCase((String)"null", (String)String.valueOf(propValue))) {
                haveValue = true;
            }
            if (!haveValue) continue;
            errorFillProp.add(property.getDisplayName().getLocaleValue());
        }
    }

    private DynamicObject getCurOrgAdminOrgType(MultiSheetRowData sheetRowData, Map<Long, DynamicObject> curBatchChgOrgInfoInDB) {
        DynamicObject opEntity = sheetRowData.getOpEntity();
        DynamicObject adminOrgType = opEntity.getDynamicObject("adminorgtype");
        DynamicObject curOrg = null;
        if (!HRStringUtils.equals((String)sheetRowData.getMainEntity(), (String)"homs_batchorgentityadd")) {
            curOrg = opEntity.getDynamicObject("adminorg");
        }
        JSONObject importData = sheetRowData.getBillData().getData().getJSONObject("data").getJSONObject(sheetRowData.getMainEntity());
        if (curOrg == null && adminOrgType == null) {
            return null;
        }
        if (adminOrgType != null) {
            return adminOrgType;
        }
        JSONObject orgType = importData.getJSONObject("adminorgtype");
        if (orgType == null) {
            DynamicObject curOldInfo = curBatchChgOrgInfoInDB.get(curOrg.getLong("id"));
            return curOldInfo.getDynamicObject("adminorgtype");
        }
        return null;
    }

    private DynamicObject validateWithParent(ImportValidationModel importValidationModel, List<CalibratorBean> calibratorBeanList) {
        MultiSheetRowData sheetRowData = ImportValidationModel.rowData.get();
        DynamicObject curAdminOrgType = this.getCurOrgAdminOrgType(sheetRowData, importValidationModel.curBatchChgOrgInfoInDB);
        if (curAdminOrgType == null) {
            return curAdminOrgType;
        }
        Long adminOrgTypeStd = importValidationModel.getOrgTypeAndTypeStdMap().get(curAdminOrgType.getLong("id"));
        DynamicObject parentOrg = sheetRowData.getOpEntity().getDynamicObject("parentorg");
        Long parentAdminOrgTypeStd = null;
        if (parentOrg != null) {
            parentAdminOrgTypeStd = this.getParentOrgTypeStd(importValidationModel, parentOrg);
        } else {
            if (HRStringUtils.equals((String)"homs_batchorgentityadd", (String)sheetRowData.getMainEntity())) {
                return curAdminOrgType;
            }
            Pair<Long, DynamicObject> pair = this.getParentOrgTypeStd(sheetRowData, importValidationModel);
            if (pair != null) {
                parentAdminOrgTypeStd = (Long)pair.getKey();
                parentOrg = (DynamicObject)pair.getValue();
            }
        }
        if (parentAdminOrgTypeStd == null) {
            return curAdminOrgType;
        }
        ArrayList parentOrgTypeShouldBe = Lists.newArrayListWithCapacity((int)4);
        boolean haveFaultRelation = this.haveFaultRelationWithParentCheck(adminOrgTypeStd, parentAdminOrgTypeStd, importValidationModel.getOrgTypeStdIdAndTypeNameMap(), parentOrgTypeShouldBe);
        if (haveFaultRelation) {
            calibratorBeanList.add(new CalibratorBean("Org4LayerModelValidator_0", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201c%1$s\u201d\u7684\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%2$s\u201d\uff0c\u8bf7\u4fee\u6539", (String)"Org4LayerModelValidator_0", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{curAdminOrgType.getString("name"), ((Object)parentOrgTypeShouldBe).toString()}));
        }
        if (parentOrg == null) {
            return curAdminOrgType;
        }
        OrgInfoVO applyingChgParentOrg = importValidationModel.getApplyingChgOrgMap().get(parentOrg.getLong("id"));
        if (applyingChgParentOrg == null) {
            return curAdminOrgType;
        }
        long typeId = applyingChgParentOrg.getDy().getLong("adminorgtype.id");
        Long changedParentOrgTypeStd = importValidationModel.orgTypeAndTypeStdMap.get(typeId);
        if (!parentAdminOrgTypeStd.equals(changedParentOrgTypeStd)) {
            parentOrgTypeShouldBe.clear();
            haveFaultRelation = this.haveFaultRelationWithParentCheck(adminOrgTypeStd, changedParentOrgTypeStd, importValidationModel.getOrgTypeStdIdAndTypeNameMap(), parentOrgTypeShouldBe);
            if (haveFaultRelation) {
                calibratorBeanList.add(new CalibratorBean("Org4LayerModelValidator_1", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201c%1$s\u201d\u7684\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%2$s\u201d\uff0c\u76ee\u524d\u6709\u5728\u9014\u5355\u6570\u636e\u4e0d\u6ee1\u8db3\uff0c\u8bf7\u4fee\u6539", (String)"Org4LayerModelValidator_1", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{curAdminOrgType.getString("name"), ((Object)parentOrgTypeShouldBe).toString()}));
            }
        }
        return curAdminOrgType;
    }

    private Pair<Long, DynamicObject> getParentOrgTypeStd(MultiSheetRowData sheetRowData, ImportValidationModel importValidationModel) {
        Long parentAdminOrgTypeStd = null;
        DynamicObject parentOrg = null;
        DynamicObject curOrg = sheetRowData.getOpEntity().getDynamicObject("adminorg");
        JSONObject importData = sheetRowData.getBillData().getData().getJSONObject("data").getJSONObject(sheetRowData.getMainEntity());
        JSONObject parenOrgData = importData.getJSONObject("parentorg");
        if (parenOrgData == null) {
            if (curOrg == null) {
                return null;
            }
            DynamicObject curOldInfo = importValidationModel.curBatchChgOrgInfoInDB.get(curOrg.getLong("id"));
            parentOrg = curOldInfo.getDynamicObject("parentorg");
            if (Objects.isNull(parentOrg)) {
                return null;
            }
            DynamicObject parentOrgType = null;
            String parentNumber = parentOrg.getString("number");
            if (importValidationModel.getCurExcelOrgCache().containsKey(parentNumber)) {
                MultiSheetRowData parentRowData = importValidationModel.getCurExcelOrgCache().get(parentNumber);
                DynamicObject parentOpEntity = parentRowData.getOpEntity();
                parentOrgType = parentOpEntity.getDynamicObject("adminorgtype");
            }
            if (Objects.isNull(parentOrgType)) {
                parentOrgType = parentOrg.getDynamicObject("adminorgtype");
            }
            if (parentOrgType != null) {
                long parentAdminOrgType = parentOrgType.getLong("id");
                parentAdminOrgTypeStd = importValidationModel.orgTypeAndTypeStdMap.get(parentAdminOrgType);
            }
        } else {
            String parentOrgNumber = parenOrgData.getString("number");
            if (parentOrgNumber == null) {
                return null;
            }
            if (importValidationModel.curExcelOrgCache.containsKey(parentOrgNumber)) {
                MultiSheetRowData parentRowData = importValidationModel.getCurExcelOrgCache().get(parentOrgNumber);
                DynamicObject orgType = parentRowData.getOpEntity().getDynamicObject("adminorgtype");
                if (orgType == null) {
                    return null;
                }
                parentAdminOrgTypeStd = importValidationModel.orgTypeAndTypeStdMap.get(orgType.getLong("id"));
            }
        }
        return new Pair(parentAdminOrgTypeStd, (Object)parentOrg);
    }

    private Long getParentOrgTypeStd(ImportValidationModel importValidationModel, DynamicObject parentOrg) {
        Long parentAdminOrgTypeStd = null;
        MultiSheetRowData parentOrgInCurExcel = importValidationModel.curExcelOrgCache.get(parentOrg.getString("number"));
        if (parentOrgInCurExcel != null) {
            DynamicObject newParentOrgType = parentOrgInCurExcel.getOpEntity().getDynamicObject("adminorgtype");
            JSONObject importData = parentOrgInCurExcel.getBillData().getData().getJSONObject("data").getJSONObject(parentOrgInCurExcel.getMainEntity());
            JSONObject orgTypeJsonObject = importData.getJSONObject("adminorgtype");
            if (orgTypeJsonObject != null && newParentOrgType == null) {
                return null;
            }
            if (newParentOrgType != null) {
                parentAdminOrgTypeStd = importValidationModel.orgTypeAndTypeStdMap.get(newParentOrgType.getLong("id"));
            }
        }
        if (parentAdminOrgTypeStd == null) {
            DynamicObject parentOrgInfo = importValidationModel.curBatchChgOrgInfoInDB.get(parentOrg.getLong("id"));
            parentAdminOrgTypeStd = parentOrgInfo.getLong("adminorgtype.adminorgtypestd.id");
        }
        return parentAdminOrgTypeStd;
    }

    private boolean haveFaultRelationWithParentCheck(Long adminOrgTypeStd, Long parentAdminOrgTypeStd, Map<Long, List<String>> orgTypeStdIdAndTypeNameMap, List<String> parentOrgTypeShouldBe) {
        boolean haveFaultRelation;
        block3: {
            AdminOrgType parentOrgType;
            AdminOrgType curOrgType;
            block2: {
                curOrgType = AdminOrgType.getById((long)adminOrgTypeStd);
                parentOrgType = AdminOrgType.getById((long)parentAdminOrgTypeStd);
                haveFaultRelation = false;
                if (curOrgType != AdminOrgType.GROUP || LAYER4_ABOVE_GROUP.contains(parentOrgType)) break block2;
                haveFaultRelation = true;
                for (AdminOrgType orgType : LAYER4_ABOVE_GROUP) {
                    long typeStdId = orgType.getId();
                    if (orgTypeStdIdAndTypeNameMap.get(typeStdId) == null) continue;
                    parentOrgTypeShouldBe.addAll((Collection<String>)orgTypeStdIdAndTypeNameMap.get(typeStdId));
                }
                break block3;
            }
            if (curOrgType != AdminOrgType.COMPANY || LAYER4_ABOVE_COMPANY.contains(parentOrgType)) break block3;
            haveFaultRelation = true;
            for (AdminOrgType orgType : LAYER4_ABOVE_COMPANY) {
                long typeStdId = orgType.getId();
                if (orgTypeStdIdAndTypeNameMap.get(typeStdId) == null) continue;
                parentOrgTypeShouldBe.addAll((Collection<String>)orgTypeStdIdAndTypeNameMap.get(typeStdId));
            }
        }
        return haveFaultRelation;
    }

    private void validateWithChildren(ImportValidationModel importValidationModel, List<CalibratorBean> calibratorBeanList, DynamicObject curOrgType) {
        MultiSheetRowData sheetRowData = ImportValidationModel.rowData.get();
        DynamicObject opEntity = sheetRowData.getOpEntity();
        DynamicObject curOrg = opEntity.getDynamicObject("adminorg");
        String chgOrNewOrgNumber = null;
        if (HRStringUtils.equals((String)sheetRowData.getMainEntity(), (String)"homs_batchorgentityadd")) {
            chgOrNewOrgNumber = opEntity.getString("number");
        } else if (curOrg != null) {
            chgOrNewOrgNumber = curOrg.getString("number");
        }
        DynamicObject finalCurOrg = curOrg;
        Optional.ofNullable(chgOrNewOrgNumber).ifPresent(orgNumber -> {
            DynamicObject child;
            Long childOrgTypeId;
            Set<String> childNumberSet = importValidationModel.getParentNumberAndChildrenNumberMapInExcel().get(orgNumber);
            HashSet childOrgTypeShouldBe = Sets.newHashSetWithExpectedSize((int)4);
            Long curOrgTypeStdId = importValidationModel.orgTypeAndTypeStdMap.get(curOrgType.getLong("id"));
            if (!CollectionUtils.isEmpty(childNumberSet)) {
                String number;
                MultiSheetRowData childRowData;
                DynamicObject childAdminOrgType;
                Iterator<String> iterator = childNumberSet.iterator();
                while (iterator.hasNext() && ((childAdminOrgType = this.getCurOrgAdminOrgType(childRowData = importValidationModel.curExcelOrgCache.get(number = iterator.next()), importValidationModel.curBatchChgOrgInfoInDB)) == null || !this.haveFaultRelationWithChildrenCheck(childAdminOrgType.getLong("id"), curOrgTypeStdId, importValidationModel, childOrgTypeShouldBe))) {
                }
                if (!CollectionUtils.isEmpty((Collection)childOrgTypeShouldBe)) {
                    calibratorBeanList.add(new CalibratorBean("Org4LayerModelValidator_2", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201c%1$s\u201d\u7684\u4e0b\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%2$s\u201d\uff0c\u8bf7\u4fee\u6539", (String)"Org4LayerModelValidator_2", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{curOrgType.getString("name"), ((Object)childOrgTypeShouldBe).toString()}));
                }
            }
            if (finalCurOrg == null) {
                return;
            }
            long curOrgId = finalCurOrg.getLong("id");
            List<DynamicObject> childDynList = importValidationModel.getCurBatchOrgChildrenMap().get(curOrgId);
            boolean haveIllegalRelation = false;
            if (!CollectionUtils.isEmpty(childDynList)) {
                DynamicObject childOrg;
                Long childOrgTypeId2;
                childDynList.removeIf(dynamicObject -> importValidationModel.getCurExcelOrgCache().containsKey(dynamicObject.getString("number")));
                childOrgTypeShouldBe.clear();
                Iterator<DynamicObject> iterator = childDynList.iterator();
                while (iterator.hasNext() && ((childOrgTypeId2 = Long.valueOf((childOrg = iterator.next()).getLong("adminorgtype.id"))) == 0L || !(haveIllegalRelation = this.haveFaultRelationWithChildrenCheck(childOrgTypeId2, curOrgTypeStdId, importValidationModel, childOrgTypeShouldBe)))) {
                }
                if (haveIllegalRelation) {
                    calibratorBeanList.add(new CalibratorBean("Org4LayerModelValidator_2", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201c%1$s\u201d\u7684\u4e0b\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%2$s\u201d\uff0c\u8bf7\u4fee\u6539", (String)"Org4LayerModelValidator_2", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{curOrgType.getString("name"), ((Object)childOrgTypeShouldBe).toString()}));
                }
            }
            childOrgTypeShouldBe.clear();
            haveIllegalRelation = false;
            if (CollectionUtils.isEmpty(this.applyingChgOrgUnderParent)) {
                return;
            }
            List<DynamicObject> changingChildren = this.applyingChgOrgUnderParent.get(curOrgId);
            if (Objects.isNull(changingChildren)) {
                return;
            }
            Iterator<DynamicObject> iterator = changingChildren.iterator();
            while (iterator.hasNext() && !(haveIllegalRelation = this.haveFaultRelationWithChildrenCheck(childOrgTypeId = Long.valueOf((child = iterator.next()).getLong("adminorgtype.id")), curOrgTypeStdId, importValidationModel, childOrgTypeShouldBe))) {
            }
            if (haveIllegalRelation) {
                calibratorBeanList.add(new CalibratorBean("Org4LayerModelValidator_3", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201c%1$s\u201d\u7684\u4e0b\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%2$s\u201d\uff0c\u76ee\u524d\u6709\u5728\u9014\u5355\u6570\u636e\u4e0d\u6ee1\u8db3\uff0c\u8bf7\u4fee\u6539", (String)"Org4LayerModelValidator_3", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{curOrgType.getString("name"), ((Object)childOrgTypeShouldBe).toString()}));
            }
        });
    }

    private boolean haveFaultRelationWithChildrenCheck(Long childOrgTypeId, Long curOrgTypeStdId, ImportValidationModel importValidationModel, Set<String> childOrgTypeShouldBe) {
        Long childOrgTypeStdId = importValidationModel.orgTypeAndTypeStdMap.get(childOrgTypeId);
        boolean haveFaultRelation = false;
        if (AdminOrgType.getById((long)curOrgTypeStdId) == AdminOrgType.COMPANY && !LAYER4_LOWER_COMPANY.contains(AdminOrgType.getById((long)childOrgTypeStdId))) {
            for (AdminOrgType adminOrgType : LAYER4_LOWER_COMPANY) {
                childOrgTypeShouldBe.addAll((Collection<String>)importValidationModel.getOrgTypeStdIdAndTypeNameMap().get(adminOrgType.getId()));
            }
            haveFaultRelation = true;
        } else if (AdminOrgType.getById((long)curOrgTypeStdId) == AdminOrgType.DEPARTMENT && !LAYER4_LOWER_DEPT.contains(AdminOrgType.getById((long)childOrgTypeStdId))) {
            for (AdminOrgType adminOrgType : LAYER4_LOWER_DEPT) {
                childOrgTypeShouldBe.addAll((Collection<String>)importValidationModel.orgTypeStdIdAndTypeNameMap.get(adminOrgType.getId()));
            }
            haveFaultRelation = true;
        }
        return haveFaultRelation;
    }
}

